/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTestTools;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FramePose3DReadOnlyTest;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;

public class FramePose3DTest
extends FramePose3DReadOnlyTest<FramePose3D> {
    public static final double EPSILON = 1.0E-15;

    @Override
    public FramePose3D createFramePose(ReferenceFrame referenceFrame, Pose3DReadOnly pose) {
        return new FramePose3D(referenceFrame, pose);
    }

    @Test
    public void testConsistencyWithPose3D() {
        FrameTypeCopier frameTypeBuilder = (frame, pose) -> this.createFramePose(frame, (Pose3DReadOnly)pose);
        RandomFramelessTypeBuilder framelessTypeBuilder = EuclidGeometryRandomTools::nextPose3D;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilder, methodFilter, 10);
        RandomFramelessTypeBuilder frameless2DTypeBuilder = random -> new Pose3D(this.createRandom2DFramePose(random, ReferenceFrame.getWorldFrame()));
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, frameless2DTypeBuilder, methodFilter, 10);
    }

    @Override
    @Test
    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Pose3D.class}));
        signaturesToIgnore.add(new MethodSignature("equals", new Class[]{Pose3D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Pose3D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Pose3D.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FramePose3D.class, Pose3D.class, true, 1, methodFilter);
    }

    @Test
    public void testSetMatchingFrame() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameRandomTools::nextFramePose3D, 10);
        Random random = new Random(544354L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FramePose3D source = EuclidFrameRandomTools.nextFramePose3D((Random)random, (ReferenceFrame)sourceFrame);
            FramePose3D actual = EuclidFrameRandomTools.nextFramePose3D((Random)random, (ReferenceFrame)destinationFrame);
            actual.setMatchingFrame((FramePose3DReadOnly)source);
            FramePose3D expected = new FramePose3D((FramePose3DReadOnly)source);
            expected.changeFrame(destinationFrame);
            EuclidGeometryTestTools.assertPose3DEquals((Pose3DReadOnly)expected, (Pose3DReadOnly)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFramePose3D, 10);
    }
}

