/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.matrix.CommonMatrix3DBasicsTest;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasicsTest;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.rotationConversion.RotationVectorConversion;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class RotationMatrixTest
extends CommonMatrix3DBasicsTest<RotationMatrix> {
    public static final double EPS = 1.0E-10;

    @Test
    public void testRotationMatrix() {
        int i;
        Random random = new Random(46876L);
        RotationMatrix actualRotationMatrix = new RotationMatrix();
        RotationMatrix expectedRotationMatrix = new RotationMatrix();
        Assertions.assertTrue((boolean)new RotationMatrix().isIdentity());
        for (i = 0; i < 1000; ++i) {
            expectedRotationMatrix = this.createRandomMatrix(random);
            double m00 = expectedRotationMatrix.getM00();
            double m01 = expectedRotationMatrix.getM01();
            double m02 = expectedRotationMatrix.getM02();
            double m10 = expectedRotationMatrix.getM10();
            double m11 = expectedRotationMatrix.getM11();
            double m12 = expectedRotationMatrix.getM12();
            double m20 = expectedRotationMatrix.getM20();
            double m21 = expectedRotationMatrix.getM21();
            double m22 = expectedRotationMatrix.getM22();
            actualRotationMatrix = new RotationMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotationMatrix, (Matrix3DReadOnly)actualRotationMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expectedRotationMatrix = this.createRandomMatrix(random);
            double[] rotationMatrixArray = new double[50];
            expectedRotationMatrix.get(rotationMatrixArray);
            actualRotationMatrix = new RotationMatrix(rotationMatrixArray);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotationMatrix, (Matrix3DReadOnly)actualRotationMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expectedRotationMatrix = this.createRandomMatrix(random);
            DMatrixRMaj rotationMatrixDenseMatrix = new DMatrixRMaj(3, 3);
            expectedRotationMatrix.get((DMatrix)rotationMatrixDenseMatrix);
            actualRotationMatrix = new RotationMatrix((DMatrix)rotationMatrixDenseMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotationMatrix, (Matrix3DReadOnly)actualRotationMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expectedRotationMatrix = this.createRandomMatrix(random);
            Matrix3D matrix3D = new Matrix3D((Matrix3DReadOnly)expectedRotationMatrix);
            actualRotationMatrix = new RotationMatrix((Matrix3DReadOnly)matrix3D);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotationMatrix, (Matrix3DReadOnly)actualRotationMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expectedRotationMatrix = this.createRandomMatrix(random);
            actualRotationMatrix = new RotationMatrix((RotationMatrixReadOnly)expectedRotationMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotationMatrix, (Matrix3DReadOnly)actualRotationMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            actualRotationMatrix = new RotationMatrix((Orientation3DReadOnly)axisAngle);
            RotationMatrixConversion.convertAxisAngleToMatrix((AxisAngleReadOnly)axisAngle, (CommonMatrix3DBasics)expectedRotationMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)actualRotationMatrix, (Matrix3DReadOnly)expectedRotationMatrix, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actualRotationMatrix = new RotationMatrix((Orientation3DReadOnly)quaternion);
            RotationMatrixConversion.convertQuaternionToMatrix((QuaternionReadOnly)quaternion, (CommonMatrix3DBasics)expectedRotationMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)actualRotationMatrix, (Matrix3DReadOnly)expectedRotationMatrix, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D rotationVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualRotationMatrix = new RotationMatrix((Vector3DReadOnly)rotationVector);
            RotationMatrixConversion.convertRotationVectorToMatrix((Vector3DReadOnly)rotationVector, (CommonMatrix3DBasics)expectedRotationMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)actualRotationMatrix, (Matrix3DReadOnly)expectedRotationMatrix, (double)1.0E-10);
        }
    }

    @Override
    public void testSetDoubles() {
        super.testSetDoubles();
        try {
            RotationMatrix rotationMatrix = new RotationMatrix();
            rotationMatrix.set(45.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            Assertions.fail((String)"should have thrown a NotARotationMatrixException");
        }
        catch (NotARotationMatrixException rotationMatrix) {
        }
        catch (Exception e) {
            Assertions.fail((String)"should have thrown a NotARotationMatrixException");
        }
    }

    @Test
    public void testSetToZero() {
        RotationMatrix rotationMatrix = new RotationMatrix();
        RotationMatrix identityMatrix = new RotationMatrix();
        identityMatrix.setToNaN();
        rotationMatrix.setToNaN();
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)identityMatrix);
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)rotationMatrix);
        identityMatrix.setIdentity();
        rotationMatrix.setToZero();
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)identityMatrix, (double)1.0E-10);
    }

    @Test
    public void testCheckIfMatrixProper() throws Exception {
        Random random = new Random(46876L);
        Matrix3D matrixCopy = new Matrix3D();
        for (int i = 0; i < 1000; ++i) {
            Matrix3D matrix;
            block3: {
                matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
                matrixCopy.set(matrix);
                RotationMatrix rotationMatrix = new RotationMatrix();
                try {
                    rotationMatrix = new RotationMatrix((Matrix3DReadOnly)matrix);
                    rotationMatrix.checkIfRotationMatrix();
                    Assertions.assertTrue((boolean)matrix.isRotationMatrix());
                }
                catch (RuntimeException e) {
                    if (!matrix.isRotationMatrix()) break block3;
                    throw e;
                }
            }
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)matrixCopy, (double)1.0E-10);
        }
    }

    @Test
    public void testSet() throws Exception {
        RotationMatrix actualMatrix;
        int i;
        double m22;
        double m21;
        double m20;
        double m12;
        double m11;
        double m10;
        double m02;
        double m01;
        int i2;
        Random random = new Random(648967L);
        RotationMatrix rotationMatrix22 = new RotationMatrix();
        for (int i3 = 0; i3 < 1000; ++i3) {
            Matrix3D expectedMatrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            RotationMatrix expectedRotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrix22.setToNaN();
            rotationMatrix22.set(expectedRotationMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix22, (Matrix3DReadOnly)expectedRotationMatrix, (double)1.0E-10);
            try {
                rotationMatrix22.set((Matrix3DReadOnly)expectedMatrix);
                EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)rotationMatrix22, (double)1.0E-10);
                continue;
            }
            catch (RuntimeException e) {
                if (!expectedMatrix.isRotationMatrix()) continue;
                throw e;
            }
        }
        RotationMatrix rotationMatrix = new RotationMatrix();
        try {
            rotationMatrix.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
        }
        catch (NotARotationMatrixException rotationMatrix22) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            RotationMatrix other = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            double m00 = other.getM00();
            m01 = other.getM01();
            m02 = other.getM02();
            m10 = other.getM10();
            m11 = other.getM11();
            m12 = other.getM12();
            m20 = other.getM20();
            m21 = other.getM21();
            m22 = other.getM22();
            rotationMatrix.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)other, (Matrix3DReadOnly)rotationMatrix, (double)1.0E-12);
        }
        rotationMatrix = new RotationMatrix();
        rotationMatrix.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertTrue((rotationMatrix.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            RotationMatrix other = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            double m00 = other.getM00();
            m01 = other.getM01();
            m02 = other.getM02();
            m10 = other.getM10();
            m11 = other.getM11();
            m12 = other.getM12();
            m20 = other.getM20();
            m21 = other.getM21();
            m22 = other.getM22();
            rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)other, (Matrix3DReadOnly)rotationMatrix, (double)1.0E-12);
        }
        double[] matrixArray = new double[9];
        RotationMatrix rotationMatrix3 = new RotationMatrix();
        try {
            rotationMatrix3.set(matrixArray);
            Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
        }
        catch (NotARotationMatrixException other) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
        }
        for (int i4 = 0; i4 < 1000; ++i4) {
            RotationMatrix other = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            double m00 = other.getM00();
            double m012 = other.getM01();
            double m022 = other.getM02();
            double m102 = other.getM10();
            double m112 = other.getM11();
            double m122 = other.getM12();
            double m202 = other.getM20();
            double m212 = other.getM21();
            double m222 = other.getM22();
            matrixArray = new double[]{m00, m012, m022, m102, m112, m122, m202, m212, m222};
            rotationMatrix3.set(matrixArray);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)other, (Matrix3DReadOnly)rotationMatrix3, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            int column;
            int row;
            actualMatrix = new RotationMatrix();
            RotationMatrix randomRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
            for (row = 0; row < 3; ++row) {
                for (column = 0; column < 3; ++column) {
                    denseMatrix.set(row, column, randomRotation.getElement(row, column));
                }
            }
            actualMatrix.set((DMatrix)denseMatrix);
            for (row = 0; row < 3; ++row) {
                for (column = 0; column < 3; ++column) {
                    Assertions.assertTrue((denseMatrix.get(row, column) == actualMatrix.getElement(row, column) ? 1 : 0) != 0);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            int column;
            int row;
            actualMatrix = new RotationMatrix();
            RotationMatrix randomRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            int startRow = random.nextInt(10);
            int startColumn = random.nextInt(10);
            DMatrixRMaj denseMatrix = new DMatrixRMaj(3 + startRow, 3 + startColumn);
            for (row = 0; row < 3; ++row) {
                for (column = 0; column < 3; ++column) {
                    denseMatrix.set(row + startRow, column + startColumn, randomRotation.getElement(row, column));
                }
            }
            actualMatrix.set(startRow, startColumn, (DMatrix)denseMatrix);
            for (row = 0; row < 3; ++row) {
                for (column = 0; column < 3; ++column) {
                    Assertions.assertTrue((denseMatrix.get(row + startRow, column + startColumn) == actualMatrix.getElement(row, column) ? 1 : 0) != 0);
                }
            }
        }
        rotationMatrix = new RotationMatrix();
        Vector3D first = new Vector3D();
        Vector3D second = new Vector3D();
        Vector3D third = new Vector3D();
        try {
            rotationMatrix.setColumns((Tuple3DReadOnly)first, (Tuple3DReadOnly)second, (Tuple3DReadOnly)third);
            Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
        }
        catch (NotARotationMatrixException startColumn) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
        }
        for (int i5 = 0; i5 < 1000; ++i5) {
            RotationMatrix other = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            for (int row = 0; row < 3; ++row) {
                first.setElement(row, other.getElement(row, 0));
                second.setElement(row, other.getElement(row, 1));
                third.setElement(row, other.getElement(row, 2));
            }
            rotationMatrix.setColumns((Tuple3DReadOnly)first, (Tuple3DReadOnly)second, (Tuple3DReadOnly)third);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)other, (Matrix3DReadOnly)rotationMatrix, (double)1.0E-12);
        }
        rotationMatrix = new RotationMatrix();
        first = new Vector3D();
        second = new Vector3D();
        third = new Vector3D();
        try {
            rotationMatrix.setRows((Tuple3DReadOnly)first, (Tuple3DReadOnly)second, (Tuple3DReadOnly)third);
            Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
        }
        catch (NotARotationMatrixException i5) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
        }
        for (int i6 = 0; i6 < 1000; ++i6) {
            RotationMatrix other = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            for (int column = 0; column < 3; ++column) {
                first.setElement(column, other.getElement(0, column));
                second.setElement(column, other.getElement(1, column));
                third.setElement(column, other.getElement(2, column));
            }
            rotationMatrix.setRows((Tuple3DReadOnly)first, (Tuple3DReadOnly)second, (Tuple3DReadOnly)third);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)other, (Matrix3DReadOnly)rotationMatrix, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendYawPitchRoll() throws Exception {
        RotationMatrix original;
        int i;
        Random random = new Random(35454L);
        RotationMatrix expected = new RotationMatrix();
        RotationMatrix actual = new RotationMatrix();
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix yawRotation = new RotationMatrix();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            yawRotation.setToYawOrientation(yaw);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)original, (RotationMatrixReadOnly)yawRotation, (CommonMatrix3DBasics)expected);
            actual.set(original);
            actual.appendYawRotation(yaw);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix pitchRotation = new RotationMatrix();
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            pitchRotation.setToPitchOrientation(pitch);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)original, (RotationMatrixReadOnly)pitchRotation, (CommonMatrix3DBasics)expected);
            actual.set(original);
            actual.appendPitchRotation(pitch);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix rollRotation = new RotationMatrix();
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rollRotation.setToRollOrientation(roll);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)original, (RotationMatrixReadOnly)rollRotation, (CommonMatrix3DBasics)expected);
            actual.set(original);
            actual.appendRollRotation(roll);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPrependYawPitchRoll() throws Exception {
        RotationMatrix original;
        int i;
        Random random = new Random(35454L);
        RotationMatrix expected = new RotationMatrix();
        RotationMatrix actual = new RotationMatrix();
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix yawRotation = new RotationMatrix();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            yawRotation.setToYawOrientation(yaw);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)yawRotation, (RotationMatrixReadOnly)original, (CommonMatrix3DBasics)expected);
            actual.set(original);
            actual.prependYawRotation(yaw);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix pitchRotation = new RotationMatrix();
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            pitchRotation.setToPitchOrientation(pitch);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)pitchRotation, (RotationMatrixReadOnly)original, (CommonMatrix3DBasics)expected);
            actual.set(original);
            actual.prependPitchRotation(pitch);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix rollRotation = new RotationMatrix();
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rollRotation.setToRollOrientation(roll);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)rollRotation, (RotationMatrixReadOnly)original, (CommonMatrix3DBasics)expected);
            actual.set(original);
            actual.prependRollRotation(roll);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testInterpolate() throws Exception {
        Quaternion qf;
        int i;
        Random random = new Random(3245235L);
        for (i = 0; i < 1000; ++i) {
            RotationMatrix actual = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix expected = new RotationMatrix();
            RotationMatrix rf = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            qf = new Quaternion((Orientation3DReadOnly)rf);
            double alpha = random.nextDouble();
            Quaternion qInterpolated = new Quaternion((Orientation3DReadOnly)actual);
            qInterpolated.interpolate((QuaternionReadOnly)qf, alpha);
            expected.set((Orientation3DReadOnly)qInterpolated);
            actual.interpolate((RotationMatrixReadOnly)rf, alpha);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-5);
        }
        for (i = 0; i < 1000; ++i) {
            RotationMatrix r0 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix rf = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Quaternion q0 = new Quaternion((Orientation3DReadOnly)r0);
            qf = new Quaternion((Orientation3DReadOnly)rf);
            RotationMatrix actual = new RotationMatrix();
            RotationMatrix expected = new RotationMatrix();
            double alpha = random.nextDouble();
            Quaternion qInterpolated = new Quaternion();
            qInterpolated.interpolate((QuaternionReadOnly)q0, (QuaternionReadOnly)qf, alpha);
            expected.set((Orientation3DReadOnly)qInterpolated);
            actual.interpolate((RotationMatrixReadOnly)r0, (RotationMatrixReadOnly)rf, alpha);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-5);
        }
    }

    @Test
    public void testSetToYawPitchRollMatrix() {
        Random random = new Random(35454L);
        RotationMatrix rotationMatrixCopy = new RotationMatrix();
        for (int i = 0; i < 1000; ++i) {
            double yawCopy;
            double rollCopy;
            double pitchCopy;
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrixCopy.set(rotationMatrix);
            double pitch = pitchCopy = random.nextDouble();
            rotationMatrix.setToNaN();
            rotationMatrixCopy.setToNaN();
            rotationMatrix.setToPitchOrientation(pitch);
            RotationMatrixConversion.computePitchMatrix((double)pitch, (CommonMatrix3DBasics)rotationMatrixCopy);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
            Assertions.assertTrue((pitch == pitchCopy ? 1 : 0) != 0);
            double roll = rollCopy = random.nextDouble();
            rotationMatrix.setToNaN();
            rotationMatrixCopy.setToNaN();
            rotationMatrix.setToRollOrientation(roll);
            RotationMatrixConversion.computeRollMatrix((double)roll, (CommonMatrix3DBasics)rotationMatrixCopy);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
            Assertions.assertTrue((roll == rollCopy ? 1 : 0) != 0);
            double yaw = yawCopy = random.nextDouble();
            rotationMatrix.setToNaN();
            rotationMatrixCopy.setToNaN();
            rotationMatrix.setToYawOrientation(yaw);
            RotationMatrixConversion.computeYawMatrix((double)yaw, (CommonMatrix3DBasics)rotationMatrixCopy);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
            Assertions.assertTrue((yaw == yawCopy ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetYawPitchRoll() {
        Random random = new Random(6465L);
        RotationMatrix rotationMatrixCopy = new RotationMatrix();
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrixCopy.set(rotationMatrix);
            YawPitchRoll yawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            rotationMatrix.setYawPitchRoll(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll());
            RotationMatrixConversion.convertYawPitchRollToMatrix((YawPitchRollReadOnly)yawPitchRoll, (CommonMatrix3DBasics)rotationMatrixCopy);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
        }
    }

    @Test
    public void testSetEuler() {
        Vector3D eulerAngles;
        Vector3D eulerAnglesCopy;
        RotationMatrix rotationMatrix;
        RotationMatrix rotationMatrixCopy;
        int i;
        Random random = new Random(65466L);
        RotationMatrix yawPitchRoll = new RotationMatrix();
        RotationMatrix expected = new RotationMatrix();
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = rotationMatrixCopy = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            eulerAngles = eulerAnglesCopy = EuclidCoreRandomTools.nextVector3D((Random)random);
            yawPitchRoll.setEuler((Vector3DReadOnly)eulerAngles);
            RotationMatrixConversion.convertYawPitchRollToMatrix((double)eulerAngles.getZ(), (double)eulerAngles.getY(), (double)eulerAngles.getX(), (CommonMatrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
            EuclidCoreTestTools.assertRotationVectorGeometricallyEquals((Vector3DReadOnly)eulerAngles, (Vector3DReadOnly)eulerAnglesCopy, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)yawPitchRoll, (Matrix3DReadOnly)expected, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = rotationMatrixCopy = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            eulerAngles = eulerAnglesCopy = EuclidCoreRandomTools.nextVector3D((Random)random);
            yawPitchRoll.setEuler(eulerAngles.getX(), eulerAngles.getY(), eulerAngles.getZ());
            RotationMatrixConversion.convertYawPitchRollToMatrix((double)eulerAngles.getZ(), (double)eulerAngles.getY(), (double)eulerAngles.getX(), (CommonMatrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
            EuclidCoreTestTools.assertRotationVectorGeometricallyEquals((Vector3DReadOnly)eulerAngles, (Vector3DReadOnly)eulerAnglesCopy, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)yawPitchRoll, (Matrix3DReadOnly)expected, (double)1.0E-10);
        }
    }

    @Test
    public void testDistance() throws Exception {
        Random random = new Random(3242L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix m1 = this.createRandomMatrix(random);
            RotationMatrix m2 = this.createRandomMatrix(random);
            double actualDistance = m1.distance((RotationMatrixReadOnly)m2);
            double expectedDistance = RotationMatrixTools.distance((RotationMatrixReadOnly)m1, (RotationMatrixReadOnly)m2);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-10);
        }
    }

    @Test
    public void testGet() {
        Random random = new Random(6841L);
        RotationMatrix rotationMatrixCopy = new RotationMatrix();
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = rotationMatrixCopy = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Vector3D vector = new Vector3D();
            Vector3D expectedVector = new Vector3D();
            rotationMatrix.getRotationVector((Vector3DBasics)vector);
            RotationVectorConversion.convertMatrixToRotationVector((RotationMatrixReadOnly)rotationMatrix, (Vector3DBasics)expectedVector);
            EuclidCoreTestTools.assertRotationVectorGeometricallyEquals((Vector3DReadOnly)vector, (Vector3DReadOnly)expectedVector, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
        }
    }

    @Test
    public void testGetEuler() {
        Random random = new Random(65466L);
        RotationMatrix yawPitchRoll = new RotationMatrix();
        Vector3D eulerAngles = new Vector3D();
        Vector3D eulerAnglesCopy = new Vector3D();
        for (int i = 0; i < 1000; ++i) {
            try {
                RotationMatrix expected = yawPitchRoll = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
                yawPitchRoll.getEuler((Tuple3DBasics)eulerAngles);
                YawPitchRollConversion.convertMatrixToYawPitchRoll((RotationMatrixReadOnly)expected, (Tuple3DBasics)eulerAnglesCopy);
                EuclidCoreTestTools.assertRotationVectorGeometricallyEquals((Vector3DReadOnly)eulerAngles, (Vector3DReadOnly)eulerAnglesCopy, (double)1.0E-10);
                EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)yawPitchRoll, (Matrix3DReadOnly)expected, (double)1.0E-10);
                continue;
            }
            catch (AssertionError e) {
                double pitch = YawPitchRollConversion.computePitch((RotationMatrixReadOnly)yawPitchRoll);
                if (Double.isNaN(pitch)) continue;
                throw e;
            }
        }
    }

    @Test
    public void testGetToYawPitchRollMatrix() {
        Random random = new Random(35454L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix expectedMatrix;
            RotationMatrix rotationMatrix = expectedMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            double pitch = rotationMatrix.getPitch();
            double expectedPitch = YawPitchRollConversion.computePitch((RotationMatrixReadOnly)expectedMatrix);
            Assertions.assertEquals((double)pitch, (double)expectedPitch, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)expectedMatrix, (double)1.0E-10);
            double roll = rotationMatrix.getRoll();
            double expectedRoll = YawPitchRollConversion.computeRoll((RotationMatrixReadOnly)expectedMatrix);
            Assertions.assertEquals((double)roll, (double)expectedRoll, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)expectedMatrix, (double)1.0E-10);
            double yaw = rotationMatrix.getYaw();
            double expectedYaw = YawPitchRollConversion.computeYaw((RotationMatrixReadOnly)expectedMatrix);
            Assertions.assertEquals((double)yaw, (double)expectedYaw, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)expectedMatrix, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)expectedMatrix, (double)1.0E-10);
        }
    }

    @Test
    public void testApplyTransform() {
        RotationMatrix actual;
        RotationMatrix expected;
        RotationMatrix original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = this.createRandomMatrix(random);
            expected = new RotationMatrix();
            actual = new RotationMatrix();
            expected.set(original);
            expected.preMultiply((RotationMatrixReadOnly)transform.getRotation());
            actual.set(original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
            double m00 = original.getM00();
            double m01 = original.getM01();
            double m02 = original.getM02();
            double m10 = original.getM10();
            double m11 = original.getM11();
            double m12 = original.getM12();
            double m20 = original.getM20();
            double m21 = original.getM21();
            double m22 = original.getM22();
            actual.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = this.createRandomMatrix(random);
            expected = new RotationMatrix();
            actual = new RotationMatrix();
            expected.set(original);
            expected.prepend((Orientation3DReadOnly)transform.getRotation());
            actual.set(original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            original = this.createRandomMatrix(random);
            expected = new RotationMatrix();
            actual = new RotationMatrix();
            expected.set(original);
            expected.prepend((Orientation3DReadOnly)transform.getLinearTransform().getAsQuaternion());
            actual.set(original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testApplyInverseTransform() {
        RotationMatrix actual;
        RotationMatrix expected;
        RotationMatrix original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = this.createRandomMatrix(random);
            expected = new RotationMatrix();
            actual = new RotationMatrix();
            expected.set(original);
            actual.set(original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = this.createRandomMatrix(random);
            expected = new RotationMatrix();
            actual = new RotationMatrix();
            expected.set(original);
            actual.set(original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            original = this.createRandomMatrix(random);
            expected = new RotationMatrix();
            actual = new RotationMatrix();
            expected.set(original);
            actual.set(original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testInvert() {
        Random random = new Random(65474L);
        RotationMatrix expectedMatrix = new RotationMatrix();
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expectedMatrix.set(rotationMatrix);
            rotationMatrix.invert();
            expectedMatrix.transpose();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)expectedMatrix, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiply() {
        RotationMatrix multiplied;
        RotationMatrix rotationMatrix;
        int i;
        Random random = new Random(645864L);
        RotationMatrix expected = new RotationMatrix();
        RotationMatrix rotationMatrixCopy = new RotationMatrix();
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrixCopy.set(rotationMatrix);
            multiplied = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.set(multiplied);
            multiplied.multiply((RotationMatrixReadOnly)rotationMatrix);
            expected.checkIfRotationMatrix();
            RotationMatrixTools.multiply((RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)rotationMatrixCopy, (CommonMatrix3DBasics)expected);
            expected.normalize();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)multiplied, (Matrix3DReadOnly)expected, (double)1.0E-10);
            Assertions.assertEquals((double)1.0, (double)multiplied.determinant(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrixCopy.set(rotationMatrix);
            multiplied = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.set(multiplied);
            multiplied.multiplyTransposeThis((RotationMatrixReadOnly)rotationMatrix);
            expected.checkIfRotationMatrix();
            RotationMatrixTools.multiplyTransposeLeft((RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)rotationMatrixCopy, (CommonMatrix3DBasics)expected);
            expected.normalize();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)multiplied, (Matrix3DReadOnly)expected, (double)1.0E-10);
            Assertions.assertEquals((double)1.0, (double)multiplied.determinant(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrixCopy.set(rotationMatrix);
            multiplied = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.set(multiplied);
            multiplied.multiplyTransposeOther((RotationMatrixReadOnly)rotationMatrix);
            expected.checkIfRotationMatrix();
            RotationMatrixTools.multiplyTransposeRight((RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)rotationMatrixCopy, (CommonMatrix3DBasics)expected);
            expected.normalize();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)multiplied, (Matrix3DReadOnly)expected, (double)1.0E-10);
            Assertions.assertEquals((double)1.0, (double)multiplied.determinant(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrixCopy.set(rotationMatrix);
            multiplied = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.set(multiplied);
            multiplied.multiplyTransposeBoth((RotationMatrixReadOnly)rotationMatrix);
            expected.checkIfRotationMatrix();
            RotationMatrixTools.multiplyTransposeBoth((RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)rotationMatrixCopy, (CommonMatrix3DBasics)expected);
            expected.normalize();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)multiplied, (Matrix3DReadOnly)expected, (double)1.0E-10);
            Assertions.assertEquals((double)1.0, (double)multiplied.determinant(), (double)1.0E-10);
        }
    }

    @Test
    public void testNumericalError() throws Exception {
        RotationMatrix multiplyWith;
        int i;
        Random random = new Random(53463L);
        RotationMatrix unnormalized = new RotationMatrix();
        RotationMatrix normalized = new RotationMatrix();
        for (i = 0; i < 269000; ++i) {
            multiplyWith = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            unnormalized.multiply((RotationMatrixReadOnly)multiplyWith);
            normalized.multiply((RotationMatrixReadOnly)multiplyWith);
            normalized.normalize();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)normalized, (Matrix3DReadOnly)unnormalized, (double)1.0E-10);
            Assertions.assertTrue((boolean)unnormalized.isRotationMatrix(1.0E-11), (String)("At multiplication #" + i + "."));
        }
        unnormalized = new RotationMatrix();
        normalized = new RotationMatrix();
        for (i = 0; i < 111000; ++i) {
            multiplyWith = EuclidCoreRandomTools.nextQuaternion((Random)random);
            unnormalized.append((Orientation3DReadOnly)multiplyWith);
            normalized.append((Orientation3DReadOnly)multiplyWith);
            normalized.normalize();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)normalized, (Matrix3DReadOnly)unnormalized, (double)1.0E-10);
            Assertions.assertTrue((boolean)unnormalized.isRotationMatrix(1.0E-11), (String)("At multiplication #" + i + "."));
        }
        unnormalized = new RotationMatrix();
        normalized = new RotationMatrix();
        for (i = 0; i < 268000; ++i) {
            multiplyWith = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            unnormalized.append((Orientation3DReadOnly)multiplyWith);
            normalized.append((Orientation3DReadOnly)multiplyWith);
            normalized.normalize();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)normalized, (Matrix3DReadOnly)unnormalized, (double)1.0E-10);
            Assertions.assertTrue((boolean)unnormalized.isRotationMatrix(1.0E-11), (String)("At multiplication #" + i + "."));
        }
    }

    @Test
    public void testPreMultiply() {
        RotationMatrix multiplied;
        RotationMatrix rotationMatrix;
        int i;
        Random random = new Random(645864L);
        RotationMatrix expected = new RotationMatrix();
        RotationMatrix rotationMatrixCopy = new RotationMatrix();
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrixCopy.set(rotationMatrix);
            multiplied = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.set(multiplied);
            multiplied.preMultiply((RotationMatrixReadOnly)rotationMatrix);
            expected.checkIfRotationMatrix();
            RotationMatrixTools.multiply((RotationMatrixReadOnly)rotationMatrixCopy, (RotationMatrixReadOnly)expected, (CommonMatrix3DBasics)expected);
            expected.normalize();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)multiplied, (Matrix3DReadOnly)expected, (double)1.0E-10);
            Assertions.assertEquals((double)1.0, (double)multiplied.determinant(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrixCopy.set(rotationMatrix);
            multiplied = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.set(multiplied);
            multiplied.preMultiplyTransposeThis((RotationMatrixReadOnly)rotationMatrix);
            expected.checkIfRotationMatrix();
            RotationMatrixTools.multiplyTransposeRight((RotationMatrixReadOnly)rotationMatrixCopy, (RotationMatrixReadOnly)expected, (CommonMatrix3DBasics)expected);
            expected.normalize();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)multiplied, (Matrix3DReadOnly)expected, (double)1.0E-10);
            Assertions.assertEquals((double)1.0, (double)multiplied.determinant(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrixCopy.set(rotationMatrix);
            multiplied = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.set(multiplied);
            multiplied.preMultiplyTransposeOther((RotationMatrixReadOnly)rotationMatrix);
            expected.checkIfRotationMatrix();
            RotationMatrixTools.multiplyTransposeLeft((RotationMatrixReadOnly)rotationMatrixCopy, (RotationMatrixReadOnly)expected, (CommonMatrix3DBasics)expected);
            expected.normalize();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)multiplied, (Matrix3DReadOnly)expected, (double)1.0E-10);
            Assertions.assertEquals((double)1.0, (double)multiplied.determinant(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrixCopy.set(rotationMatrix);
            multiplied = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.set(multiplied);
            multiplied.preMultiplyTransposeBoth((RotationMatrixReadOnly)rotationMatrix);
            expected.checkIfRotationMatrix();
            RotationMatrixTools.multiplyTransposeBoth((RotationMatrixReadOnly)rotationMatrixCopy, (RotationMatrixReadOnly)expected, (CommonMatrix3DBasics)expected);
            expected.normalize();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)multiplied, (Matrix3DReadOnly)expected, (double)1.0E-10);
            Assertions.assertEquals((double)1.0, (double)multiplied.determinant(), (double)1.0E-10);
        }
    }

    @Test
    public void testNormalize() throws Exception {
        Random random = new Random(39456L);
        RotationMatrix matrixExpected = new RotationMatrix();
        RotationMatrix matrixActual = new RotationMatrix();
        matrixActual.setIdentity();
        matrixExpected.setIdentity();
        matrixActual.normalize();
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        for (int i = 0; i < 1000; ++i) {
            matrixExpected.set(EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            matrixActual.set(matrixExpected);
            matrixActual.normalize();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        }
        Vector3D vector1 = new Vector3D();
        Vector3D vector2 = new Vector3D();
        double corruptionFactor = 0.1;
        for (int i = 0; i < 1000; ++i) {
            int j;
            RotationMatrix randomRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            double m00 = randomRotation.getM00() + corruptionFactor * random.nextDouble();
            double m01 = randomRotation.getM01() + corruptionFactor * random.nextDouble();
            double m02 = randomRotation.getM02() + corruptionFactor * random.nextDouble();
            double m10 = randomRotation.getM10() + corruptionFactor * random.nextDouble();
            double m11 = randomRotation.getM11() + corruptionFactor * random.nextDouble();
            double m12 = randomRotation.getM12() + corruptionFactor * random.nextDouble();
            double m20 = randomRotation.getM20() + corruptionFactor * random.nextDouble();
            double m21 = randomRotation.getM21() + corruptionFactor * random.nextDouble();
            double m22 = randomRotation.getM22() + corruptionFactor * random.nextDouble();
            matrixActual.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            matrixActual.normalize();
            for (j = 0; j < 3; ++j) {
                matrixActual.getRow(j, (Tuple3DBasics)vector1);
                Assertions.assertEquals((double)1.0, (double)vector1.length(), (double)1.0E-10);
                matrixActual.getColumn(j, (Tuple3DBasics)vector1);
                Assertions.assertEquals((double)1.0, (double)vector1.length(), (double)1.0E-10);
            }
            for (j = 0; j < 3; ++j) {
                matrixActual.getRow(j, (Tuple3DBasics)vector1);
                matrixActual.getRow((j + 1) % 3, (Tuple3DBasics)vector2);
                Assertions.assertEquals((double)0.0, (double)vector1.dot((Vector3DReadOnly)vector2), (double)1.0E-10);
                matrixActual.getColumn(j, (Tuple3DBasics)vector1);
                matrixActual.getColumn((j + 1) % 3, (Tuple3DBasics)vector2);
                Assertions.assertEquals((double)0.0, (double)vector1.dot((Vector3DReadOnly)vector2), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testSetAndNormalize() throws Exception {
        Random random = new Random(39456L);
        RotationMatrix matrixExpected = new RotationMatrix();
        RotationMatrix matrixActual = new RotationMatrix();
        for (int i = 0; i < 1000; ++i) {
            matrixExpected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            double m00 = matrixExpected.getM00();
            double m01 = matrixExpected.getM01();
            double m02 = matrixExpected.getM02();
            double m10 = matrixExpected.getM10();
            double m11 = matrixExpected.getM11();
            double m12 = matrixExpected.getM12();
            double m20 = matrixExpected.getM20();
            double m21 = matrixExpected.getM21();
            double m22 = matrixExpected.getM22();
            matrixActual.setAndNormalize(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
            matrixActual.setToNaN();
            matrixActual.setAndNormalize((RotationMatrixReadOnly)matrixExpected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
            matrixActual.setToNaN();
            matrixActual.setAndNormalize((Matrix3DReadOnly)matrixExpected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
            matrixActual.setToNaN();
            matrixActual.setAndNormalize((Orientation3DReadOnly)matrixExpected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        }
        double corruptionFactor = 0.1;
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix corrupted = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            double m00 = corrupted.getM00() + corruptionFactor * random.nextDouble();
            double m01 = corrupted.getM01() + corruptionFactor * random.nextDouble();
            double m02 = corrupted.getM02() + corruptionFactor * random.nextDouble();
            double m10 = corrupted.getM10() + corruptionFactor * random.nextDouble();
            double m11 = corrupted.getM11() + corruptionFactor * random.nextDouble();
            double m12 = corrupted.getM12() + corruptionFactor * random.nextDouble();
            double m20 = corrupted.getM20() + corruptionFactor * random.nextDouble();
            double m21 = corrupted.getM21() + corruptionFactor * random.nextDouble();
            double m22 = corrupted.getM22() + corruptionFactor * random.nextDouble();
            corrupted.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            matrixExpected.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            matrixExpected.normalize();
            matrixActual.setAndNormalize(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
            matrixActual.setToNaN();
            matrixActual.setAndNormalize((RotationMatrixReadOnly)corrupted);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
            matrixActual.setToNaN();
            matrixActual.setAndNormalize((Matrix3DReadOnly)corrupted);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
            matrixActual.setToNaN();
            matrixActual.setAndNormalize((Orientation3DReadOnly)corrupted);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        }
    }

    @Test
    public void testSetAndInvert() throws Exception {
        Random random = new Random(545L);
        RotationMatrix matrixActual = new RotationMatrix();
        RotationMatrix matrixExpected = new RotationMatrix();
        RotationMatrix randomMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        matrixExpected.set(randomMatrix);
        matrixExpected.invert();
        matrixActual.setAndInvert((RotationMatrixReadOnly)randomMatrix);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        matrixActual.setToNaN();
        matrixActual.setAndInvert((Matrix3DReadOnly)randomMatrix);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
    }

    @Test
    public void testSetAndTranspose() throws Exception {
        Random random = new Random(545L);
        RotationMatrix matrixActual = new RotationMatrix();
        RotationMatrix matrixExpected = new RotationMatrix();
        RotationMatrix randomMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        matrixExpected.set(randomMatrix);
        matrixExpected.transpose();
        matrixActual.setAndTranspose((Matrix3DReadOnly)randomMatrix);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        matrixActual.setToNaN();
        matrixActual.setAndTranspose((Matrix3DReadOnly)randomMatrix);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
    }

    @Test
    public void testTransformTuple() throws Exception {
        Vector3D original1;
        Vector3D original0;
        RotationMatrix matrix;
        Vector3D expected;
        Vector3D actual;
        int i;
        Random random = new Random(435L);
        for (i = 0; i < 1000; ++i) {
            actual = new Vector3D();
            expected = new Vector3D();
            matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Vector3D original = EuclidCoreRandomTools.nextVector3D((Random)random);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)original, (Tuple3DBasics)expected);
            actual.set(original);
            matrix.transform((Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-10);
            actual.setToNaN();
            matrix.transform((Tuple3DReadOnly)original, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-10);
            matrix.setToZero();
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)original, (Tuple3DBasics)expected);
            actual.setToNaN();
            matrix.transform((Tuple3DReadOnly)original, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidCoreRandomTools.nextVector3D((Random)random);
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            original0 = EuclidCoreRandomTools.nextVector3D((Random)random);
            original1 = EuclidCoreRandomTools.nextVector3D((Random)random);
            expected.set(original1);
            actual.set(original1);
            Matrix3DTools.addTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)expected, (Tuple3DBasics)expected);
            matrix.addTransform((Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-10);
            expected.set(original1);
            actual.set(original1);
            Matrix3DTools.addTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)original0, (Tuple3DBasics)expected);
            matrix.addTransform((Tuple3DReadOnly)original0, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-10);
            matrix.setToZero();
            expected.set(original1);
            actual.set(original1);
            Matrix3DTools.addTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)original0, (Tuple3DBasics)expected);
            matrix.addTransform((Tuple3DReadOnly)original0, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidCoreRandomTools.nextVector3D((Random)random);
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            original0 = EuclidCoreRandomTools.nextVector3D((Random)random);
            original1 = EuclidCoreRandomTools.nextVector3D((Random)random);
            expected.set(original1);
            actual.set(original1);
            Matrix3DTools.subTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)expected, (Tuple3DBasics)expected);
            matrix.subTransform((Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-10);
            expected.set(original1);
            actual.set(original1);
            Matrix3DTools.subTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)original0, (Tuple3DBasics)expected);
            matrix.subTransform((Tuple3DReadOnly)original0, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-10);
            matrix.setToZero();
            expected.set(original1);
            actual.set(original1);
            Matrix3DTools.subTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)original0, (Tuple3DBasics)expected);
            matrix.subTransform((Tuple3DReadOnly)original0, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testTransformTuple2D() throws Exception {
        Random random = new Random(435L);
        Vector2D actual = new Vector2D();
        Vector2D expected = new Vector2D();
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix matrix = new RotationMatrix();
            matrix.setToYawOrientation(Math.PI * 2 * random.nextDouble());
            Vector2D original = EuclidCoreRandomTools.nextVector2D((Random)random);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)true);
            actual.set(original);
            matrix.transform((Tuple2DBasics)actual);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-10);
            actual.setToNaN();
            matrix.transform((Tuple2DReadOnly)original, (Tuple2DBasics)actual);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-10);
            actual.setToNaN();
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)true);
            actual.set(original);
            matrix.transform((Tuple2DBasics)actual, true);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-10);
            actual.setToNaN();
            matrix.transform((Tuple2DReadOnly)original, (Tuple2DBasics)actual, true);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-10);
            matrix.setToZero();
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)true);
            actual.set(original);
            matrix.transform((Tuple2DBasics)actual);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testTransformMatrix() throws Exception {
        Random random = new Random(435L);
        Matrix3D actual = new Matrix3D();
        Matrix3D expected = new Matrix3D();
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Matrix3D original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            actual.set(original);
            matrix.transform((Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
            actual.setToNaN();
            matrix.transform((Matrix3DReadOnly)original, (Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
            matrix.setToZero();
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            actual.set(original);
            matrix.transform((Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testTransformQuaternion() throws Exception {
        Random random = new Random(435L);
        Quaternion actual = new Quaternion();
        Quaternion expected = new Quaternion();
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Quaternion original = EuclidCoreRandomTools.nextQuaternion((Random)random);
            matrix.transform((Orientation3DReadOnly)original, (Orientation3DBasics)expected);
            actual.set(original);
            matrix.transform((Orientation3DBasics)actual);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)actual, (double)1.0E-10);
            actual.setToNaN();
            matrix.transform((Orientation3DReadOnly)original, (Orientation3DBasics)actual);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)actual, (double)1.0E-10);
            matrix.setToZero();
            matrix.transform((Orientation3DReadOnly)original, (Orientation3DBasics)expected);
            actual.set(original);
            matrix.transform((Orientation3DBasics)actual);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testTransformVector4D() throws Exception {
        Random random = new Random(435L);
        Vector4D actual = new Vector4D();
        Vector4D expected = new Vector4D();
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Vector4D original = EuclidCoreRandomTools.nextVector4D((Random)random);
            matrix.transform((Vector4DReadOnly)original, (Vector4DBasics)expected);
            actual.set(original);
            matrix.transform((Vector4DBasics)actual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
            actual.setToNaN();
            matrix.transform((Vector4DReadOnly)original, (Vector4DBasics)actual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
            matrix.setToZero();
            matrix.transform((Vector4DReadOnly)original, (Vector4DBasics)expected);
            actual.set(original);
            matrix.transform((Vector4DBasics)actual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testTransformRotationMatrix() throws Exception {
        Random random = new Random(435L);
        RotationMatrix actual = new RotationMatrix();
        Matrix3D expected = new Matrix3D();
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Matrix3DTools.multiply((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)original, (CommonMatrix3DBasics)expected);
            matrix.transform((RotationMatrixReadOnly)original, (RotationMatrixBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
            actual.set(original);
            matrix.transform((RotationMatrixBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
            matrix.setToZero();
            Matrix3DTools.multiply((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)original, (CommonMatrix3DBasics)expected);
            matrix.transform((RotationMatrixReadOnly)original, (RotationMatrixBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Override
    @Test
    public void testInverseTransform() throws Exception {
        Quaternion expected;
        Quaternion actual;
        Quaternion original;
        int i;
        double theta;
        Vector3D expectedTuple;
        Vector3D actualTuple;
        Vector3D tuple;
        int i2;
        super.testInverseTransform();
        Random random = new Random(6787L);
        RotationMatrix rotationMatrix = this.createEmptyMatrix();
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = new Vector3D((Tuple3DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            rotationMatrix = this.createRandomMatrix(random);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            rotationMatrix.inverseTransform((Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedTuple, (Tuple3DReadOnly)actualTuple, (double)1.0E-10);
            rotationMatrix.setToZero();
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            actualTuple.set((Tuple3DReadOnly)tuple);
            rotationMatrix.inverseTransform((Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedTuple, (Tuple3DReadOnly)actualTuple, (double)1.0E-10);
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = new Vector3D((Tuple3DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            rotationMatrix = this.createRandomMatrix(random);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            rotationMatrix.inverseTransform((Tuple3DReadOnly)tuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedTuple, (Tuple3DReadOnly)actualTuple, (double)1.0E-10);
            rotationMatrix.setToZero();
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            rotationMatrix.inverseTransform((Tuple3DReadOnly)tuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedTuple, (Tuple3DReadOnly)actualTuple, (double)1.0E-10);
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            actualTuple = new Vector2D((Tuple2DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rotationMatrix.setToYawOrientation(theta);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Tuple2DReadOnly)tuple, (Tuple2DBasics)expectedTuple, (boolean)false);
            rotationMatrix.inverseTransform((Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedTuple, (Tuple2DReadOnly)actualTuple, (double)1.0E-10);
            actualTuple.set((Tuple2DReadOnly)tuple);
            rotationMatrix.inverseTransform((Tuple2DBasics)actualTuple, true);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedTuple, (Tuple2DReadOnly)actualTuple, (double)1.0E-10);
            actualTuple.set((Tuple2DReadOnly)tuple);
            rotationMatrix.inverseTransform((Tuple2DBasics)actualTuple, false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedTuple, (Tuple2DReadOnly)actualTuple, (double)1.0E-10);
            rotationMatrix.setToZero();
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Tuple2DReadOnly)tuple, (Tuple2DBasics)expectedTuple, (boolean)false);
            actualTuple.set((Tuple2DReadOnly)tuple);
            rotationMatrix.inverseTransform((Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedTuple, (Tuple2DReadOnly)actualTuple, (double)1.0E-10);
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            tuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            actualTuple = new Vector2D((Tuple2DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rotationMatrix.setToYawOrientation(theta);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Tuple2DReadOnly)tuple, (Tuple2DBasics)expectedTuple, (boolean)false);
            rotationMatrix.inverseTransform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedTuple, (Tuple2DReadOnly)actualTuple, (double)1.0E-10);
            rotationMatrix.inverseTransform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple, true);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedTuple, (Tuple2DReadOnly)actualTuple, (double)1.0E-10);
            rotationMatrix.inverseTransform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple, false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedTuple, (Tuple2DReadOnly)actualTuple, (double)1.0E-10);
            rotationMatrix.setToZero();
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Tuple2DReadOnly)tuple, (Tuple2DBasics)expectedTuple, (boolean)false);
            rotationMatrix.inverseTransform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedTuple, (Tuple2DReadOnly)actualTuple, (double)1.0E-10);
        }
        try {
            rotationMatrix = this.createRandomMatrix(random);
            rotationMatrix.inverseTransform((Tuple2DBasics)new Vector2D());
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeException i3) {
            // empty catch block
        }
        try {
            rotationMatrix = this.createRandomMatrix(random);
            rotationMatrix.inverseTransform((Tuple2DReadOnly)new Vector2D(), (Tuple2DBasics)new Vector2D());
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeException i3) {
            // empty catch block
        }
        try {
            rotationMatrix = this.createRandomMatrix(random);
            rotationMatrix.inverseTransform((Tuple2DBasics)new Vector2D(), true);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeException i3) {
            // empty catch block
        }
        try {
            rotationMatrix = this.createRandomMatrix(random);
            rotationMatrix.inverseTransform((Tuple2DReadOnly)new Vector2D(), (Tuple2DBasics)new Vector2D(), true);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeException i3) {
            // empty catch block
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actual = new Quaternion((QuaternionReadOnly)original);
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            rotationMatrix = this.createRandomMatrix(random);
            QuaternionTools.multiply((Orientation3DReadOnly)rotationMatrix, (boolean)true, (QuaternionReadOnly)original, (boolean)false, (QuaternionBasics)expected);
            rotationMatrix.inverseTransform((Orientation3DBasics)actual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
            rotationMatrix.setToZero();
            QuaternionTools.multiply((Orientation3DReadOnly)rotationMatrix, (boolean)true, (QuaternionReadOnly)original, (boolean)false, (QuaternionBasics)expected);
            actual.set((QuaternionReadOnly)original);
            rotationMatrix.inverseTransform((Orientation3DBasics)actual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actual = new Quaternion((QuaternionReadOnly)original);
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            rotationMatrix = this.createRandomMatrix(random);
            QuaternionTools.multiply((Orientation3DReadOnly)rotationMatrix, (boolean)true, (QuaternionReadOnly)original, (boolean)false, (QuaternionBasics)expected);
            rotationMatrix.inverseTransform((Orientation3DReadOnly)original, (Orientation3DBasics)actual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
            rotationMatrix.setToZero();
            QuaternionTools.multiply((Orientation3DReadOnly)rotationMatrix, (boolean)true, (QuaternionReadOnly)original, (boolean)false, (QuaternionBasics)expected);
            rotationMatrix.inverseTransform((Orientation3DReadOnly)original, (Orientation3DBasics)actual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D((Tuple4DReadOnly)original);
            expected = EuclidCoreRandomTools.nextVector4D((Random)random);
            rotationMatrix = this.createRandomMatrix(random);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Vector4DReadOnly)original, (Vector4DBasics)expected);
            rotationMatrix.inverseTransform((Vector4DBasics)actual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
            rotationMatrix.setToZero();
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Vector4DReadOnly)original, (Vector4DBasics)expected);
            actual.set((Tuple4DReadOnly)original);
            rotationMatrix.inverseTransform((Vector4DBasics)actual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D((Tuple4DReadOnly)original);
            expected = EuclidCoreRandomTools.nextVector4D((Random)random);
            rotationMatrix = this.createRandomMatrix(random);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Vector4DReadOnly)original, (Vector4DBasics)expected);
            rotationMatrix.inverseTransform((Vector4DReadOnly)original, (Vector4DBasics)actual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
            rotationMatrix.setToZero();
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Vector4DReadOnly)original, (Vector4DBasics)expected);
            rotationMatrix.inverseTransform((Vector4DReadOnly)original, (Vector4DBasics)actual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D((Matrix3DReadOnly)original);
            expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            rotationMatrix = this.createRandomMatrix(random);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            rotationMatrix.inverseTransform((Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
            rotationMatrix.setToZero();
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)original);
            rotationMatrix.inverseTransform((Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D((Matrix3DReadOnly)original);
            expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            rotationMatrix = this.createRandomMatrix(random);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            rotationMatrix.inverseTransform((Matrix3DReadOnly)original, (Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
            rotationMatrix.setToZero();
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            rotationMatrix.inverseTransform((Matrix3DReadOnly)original, (Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix((RotationMatrixReadOnly)original);
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrix = this.createRandomMatrix(random);
            RotationMatrixTools.multiplyTransposeLeft((RotationMatrixReadOnly)rotationMatrix, (RotationMatrixReadOnly)original, (CommonMatrix3DBasics)expected);
            rotationMatrix.inverseTransform((RotationMatrixBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
            rotationMatrix.setToZero();
            RotationMatrixTools.multiplyTransposeLeft((RotationMatrixReadOnly)rotationMatrix, (RotationMatrixReadOnly)original, (CommonMatrix3DBasics)expected);
            actual.set((RotationMatrixReadOnly)original);
            rotationMatrix.inverseTransform((RotationMatrixBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix((RotationMatrixReadOnly)original);
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrix = this.createRandomMatrix(random);
            RotationMatrixTools.multiplyTransposeLeft((RotationMatrixReadOnly)rotationMatrix, (RotationMatrixReadOnly)original, (CommonMatrix3DBasics)expected);
            rotationMatrix.inverseTransform((RotationMatrixReadOnly)original, (RotationMatrixBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
            rotationMatrix.setToZero();
            RotationMatrixTools.multiplyTransposeLeft((RotationMatrixReadOnly)rotationMatrix, (RotationMatrixReadOnly)original, (CommonMatrix3DBasics)expected);
            rotationMatrix.inverseTransform((RotationMatrixReadOnly)original, (RotationMatrixBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(2354L);
        RotationMatrix m1 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        RotationMatrix m2 = new RotationMatrix();
        Assertions.assertFalse((boolean)m1.equals((Matrix3DReadOnly)m2));
        Assertions.assertFalse((boolean)m1.equals(null));
        Assertions.assertFalse((boolean)m1.equals((Object)new double[4]));
        m2.set(m1);
        Assertions.assertTrue((boolean)m1.equals((Matrix3DReadOnly)m2));
        RotationMatrix m2AsObject = m2;
        Assertions.assertTrue((boolean)m1.equals((Object)m2AsObject));
        double smallestEpsilon = 1.0E-16;
        double[] coeffs = new double[9];
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                m2.set(m1);
                Assertions.assertTrue((boolean)m1.equals((Matrix3DReadOnly)m2));
                m1.get(coeffs);
                int n = 3 * row + column;
                coeffs[n] = coeffs[n] + smallestEpsilon;
                m2.set(coeffs);
                Assertions.assertFalse((boolean)m1.equals((Matrix3DReadOnly)m2));
                m2.set(m1);
                Assertions.assertTrue((boolean)m1.equals((Matrix3DReadOnly)m2));
                m1.get(coeffs);
                int n2 = 3 * row + column;
                coeffs[n2] = coeffs[n2] - smallestEpsilon;
                m2.set(coeffs);
                Assertions.assertFalse((boolean)m1.equals((Matrix3DReadOnly)m2));
            }
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        RotationMatrix mB;
        AxisAngle aa;
        double angleDiff;
        RotationMatrix mA;
        double epsilon;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-12, (double)1.0E-11);
            mA = this.createRandomMatrix(random);
            angleDiff = 0.99 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            mB = new RotationMatrix((Orientation3DReadOnly)aa);
            mB.preMultiply((RotationMatrixReadOnly)mA);
            Assertions.assertTrue((boolean)mA.geometricallyEquals(mB, epsilon), (String)("Epsilon = " + epsilon));
            Assertions.assertTrue((boolean)mA.geometricallyEquals(mA, 0.0));
            Assertions.assertTrue((boolean)mB.geometricallyEquals(mB, 0.0));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-11, (double)1.0E-10);
            mA = this.createRandomMatrix(random);
            angleDiff = 1.01 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            RotationMatrix rDiff = new RotationMatrix((Orientation3DReadOnly)aa);
            mB = new RotationMatrix((RotationMatrixReadOnly)rDiff);
            mB.preMultiply((RotationMatrixReadOnly)mA);
            Assertions.assertFalse((boolean)mA.geometricallyEquals(mB, epsilon), (String)("Epsilon = " + epsilon));
            Assertions.assertTrue((boolean)mA.geometricallyEquals(mA, 0.0));
            Assertions.assertTrue((boolean)mB.geometricallyEquals(mB, 0.0));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)(Math.PI * 2));
            mA = this.createRandomMatrix(random);
            angleDiff = 0.99 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            mB = new RotationMatrix((Orientation3DReadOnly)aa);
            mB.preMultiply((RotationMatrixReadOnly)mA);
            Assertions.assertTrue((boolean)mA.geometricallyEquals(mB, epsilon), (String)("Epsilon = " + epsilon));
            Assertions.assertTrue((boolean)mA.geometricallyEquals(mA, 0.0));
            Assertions.assertTrue((boolean)mB.geometricallyEquals(mB, 0.0));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)3.079992797637052);
            mA = this.createRandomMatrix(random);
            angleDiff = 1.01 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            mB = new RotationMatrix((Orientation3DReadOnly)aa);
            mB.preMultiply((RotationMatrixReadOnly)mA);
            Assertions.assertFalse((boolean)mA.geometricallyEquals(mB, epsilon), (String)("Epsilon = " + epsilon));
            Assertions.assertTrue((boolean)mA.geometricallyEquals(mA, 0.0));
            Assertions.assertTrue((boolean)mB.geometricallyEquals(mB, 0.0));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI, (double)(Math.PI * 2));
            mA = this.createRandomMatrix(random);
            mB = this.createRandomMatrix(random);
            Assertions.assertTrue((boolean)mA.geometricallyEquals(mB, epsilon), (String)("Epsilon = " + epsilon));
        }
    }

    @Test
    public void testEpsilonConsistencyWithQuaternionAndAxisAngle() throws Exception {
        AxisAngle axisAngleB;
        AxisAngle axisAngleA;
        Quaternion quaternionB;
        Quaternion quaternionA;
        RotationMatrix rotationMatrixB;
        AxisAngle aa;
        double angleDiff;
        RotationMatrix rotationMatrixA;
        double epsilon;
        int i;
        Random random = new Random(9762344L);
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            rotationMatrixA = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            angleDiff = 0.99 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            rotationMatrixB = new RotationMatrix((Orientation3DReadOnly)aa);
            rotationMatrixB.preMultiply((RotationMatrixReadOnly)rotationMatrixA);
            Assertions.assertTrue((boolean)rotationMatrixA.geometricallyEquals(rotationMatrixB, epsilon));
            quaternionA = new Quaternion((Orientation3DReadOnly)rotationMatrixA);
            quaternionB = new Quaternion((Orientation3DReadOnly)rotationMatrixB);
            Assertions.assertTrue((boolean)quaternionA.geometricallyEquals(quaternionB, epsilon));
            axisAngleA = new AxisAngle((Orientation3DReadOnly)rotationMatrixA);
            axisAngleB = new AxisAngle((Orientation3DReadOnly)rotationMatrixB);
            Assertions.assertTrue((boolean)axisAngleA.geometricallyEquals(axisAngleB, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            rotationMatrixA = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            angleDiff = 1.01 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            rotationMatrixB = new RotationMatrix((Orientation3DReadOnly)aa);
            rotationMatrixB.preMultiply((RotationMatrixReadOnly)rotationMatrixA);
            quaternionA = new Quaternion((Orientation3DReadOnly)rotationMatrixA);
            quaternionB = new Quaternion((Orientation3DReadOnly)rotationMatrixB);
            Assertions.assertFalse((boolean)quaternionA.geometricallyEquals(quaternionB, epsilon));
            axisAngleA = new AxisAngle((Orientation3DReadOnly)rotationMatrixA);
            axisAngleB = new AxisAngle((Orientation3DReadOnly)rotationMatrixB);
            Assertions.assertFalse((boolean)axisAngleA.geometricallyEquals(axisAngleB, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Matrix3D matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        RotationMatrix rotationMatrix = new RotationMatrix();
        int newHashCode = matrix.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)matrix.hashCode());
        int previousHashCode = matrix.hashCode();
        for (int i = 0; i < 1000; ++i) {
            int row = random.nextInt(3);
            int column = random.nextInt(3);
            matrix.setElement(row, column, random.nextDouble());
            double m00 = matrix.getM00();
            double m01 = matrix.getM01();
            double m02 = matrix.getM02();
            double m10 = matrix.getM10();
            double m11 = matrix.getM11();
            double m12 = matrix.getM12();
            double m20 = matrix.getM20();
            double m21 = matrix.getM21();
            double m22 = matrix.getM22();
            rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            newHashCode = rotationMatrix.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Test
    public void testOrientation3DBasicsFeatures() throws Throwable {
        Orientation3DBasicsTest test = new Orientation3DBasicsTest(){

            @Override
            public Orientation3DBasics createEmptyOrientation3DBasics() {
                return RotationMatrixTest.this.createEmptyMatrix();
            }

            @Override
            public double getEpsilon() {
                return 1.0E-10;
            }
        };
        for (Method testMethod : test.getClass().getMethods()) {
            if (!testMethod.getName().startsWith("test") || !Modifier.isPublic(testMethod.getModifiers()) || Modifier.isStatic(testMethod.getModifiers())) continue;
            try {
                testMethod.invoke((Object)test, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    @Override
    public RotationMatrix createEmptyMatrix() {
        return new RotationMatrix();
    }

    @Override
    public RotationMatrix createMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        RotationMatrix rotationMatrix = new RotationMatrix();
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        return rotationMatrix;
    }

    @Override
    public RotationMatrix createRandomMatrix(Random random) {
        return EuclidCoreRandomTools.nextRotationMatrix((Random)random);
    }
}

