/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.LineSegment1D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class LineSegment1DTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void lineBoundariesTest() {
        double firstPoint = 16.7;
        double secondPoint = -2.5;
        double[] pointsArray = new double[]{firstPoint, secondPoint};
        double p1 = 2.5;
        double p2 = 18.0;
        double p3 = 0.0;
        double p4 = 7.1;
        double p5 = -5.2;
        double p6 = 16.2;
        LineSegment1D line = new LineSegment1D(pointsArray);
        Assertions.assertEquals((double)line.getMinPoint(), (double)secondPoint, (double)(0.001 / line.length()));
        Assertions.assertEquals((double)line.getMaxPoint(), (double)firstPoint, (double)(0.001 / line.length()));
        Assertions.assertEquals((double)line.getSecondEndpoint(), (double)secondPoint, (double)(0.001 / line.length()));
        Assertions.assertEquals((double)line.getFirstEndpoint(), (double)firstPoint, (double)(0.001 / line.length()));
        Assertions.assertEquals((double)line.getMidPoint(), (double)p4, (double)(0.001 / line.length()));
        Assertions.assertFalse((boolean)line.isBetweenEndpoints(p2, 0.001 / line.length()));
        Assertions.assertTrue((boolean)line.isBetweenEndpoints(p3, 0.001 / line.length()));
        Assertions.assertFalse((boolean)line.isBetweenEndpoints(p5, 0.001 / line.length()));
        Assertions.assertFalse((boolean)line.isBetweenEndpointsExclusive(firstPoint));
        Assertions.assertTrue((boolean)line.isBetweenEndpointsInclusive(secondPoint));
        Assertions.assertTrue((boolean)line.isBetweenEndpoints(p1, 4.999 / line.length()));
        Assertions.assertFalse((boolean)line.isBetweenEndpoints(p3, 20.0 / line.length()));
        Assertions.assertTrue((boolean)line.isBetweenEndpoints(p6, 0.5 / line.length()));
        LineSegment1D pointLine = new LineSegment1D(firstPoint, firstPoint);
        Assertions.assertTrue((boolean)pointLine.isBetweenEndpoints(firstPoint, 0.0));
        Assertions.assertTrue((boolean)pointLine.isBetweenEndpoints(firstPoint, 0.01));
        Assertions.assertFalse((boolean)pointLine.isBetweenEndpoints(secondPoint, 0.0));
    }

    @Test
    public void lineOverlapsTest1() {
        double firstPoint = -10.0;
        double secondPoint = 10.0;
        LineSegment1D emptyLine = new LineSegment1D();
        LineSegment1D mainLine = new LineSegment1D(firstPoint, secondPoint);
        LineSegment1D separateLine = new LineSegment1D(firstPoint + 100.0, secondPoint + 100.0);
        LineSegment1D otherLine1 = new LineSegment1D(firstPoint - 3.0, secondPoint - 3.0);
        LineSegment1D intersectionLine1 = new LineSegment1D(firstPoint, secondPoint - 3.0);
        LineSegment1D otherLine2 = new LineSegment1D(secondPoint, secondPoint + 10.0);
        Assertions.assertTrue((boolean)mainLine.computeOverlap(otherLine1, emptyLine));
        Assertions.assertEquals((double)intersectionLine1.getMaxPoint(), (double)emptyLine.getMaxPoint(), (double)0.001);
        Assertions.assertEquals((double)intersectionLine1.getMinPoint(), (double)emptyLine.getMinPoint(), (double)0.001);
        Assertions.assertTrue((boolean)intersectionLine1.computeOverlap(emptyLine, emptyLine));
        Assertions.assertFalse((boolean)mainLine.computeOverlap(separateLine, emptyLine));
        Assertions.assertTrue((boolean)mainLine.isOverlappingInclusive(otherLine2));
        Assertions.assertFalse((boolean)mainLine.isOverlappingExclusive(otherLine2));
        Assertions.assertTrue((boolean)mainLine.isOverlappingExclusive(new LineSegment1D(-9.9, 9.9)));
        LineSegment1D intersectionLine2 = mainLine.computeOverlap(otherLine1);
        LineSegment1D intersectionLine3 = mainLine.computeOverlap(separateLine);
        Assertions.assertEquals((double)intersectionLine1.getMaxPoint(), (double)intersectionLine2.getMaxPoint(), (double)0.001);
        Assertions.assertEquals((double)intersectionLine1.getMinPoint(), (double)intersectionLine2.getMinPoint(), (double)0.001);
        Assertions.assertEquals(null, (Object)intersectionLine3);
        Assertions.assertFalse((boolean)mainLine.isBetweenEndpointsExclusive(mainLine));
        Assertions.assertTrue((boolean)mainLine.isBetweenEndpointsInclusive(mainLine));
        Assertions.assertFalse((boolean)mainLine.isBetweenEndpointsInclusive(otherLine2));
        Assertions.assertTrue((boolean)mainLine.isBetweenEndpointsExclusive(new LineSegment1D(-5.0, 5.0)));
    }

    @Test
    public void lineOverlapsTest2() {
        LineSegment1D actualOverlap;
        double lineSegmentEnd2;
        double lineSegmentStart2;
        boolean areOverlaping;
        LineSegment1D actualOverlap2;
        double expectedOverlapEnd;
        double expectedOverlapStart;
        LineSegment1D lineSegment2;
        double lineSegmentEnd22;
        double lineSegmentStart22;
        double boundaryTwo;
        double boundaryOne;
        LineSegment1D lineSegment1;
        double lineSegmentEnd1;
        double lineSegmentStart1;
        int i;
        Random random = new Random(32423L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegmentEnd1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegment1 = new LineSegment1D(lineSegmentStart1, lineSegmentEnd1);
            boundaryOne = lineSegmentStart1 < lineSegmentEnd1 ? lineSegmentStart1 : lineSegmentEnd1;
            boundaryTwo = lineSegmentStart1 > lineSegmentEnd1 ? lineSegmentStart1 : lineSegmentEnd1;
            lineSegmentStart22 = EuclidCoreRandomTools.nextDouble((Random)random, (double)boundaryOne, (double)boundaryTwo);
            lineSegmentEnd22 = EuclidCoreRandomTools.nextDouble((Random)random, (double)boundaryOne, (double)boundaryTwo);
            lineSegment2 = new LineSegment1D(lineSegmentStart22, lineSegmentEnd22);
            expectedOverlapStart = lineSegmentStart22;
            expectedOverlapEnd = lineSegmentEnd22;
            actualOverlap2 = new LineSegment1D();
            areOverlaping = lineSegment1.computeOverlap(lineSegment2, actualOverlap2);
            Assertions.assertTrue((boolean)areOverlaping);
            if (actualOverlap2.getFirstEndpoint() != expectedOverlapStart) {
                Assertions.assertTrue((expectedOverlapStart == actualOverlap2.getSecondEndpoint() ? 1 : 0) != 0);
                Assertions.assertTrue((expectedOverlapEnd == actualOverlap2.getFirstEndpoint() ? 1 : 0) != 0);
            } else {
                Assertions.assertTrue((expectedOverlapStart == actualOverlap2.getFirstEndpoint() ? 1 : 0) != 0);
                Assertions.assertTrue((expectedOverlapEnd == actualOverlap2.getSecondEndpoint() ? 1 : 0) != 0);
            }
            areOverlaping = lineSegment2.computeOverlap(lineSegment1, actualOverlap2);
            Assertions.assertTrue((boolean)areOverlaping);
            if (actualOverlap2.getFirstEndpoint() != expectedOverlapStart) {
                Assertions.assertTrue((expectedOverlapStart == actualOverlap2.getSecondEndpoint() ? 1 : 0) != 0);
                Assertions.assertTrue((expectedOverlapEnd == actualOverlap2.getFirstEndpoint() ? 1 : 0) != 0);
                continue;
            }
            Assertions.assertTrue((expectedOverlapStart == actualOverlap2.getFirstEndpoint() ? 1 : 0) != 0);
            Assertions.assertTrue((expectedOverlapEnd == actualOverlap2.getSecondEndpoint() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegmentEnd1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegment1 = new LineSegment1D(lineSegmentStart1, lineSegmentEnd1);
            boundaryOne = lineSegmentStart1 < lineSegmentEnd1 ? lineSegmentStart1 : lineSegmentEnd1;
            boundaryTwo = lineSegmentStart1 > lineSegmentEnd1 ? lineSegmentStart1 : lineSegmentEnd1;
            lineSegmentStart22 = EuclidCoreRandomTools.nextDouble((Random)random, (double)boundaryOne, (double)boundaryTwo);
            lineSegmentEnd22 = EuclidCoreRandomTools.nextDouble((Random)random, (double)(boundaryOne - 10.0), (double)boundaryOne);
            lineSegment2 = new LineSegment1D(lineSegmentStart22, lineSegmentEnd22);
            expectedOverlapStart = lineSegmentStart22;
            expectedOverlapEnd = boundaryOne;
            actualOverlap2 = new LineSegment1D();
            areOverlaping = lineSegment1.computeOverlap(lineSegment2, actualOverlap2);
            Assertions.assertTrue((boolean)areOverlaping);
            if (actualOverlap2.getFirstEndpoint() != expectedOverlapStart) {
                Assertions.assertTrue((expectedOverlapStart == actualOverlap2.getSecondEndpoint() ? 1 : 0) != 0);
                Assertions.assertTrue((expectedOverlapEnd == actualOverlap2.getFirstEndpoint() ? 1 : 0) != 0);
            } else {
                Assertions.assertTrue((expectedOverlapStart == actualOverlap2.getFirstEndpoint() ? 1 : 0) != 0);
                Assertions.assertTrue((expectedOverlapEnd == actualOverlap2.getSecondEndpoint() ? 1 : 0) != 0);
            }
            areOverlaping = lineSegment2.computeOverlap(lineSegment1, actualOverlap2);
            Assertions.assertTrue((boolean)areOverlaping);
            if (actualOverlap2.getFirstEndpoint() != expectedOverlapStart) {
                Assertions.assertTrue((expectedOverlapStart == actualOverlap2.getSecondEndpoint() ? 1 : 0) != 0);
                Assertions.assertTrue((expectedOverlapEnd == actualOverlap2.getFirstEndpoint() ? 1 : 0) != 0);
                continue;
            }
            Assertions.assertTrue((expectedOverlapStart == actualOverlap2.getFirstEndpoint() ? 1 : 0) != 0);
            Assertions.assertTrue((expectedOverlapEnd == actualOverlap2.getSecondEndpoint() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegmentEnd1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegment1 = new LineSegment1D(lineSegmentStart1, lineSegmentEnd1);
            boundaryOne = lineSegmentStart1 < lineSegmentEnd1 ? lineSegmentStart1 : lineSegmentEnd1;
            boundaryTwo = lineSegmentStart1 > lineSegmentEnd1 ? lineSegmentStart1 : lineSegmentEnd1;
            lineSegmentStart22 = EuclidCoreRandomTools.nextDouble((Random)random, (double)boundaryOne, (double)boundaryTwo);
            lineSegmentEnd22 = EuclidCoreRandomTools.nextDouble((Random)random, (double)boundaryTwo, (double)(boundaryTwo + 10.0));
            lineSegment2 = new LineSegment1D(lineSegmentStart22, lineSegmentEnd22);
            expectedOverlapStart = lineSegmentStart22;
            expectedOverlapEnd = boundaryTwo;
            actualOverlap2 = new LineSegment1D();
            areOverlaping = lineSegment1.computeOverlap(lineSegment2, actualOverlap2);
            Assertions.assertTrue((boolean)areOverlaping);
            if (actualOverlap2.getFirstEndpoint() != expectedOverlapStart) {
                Assertions.assertTrue((expectedOverlapStart == actualOverlap2.getSecondEndpoint() ? 1 : 0) != 0);
                Assertions.assertTrue((expectedOverlapEnd == actualOverlap2.getFirstEndpoint() ? 1 : 0) != 0);
            } else {
                Assertions.assertTrue((expectedOverlapStart == actualOverlap2.getFirstEndpoint() ? 1 : 0) != 0);
                Assertions.assertTrue((expectedOverlapEnd == actualOverlap2.getSecondEndpoint() ? 1 : 0) != 0);
            }
            areOverlaping = lineSegment2.computeOverlap(lineSegment1, actualOverlap2);
            Assertions.assertTrue((boolean)areOverlaping);
            if (actualOverlap2.getFirstEndpoint() != expectedOverlapStart) {
                Assertions.assertTrue((expectedOverlapStart == actualOverlap2.getSecondEndpoint() ? 1 : 0) != 0);
                Assertions.assertTrue((expectedOverlapEnd == actualOverlap2.getFirstEndpoint() ? 1 : 0) != 0);
                continue;
            }
            Assertions.assertTrue((expectedOverlapStart == actualOverlap2.getFirstEndpoint() ? 1 : 0) != 0);
            Assertions.assertTrue((expectedOverlapEnd == actualOverlap2.getSecondEndpoint() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegmentEnd1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegment1 = new LineSegment1D(lineSegmentStart1, lineSegmentEnd1);
            double max = lineSegmentStart1 > lineSegmentEnd1 ? lineSegmentStart1 : lineSegmentEnd1;
            lineSegmentStart2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)max, (double)(max + 10.0));
            lineSegmentEnd2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)max, (double)(max + 10.0));
            LineSegment1D lineSegment22 = new LineSegment1D(lineSegmentStart2, lineSegmentEnd2);
            actualOverlap = new LineSegment1D();
            boolean areOverlaping2 = lineSegment1.computeOverlap(lineSegment22, actualOverlap);
            Assertions.assertFalse((boolean)areOverlaping2);
            areOverlaping2 = lineSegment22.computeOverlap(lineSegment1, actualOverlap);
            Assertions.assertFalse((boolean)areOverlaping2);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegmentEnd1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegment1 = new LineSegment1D(lineSegmentStart1, lineSegmentEnd1);
            double min = lineSegmentStart1 < lineSegmentEnd1 ? lineSegmentStart1 : lineSegmentEnd1;
            lineSegmentStart2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)(min - 10.0), (double)min);
            lineSegmentEnd2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)(min - 10.0), (double)min);
            LineSegment1D lineSegment23 = new LineSegment1D(lineSegmentStart2, lineSegmentEnd2);
            actualOverlap = new LineSegment1D();
            boolean areOverlaping3 = lineSegment1.computeOverlap(lineSegment23, actualOverlap);
            Assertions.assertFalse((boolean)areOverlaping3);
            areOverlaping3 = lineSegment23.computeOverlap(lineSegment1, actualOverlap);
            Assertions.assertFalse((boolean)areOverlaping3);
        }
    }

    @Test
    public void testSignedDistance() {
        double firstPoint = -10.0;
        double secondPoint = 10.0;
        double p1 = 15.0;
        double p2 = -15.0;
        double p3 = 2.0;
        LineSegment1D mainLine = new LineSegment1D(firstPoint, secondPoint);
        LineSegment1D secondLine = new LineSegment1D(secondPoint, firstPoint);
        Assertions.assertEquals((double)mainLine.signedDistance(p1), (double)5.0, (double)0.001);
        Assertions.assertEquals((double)mainLine.signedDistance(p2), (double)5.0, (double)0.001);
        Assertions.assertEquals((double)mainLine.signedDistance(p3), (double)-8.0, (double)0.001);
        Assertions.assertEquals((double)mainLine.signedDistance(firstPoint), (double)0.0, (double)0.001);
        Assertions.assertTrue((boolean)mainLine.isBefore(p2));
        Assertions.assertTrue((boolean)mainLine.isAfter(p1));
        Assertions.assertFalse((boolean)mainLine.isBefore(p3));
        Assertions.assertFalse((boolean)mainLine.isAfter(p3));
        Assertions.assertFalse((boolean)mainLine.isBefore(firstPoint));
        Assertions.assertFalse((boolean)mainLine.isAfter(secondPoint));
        Assertions.assertTrue((boolean)secondLine.isBefore(p1));
        Assertions.assertTrue((boolean)secondLine.isAfter(p2));
        Assertions.assertFalse((boolean)secondLine.isBefore(p3));
        Assertions.assertFalse((boolean)secondLine.isAfter(p3));
        Assertions.assertFalse((boolean)secondLine.isBefore(secondPoint));
        Assertions.assertFalse((boolean)secondLine.isAfter(firstPoint));
        Assertions.assertEquals((double)mainLine.length(), (double)20.0, (double)0.001);
    }

    @Test
    public void testExtension() {
        double firstPoint = -10.0;
        double secondPoint = 10.0;
        double p1 = 15.0;
        double p2 = -15.0;
        double p3 = 0.0;
        LineSegment1D mainLine = new LineSegment1D(firstPoint, secondPoint);
        mainLine.extendSegmentToPoint(p1);
        Assertions.assertEquals((double)mainLine.getMaxPoint(), (double)p1, (double)0.001);
        mainLine.extendSegmentToPoint(p2);
        Assertions.assertEquals((double)mainLine.getMinPoint(), (double)p2, (double)0.001);
        mainLine.extendSegmentToPoint(p3);
        Assertions.assertEquals((double)mainLine.getMaxPoint(), (double)p1, (double)0.001);
        Assertions.assertEquals((double)mainLine.getMinPoint(), (double)p2, (double)0.001);
    }

    @Test
    public void testSetters() {
        double p1 = 15.0;
        double p2 = -15.0;
        boolean fail = false;
        LineSegment1D line1 = new LineSegment1D();
        LineSegment1D line2 = new LineSegment1D(-10.0, 10.0);
        line1.setFirstEndpoint(p1);
        line1.setSecondEndpoint(p2);
        Assertions.assertEquals((double)line1.getFirstEndpoint(), (double)p1, (double)0.001);
        Assertions.assertEquals((double)line1.getSecondEndpoint(), (double)p2, (double)0.001);
        line1.setMaxPoint(17.0);
        line1.setMinPoint(-17.0);
        Assertions.assertEquals((double)line1.length(), (double)34.0, (double)0.001);
        line2.setMaxPoint(17.0);
        Assertions.assertEquals((double)line2.length(), (double)27.0, (double)0.001);
        try {
            line1.setMaxPoint(-17.0);
        }
        catch (RuntimeException e) {
            fail = true;
        }
        Assertions.assertTrue((boolean)fail);
        fail = false;
        try {
            line1.setMinPoint(17.0);
        }
        catch (RuntimeException e) {
            fail = true;
        }
        Assertions.assertTrue((boolean)fail);
    }

    @Test
    public void toUpperDimensionsTest() {
        Point2D point2d = new Point2D(1.0, 1.0);
        Vector2D direction2d = new Vector2D(1.0, 2.0);
        LineSegment1D firstLine = new LineSegment1D(0.0, 10.0);
        LineSegment2D line2d = firstLine.toLineSegment2d((Point2DReadOnly)point2d, (Vector2DReadOnly)direction2d);
        Assertions.assertEquals((Object)line2d.getFirstEndpoint(), (Object)new Point2D(1.0, 1.0));
        Assertions.assertEquals((Object)line2d.getSecondEndpoint(), (Object)new Point2D(11.0, 21.0));
        Point3D point3d = new Point3D(1.0, 1.0, 1.0);
        Vector3D direction3d = new Vector3D(1.0, 2.0, 3.0);
        LineSegment3D line3d = firstLine.toLineSegment3d((Point3DReadOnly)point3d, (Vector3DReadOnly)direction3d);
        Assertions.assertEquals((Object)line3d.getFirstEndpoint(), (Object)new Point3D(1.0, 1.0, 1.0));
        Assertions.assertEquals((Object)line3d.getSecondEndpoint(), (Object)new Point3D(11.0, 21.0, 31.0));
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        LineSegment1D lineSegment2;
        LineSegment1D lineSegment1;
        int i;
        Random random = new Random(23525L);
        for (i = 0; i < 1000; ++i) {
            double endpoint1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double endpoint2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegment1 = new LineSegment1D(endpoint1, endpoint2);
            lineSegment2 = new LineSegment1D(endpoint1, endpoint2);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint1 + 9.9E-13, endpoint2);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint1 - 9.9E-13, endpoint2);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint1 + 1.01E-12, endpoint2);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint1 - 1.01E-12, endpoint2);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint1, endpoint2 + 9.9E-13);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint1, endpoint2 - 9.9E-13);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint1, endpoint2 + 1.01E-12);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint1, endpoint2 - 1.01E-12);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint1 + 9.9E-13, endpoint2 + 9.9E-13);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint1 - 9.9E-13, endpoint2 - 9.9E-13);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint1 + 1.01E-12, endpoint2 + 1.01E-12);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint1 - 1.01E-12, endpoint2 - 1.01E-12);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
        }
        for (i = 0; i < 1000; ++i) {
            double endpoint2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double endpoint1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            lineSegment1 = new LineSegment1D(endpoint1, endpoint2);
            lineSegment2 = new LineSegment1D(endpoint2, endpoint1);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint2 + 9.9E-13, endpoint1);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint2 - 9.9E-13, endpoint1);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint2 + 1.01E-12, endpoint1);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint2 - 1.01E-12, endpoint1);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint2, endpoint1 + 9.9E-13);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint2, endpoint1 - 9.9E-13);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint2, endpoint1 + 1.01E-12);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint2, endpoint1 - 1.01E-12);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint2 + 9.9E-13, endpoint1 + 9.9E-13);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint2 - 9.9E-13, endpoint1 - 9.9E-13);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint2 + 1.01E-12, endpoint1 + 1.01E-12);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
            lineSegment2.set(endpoint2 - 1.01E-12, endpoint1 - 1.01E-12);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-12));
        }
    }
}

