/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision.interfaces;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface EuclidShape3DCollisionResultReadOnly
extends EuclidGeometry {
    public boolean areShapesColliding();

    default public double getDistance() {
        return Math.abs(this.getSignedDistance());
    }

    public double getSignedDistance();

    public Shape3DReadOnly getShapeA();

    public Shape3DReadOnly getShapeB();

    public Point3DReadOnly getPointOnA();

    public Point3DReadOnly getPointOnB();

    public Vector3DReadOnly getNormalOnA();

    public Vector3DReadOnly getNormalOnB();

    default public boolean containsNaN() {
        if (Double.isNaN(this.getSignedDistance())) {
            return true;
        }
        if (this.getPointOnA().containsNaN() || this.getNormalOnA().containsNaN()) {
            return true;
        }
        return this.getPointOnB().containsNaN() || this.getNormalOnB().containsNaN();
    }

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof EuclidShape3DCollisionResultReadOnly)) {
            return false;
        }
        EuclidShape3DCollisionResultReadOnly other = (EuclidShape3DCollisionResultReadOnly)geometry;
        if (this.getShapeA() != other.getShapeA()) {
            return false;
        }
        if (this.getShapeB() != other.getShapeB()) {
            return false;
        }
        if (this.areShapesColliding() != other.areShapesColliding()) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals((double)this.getSignedDistance(), (double)other.getSignedDistance(), (double)epsilon)) {
            return false;
        }
        if (this.getPointOnA().containsNaN() ? !other.getPointOnA().containsNaN() : !this.getPointOnA().epsilonEquals((EuclidGeometry)other.getPointOnA(), epsilon)) {
            return false;
        }
        if (this.getPointOnB().containsNaN() ? !other.getPointOnB().containsNaN() : !this.getPointOnB().epsilonEquals((EuclidGeometry)other.getPointOnB(), epsilon)) {
            return false;
        }
        if (this.getNormalOnA().containsNaN() ? !other.getNormalOnA().containsNaN() : !this.getNormalOnA().epsilonEquals((EuclidGeometry)other.getNormalOnA(), epsilon)) {
            return false;
        }
        return !(this.getNormalOnB().containsNaN() ? !other.getNormalOnB().containsNaN() : !this.getNormalOnB().epsilonEquals((EuclidGeometry)other.getNormalOnB(), epsilon));
    }

    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof EuclidShape3DCollisionResultReadOnly)) {
            return false;
        }
        EuclidShape3DCollisionResultReadOnly other = (EuclidShape3DCollisionResultReadOnly)geometry;
        return this.geometricallyEquals(other, epsilon, epsilon, epsilon);
    }

    default public boolean geometricallyEquals(EuclidShape3DCollisionResultReadOnly other, double distanceEpsilon, double pointTangentialEpsilon, double normalEpsilon) {
        Vector3DReadOnly otherNormalOnB;
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.areShapesColliding() != other.areShapesColliding()) {
            return false;
        }
        if (Double.isNaN(this.getSignedDistance()) ? !Double.isNaN(other.getSignedDistance()) : !EuclidCoreTools.epsilonEquals((double)this.getSignedDistance(), (double)other.getSignedDistance(), (double)distanceEpsilon)) {
            return false;
        }
        boolean swap = this.getShapeA() != null || this.getShapeB() != null || other.getShapeA() != null || other.getShapeB() != null ? this.getShapeA() != other.getShapeA() : !this.getPointOnA().geometricallyEquals((EuclidGeometry)other.getPointOnA(), pointTangentialEpsilon);
        Shape3DReadOnly otherShapeA = swap ? other.getShapeB() : other.getShapeA();
        Shape3DReadOnly otherShapeB = swap ? other.getShapeA() : other.getShapeB();
        Point3DReadOnly otherPointOnA = swap ? other.getPointOnB() : other.getPointOnA();
        Point3DReadOnly otherPointOnB = swap ? other.getPointOnA() : other.getPointOnB();
        Vector3DReadOnly otherNormalOnA = swap ? other.getNormalOnB() : other.getNormalOnA();
        Vector3DReadOnly vector3DReadOnly = otherNormalOnB = swap ? other.getNormalOnA() : other.getNormalOnB();
        if (this.getShapeA() != otherShapeA) {
            return false;
        }
        if (this.getShapeB() != otherShapeB) {
            return false;
        }
        if (this.getPointOnA().containsNaN() || this.getPointOnB().containsNaN() || distanceEpsilon == pointTangentialEpsilon) {
            if (this.getPointOnA().containsNaN() ? !otherPointOnA.containsNaN() : !this.getPointOnA().geometricallyEquals((EuclidGeometry)otherPointOnA, distanceEpsilon)) {
                return false;
            }
            if (this.getPointOnB().containsNaN() ? !otherPointOnB.containsNaN() : !this.getPointOnB().geometricallyEquals((EuclidGeometry)otherPointOnB, distanceEpsilon)) {
                return false;
            }
        } else {
            double collisionVectorX = (this.getPointOnA().getX() - this.getPointOnB().getX()) / this.getDistance();
            double collisionVectorY = (this.getPointOnA().getY() - this.getPointOnB().getY()) / this.getDistance();
            double collisionVectorZ = (this.getPointOnA().getZ() - this.getPointOnB().getZ()) / this.getDistance();
            if (!EuclidShapeTools.geometricallyEquals(this.getPointOnA(), otherPointOnA, collisionVectorX, collisionVectorY, collisionVectorZ, distanceEpsilon, pointTangentialEpsilon)) {
                return false;
            }
            if (!EuclidShapeTools.geometricallyEquals(this.getPointOnB(), otherPointOnB, collisionVectorX, collisionVectorY, collisionVectorZ, distanceEpsilon, pointTangentialEpsilon)) {
                return false;
            }
        }
        if (this.getNormalOnA().containsNaN() ? !otherNormalOnA.containsNaN() : !this.getNormalOnA().geometricallyEquals((EuclidGeometry)otherNormalOnA, normalEpsilon)) {
            return false;
        }
        return !(this.getNormalOnB().containsNaN() ? !otherNormalOnB.containsNaN() : !this.getNormalOnB().geometricallyEquals((EuclidGeometry)otherNormalOnB, normalEpsilon));
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof EuclidShape3DCollisionResultReadOnly)) {
            return false;
        }
        EuclidShape3DCollisionResultReadOnly other = (EuclidShape3DCollisionResultReadOnly)geometry;
        if (this.areShapesColliding() != other.areShapesColliding()) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.getSignedDistance(), (double)other.getSignedDistance())) {
            return false;
        }
        if (this.getShapeA() != other.getShapeA()) {
            return false;
        }
        if (this.getShapeB() != other.getShapeB()) {
            return false;
        }
        if (!this.getPointOnA().equals((EuclidGeometry)other.getPointOnA())) {
            return false;
        }
        if (!this.getNormalOnA().equals((EuclidGeometry)other.getNormalOnA())) {
            return false;
        }
        if (!this.getPointOnB().equals((EuclidGeometry)other.getPointOnB())) {
            return false;
        }
        return this.getNormalOnB().equals((EuclidGeometry)other.getNormalOnB());
    }

    default public String toString(String format) {
        return EuclidShapeIOTools.getEuclidShape3DCollisionResultString(format, this);
    }
}

