/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.tools;

import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidEllipsoid3DTools {
    private static final int DEFAULT_ROOT_FINDING_ITERATIONS = 150;
    private static final double DEFAULT_EPSILON = 1.0E-10;

    private EuclidEllipsoid3DTools() {
    }

    public static double distancePoint3DEllipsoid3D(Vector3DReadOnly radii, Point3DReadOnly query) {
        return EuclidEllipsoid3DTools.distancePoint3DEllipsoid3D(radii, query, null);
    }

    public static double distancePoint3DEllipsoid3D(Vector3DReadOnly radii, Point3DReadOnly query, Point3DBasics closestPointToPack) {
        return EuclidEllipsoid3DTools.distancePoint3DEllipsoid3D(radii, query, 150, 1.0E-10, closestPointToPack);
    }

    public static double distancePoint3DEllipsoid3D(Vector3DReadOnly radii, Point3DReadOnly query, int maxIterations, double epsilon, Point3DBasics closestPointToPack) {
        boolean negate2;
        CoordinateOrder order = CoordinateOrder.descendingOrder((Tuple3DReadOnly)radii);
        double e0 = order.getCoordinate0((Tuple3DReadOnly)radii);
        double e1 = order.getCoordinate1((Tuple3DReadOnly)radii);
        double e2 = order.getCoordinate2((Tuple3DReadOnly)radii);
        double y0 = order.getCoordinate0((Tuple3DReadOnly)query);
        double y1 = order.getCoordinate1((Tuple3DReadOnly)query);
        double y2 = order.getCoordinate2((Tuple3DReadOnly)query);
        boolean negate0 = y0 < 0.0;
        boolean negate1 = y1 < 0.0;
        boolean bl = negate2 = y2 < 0.0;
        if (negate0) {
            y0 = -y0;
        }
        if (negate1) {
            y1 = -y1;
        }
        if (negate2) {
            y2 = -y2;
        }
        double x0 = Double.NaN;
        double x1 = Double.NaN;
        double x2 = Double.NaN;
        double distance = Double.NaN;
        if (y2 > epsilon) {
            if (y1 > epsilon) {
                if (y0 > epsilon) {
                    double z0 = y0 / e0;
                    double z1 = y1 / e1;
                    double z2 = y2 / e2;
                    double g = EuclidCoreTools.normSquared((double)z0, (double)z1, (double)z2) - 1.0;
                    if (!EuclidCoreTools.isZero((double)g, (double)epsilon)) {
                        double r0 = EuclidEllipsoid3DTools.square(e0 / e2);
                        double r1 = EuclidEllipsoid3DTools.square(e1 / e2);
                        double sbar = EuclidEllipsoid3DTools.findRoot(r0, r1, z0, z1, z2, g, maxIterations, epsilon);
                        x0 = r0 * y0 / (sbar + r0);
                        x1 = r1 * y1 / (sbar + r1);
                        x2 = y2 / (sbar + 1.0);
                        distance = EuclidGeometryTools.distanceBetweenPoint3Ds((double)x0, (double)x1, (double)x2, (double)y0, (double)y1, (double)y2);
                        if (g < 0.0) {
                            distance = -distance;
                        }
                    } else {
                        x0 = y0;
                        x1 = y1;
                        x2 = y2;
                        distance = 0.0;
                    }
                } else {
                    distance = EuclidEllipsoid3DTools.distancePoint2DEllipse2D(e1, e2, y1, y2, maxIterations, epsilon, closestPointToPack);
                    if (closestPointToPack != null) {
                        x0 = 0.0;
                        x1 = closestPointToPack.getX();
                        x2 = closestPointToPack.getY();
                    }
                }
            } else if (y0 > epsilon) {
                distance = EuclidEllipsoid3DTools.distancePoint2DEllipse2D(e0, e2, y0, y2, maxIterations, epsilon, closestPointToPack);
                if (closestPointToPack != null) {
                    x0 = closestPointToPack.getX();
                    x1 = 0.0;
                    x2 = closestPointToPack.getY();
                }
            } else {
                x0 = 0.0;
                x1 = 0.0;
                x2 = e2;
                distance = y2 - e2;
            }
        } else {
            double denom0 = EuclidEllipsoid3DTools.square(e0) - EuclidEllipsoid3DTools.square(e2);
            double denom1 = EuclidEllipsoid3DTools.square(e1) - EuclidEllipsoid3DTools.square(e2);
            double numer0 = e0 * y0;
            double numer1 = e1 * y1;
            boolean computed = false;
            if (numer0 < denom0 && numer1 < denom1) {
                double xde0 = numer0 / denom0;
                double xde1 = numer1 / denom1;
                double discr = 1.0 - EuclidEllipsoid3DTools.square(xde0) - EuclidEllipsoid3DTools.square(xde1);
                if (discr > epsilon) {
                    x0 = e0 * xde0;
                    x1 = e1 * xde1;
                    x2 = e2 * EuclidCoreTools.squareRoot((double)discr);
                    distance = -EuclidGeometryTools.distanceBetweenPoint3Ds((double)x0, (double)x1, (double)x2, (double)y0, (double)y1, (double)0.0);
                    computed = true;
                }
            }
            if (!computed) {
                distance = EuclidEllipsoid3DTools.distancePoint2DEllipse2D(e0, e1, y0, y1, maxIterations, epsilon, closestPointToPack);
                if (closestPointToPack != null) {
                    x0 = closestPointToPack.getX();
                    x1 = closestPointToPack.getY();
                    x2 = 0.0;
                }
            }
        }
        if (negate0) {
            x0 = -x0;
        }
        if (negate1) {
            x1 = -x1;
        }
        if (negate2) {
            x2 = -x2;
        }
        if (closestPointToPack != null) {
            order.updateTuple3D(x0, x1, x2, (Tuple3DBasics)closestPointToPack);
        }
        return distance;
    }

    private static double distancePoint2DEllipse2D(double e0, double e1, double y0, double y1, int maxIterations, double epsilon, Point3DBasics closestPointToPack) {
        double distance;
        double x1;
        double x0;
        if (y1 > epsilon) {
            if (y0 > epsilon) {
                double z0 = y0 / e0;
                double z1 = y1 / e1;
                double g = EuclidCoreTools.normSquared((double)z0, (double)z1) - 1.0;
                if (!EuclidCoreTools.isZero((double)g, (double)epsilon)) {
                    double r0 = EuclidEllipsoid3DTools.square(e0 / e1);
                    double sbar = EuclidEllipsoid3DTools.findRoot(r0, z0, z1, g, maxIterations, epsilon);
                    x0 = r0 * y0 / (sbar + r0);
                    x1 = y1 / (sbar + 1.0);
                    distance = EuclidGeometryTools.distanceBetweenPoint2Ds((double)x0, (double)x1, (double)y0, (double)y1);
                    if (g < 0.0) {
                        distance = -distance;
                    }
                } else {
                    x0 = y0;
                    x1 = y1;
                    distance = 0.0;
                }
            } else {
                x0 = 0.0;
                x1 = e1;
                distance = y1 - e1;
            }
        } else {
            double numer0 = e0 * y0;
            double denom0 = EuclidEllipsoid3DTools.square(e0) - EuclidEllipsoid3DTools.square(e1);
            if (numer0 < denom0) {
                double xde0 = numer0 / denom0;
                x0 = e0 * xde0;
                x1 = e1 * EuclidCoreTools.squareRoot((double)(1.0 - EuclidEllipsoid3DTools.square(xde0)));
                distance = EuclidCoreTools.norm((double)(x0 - y0), (double)x1);
            } else {
                x0 = e0;
                x1 = 0.0;
                distance = y0 - e0;
            }
        }
        if (closestPointToPack != null) {
            closestPointToPack.set(x0, x1, Double.NaN);
        }
        return distance;
    }

    private static double findRoot(double r0, double r1, double z0, double z1, double z2, double g, int maxIterations, double epsilon) {
        double n0 = r0 * z0;
        double n1 = r1 * z1;
        double s0 = z2 - 1.0;
        double s1 = g < 0.0 ? 0.0 : EuclidCoreTools.norm((double)n0, (double)n1, (double)z2) - 1.0;
        double s = 0.0;
        for (int i = 0; i < maxIterations && (s = (s0 + s1) / 2.0) != s0 && s != s1; ++i) {
            double ratio0 = n0 / (s + r0);
            double ratio1 = n1 / (s + r1);
            double ratio2 = z2 / (s + 1.0);
            g = EuclidCoreTools.normSquared((double)ratio0, (double)ratio1, (double)ratio2) - 1.0;
            if (g > epsilon) {
                s0 = s;
                continue;
            }
            if (!(g < -epsilon)) break;
            s1 = s;
        }
        return s;
    }

    private static double findRoot(double r0, double z0, double z1, double g, int maxIterations, double epsilon) {
        double n0 = r0 * z0;
        double s0 = z1 - 1.0;
        double s1 = g < 0.0 ? 0.0 : EuclidCoreTools.norm((double)n0, (double)z1) - 1.0;
        double s = 0.0;
        for (int i = 0; i < maxIterations && (s = (s0 + s1) / 2.0) != s0 && s != s1; ++i) {
            double ratio0 = n0 / (s + r0);
            double ratio1 = z1 / (s + 1.0);
            g = EuclidCoreTools.normSquared((double)ratio0, (double)ratio1) - 1.0;
            if (g > epsilon) {
                s0 = s;
                continue;
            }
            if (!(g < -epsilon)) break;
            s1 = s;
        }
        return s;
    }

    private static double square(double value) {
        return value * value;
    }

    private static enum CoordinateOrder implements Tuple3DUpdater
    {
        XYZ((x0, x1, x2, tuple) -> tuple.set(x0, x1, x2), tuple -> tuple.getX(), tuple -> tuple.getY(), tuple -> tuple.getZ()),
        XZY((x0, x1, x2, tuple) -> tuple.set(x0, x2, x1), tuple -> tuple.getX(), tuple -> tuple.getZ(), tuple -> tuple.getY()),
        YXZ((x0, x1, x2, tuple) -> tuple.set(x1, x0, x2), tuple -> tuple.getY(), tuple -> tuple.getX(), tuple -> tuple.getZ()),
        YZX((x0, x1, x2, tuple) -> tuple.set(x2, x0, x1), tuple -> tuple.getY(), tuple -> tuple.getZ(), tuple -> tuple.getX()),
        ZXY((x0, x1, x2, tuple) -> tuple.set(x1, x2, x0), tuple -> tuple.getZ(), tuple -> tuple.getX(), tuple -> tuple.getY()),
        ZYX((x0, x1, x2, tuple) -> tuple.set(x2, x1, x0), tuple -> tuple.getZ(), tuple -> tuple.getY(), tuple -> tuple.getX());

        private final Tuple3DUpdater tuple3DUpdater;
        private final CoordinateReader coordinateReader0;
        private final CoordinateReader coordinateReader1;
        private final CoordinateReader coordinateReader2;

        private CoordinateOrder(Tuple3DUpdater tuple3DUpdater, CoordinateReader coordinateReader0, CoordinateReader coordinateReader1, CoordinateReader coordinateReader2) {
            this.tuple3DUpdater = tuple3DUpdater;
            this.coordinateReader0 = coordinateReader0;
            this.coordinateReader1 = coordinateReader1;
            this.coordinateReader2 = coordinateReader2;
        }

        @Override
        public void updateTuple3D(double x0, double x1, double x2, Tuple3DBasics tupleToUpdate) {
            this.tuple3DUpdater.updateTuple3D(x0, x1, x2, tupleToUpdate);
        }

        public double getCoordinate0(Tuple3DReadOnly tuple) {
            return this.coordinateReader0.read(tuple);
        }

        public double getCoordinate1(Tuple3DReadOnly tuple) {
            return this.coordinateReader1.read(tuple);
        }

        public double getCoordinate2(Tuple3DReadOnly tuple) {
            return this.coordinateReader2.read(tuple);
        }

        static CoordinateOrder descendingOrder(Tuple3DReadOnly tuple) {
            if (tuple.getX() >= tuple.getY()) {
                if (tuple.getY() >= tuple.getZ()) {
                    return XYZ;
                }
                if (tuple.getX() >= tuple.getZ()) {
                    return XZY;
                }
                return ZXY;
            }
            if (tuple.getX() >= tuple.getZ()) {
                return YXZ;
            }
            if (tuple.getY() >= tuple.getZ()) {
                return YZX;
            }
            return ZYX;
        }
    }

    private static interface CoordinateReader {
        public double read(Tuple3DReadOnly var1);
    }

    private static interface Tuple3DUpdater {
        public void updateTuple3D(double var1, double var3, double var5, Tuple3DBasics var7);
    }
}

