/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Torus3DBasics
extends Torus3DReadOnly,
Shape3DBasics {
    public void setRadii(double var1, double var3);

    public Point3DBasics getPosition();

    public UnitVector3DBasics getAxis();

    @Override
    default public boolean containsNaN() {
        return Torus3DReadOnly.super.containsNaN();
    }

    default public void setToZero() {
        this.getPosition().setToZero();
        this.getAxis().set((UnitVector3DReadOnly)Axis3D.Z);
        this.setRadii(0.0, 0.0);
    }

    default public void setToNaN() {
        this.getPosition().setToNaN();
        this.getAxis().setToNaN();
        this.setRadii(Double.NaN, Double.NaN);
    }

    default public void set(Torus3DReadOnly other) {
        this.getPosition().set((Tuple3DReadOnly)other.getPosition());
        this.getAxis().set(other.getAxis());
        this.setRadii(other.getRadius(), other.getTubeRadius());
    }

    default public void set(Point3DReadOnly position, Vector3DReadOnly axis, double radius, double tubeRadius) {
        this.getPosition().set((Tuple3DReadOnly)position);
        this.getAxis().set((Tuple3DReadOnly)axis);
        this.getAxis().normalize();
        this.setRadii(radius, tubeRadius);
    }

    @Override
    default public Shape3DPoseBasics getPose() {
        return null;
    }

    default public void applyInverseTransform(Transform transform) {
        transform.inverseTransform(this.getPosition());
        transform.inverseTransform((Vector3DBasics)this.getAxis());
    }

    default public void applyTransform(Transform transform) {
        transform.transform(this.getPosition());
        transform.transform((Vector3DBasics)this.getAxis());
    }
}

