/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.euclid.geometry.Triangle3D;
import us.ihmc.euclid.geometry.interfaces.Triangle3DBasics;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class IcoSphereFactory {
    private IcoSphereFactory() {
    }

    public static TriangleMesh3D newIcoSphere(int recursionLevel) {
        TriangleMesh3D geometry = new TriangleMesh3D();
        HashMap<Long, Integer> midVertexIndexCache = new HashMap<Long, Integer>();
        double t = (1.0 + EuclidCoreTools.squareRoot((double)5.0)) / 2.0;
        geometry.addVertex(new Point3D(-1.0, t, 0.0));
        geometry.addVertex(new Point3D(1.0, t, 0.0));
        geometry.addVertex(new Point3D(-1.0, -t, 0.0));
        geometry.addVertex(new Point3D(1.0, -t, 0.0));
        geometry.addVertex(new Point3D(0.0, -1.0, t));
        geometry.addVertex(new Point3D(0.0, 1.0, t));
        geometry.addVertex(new Point3D(0.0, -1.0, -t));
        geometry.addVertex(new Point3D(0.0, 1.0, -t));
        geometry.addVertex(new Point3D(t, 0.0, -1.0));
        geometry.addVertex(new Point3D(t, 0.0, 1.0));
        geometry.addVertex(new Point3D(-t, 0.0, -1.0));
        geometry.addVertex(new Point3D(-t, 0.0, 1.0));
        ArrayList<TriangleIndices> faces = new ArrayList<TriangleIndices>();
        faces.add(new TriangleIndices(0, 11, 5));
        faces.add(new TriangleIndices(0, 5, 1));
        faces.add(new TriangleIndices(0, 1, 7));
        faces.add(new TriangleIndices(0, 7, 10));
        faces.add(new TriangleIndices(0, 10, 11));
        faces.add(new TriangleIndices(1, 5, 9));
        faces.add(new TriangleIndices(5, 11, 4));
        faces.add(new TriangleIndices(11, 10, 2));
        faces.add(new TriangleIndices(10, 7, 6));
        faces.add(new TriangleIndices(7, 1, 8));
        faces.add(new TriangleIndices(3, 9, 4));
        faces.add(new TriangleIndices(3, 4, 2));
        faces.add(new TriangleIndices(3, 2, 6));
        faces.add(new TriangleIndices(3, 6, 8));
        faces.add(new TriangleIndices(3, 8, 9));
        faces.add(new TriangleIndices(4, 9, 5));
        faces.add(new TriangleIndices(2, 4, 11));
        faces.add(new TriangleIndices(6, 2, 10));
        faces.add(new TriangleIndices(8, 6, 7));
        faces.add(new TriangleIndices(9, 8, 1));
        for (int i = 0; i < recursionLevel; ++i) {
            ArrayList<TriangleIndices> newFaces = new ArrayList<TriangleIndices>();
            for (TriangleIndices triangleIndices : faces) {
                int midAB = IcoSphereFactory.addMidVertex(geometry, midVertexIndexCache, triangleIndices.indexA, triangleIndices.indexB);
                int midBC = IcoSphereFactory.addMidVertex(geometry, midVertexIndexCache, triangleIndices.indexB, triangleIndices.indexC);
                int midCA = IcoSphereFactory.addMidVertex(geometry, midVertexIndexCache, triangleIndices.indexC, triangleIndices.indexA);
                newFaces.add(new TriangleIndices(triangleIndices.indexA, midAB, midCA));
                newFaces.add(new TriangleIndices(triangleIndices.indexB, midBC, midAB));
                newFaces.add(new TriangleIndices(triangleIndices.indexC, midCA, midBC));
                newFaces.add(new TriangleIndices(midAB, midBC, midCA));
            }
            faces = newFaces;
        }
        geometry.faces.addAll(faces);
        geometry.vertices.forEach(vertex -> vertex.scale(1.0 / vertex.distanceFromOrigin()));
        return geometry;
    }

    private static int addMidVertex(TriangleMesh3D geometry, Map<Long, Integer> midVertexIndexCache, int firstVertexIndex, int secondVertexIndex) {
        long greaterIndex;
        boolean firstIsSmaller = firstVertexIndex < secondVertexIndex;
        long smallerIndex = firstIsSmaller ? (long)firstVertexIndex : (long)secondVertexIndex;
        long key = (smallerIndex << 32) + (greaterIndex = firstIsSmaller ? (long)secondVertexIndex : (long)firstVertexIndex);
        Integer midVertexIndex = midVertexIndexCache.get(key);
        if (midVertexIndex != null) {
            return midVertexIndex;
        }
        Point3D vertex1 = geometry.getVertex(firstVertexIndex);
        Point3D vertex2 = geometry.getVertex(secondVertexIndex);
        int newVertexIndex = geometry.getNumberOfVertices();
        geometry.addVertex(EuclidGeometryTools.averagePoint3Ds((Point3DReadOnly)vertex1, (Point3DReadOnly)vertex2));
        midVertexIndexCache.put(key, newVertexIndex);
        return newVertexIndex;
    }

    public static class TriangleMesh3D
    implements Transformable {
        private final List<Point3D> vertices = new ArrayList<Point3D>();
        private final List<TriangleIndices> faces = new ArrayList<TriangleIndices>();

        public void addVertex(Point3D vertex) {
            this.vertices.add(vertex);
        }

        public Point3D getVertex(int index) {
            return this.vertices.get(index);
        }

        public List<Point3D> getVertices() {
            return this.vertices;
        }

        public int getNumberOfVertices() {
            return this.vertices.size();
        }

        public int getNumberOfTriangles() {
            return this.faces.size();
        }

        public Triangle3D getTriangle(int index) {
            TriangleIndices triangleIndices = this.faces.get(index);
            Point3D a = this.vertices.get(triangleIndices.indexA);
            Point3D b = this.vertices.get(triangleIndices.indexB);
            Point3D c = this.vertices.get(triangleIndices.indexC);
            return new Triangle3D((Point3DReadOnly)a, (Point3DReadOnly)b, (Point3DReadOnly)c);
        }

        public void getTriangle(int index, Triangle3DBasics triangleToPack) {
            TriangleIndices triangleIndices = this.faces.get(index);
            Point3D a = this.vertices.get(triangleIndices.indexA);
            Point3D b = this.vertices.get(triangleIndices.indexB);
            Point3D c = this.vertices.get(triangleIndices.indexC);
            triangleToPack.set((Point3DReadOnly)a, (Point3DReadOnly)b, (Point3DReadOnly)c);
        }

        public List<Triangle3D> getAllTriangles() {
            ArrayList<Triangle3D> triangles = new ArrayList<Triangle3D>();
            for (int index = 0; index < this.getNumberOfTriangles(); ++index) {
                triangles.add(this.getTriangle(index));
            }
            return triangles;
        }

        public void applyTransform(Transform transform) {
            this.vertices.forEach(arg_0 -> ((Transform)transform).transform(arg_0));
        }

        public void applyInverseTransform(Transform transform) {
            this.vertices.forEach(arg_0 -> ((Transform)transform).inverseTransform(arg_0));
        }
    }

    public static class TriangleIndices {
        private final int indexA;
        private final int indexB;
        private final int indexC;

        public TriangleIndices(int v1, int v2, int v3) {
            this.indexA = v1;
            this.indexB = v2;
            this.indexC = v3;
        }
    }
}

