/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DBasics;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Sphere3DReadOnly
extends Shape3DReadOnly {
    public double getRadius();

    public Point3DReadOnly getPosition();

    @Override
    default public Point3DReadOnly getCentroid() {
        return this.getPosition();
    }

    @Override
    default public double getVolume() {
        return EuclidShapeTools.sphereVolume(this.getRadius());
    }

    @Override
    default public boolean containsNaN() {
        return this.getPosition().containsNaN() || Double.isNaN(this.getRadius());
    }

    @Override
    default public boolean evaluatePoint3DCollision(Point3DReadOnly pointToCheck, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalAtClosestPointToPack) {
        return EuclidShapeTools.evaluatePoint3DSphere3DCollision(pointToCheck, this.getPosition(), this.getRadius(), closestPointOnSurfaceToPack, normalAtClosestPointToPack) <= 0.0;
    }

    @Override
    default public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        EuclidShapeTools.supportingVertexSphere3D(supportDirection, this.getPosition(), this.getRadius(), supportingVertexToPack);
        return true;
    }

    @Override
    default public double signedDistance(Point3DReadOnly point) {
        return EuclidShapeTools.signedDistanceBetweenPoint3DAndSphere3D(point, this.getPosition(), this.getRadius());
    }

    @Override
    default public boolean isPointInside(Point3DReadOnly query, double epsilon) {
        return EuclidShapeTools.isPoint3DInsideSphere3D(query, this.getPosition(), this.getRadius(), epsilon);
    }

    @Override
    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        return EuclidShapeTools.orthogonalProjectionOntoSphere3D(pointToProject, this.getPosition(), this.getRadius(), projectionToPack);
    }

    default public int intersectionWith(Line3DReadOnly line, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (Vector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double pointOnLineX = pointOnLine.getX() - this.getPosition().getX();
        double pointOnLineY = pointOnLine.getY() - this.getPosition().getY();
        double pointOnLineZ = pointOnLine.getZ() - this.getPosition().getZ();
        double lineDirectionX = lineDirection.getX();
        double lineDirectionY = lineDirection.getY();
        double lineDirectionZ = lineDirection.getZ();
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)this.getRadius(), (double)this.getRadius(), (double)this.getRadius(), (double)pointOnLineX, (double)pointOnLineY, (double)pointOnLineZ, (double)lineDirectionX, (double)lineDirectionY, (double)lineDirectionZ, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        if (firstIntersectionToPack != null && numberOfIntersections >= 1) {
            firstIntersectionToPack.add((Tuple3DReadOnly)this.getPosition());
        }
        if (secondIntersectionToPack != null && numberOfIntersections == 2) {
            secondIntersectionToPack.add((Tuple3DReadOnly)this.getPosition());
        }
        return numberOfIntersections;
    }

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        double minX = this.getPosition().getX() - this.getRadius();
        double minY = this.getPosition().getY() - this.getRadius();
        double minZ = this.getPosition().getZ() - this.getRadius();
        double maxX = this.getPosition().getX() + this.getRadius();
        double maxY = this.getPosition().getY() + this.getRadius();
        double maxZ = this.getPosition().getZ() + this.getRadius();
        boundingBoxToPack.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    default public boolean isConvex() {
        return true;
    }

    @Override
    default public boolean isPrimitive() {
        return true;
    }

    @Override
    default public boolean isDefinedByPose() {
        return false;
    }

    @Override
    default public Shape3DPoseReadOnly getPose() {
        return null;
    }

    @Override
    public Sphere3DBasics copy();

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Sphere3DReadOnly)) {
            return false;
        }
        Sphere3DReadOnly other = (Sphere3DReadOnly)geometry;
        return EuclidCoreTools.epsilonEquals((double)this.getRadius(), (double)other.getRadius(), (double)epsilon) && this.getPosition().epsilonEquals((EuclidGeometry)other.getPosition(), epsilon);
    }

    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Sphere3DReadOnly)) {
            return false;
        }
        Sphere3DReadOnly other = (Sphere3DReadOnly)geometry;
        return EuclidCoreTools.epsilonEquals((double)this.getRadius(), (double)other.getRadius(), (double)epsilon) && this.getPosition().geometricallyEquals((EuclidGeometry)other.getPosition(), epsilon);
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Sphere3DReadOnly)) {
            return false;
        }
        Sphere3DReadOnly other = (Sphere3DReadOnly)geometry;
        return this.getPosition().equals((EuclidGeometry)other.getPosition()) && EuclidCoreTools.equals((double)this.getRadius(), (double)other.getRadius());
    }

    default public String toString(String format) {
        return EuclidShapeIOTools.getSphere3DString(format, this);
    }
}

