/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import java.util.ArrayDeque;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;

public interface IntermediateVariableSupplier {
    public Point3DBasics requestPoint3D();

    public void releasePoint3D(Point3DBasics var1);

    public Vector3DBasics requestVector3D();

    public void releaseVector3D(Vector3DBasics var1);

    public static IntermediateVariableSupplier defaultIntermediateVariableSupplier() {
        return new IntermediateVariableSupplier(){

            @Override
            public Point3DBasics requestPoint3D() {
                return new Point3D();
            }

            @Override
            public void releasePoint3D(Point3DBasics variableToRelease) {
            }

            @Override
            public Vector3DBasics requestVector3D() {
                return new Vector3D();
            }

            @Override
            public void releaseVector3D(Vector3DBasics variableToRelease) {
            }
        };
    }

    public static IntermediateVariableSupplier garbageFreeIntermediateVariableSupplier() {
        return new IntermediateVariableSupplier(){
            private final ArrayDeque<Point3DBasics> point3DPool = new ArrayDeque();
            private final ArrayDeque<Vector3DBasics> vector3DPool = new ArrayDeque();

            @Override
            public Point3DBasics requestPoint3D() {
                if (this.point3DPool.isEmpty()) {
                    return new Point3D();
                }
                return this.point3DPool.poll();
            }

            @Override
            public void releasePoint3D(Point3DBasics variableToRelease) {
                this.point3DPool.addLast(variableToRelease);
            }

            @Override
            public Vector3DBasics requestVector3D() {
                if (this.vector3DPool.isEmpty()) {
                    return new Vector3D();
                }
                return this.vector3DPool.poll();
            }

            @Override
            public void releaseVector3D(Vector3DBasics variableToRelease) {
                this.vector3DPool.addLast(variableToRelease);
            }
        };
    }
}

