/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision.gjk;

import us.ihmc.euclid.shape.collision.gjk.GJKSimplex3D;
import us.ihmc.euclid.shape.collision.gjk.GJKVertex3D;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.Matrix3DFeatures;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class GJKTools {
    public static final ProjectedTriangleSignedAreaCalculator yzTriangleAreaCalculator = (ax, ay, az, bx, by, bz, cx, cy, cz) -> GJKTools.triangleSignedArea(ay, az, by, bz, cy, cz);
    public static final ProjectedTriangleSignedAreaCalculator zxTriangleAreaCalculator = (ax, ay, az, bx, by, bz, cx, cy, cz) -> GJKTools.triangleSignedArea(az, ax, bz, bx, cz, cx);
    public static final ProjectedTriangleSignedAreaCalculator xyTriangleAreaCalculator = (ax, ay, az, bx, by, bz, cx, cy, cz) -> GJKTools.triangleSignedArea(ax, ay, bx, by, cx, cy);

    public static double triangleSignedArea(double ax, double ay, double bx, double by, double cx, double cy) {
        return ax * (by - cy) + bx * (cy - ay) + cx * (ay - by);
    }

    public static GJKSimplex3D simplexClosestToOrigin(GJKVertex3D[] oldVertices, GJKVertex3D newVertex) {
        if (oldVertices.length == 3) {
            return GJKTools.simplexClosestToOriginFrom3Simplex(newVertex, oldVertices[2], oldVertices[1], oldVertices[0]);
        }
        if (oldVertices.length == 2) {
            return GJKTools.simplexClosestToOriginFrom2Simplex(newVertex, oldVertices[1], oldVertices[0]);
        }
        if (oldVertices.length == 1) {
            return GJKTools.simplexClosestToOriginFrom1Simplex(newVertex, oldVertices[0]);
        }
        return new GJKSimplex3D(newVertex);
    }

    public static GJKSimplex3D simplexClosestToOriginFrom3Simplex(GJKVertex3D s1, GJKVertex3D s2, GJKVertex3D s3, GJKVertex3D s4) {
        double candidateNorm;
        GJKSimplex3D candidateOutput;
        double C44;
        double C43;
        double C42;
        double s4z;
        double s4y;
        double s1x = s1.getX();
        double s1y = s1.getY();
        double s1z = s1.getZ();
        double s2x = s2.getX();
        double s2y = s2.getY();
        double s2z = s2.getZ();
        double s3x = s3.getX();
        double s3y = s3.getY();
        double s3z = s3.getZ();
        double s4x = s4.getX();
        double C41 = -Matrix3DFeatures.determinant((double)s2x, (double)s3x, (double)s4x, (double)s2y, (double)s3y, (double)(s4y = s4.getY()), (double)s2z, (double)s3z, (double)(s4z = s4.getZ()));
        double detM = C41 + (C42 = Matrix3DFeatures.determinant((double)s1x, (double)s3x, (double)s4x, (double)s1y, (double)s3y, (double)s4y, (double)s1z, (double)s3z, (double)s4z)) + (C43 = -Matrix3DFeatures.determinant((double)s1x, (double)s2x, (double)s4x, (double)s1y, (double)s2y, (double)s4y, (double)s1z, (double)s2z, (double)s4z)) + (C44 = Matrix3DFeatures.determinant((double)s1x, (double)s2x, (double)s3x, (double)s1y, (double)s2y, (double)s3y, (double)s1z, (double)s2z, (double)s3z));
        if (GJKTools.compareSigns(detM, C41) && GJKTools.compareSigns(detM, C42) && GJKTools.compareSigns(detM, C43) && GJKTools.compareSigns(detM, C44)) {
            double[] lambdas = new double[]{C41 / detM, C42 / detM, C43 / detM, C44 / detM};
            GJKVertex3D[] supportVertices = new GJKVertex3D[]{s1, s2, s3, s4};
            return new GJKSimplex3D(supportVertices, lambdas);
        }
        double d = Double.POSITIVE_INFINITY;
        GJKSimplex3D output = null;
        double zeroTestEpsilon = 1.0E-13;
        if (GJKTools.compareSigns(detM, -C42)) {
            if (EuclidCoreTools.isZero((double)detM, (double)zeroTestEpsilon) && EuclidCoreTools.isZero((double)C42, (double)zeroTestEpsilon)) {
                return null;
            }
            candidateOutput = GJKTools.simplexClosestToOriginFrom2Simplex(s1, s3, s4);
            if (candidateOutput != null && (candidateNorm = candidateOutput.getDistanceSquaredToOrigin()) < d) {
                output = candidateOutput;
                d = candidateNorm;
            }
        }
        if (GJKTools.compareSigns(detM, -C43)) {
            if (EuclidCoreTools.isZero((double)detM, (double)zeroTestEpsilon) && EuclidCoreTools.isZero((double)C43, (double)zeroTestEpsilon)) {
                return null;
            }
            candidateOutput = GJKTools.simplexClosestToOriginFrom2Simplex(s1, s2, s4);
            if (candidateOutput != null && (candidateNorm = candidateOutput.getDistanceSquaredToOrigin()) < d) {
                output = candidateOutput;
                d = candidateNorm;
            }
        }
        if (GJKTools.compareSigns(detM, -C44)) {
            if (EuclidCoreTools.isZero((double)detM, (double)zeroTestEpsilon) && EuclidCoreTools.isZero((double)C44, (double)zeroTestEpsilon)) {
                return null;
            }
            candidateOutput = GJKTools.simplexClosestToOriginFrom2Simplex(s1, s2, s3);
            if (candidateOutput != null && (candidateNorm = candidateOutput.getDistanceSquaredToOrigin()) < d) {
                output = candidateOutput;
                d = candidateNorm;
            }
        }
        return output;
    }

    public static GJKSimplex3D simplexClosestToOriginFrom2Simplex(GJKVertex3D s1, GJKVertex3D s2, GJKVertex3D s3) {
        GJKSimplex3D candidateOutput;
        double candidateNorm;
        double s1x = s1.getX();
        double s1y = s1.getY();
        double s1z = s1.getZ();
        double s2x = s2.getX();
        double s2y = s2.getY();
        double s2z = s2.getZ();
        double s3x = s3.getX();
        double s3y = s3.getY();
        double s3z = s3.getZ();
        double s2s1x3D = s1x - s2x;
        double s2s1y3D = s1y - s2y;
        double s2s1z3D = s1z - s2z;
        double s3s1x3D = s1x - s3x;
        double s3s1y3D = s1y - s3y;
        double s3s1z3D = s1z - s3z;
        double nx = s2s1y3D * s3s1z3D - s2s1z3D * s3s1y3D;
        double ny = s2s1z3D * s3s1x3D - s2s1x3D * s3s1z3D;
        double nz = s2s1x3D * s3s1y3D - s2s1y3D * s3s1x3D;
        double distanceFromPlane = TupleTools.dot((double)nx, (double)ny, (double)nz, (Tuple3DReadOnly)s1) / EuclidCoreTools.normSquared((double)nx, (double)ny, (double)nz);
        double p0x = distanceFromPlane * nx;
        double p0y = distanceFromPlane * ny;
        double p0z = distanceFromPlane * nz;
        double muMax = 0.0;
        double muMaxAbs = 0.0;
        ProjectedTriangleSignedAreaCalculator calculator = yzTriangleAreaCalculator;
        double mu = calculator.compute(s1x, s1y, s1z, s2x, s2y, s2z, s3x, s3y, s3z);
        double muAbs = Math.abs(mu);
        muMax = mu;
        muMaxAbs = muAbs;
        mu = zxTriangleAreaCalculator.compute(s1x, s1y, s1z, s2x, s2y, s2z, s3x, s3y, s3z);
        muAbs = Math.abs(mu);
        if (muAbs > muMaxAbs) {
            muMax = mu;
            muMaxAbs = muAbs;
            calculator = zxTriangleAreaCalculator;
        }
        if ((muAbs = Math.abs(mu = xyTriangleAreaCalculator.compute(s1x, s1y, s1z, s2x, s2y, s2z, s3x, s3y, s3z))) > muMaxAbs) {
            muMax = mu;
            muMaxAbs = muAbs;
            calculator = xyTriangleAreaCalculator;
        }
        double C1 = calculator.compute(p0x, p0y, p0z, s2x, s2y, s2z, s3x, s3y, s3z);
        double C2 = calculator.compute(s1x, s1y, s1z, p0x, p0y, p0z, s3x, s3y, s3z);
        double C3 = calculator.compute(s1x, s1y, s1z, s2x, s2y, s2z, p0x, p0y, p0z);
        if (GJKTools.compareSigns(muMax, C1) && GJKTools.compareSigns(muMax, C2) && GJKTools.compareSigns(muMax, C3)) {
            if (Math.abs(C1) < 1.0E-16 && Math.abs(C2) < 1.0E-16 && Math.abs(C3) < 1.0E-16) {
                return null;
            }
            double[] lambdas = new double[]{C1 / muMax, C2 / muMax, C3 / muMax};
            GJKVertex3D[] supportingVerices = new GJKVertex3D[]{s1, s2, s3};
            return new GJKSimplex3D(supportingVerices, lambdas);
        }
        double d = Double.POSITIVE_INFINITY;
        GJKSimplex3D output = null;
        if (GJKTools.compareSigns(muMax, -C2)) {
            GJKSimplex3D candidateOutput2 = GJKTools.simplexClosestToOriginFrom1Simplex(s1, s3);
            candidateNorm = candidateOutput2.getDistanceSquaredToOrigin();
            output = candidateOutput2;
            d = candidateNorm;
        }
        if (GJKTools.compareSigns(muMax, -C3) && (candidateNorm = (candidateOutput = GJKTools.simplexClosestToOriginFrom1Simplex(s1, s2)).getDistanceSquaredToOrigin()) < d) {
            output = candidateOutput;
            d = candidateNorm;
        }
        return output;
    }

    public static GJKSimplex3D simplexClosestToOriginFrom1Simplex(GJKVertex3D s1, GJKVertex3D s2) {
        double C1;
        double s1x = s1.getX();
        double s1y = s1.getY();
        double s1z = s1.getZ();
        double s2x = s2.getX();
        double s2y = s2.getY();
        double s2z = s2.getZ();
        double tx = s2x - s1x;
        double ty = s2y - s1y;
        double tz = s2z - s1z;
        double param = -TupleTools.dot((double)tx, (double)ty, (double)tz, (Tuple3DReadOnly)s2) / EuclidCoreTools.normSquared((double)tx, (double)ty, (double)tz);
        double p0x = param * tx + s2x;
        double p0y = param * ty + s2y;
        double p0z = param * tz + s2z;
        double muMax = 0.0;
        double s1Max = s1x;
        double s2Max = s2x;
        double p0Max = p0x;
        muMax = s1x - s2x;
        double mu = s1y - s2y;
        if (Math.abs(mu) > Math.abs(muMax)) {
            s1Max = s1y;
            s2Max = s2y;
            p0Max = p0y;
            muMax = mu;
        }
        if (Math.abs(mu = s1z - s2z) > Math.abs(muMax)) {
            s1Max = s1z;
            s2Max = s2z;
            p0Max = p0z;
            muMax = mu;
        }
        if (GJKTools.compareSigns(muMax, C1 = -(s2Max - p0Max))) {
            double C2 = s1Max - p0Max;
            if (GJKTools.compareSigns(muMax, C2)) {
                double[] lambdas = new double[]{C1 / muMax, C2 / muMax};
                GJKVertex3D[] supportVertices = new GJKVertex3D[]{s1, s2};
                return new GJKSimplex3D(supportVertices, lambdas);
            }
            return new GJKSimplex3D(s1);
        }
        return new GJKSimplex3D(s1);
    }

    public static boolean compareSigns(double a, double b) {
        if (a > 0.0 && b >= 0.0) {
            return true;
        }
        return a < -0.0 && b <= -0.0;
    }

    public static interface ProjectedTriangleSignedAreaCalculator {
        public double compute(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17);
    }
}

