/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface PointShape3DReadOnly
extends Shape3DReadOnly,
Point3DReadOnly {
    @Override
    default public Point3DReadOnly getCentroid() {
        return this;
    }

    @Override
    default public double getVolume() {
        return 0.0;
    }

    @Override
    default public double distance(Point3DReadOnly point) {
        return super.distance(point);
    }

    @Override
    default public double signedDistance(Point3DReadOnly point) {
        return this.distance(point);
    }

    @Override
    default public boolean containsNaN() {
        return super.containsNaN();
    }

    @Override
    default public boolean evaluatePoint3DCollision(Point3DReadOnly pointToCheck, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalAtClosestPointToPack) {
        closestPointOnSurfaceToPack.set((Tuple3DReadOnly)this);
        normalAtClosestPointToPack.sub((Tuple3DReadOnly)pointToCheck, (Tuple3DReadOnly)this);
        normalAtClosestPointToPack.normalize();
        return false;
    }

    @Override
    default public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        supportingVertexToPack.set((Tuple3DReadOnly)this);
        return true;
    }

    @Override
    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        projectionToPack.set((Tuple3DReadOnly)this);
        return true;
    }

    @Override
    default public boolean isPointInside(Point3DReadOnly query, double epsilon) {
        return this.distanceSquared(query) <= epsilon * epsilon;
    }

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        boundingBoxToPack.set((Point3DReadOnly)this, (Point3DReadOnly)this);
    }

    @Override
    default public boolean isConvex() {
        return true;
    }

    @Override
    default public boolean isPrimitive() {
        return true;
    }

    @Override
    default public boolean isDefinedByPose() {
        return false;
    }

    @Override
    default public Shape3DPoseReadOnly getPose() {
        return null;
    }

    @Override
    public PointShape3DBasics copy();

    default public String toString(String format) {
        return EuclidShapeIOTools.getPointShape3DString(format, this);
    }
}

