/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Cylinder3DReadOnly
extends Shape3DReadOnly {
    public double getLength();

    default public double getHalfLength() {
        return 0.5 * this.getLength();
    }

    public double getRadius();

    public Point3DReadOnly getPosition();

    public UnitVector3DReadOnly getAxis();

    @Override
    default public Point3DReadOnly getCentroid() {
        return this.getPosition();
    }

    @Override
    default public double getVolume() {
        return EuclidShapeTools.cylinderVolume(this.getRadius(), this.getLength());
    }

    default public Point3DReadOnly getTopCenter() {
        Point3D topCenter = new Point3D();
        topCenter.scaleAdd(this.getHalfLength(), (Tuple3DReadOnly)this.getAxis(), (Tuple3DReadOnly)this.getPosition());
        return topCenter;
    }

    default public Point3DReadOnly getBottomCenter() {
        Point3D bottomCenter = new Point3D();
        bottomCenter.scaleAdd(-this.getHalfLength(), (Tuple3DReadOnly)this.getAxis(), (Tuple3DReadOnly)this.getPosition());
        return bottomCenter;
    }

    @Override
    default public boolean containsNaN() {
        return this.getPosition().containsNaN() || this.getAxis().containsNaN() || Double.isNaN(this.getLength()) || Double.isNaN(this.getRadius());
    }

    @Override
    default public boolean evaluatePoint3DCollision(Point3DReadOnly pointToCheck, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalAtClosestPointToPack) {
        return EuclidShapeTools.evaluatePoint3DCylinder3DCollision(pointToCheck, this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getLength(), this.getRadius(), closestPointOnSurfaceToPack, normalAtClosestPointToPack) <= 0.0;
    }

    @Override
    default public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        EuclidShapeTools.supportingVertexCylinder3D(supportDirection, this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getLength(), this.getRadius(), supportingVertexToPack);
        return true;
    }

    @Override
    default public double signedDistance(Point3DReadOnly point) {
        return EuclidShapeTools.signedDistanceBetweenPoint3DAndCylinder3D(point, this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getLength(), this.getRadius());
    }

    @Override
    default public boolean isPointInside(Point3DReadOnly query, double epsilon) {
        return EuclidShapeTools.isPoint3DInsideCylinder3D(query, this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getLength(), this.getRadius(), epsilon);
    }

    @Override
    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        return EuclidShapeTools.orthogonalProjectionOntoCylinder3D(pointToProject, this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getLength(), this.getRadius(), projectionToPack);
    }

    default public int intersectionWith(Line3DReadOnly line, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (Vector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3D((double)this.getLength(), (double)this.getRadius(), (Point3DReadOnly)this.getPosition(), (Vector3DReadOnly)this.getAxis(), (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        EuclidShapeTools.boundingBoxCylinder3D(this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getLength(), this.getRadius(), boundingBoxToPack);
    }

    @Override
    default public boolean isConvex() {
        return true;
    }

    @Override
    default public boolean isPrimitive() {
        return true;
    }

    @Override
    default public boolean isDefinedByPose() {
        return false;
    }

    @Override
    default public Shape3DPoseReadOnly getPose() {
        return null;
    }

    @Override
    public Cylinder3DBasics copy();

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Cylinder3DReadOnly)) {
            return false;
        }
        Cylinder3DReadOnly other = (Cylinder3DReadOnly)geometry;
        if (!EuclidCoreTools.epsilonEquals((double)this.getLength(), (double)other.getLength(), (double)epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals((double)this.getRadius(), (double)other.getRadius(), (double)epsilon)) {
            return false;
        }
        if (!this.getPosition().epsilonEquals((EuclidGeometry)other.getPosition(), epsilon)) {
            return false;
        }
        return other.getAxis().epsilonEquals((EuclidGeometry)other.getAxis(), epsilon);
    }

    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Cylinder3DReadOnly)) {
            return false;
        }
        Cylinder3DReadOnly other = (Cylinder3DReadOnly)geometry;
        if (!EuclidCoreTools.epsilonEquals((double)this.getRadius(), (double)other.getRadius(), (double)epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals((double)this.getLength(), (double)other.getLength(), (double)epsilon)) {
            return false;
        }
        if (!this.getPosition().geometricallyEquals((EuclidGeometry)other.getPosition(), epsilon)) {
            return false;
        }
        return EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)this.getAxis(), (Vector3DReadOnly)other.getAxis(), (double)epsilon);
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Cylinder3DReadOnly)) {
            return false;
        }
        Cylinder3DReadOnly other = (Cylinder3DReadOnly)geometry;
        if (!EuclidCoreTools.equals((double)this.getRadius(), (double)other.getRadius())) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.getLength(), (double)other.getLength())) {
            return false;
        }
        if (!this.getPosition().equals((EuclidGeometry)other.getPosition())) {
            return false;
        }
        return this.getAxis().equals((EuclidGeometry)other.getAxis());
    }

    default public String toString(String format) {
        return EuclidShapeIOTools.getCylinder3DString(format, this);
    }
}

