/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Shape3DPose
implements Shape3DPoseBasics,
Settable<Shape3DPose> {
    private final List<Shape3DChangeListener> changeListeners = new ArrayList<Shape3DChangeListener>();
    private final RotationMatrixBasics shapeOrientation = EuclidCoreFactories.newObservableRotationMatrixBasics(this::notifyChangeListeners, null);
    private final Point3DBasics shapePosition = EuclidCoreFactories.newObservablePoint3DBasics((axis, newValue) -> this.notifyChangeListeners(), null);
    private final Vector3DReadOnly xAxis = EuclidCoreFactories.newLinkedVector3DReadOnly(() -> ((RotationMatrixBasics)this.shapeOrientation).getM00(), () -> ((RotationMatrixBasics)this.shapeOrientation).getM10(), () -> ((RotationMatrixBasics)this.shapeOrientation).getM20());
    private final Vector3DReadOnly yAxis = EuclidCoreFactories.newLinkedVector3DReadOnly(() -> ((RotationMatrixBasics)this.shapeOrientation).getM01(), () -> ((RotationMatrixBasics)this.shapeOrientation).getM11(), () -> ((RotationMatrixBasics)this.shapeOrientation).getM21());
    private final Vector3DReadOnly zAxis = EuclidCoreFactories.newLinkedVector3DReadOnly(() -> ((RotationMatrixBasics)this.shapeOrientation).getM02(), () -> ((RotationMatrixBasics)this.shapeOrientation).getM12(), () -> ((RotationMatrixBasics)this.shapeOrientation).getM22());

    public Shape3DPose() {
        this.setToZero();
    }

    public Shape3DPose(RigidBodyTransformReadOnly rigidBodyTransform) {
        this.set(rigidBodyTransform);
    }

    public Shape3DPose(Pose3DReadOnly pose) {
        this.set(pose);
    }

    public void set(Shape3DPose other) {
        Shape3DPoseBasics.super.set((RigidBodyTransformReadOnly)other);
    }

    @Override
    public RotationMatrixBasics getShapeOrientation() {
        return this.shapeOrientation;
    }

    @Override
    public Point3DBasics getShapePosition() {
        return this.shapePosition;
    }

    @Override
    public Vector3DReadOnly getXAxis() {
        return this.xAxis;
    }

    @Override
    public Vector3DReadOnly getYAxis() {
        return this.yAxis;
    }

    @Override
    public Vector3DReadOnly getZAxis() {
        return this.zAxis;
    }

    public void notifyChangeListeners() {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).changed();
        }
    }

    public void addChangeListeners(List<? extends Shape3DChangeListener> listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.addChangeListener(listeners.get(i));
        }
    }

    public void addChangeListener(Shape3DChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public boolean removeChangeListener(Shape3DChangeListener listener) {
        return this.changeListeners.remove(listener);
    }

    public boolean equals(Object object) {
        if (object instanceof Shape3DPoseReadOnly) {
            return this.equals((EuclidGeometry)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.shapePosition, (Object)this.shapeOrientation);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

