/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision.epa;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.collision.epa.EPAFace3D;
import us.ihmc.euclid.shape.collision.epa.EPAHalfEdge3D;
import us.ihmc.euclid.shape.collision.epa.EPAVertex3D;
import us.ihmc.euclid.shape.collision.gjk.GJKTools;
import us.ihmc.euclid.shape.collision.gjk.GJKVertex3D;
import us.ihmc.euclid.shape.collision.interfaces.SupportingVertexHolder;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EPATools {
    public static BarycentricCoordinatesOutput barycentricCoordinatesFrom2Simplex(Point3DReadOnly s1, Point3DReadOnly s2, Point3DReadOnly s3, double epsilon, double[] lambdasToPack) {
        double lambda1;
        double candidateNormSquared;
        double lambda3;
        double s1x = s1.getX();
        double s1y = s1.getY();
        double s1z = s1.getZ();
        double s2x = s2.getX();
        double s2y = s2.getY();
        double s2z = s2.getZ();
        double s3x = s3.getX();
        double s3y = s3.getY();
        double s3z = s3.getZ();
        double s2s1x3D = s1x - s2x;
        double s2s1y3D = s1y - s2y;
        double s2s1z3D = s1z - s2z;
        double s3s1x3D = s1x - s3x;
        double s3s1y3D = s1y - s3y;
        double s3s1z3D = s1z - s3z;
        double nx = s2s1y3D * s3s1z3D - s2s1z3D * s3s1y3D;
        double ny = s2s1z3D * s3s1x3D - s2s1x3D * s3s1z3D;
        double nz = s2s1x3D * s3s1y3D - s2s1y3D * s3s1x3D;
        double distanceFromPlane = TupleTools.dot((double)nx, (double)ny, (double)nz, (Tuple3DReadOnly)s1) / EuclidCoreTools.normSquared((double)nx, (double)ny, (double)nz);
        double p0x = distanceFromPlane * nx;
        double p0y = distanceFromPlane * ny;
        double p0z = distanceFromPlane * nz;
        double muMax = 0.0;
        double muMaxAbs = 0.0;
        GJKTools.ProjectedTriangleSignedAreaCalculator calculator = GJKTools.yzTriangleAreaCalculator;
        double mu = calculator.compute(s1x, s1y, s1z, s2x, s2y, s2z, s3x, s3y, s3z);
        double muAbs = Math.abs(mu);
        muMax = mu;
        muMaxAbs = muAbs;
        mu = GJKTools.zxTriangleAreaCalculator.compute(s1x, s1y, s1z, s2x, s2y, s2z, s3x, s3y, s3z);
        muAbs = Math.abs(mu);
        if (muAbs > muMaxAbs) {
            muMax = mu;
            muMaxAbs = muAbs;
            calculator = GJKTools.zxTriangleAreaCalculator;
        }
        if ((muAbs = Math.abs(mu = GJKTools.xyTriangleAreaCalculator.compute(s1x, s1y, s1z, s2x, s2y, s2z, s3x, s3y, s3z))) > muMaxAbs) {
            muMax = mu;
            muMaxAbs = muAbs;
            calculator = GJKTools.xyTriangleAreaCalculator;
        }
        if (Math.abs(muMax) < epsilon) {
            return BarycentricCoordinatesOutput.AFFINELY_DEPENDENT;
        }
        double C1 = calculator.compute(p0x, p0y, p0z, s2x, s2y, s2z, s3x, s3y, s3z);
        double C2 = calculator.compute(s1x, s1y, s1z, p0x, p0y, p0z, s3x, s3y, s3z);
        double C3 = calculator.compute(s1x, s1y, s1z, s2x, s2y, s2z, p0x, p0y, p0z);
        if (GJKTools.compareSigns(muMax, C1) && GJKTools.compareSigns(muMax, C2) && GJKTools.compareSigns(muMax, C3)) {
            lambdasToPack[0] = C1 / muMax;
            lambdasToPack[1] = C2 / muMax;
            lambdasToPack[2] = C3 / muMax;
            return BarycentricCoordinatesOutput.INSIDE;
        }
        double normSquared = Double.POSITIVE_INFINITY;
        boolean isAlmostInside = true;
        if (GJKTools.compareSigns(muMax, -C1)) {
            if (Math.abs(C1) > epsilon) {
                isAlmostInside = false;
            }
            double[] candidateOutput = EPATools.barycentricCoordinatesFrom1Simplex(s2, s3);
            double lambda2 = candidateOutput[0];
            lambda3 = candidateOutput[1];
            p0x = lambda2 * s2x + lambda3 * s3x;
            p0y = lambda2 * s2y + lambda3 * s3y;
            p0z = lambda2 * s2z + lambda3 * s3z;
            candidateNormSquared = EuclidCoreTools.normSquared((double)p0x, (double)p0y, (double)p0z);
            lambdasToPack[0] = 0.0;
            lambdasToPack[1] = lambda2;
            lambdasToPack[2] = lambda3;
            normSquared = candidateNormSquared;
        }
        if (GJKTools.compareSigns(muMax, -C2)) {
            double[] candidateOutput;
            if (Math.abs(C2) > epsilon) {
                isAlmostInside = false;
            }
            if ((candidateNormSquared = EuclidCoreTools.normSquared((double)(p0x = (lambda1 = (candidateOutput = EPATools.barycentricCoordinatesFrom1Simplex(s1, s3))[0]) * s1x + (lambda3 = candidateOutput[1]) * s3x), (double)(p0y = lambda1 * s1y + lambda3 * s3y), (double)(p0z = lambda1 * s1z + lambda3 * s3z))) < normSquared) {
                lambdasToPack[0] = lambda1;
                lambdasToPack[1] = 0.0;
                lambdasToPack[2] = lambda3;
                normSquared = candidateNormSquared;
            }
        }
        if (GJKTools.compareSigns(muMax, -C3)) {
            double lambda2;
            double[] candidateOutput;
            if (Math.abs(C3) > epsilon) {
                isAlmostInside = false;
            }
            if ((candidateNormSquared = EuclidCoreTools.normSquared((double)(p0x = (lambda1 = (candidateOutput = EPATools.barycentricCoordinatesFrom1Simplex(s1, s2))[0]) * s1x + (lambda2 = candidateOutput[1]) * s2x), (double)(p0y = lambda1 * s1y + lambda2 * s2y), (double)(p0z = lambda1 * s1z + lambda2 * s2z))) < normSquared) {
                lambdasToPack[0] = lambda1;
                lambdasToPack[1] = lambda2;
                lambdasToPack[2] = 0.0;
                normSquared = candidateNormSquared;
            }
        }
        return isAlmostInside ? BarycentricCoordinatesOutput.INSIDE : BarycentricCoordinatesOutput.OUTSIDE;
    }

    public static double[] barycentricCoordinatesFrom1Simplex(Point3DReadOnly s1, Point3DReadOnly s2) {
        double C1;
        double s1x = s1.getX();
        double s1y = s1.getY();
        double s1z = s1.getZ();
        double s2x = s2.getX();
        double s2y = s2.getY();
        double s2z = s2.getZ();
        double tx = s2x - s1x;
        double ty = s2y - s1y;
        double tz = s2z - s1z;
        double param = -TupleTools.dot((double)tx, (double)ty, (double)tz, (Tuple3DReadOnly)s2) / EuclidCoreTools.normSquared((double)tx, (double)ty, (double)tz);
        double p0x = param * tx + s2x;
        double p0y = param * ty + s2y;
        double p0z = param * tz + s2z;
        double muMax = 0.0;
        double s1Max = s1x;
        double s2Max = s2x;
        double p0Max = p0x;
        muMax = s1x - s2x;
        double mu = s1y - s2y;
        if (Math.abs(mu) > Math.abs(muMax)) {
            s1Max = s1y;
            s2Max = s2y;
            p0Max = p0y;
            muMax = mu;
        }
        if (Math.abs(mu = s1z - s2z) > Math.abs(muMax)) {
            s1Max = s1z;
            s2Max = s2z;
            p0Max = p0z;
            muMax = mu;
        }
        if (GJKTools.compareSigns(muMax, C1 = -(s2Max - p0Max))) {
            double C2 = s1Max - p0Max;
            if (GJKTools.compareSigns(muMax, C2)) {
                return new double[]{C1 / muMax, C2 / muMax};
            }
            return new double[]{0.0, 1.0};
        }
        return new double[]{1.0, 0.0};
    }

    public static List<EPAFace3D> newEPAPolytopeFromGJKSimplex(SupportingVertexHolder shapeA, SupportingVertexHolder shapeB, GJKVertex3D[] gjkVertices, double epsilon) {
        ArrayList<EPAFace3D> epaPolytope = new ArrayList<EPAFace3D>();
        if (gjkVertices == null) {
            return null;
        }
        if (gjkVertices.length == 4) {
            EPAVertex3D y0 = new EPAVertex3D(gjkVertices[0]);
            EPAVertex3D y1 = new EPAVertex3D(gjkVertices[1]);
            EPAVertex3D y2 = new EPAVertex3D(gjkVertices[2]);
            EPAVertex3D y3 = new EPAVertex3D(gjkVertices[3]);
            Vector3D n = EuclidPolytopeTools.crossProductOfLineSegment3Ds(y0, y1, y1, y2);
            n.negate();
            if (EuclidGeometryTools.isPoint3DAbovePlane3D((Point3DReadOnly)y3, (Point3DReadOnly)y0, (Vector3DReadOnly)n)) {
                EPAFace3D f0 = new EPAFace3D(y3, y0, y1, epsilon);
                if (f0.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f1 = new EPAFace3D(y3, y1, y2, epsilon);
                if (f1.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f2 = new EPAFace3D(y3, y2, y0, epsilon);
                if (f2.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f3 = new EPAFace3D(y0, y2, y1, epsilon);
                if (f3.isTriangleAffinelyDependent()) {
                    return null;
                }
                f0.getEdge1().setTwin(f3.getEdge2());
                f3.getEdge0().setTwin(f2.getEdge1());
                f2.getEdge2().setTwin(f0.getEdge0());
                f1.getEdge1().setTwin(f3.getEdge1());
                f0.getEdge2().setTwin(f1.getEdge0());
                f1.getEdge2().setTwin(f2.getEdge0());
                epaPolytope.add(f0);
                epaPolytope.add(f1);
                epaPolytope.add(f2);
                epaPolytope.add(f3);
            } else {
                EPAFace3D f0 = new EPAFace3D(y3, y1, y0, epsilon);
                if (f0.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f1 = new EPAFace3D(y3, y2, y1, epsilon);
                if (f1.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f2 = new EPAFace3D(y3, y0, y2, epsilon);
                if (f2.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f3 = new EPAFace3D(y0, y1, y2, epsilon);
                if (f3.isTriangleAffinelyDependent()) {
                    return null;
                }
                f3.getEdge0().setTwin(f0.getEdge1());
                f2.getEdge1().setTwin(f3.getEdge2());
                f0.getEdge2().setTwin(f2.getEdge0());
                f3.getEdge1().setTwin(f1.getEdge1());
                f1.getEdge2().setTwin(f0.getEdge0());
                f2.getEdge2().setTwin(f1.getEdge0());
                epaPolytope.add(f0);
                epaPolytope.add(f1);
                epaPolytope.add(f2);
                epaPolytope.add(f3);
            }
        } else if (gjkVertices.length == 3) {
            EPAVertex3D y0 = new EPAVertex3D(gjkVertices[0]);
            EPAVertex3D y1 = new EPAVertex3D(gjkVertices[1]);
            EPAVertex3D y2 = new EPAVertex3D(gjkVertices[2]);
            Vector3D n = EuclidPolytopeTools.crossProductOfLineSegment3Ds(y0, y1, y1, y2);
            n.negate();
            Point3DReadOnly vertexA = shapeA.getSupportingVertex((Vector3DReadOnly)n);
            n.negate();
            Point3DReadOnly vertexB = shapeB.getSupportingVertex((Vector3DReadOnly)n);
            EPAVertex3D y3 = new EPAVertex3D(vertexA, vertexB);
            vertexA = shapeA.getSupportingVertex((Vector3DReadOnly)n);
            n.negate();
            vertexB = shapeB.getSupportingVertex((Vector3DReadOnly)n);
            EPAVertex3D y4 = new EPAVertex3D(vertexA, vertexB);
            if (EuclidPolytopeTools.tetrahedronContainsOrigin(y0, y1, y2, y3)) {
                EPAFace3D f0 = new EPAFace3D(y3, y0, y1, epsilon);
                if (f0.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f1 = new EPAFace3D(y3, y1, y2, epsilon);
                if (f1.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f2 = new EPAFace3D(y3, y2, y0, epsilon);
                if (f2.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f3 = new EPAFace3D(y0, y2, y1, epsilon);
                if (f3.isTriangleAffinelyDependent()) {
                    return null;
                }
                f0.getEdge1().setTwin(f3.getEdge2());
                f3.getEdge0().setTwin(f2.getEdge1());
                f2.getEdge2().setTwin(f0.getEdge0());
                f1.getEdge1().setTwin(f3.getEdge1());
                f0.getEdge2().setTwin(f1.getEdge0());
                f1.getEdge2().setTwin(f2.getEdge0());
                epaPolytope.add(f0);
                epaPolytope.add(f1);
                epaPolytope.add(f2);
                epaPolytope.add(f3);
            } else if (EuclidPolytopeTools.tetrahedronContainsOrigin(y0, y1, y2, y4)) {
                EPAFace3D f0 = new EPAFace3D(y4, y1, y0, epsilon);
                if (f0.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f1 = new EPAFace3D(y4, y2, y1, epsilon);
                if (f1.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f2 = new EPAFace3D(y4, y0, y2, epsilon);
                if (f2.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f3 = new EPAFace3D(y0, y1, y2, epsilon);
                if (f3.isTriangleAffinelyDependent()) {
                    return null;
                }
                f3.getEdge0().setTwin(f0.getEdge1());
                f2.getEdge1().setTwin(f3.getEdge2());
                f0.getEdge2().setTwin(f2.getEdge0());
                f3.getEdge1().setTwin(f1.getEdge1());
                f1.getEdge2().setTwin(f0.getEdge0());
                f2.getEdge2().setTwin(f1.getEdge0());
                epaPolytope.add(f0);
                epaPolytope.add(f1);
                epaPolytope.add(f2);
                epaPolytope.add(f3);
            } else {
                EPAFace3D f0 = new EPAFace3D(y4, y1, y0, epsilon);
                if (f0.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f1 = new EPAFace3D(y4, y2, y1, epsilon);
                if (f1.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f2 = new EPAFace3D(y4, y0, y2, epsilon);
                if (f2.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f3 = new EPAFace3D(y3, y0, y1, epsilon);
                if (f3.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f4 = new EPAFace3D(y3, y1, y2, epsilon);
                if (f4.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f5 = new EPAFace3D(y3, y2, y0, epsilon);
                if (f5.isTriangleAffinelyDependent()) {
                    return null;
                }
                f3.getEdge0().setTwin(f5.getEdge2());
                f4.getEdge0().setTwin(f3.getEdge2());
                f5.getEdge0().setTwin(f4.getEdge2());
                f2.getEdge0().setTwin(f0.getEdge2());
                f0.getEdge0().setTwin(f1.getEdge2());
                f1.getEdge0().setTwin(f2.getEdge2());
                f3.getEdge1().setTwin(f0.getEdge1());
                f2.getEdge1().setTwin(f5.getEdge1());
                f4.getEdge1().setTwin(f1.getEdge1());
                epaPolytope.add(f0);
                epaPolytope.add(f1);
                epaPolytope.add(f2);
                epaPolytope.add(f3);
                epaPolytope.add(f4);
                epaPolytope.add(f5);
            }
        } else if (gjkVertices.length == 2) {
            EPAVertex3D y0 = new EPAVertex3D(gjkVertices[0]);
            EPAVertex3D y1 = new EPAVertex3D(gjkVertices[1]);
            Vector3D d = new Vector3D();
            d.sub((Tuple3DReadOnly)y1, (Tuple3DReadOnly)y0);
            Axis3D axis = Axis3D.X;
            double coord = Math.abs(d.getX());
            double yAbs = Math.abs(d.getY());
            double zAbs = Math.abs(d.getZ());
            if (yAbs > coord) {
                coord = yAbs;
                axis = Axis3D.Y;
            }
            if (zAbs > coord) {
                axis = Axis3D.Z;
            }
            Vector3D v1 = new Vector3D();
            v1.cross((Tuple3DReadOnly)d, (Tuple3DReadOnly)axis);
            RotationMatrix r = new RotationMatrix((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)d, 2.0943951023931953));
            Vector3D v2 = new Vector3D();
            Vector3D v3 = new Vector3D();
            r.transform((Tuple3DReadOnly)v1, (Tuple3DBasics)v2);
            r.transform((Tuple3DReadOnly)v2, (Tuple3DBasics)v3);
            Point3DReadOnly vertexA = shapeA.getSupportingVertex((Vector3DReadOnly)v1);
            v1.negate();
            Point3DReadOnly vertexB = shapeB.getSupportingVertex((Vector3DReadOnly)v1);
            EPAVertex3D y2 = new EPAVertex3D(vertexA, vertexB);
            vertexA = shapeA.getSupportingVertex((Vector3DReadOnly)v2);
            v2.negate();
            vertexB = shapeB.getSupportingVertex((Vector3DReadOnly)v2);
            EPAVertex3D y3 = new EPAVertex3D(vertexA, vertexB);
            vertexA = shapeA.getSupportingVertex((Vector3DReadOnly)v3);
            v3.negate();
            vertexB = shapeB.getSupportingVertex((Vector3DReadOnly)v3);
            EPAVertex3D y4 = new EPAVertex3D(vertexA, vertexB);
            if (EuclidPolytopeTools.tetrahedronContainsOrigin(y0, y2, y3, y4)) {
                EPAFace3D f0 = new EPAFace3D(y0, y2, y3, epsilon);
                if (f0.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f1 = new EPAFace3D(y0, y3, y4, epsilon);
                if (f1.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f2 = new EPAFace3D(y0, y4, y2, epsilon);
                if (f2.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f3 = new EPAFace3D(y2, y4, y3, epsilon);
                if (f3.isTriangleAffinelyDependent()) {
                    return null;
                }
                f0.getEdge0().setTwin(f2.getEdge2());
                f1.getEdge0().setTwin(f0.getEdge2());
                f2.getEdge0().setTwin(f1.getEdge2());
                f0.getEdge1().setTwin(f3.getEdge2());
                f3.getEdge0().setTwin(f2.getEdge1());
                f1.getEdge1().setTwin(f3.getEdge1());
                epaPolytope.add(f0);
                epaPolytope.add(f1);
                epaPolytope.add(f2);
                epaPolytope.add(f3);
            } else if (EuclidPolytopeTools.tetrahedronContainsOrigin(y1, y2, y3, y4)) {
                EPAFace3D f0 = new EPAFace3D(y1, y3, y2, epsilon);
                if (f0.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f1 = new EPAFace3D(y1, y4, y3, epsilon);
                if (f1.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f2 = new EPAFace3D(y1, y2, y4, epsilon);
                if (f2.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f3 = new EPAFace3D(y2, y3, y4, epsilon);
                if (f3.isTriangleAffinelyDependent()) {
                    return null;
                }
                f2.getEdge0().setTwin(f0.getEdge2());
                f0.getEdge0().setTwin(f1.getEdge2());
                f1.getEdge0().setTwin(f2.getEdge2());
                f3.getEdge0().setTwin(f0.getEdge1());
                f2.getEdge1().setTwin(f3.getEdge2());
                f3.getEdge1().setTwin(f1.getEdge1());
                epaPolytope.add(f0);
                epaPolytope.add(f1);
                epaPolytope.add(f2);
                epaPolytope.add(f3);
            } else {
                EPAFace3D f0 = new EPAFace3D(y0, y2, y3, epsilon);
                if (f0.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f1 = new EPAFace3D(y0, y3, y4, epsilon);
                if (f1.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f2 = new EPAFace3D(y0, y4, y2, epsilon);
                if (f2.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f3 = new EPAFace3D(y1, y3, y2, epsilon);
                if (f3.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f4 = new EPAFace3D(y1, y4, y3, epsilon);
                if (f4.isTriangleAffinelyDependent()) {
                    return null;
                }
                EPAFace3D f5 = new EPAFace3D(y1, y2, y4, epsilon);
                if (f5.isTriangleAffinelyDependent()) {
                    return null;
                }
                f0.getEdge0().setTwin(f2.getEdge2());
                f1.getEdge0().setTwin(f0.getEdge2());
                f2.getEdge0().setTwin(f1.getEdge2());
                f5.getEdge0().setTwin(f3.getEdge2());
                f3.getEdge0().setTwin(f4.getEdge2());
                f4.getEdge0().setTwin(f5.getEdge2());
                f0.getEdge1().setTwin(f3.getEdge1());
                f5.getEdge1().setTwin(f2.getEdge1());
                f1.getEdge1().setTwin(f4.getEdge1());
                f0.getEdge1().setTwin(f3.getEdge1());
                f5.getEdge1().setTwin(f2.getEdge1());
                f1.getEdge1().setTwin(f4.getEdge1());
                epaPolytope.add(f0);
                epaPolytope.add(f1);
                epaPolytope.add(f2);
                epaPolytope.add(f3);
                epaPolytope.add(f4);
                epaPolytope.add(f5);
            }
        } else if (gjkVertices.length == 1) {
            return null;
        }
        return epaPolytope;
    }

    public static void silhouette(EPAHalfEdge3D edge, Point3DReadOnly observer, List<EPAHalfEdge3D> silhouetteToPack) {
        if (edge == null || edge.getFace().isObsolete()) {
            return;
        }
        if (!edge.getFace().canObserverSeeFace(observer)) {
            silhouetteToPack.add(edge);
        } else {
            edge.getFace().markObsolete();
            EPATools.silhouette(edge.getNext().getTwin(), observer, silhouetteToPack);
            EPATools.silhouette(edge.getPrevious().getTwin(), observer, silhouetteToPack);
        }
    }

    public static enum BarycentricCoordinatesOutput {
        INSIDE,
        OUTSIDE,
        AFFINELY_DEPENDENT;

    }
}

