/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class Sphere3D
implements Sphere3DBasics,
Settable<Sphere3D> {
    private final Point3D position = new Point3D();
    private double radius;

    public Sphere3D() {
        this(1.0);
    }

    public Sphere3D(double radius) {
        this.setRadius(radius);
    }

    public Sphere3D(Point3DReadOnly center, double radius) {
        this.set(center, radius);
    }

    public Sphere3D(double centerX, double centerY, double centerZ, double radius) {
        this.set(centerX, centerY, centerZ, radius);
    }

    public Sphere3D(Sphere3DReadOnly other) {
        this.set(other);
    }

    public Point3D getPosition() {
        return this.position;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(double radius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("The radius of a Sphere 3D cannot be negative.");
        }
        this.radius = radius;
    }

    public void set(Sphere3D other) {
        Sphere3DBasics.super.set(other);
    }

    @Override
    public Sphere3D copy() {
        return new Sphere3D(this);
    }

    public boolean equals(Object object) {
        if (object instanceof Sphere3DReadOnly) {
            return this.equals((EuclidGeometry)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = EuclidHashCodeTools.addToHashCode((long)this.position.hashCode(), (double)this.radius);
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

