/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.tools;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.tools.IcoSphereFactory;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Point3D;

public class EuclidPolytopeFactories {
    private EuclidPolytopeFactories() {
    }

    public static List<Point3D> newConeVertices(double height, double radius, int numberOfDivisions) {
        ArrayList<Point3D> vertices = new ArrayList<Point3D>();
        vertices.add(new Point3D(0.0, 0.0, height));
        for (int i = 0; i < numberOfDivisions; ++i) {
            double theta = (double)i * 2.0 * Math.PI / (double)numberOfDivisions;
            double x = radius * EuclidCoreTools.cos((double)theta);
            double y = radius * EuclidCoreTools.sin((double)theta);
            vertices.add(new Point3D(x, y, 0.0));
        }
        return vertices;
    }

    public static List<Point3D> newCubeVertices(double edgeLength) {
        ArrayList<Point3D> vertices = new ArrayList<Point3D>();
        double halfL = 0.5 * edgeLength;
        vertices.add(new Point3D(-halfL, -halfL, -halfL));
        vertices.add(new Point3D(halfL, -halfL, -halfL));
        vertices.add(new Point3D(-halfL, halfL, -halfL));
        vertices.add(new Point3D(halfL, halfL, -halfL));
        vertices.add(new Point3D(-halfL, -halfL, halfL));
        vertices.add(new Point3D(halfL, -halfL, halfL));
        vertices.add(new Point3D(-halfL, halfL, halfL));
        vertices.add(new Point3D(halfL, halfL, halfL));
        return vertices;
    }

    public static List<Point3D> newCylinderVertices(double length, double radius, int numberOfDivisions) {
        ArrayList<Point3D> vertices = new ArrayList<Point3D>();
        double halfL = 0.5 * length;
        for (int i = 0; i < numberOfDivisions; ++i) {
            double theta = (double)i * 2.0 * Math.PI / (double)numberOfDivisions;
            double x = radius * EuclidCoreTools.cos((double)theta);
            double y = radius * EuclidCoreTools.sin((double)theta);
            Point3D top = new Point3D(x, y, halfL);
            Point3D bottom = new Point3D(x, y, -halfL);
            vertices.add(top);
            vertices.add(bottom);
        }
        return vertices;
    }

    public static List<Point3D> newIcosahedronVertices(double radius) {
        return EuclidPolytopeFactories.newIcoSphereVertices(radius, 0);
    }

    public static List<Point3D> newIcoSphereVertices(double radius, int recursionLevel) {
        List<Point3D> vertices = IcoSphereFactory.newIcoSphere(recursionLevel).getVertices();
        if (radius != 1.0) {
            vertices.forEach(vertex -> vertex.scale(radius));
        }
        return vertices;
    }

    public static List<Point3D> newPyramidVertices(double height, double baseLength, double baseWidth) {
        ArrayList<Point3D> vertices = new ArrayList<Point3D>();
        double halfL = 0.5 * baseLength;
        double halfW = 0.5 * baseWidth;
        vertices.add(new Point3D(0.0, 0.0, height));
        vertices.add(new Point3D(halfL, halfW, 0.0));
        vertices.add(new Point3D(halfL, -halfW, 0.0));
        vertices.add(new Point3D(-halfL, halfW, 0.0));
        vertices.add(new Point3D(-halfL, -halfW, 0.0));
        return vertices;
    }

    public static ConvexPolytope3D newCone(double height, double radius, int numberOfDivisions) {
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier(EuclidPolytopeFactories.newConeVertices(height, radius, numberOfDivisions)));
    }

    public static ConvexPolytope3D newCube(double edgeLength) {
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier(EuclidPolytopeFactories.newCubeVertices(edgeLength)));
    }

    public static ConvexPolytope3D newCylinder(double length, double radius, int numberOfDivisions) {
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier(EuclidPolytopeFactories.newCylinderVertices(length, radius, numberOfDivisions)));
    }

    public static ConvexPolytope3D newIcosahedron(double radius) {
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier(EuclidPolytopeFactories.newIcosahedronVertices(radius)));
    }

    public static ConvexPolytope3D newIcoSphere(double radius, int recursionLevel) {
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier(EuclidPolytopeFactories.newIcoSphereVertices(radius, recursionLevel)));
    }

    public static ConvexPolytope3D newPyramid(double height, double baseLength, double baseWidth) {
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier(EuclidPolytopeFactories.newPyramidVertices(height, baseLength, baseWidth)));
    }
}

