/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision.gjk;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class GJKVertex3D
implements Point3DReadOnly {
    private final double x;
    private final double y;
    private final double z;
    private final Point3DReadOnly vertexOnShapeA;
    private final Point3DReadOnly vertexOnShapeB;

    public GJKVertex3D(Point3DReadOnly vertexOnShapeA, Point3DReadOnly vertexOnShapeB) {
        this.vertexOnShapeA = vertexOnShapeA;
        this.vertexOnShapeB = vertexOnShapeB;
        this.x = vertexOnShapeA.getX() - vertexOnShapeB.getX();
        this.y = vertexOnShapeA.getY() - vertexOnShapeB.getY();
        this.z = vertexOnShapeA.getZ() - vertexOnShapeB.getZ();
    }

    public Point3DReadOnly getVertexOnShapeA() {
        return this.vertexOnShapeA;
    }

    public Point3DReadOnly getVertexOnShapeB() {
        return this.vertexOnShapeB;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public boolean equals(Object object) {
        if (object instanceof GJKVertex3D) {
            return this.equals((EuclidGeometry)((Tuple3DReadOnly)object));
        }
        return false;
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.x);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.y);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.z);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public String toString() {
        return "GJK Vertex 3D: " + this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

