/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseBasics;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Capsule3DBasics
extends Capsule3DReadOnly,
Shape3DBasics {
    public void setLength(double var1);

    public void setRadius(double var1);

    public Point3DBasics getPosition();

    public UnitVector3DBasics getAxis();

    default public void setSize(double length, double radius) {
        this.setLength(length);
        this.setRadius(radius);
    }

    @Deprecated
    default public void setAxis(Vector3DReadOnly axis) {
        this.getAxis().set((Tuple3DReadOnly)axis);
    }

    @Override
    default public boolean containsNaN() {
        return Capsule3DReadOnly.super.containsNaN();
    }

    default public void setToNaN() {
        this.getPosition().setToNaN();
        this.getAxis().setToNaN();
        this.setSize(Double.NaN, Double.NaN);
    }

    default public void setToZero() {
        this.getPosition().setToZero();
        this.getAxis().set((UnitVector3DReadOnly)Axis3D.Z);
        this.setSize(0.0, 0.0);
    }

    default public void set(Capsule3DReadOnly other) {
        this.getPosition().set((Tuple3DReadOnly)other.getPosition());
        this.getAxis().set(other.getAxis());
        this.setSize(other.getLength(), other.getRadius());
    }

    default public void set(Point3DReadOnly position, Vector3DReadOnly axis, double length, double radius) {
        this.getPosition().set((Tuple3DReadOnly)position);
        this.getAxis().set((Tuple3DReadOnly)axis);
        this.setSize(length, radius);
    }

    @Override
    default public Shape3DPoseBasics getPose() {
        return null;
    }

    default public void applyInverseTransform(Transform transform) {
        transform.inverseTransform(this.getPosition());
        transform.inverseTransform((Vector3DBasics)this.getAxis());
    }

    default public void applyTransform(Transform transform) {
        transform.transform(this.getPosition());
        transform.transform((Vector3DBasics)this.getAxis());
    }
}

