/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DBasics;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Torus3DReadOnly
extends Shape3DReadOnly {
    public double getRadius();

    public double getTubeRadius();

    public Point3DReadOnly getPosition();

    public UnitVector3DReadOnly getAxis();

    @Override
    default public Point3DReadOnly getCentroid() {
        return this.getPosition();
    }

    @Override
    default public double getVolume() {
        return EuclidShapeTools.torusVolume(this.getRadius(), this.getTubeRadius());
    }

    @Override
    default public boolean containsNaN() {
        return this.getPosition().containsNaN() || this.getAxis().containsNaN() || Double.isNaN(this.getRadius()) || Double.isNaN(this.getTubeRadius());
    }

    @Override
    default public boolean evaluatePoint3DCollision(Point3DReadOnly pointToCheck, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalAtClosestPointToPack) {
        return EuclidShapeTools.evaluatePoint3DTorus3DCollision(pointToCheck, this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getRadius(), this.getTubeRadius(), closestPointOnSurfaceToPack, normalAtClosestPointToPack) <= 0.0;
    }

    @Override
    default public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        throw new UnsupportedOperationException("Torus3D being a concave shape cannot implement the supporting vertex feature.");
    }

    @Override
    default public double signedDistance(Point3DReadOnly point) {
        return EuclidShapeTools.signedDistanceBetweenPoint3DAndTorus3D(point, this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getRadius(), this.getTubeRadius());
    }

    @Override
    default public boolean isPointInside(Point3DReadOnly query, double epsilon) {
        return EuclidShapeTools.isPoint3DInsideTorus3D(query, this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getRadius(), this.getTubeRadius(), epsilon);
    }

    @Override
    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        return EuclidShapeTools.orthogonalProjectionOntoTorus3D(pointToProject, this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getRadius(), this.getTubeRadius(), projectionToPack);
    }

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        EuclidShapeTools.boundingBoxCylinder3D(this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getTubeRadius(), this.getRadius() + this.getTubeRadius(), boundingBoxToPack);
    }

    @Override
    default public boolean isConvex() {
        return false;
    }

    @Override
    default public boolean isPrimitive() {
        return true;
    }

    @Override
    default public boolean isDefinedByPose() {
        return false;
    }

    @Override
    default public Shape3DPoseReadOnly getPose() {
        return null;
    }

    @Override
    public Torus3DBasics copy();

    default public boolean epsilonEquals(Torus3DReadOnly other, double epsilon) {
        return EuclidCoreTools.epsilonEquals((double)this.getRadius(), (double)other.getRadius(), (double)epsilon) && EuclidCoreTools.epsilonEquals((double)this.getTubeRadius(), (double)other.getTubeRadius(), (double)epsilon) && this.getPosition().epsilonEquals((Tuple3DReadOnly)other.getPosition(), epsilon) && this.getAxis().epsilonEquals((Tuple3DReadOnly)other.getAxis(), epsilon);
    }

    default public boolean geometricallyEquals(Torus3DReadOnly other, double epsilon) {
        if (!EuclidCoreTools.epsilonEquals((double)this.getRadius(), (double)other.getRadius(), (double)epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals((double)this.getTubeRadius(), (double)other.getTubeRadius(), (double)epsilon)) {
            return false;
        }
        if (!this.getPosition().geometricallyEquals(this.getPosition(), epsilon)) {
            return false;
        }
        return EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)this.getAxis(), (Vector3DReadOnly)other.getAxis(), (double)epsilon);
    }

    default public boolean equals(Torus3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getRadius() != other.getRadius()) {
            return false;
        }
        if (this.getTubeRadius() != other.getTubeRadius()) {
            return false;
        }
        if (!this.getPosition().equals((Tuple3DReadOnly)other.getPosition())) {
            return false;
        }
        return this.getAxis().equals((Tuple3DReadOnly)other.getAxis());
    }
}

