/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.RampPolytope3DView;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Ramp3DReadOnly
extends Shape3DReadOnly {
    public Vector3DReadOnly getSize();

    @Override
    public Shape3DPoseReadOnly getPose();

    default public RotationMatrixReadOnly getOrientation() {
        return this.getPose().getShapeOrientation();
    }

    default public Point3DReadOnly getPosition() {
        return this.getPose().getShapePosition();
    }

    @Override
    default public double getVolume() {
        return EuclidShapeTools.rampVolume(this.getSizeX(), this.getSizeY(), this.getSizeZ());
    }

    default public void checkSizePositive(Axis3D axis) {
        if (this.getSize().getElement(axis) < 0.0) {
            throw new IllegalArgumentException("The " + axis + "-size of a " + this.getClass().getSimpleName() + " cannot be negative: " + this.getSize().getElement(axis));
        }
    }

    public IntermediateVariableSupplier getIntermediateVariableSupplier();

    @Override
    default public boolean containsNaN() {
        return this.getPose().containsNaN() || this.getSize().containsNaN();
    }

    @Override
    default public boolean evaluatePoint3DCollision(Point3DReadOnly pointToCheck, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalAtClosestPointToPack) {
        Point3DBasics pointToCheckInLocal = this.getIntermediateVariableSupplier().requestPoint3D();
        this.getPose().inverseTransform(pointToCheck, pointToCheckInLocal);
        double distance = EuclidShapeTools.evaluatePoint3DRamp3DCollision((Point3DReadOnly)pointToCheckInLocal, this.getSize(), closestPointOnSurfaceToPack, normalAtClosestPointToPack);
        this.transformToWorld((Transformable)closestPointOnSurfaceToPack);
        this.transformToWorld((Transformable)normalAtClosestPointToPack);
        this.getIntermediateVariableSupplier().releasePoint3D(pointToCheckInLocal);
        return distance <= 0.0;
    }

    @Override
    default public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        if (this.getOrientation().isIdentity()) {
            EuclidShapeTools.supportingVectexRamp3D(supportDirection, this.getSize(), supportingVertexToPack);
            supportingVertexToPack.add((Tuple3DReadOnly)this.getPosition());
        } else {
            Vector3DBasics supportDirectionInLocal = this.getIntermediateVariableSupplier().requestVector3D();
            this.getPose().inverseTransform(supportDirection, supportDirectionInLocal);
            EuclidShapeTools.supportingVectexRamp3D((Vector3DReadOnly)supportDirectionInLocal, this.getSize(), supportingVertexToPack);
            this.transformToWorld((Transformable)supportingVertexToPack);
            this.getIntermediateVariableSupplier().releaseVector3D(supportDirectionInLocal);
        }
        return true;
    }

    @Override
    default public double signedDistance(Point3DReadOnly point) {
        Point3DBasics pointInLocal = this.getIntermediateVariableSupplier().requestPoint3D();
        this.getPose().inverseTransform(point, pointInLocal);
        double signedDistance = EuclidShapeTools.signedDistanceBetweenPoint3DAndRamp3D((Point3DReadOnly)pointInLocal, this.getSize());
        this.getIntermediateVariableSupplier().releasePoint3D(pointInLocal);
        return signedDistance;
    }

    @Override
    default public boolean isPointInside(Point3DReadOnly query, double epsilon) {
        Point3DBasics queryInLocal = this.getIntermediateVariableSupplier().requestPoint3D();
        this.getPose().inverseTransform(query, queryInLocal);
        boolean isInside = EuclidShapeTools.isPoint3DInsideRamp3D((Point3DReadOnly)queryInLocal, this.getSize(), epsilon);
        this.getIntermediateVariableSupplier().releasePoint3D(queryInLocal);
        return isInside;
    }

    @Override
    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        Point3DBasics pointToProjectInLocal = this.getIntermediateVariableSupplier().requestPoint3D();
        this.getPose().inverseTransform(pointToProject, pointToProjectInLocal);
        boolean hasBeenProjected = EuclidShapeTools.orthogonalProjectionOntoRamp3D((Point3DReadOnly)pointToProjectInLocal, this.getSize(), projectionToPack);
        if (hasBeenProjected) {
            this.transformToWorld((Transformable)projectionToPack);
        }
        this.getIntermediateVariableSupplier().releasePoint3D(pointToProjectInLocal);
        return hasBeenProjected;
    }

    default public double getSizeX() {
        return this.getSize().getX();
    }

    default public double getSizeY() {
        return this.getSize().getY();
    }

    default public double getSizeZ() {
        return this.getSize().getZ();
    }

    default public double getRampLength() {
        return EuclidShapeTools.computeRamp3DLength(this.getSize());
    }

    default public double getRampIncline() {
        return EuclidShapeTools.computeRamp3DIncline(this.getSize());
    }

    default public Vector3DReadOnly getRampSurfaceNormal() {
        Vector3D surfaceNormal = new Vector3D();
        this.getRampSurfaceNormal((Vector3DBasics)surfaceNormal);
        return surfaceNormal;
    }

    default public void getRampSurfaceNormal(Vector3DBasics surfaceNormalToPack) {
        surfaceNormalToPack.set(-this.getSizeZ() / this.getRampLength(), 0.0, this.getSizeX() / this.getRampLength());
        this.transformToWorld((Transformable)surfaceNormalToPack);
    }

    default public Point3DBasics[] getVertices() {
        Point3D[] vertices = new Point3D[6];
        for (int vertexIndex = 0; vertexIndex < 6; ++vertexIndex) {
            vertices[vertexIndex] = new Point3D();
            this.getVertex(vertexIndex, (Point3DBasics)vertices[vertexIndex]);
        }
        return vertices;
    }

    default public void getVertices(Point3DBasics[] verticesToPack) {
        if (verticesToPack.length < 6) {
            throw new IllegalArgumentException("Array is too small, has to be at least 6 element long, was: " + verticesToPack.length);
        }
        for (int vertexIndex = 0; vertexIndex < 6; ++vertexIndex) {
            this.getVertex(vertexIndex, verticesToPack[vertexIndex]);
        }
    }

    default public Point3DBasics getVertex(int vertexIndex) {
        Point3D vertex = new Point3D();
        this.getVertex(vertexIndex, (Point3DBasics)vertex);
        return vertex;
    }

    default public void getVertex(int vertexIndex, Point3DBasics vertexToPack) {
        if (vertexIndex < 0 || vertexIndex >= 6) {
            throw new IndexOutOfBoundsException("The vertex index has to be in [0, 5], was: " + vertexIndex);
        }
        vertexToPack.set((vertexIndex & 2) == 0 ? this.getSizeX() : 0.0, (vertexIndex & 1) == 0 ? 0.5 * this.getSizeY() : -0.5 * this.getSizeY(), (vertexIndex & 4) == 0 ? 0.0 : this.getSizeZ());
        this.transformToWorld((Transformable)vertexToPack);
    }

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        boundingBoxToPack.setToNaN();
        Point3DBasics vertex = this.getIntermediateVariableSupplier().requestPoint3D();
        for (int vertexIndex = 0; vertexIndex < 6; ++vertexIndex) {
            this.getVertex(vertexIndex, vertex);
            boundingBoxToPack.updateToIncludePoint((Point3DReadOnly)vertex);
        }
        this.getIntermediateVariableSupplier().releasePoint3D(vertex);
    }

    public RampPolytope3DView asConvexPolytope();

    @Override
    default public boolean isConvex() {
        return true;
    }

    @Override
    default public boolean isPrimitive() {
        return true;
    }

    @Override
    default public boolean isDefinedByPose() {
        return true;
    }

    @Override
    public Ramp3DBasics copy();

    default public boolean epsilonEquals(Ramp3DReadOnly other, double epsilon) {
        return this.getSize().epsilonEquals((Tuple3DReadOnly)other.getSize(), epsilon) && this.getPosition().epsilonEquals((Tuple3DReadOnly)other.getPosition(), epsilon) && this.getOrientation().epsilonEquals((Matrix3DReadOnly)other.getOrientation(), epsilon);
    }

    default public boolean geometricallyEquals(Ramp3DReadOnly other, double epsilon) {
        return this.getSize().epsilonEquals((Tuple3DReadOnly)other.getSize(), epsilon) && this.getPosition().geometricallyEquals(other.getPosition(), epsilon) && this.getOrientation().geometricallyEquals(other.getOrientation(), epsilon);
    }

    default public boolean equals(Ramp3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getPose().equals(other.getPose()) && this.getSize().equals((Tuple3DReadOnly)other.getSize());
    }

    default public void transformToLocal(Transformable transformable) {
        transformable.applyInverseTransform((Transform)this.getPose());
    }

    default public void transformToWorld(Transformable transformable) {
        transformable.applyTransform((Transform)this.getPose());
    }
}

