/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidEllipsoid3DTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Ellipsoid3DReadOnly
extends Shape3DReadOnly {
    public Vector3DReadOnly getRadii();

    @Override
    public Shape3DPoseReadOnly getPose();

    default public RotationMatrixReadOnly getOrientation() {
        return this.getPose().getShapeOrientation();
    }

    default public Point3DReadOnly getPosition() {
        return this.getPose().getShapePosition();
    }

    @Override
    default public Point3DReadOnly getCentroid() {
        return this.getPosition();
    }

    @Override
    default public double getVolume() {
        return EuclidShapeTools.ellipsoidVolume(this.getRadiusX(), this.getRadiusY(), this.getRadiusZ());
    }

    default public void checkRadiusPositive(Axis3D axis) {
        if (this.getRadii().getElement(axis) < 0.0) {
            throw new IllegalArgumentException("The " + axis + "-radius of a " + this.getClass().getSimpleName() + " cannot be negative: " + this.getRadii().getElement(axis));
        }
    }

    public IntermediateVariableSupplier getIntermediateVariableSupplier();

    @Override
    default public boolean containsNaN() {
        return this.getPose().containsNaN() || this.getRadii().containsNaN();
    }

    @Override
    default public boolean evaluatePoint3DCollision(Point3DReadOnly pointToCheck, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalAtClosestPointToPack) {
        Point3DBasics pointToCheckInLocal = this.getIntermediateVariableSupplier().requestPoint3D();
        this.getPose().inverseTransform(pointToCheck, pointToCheckInLocal);
        double distance = EuclidShapeTools.evaluatePoint3DEllipsoid3DCollision((Point3DReadOnly)pointToCheckInLocal, this.getRadii(), closestPointOnSurfaceToPack, normalAtClosestPointToPack);
        this.transformToWorld((Transformable)closestPointOnSurfaceToPack);
        this.transformToWorld((Transformable)normalAtClosestPointToPack);
        this.getIntermediateVariableSupplier().releasePoint3D(pointToCheckInLocal);
        return distance <= 0.0;
    }

    @Override
    default public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        if (this.getOrientation().isIdentity()) {
            EuclidShapeTools.supportingVertexEllipsoid3D(supportDirection, this.getRadii(), supportingVertexToPack);
            supportingVertexToPack.add((Tuple3DReadOnly)this.getPosition());
        } else {
            Vector3DBasics supportDirectionInLocal = this.getIntermediateVariableSupplier().requestVector3D();
            this.getPose().inverseTransform(supportDirection, supportDirectionInLocal);
            EuclidShapeTools.supportingVertexEllipsoid3D((Vector3DReadOnly)supportDirectionInLocal, this.getRadii(), supportingVertexToPack);
            this.transformToWorld((Transformable)supportingVertexToPack);
            this.getIntermediateVariableSupplier().releaseVector3D(supportDirectionInLocal);
        }
        return true;
    }

    @Override
    default public double signedDistance(Point3DReadOnly point) {
        Point3DBasics queryInLocal = this.getIntermediateVariableSupplier().requestPoint3D();
        this.getPose().inverseTransform(point, queryInLocal);
        double signedDistance = EuclidEllipsoid3DTools.distancePoint3DEllipsoid3D(this.getRadii(), (Point3DReadOnly)queryInLocal);
        this.getIntermediateVariableSupplier().releasePoint3D(queryInLocal);
        return signedDistance;
    }

    @Override
    default public boolean isPointInside(Point3DReadOnly query, double epsilon) {
        Point3DBasics queryInLocal = this.getIntermediateVariableSupplier().requestPoint3D();
        this.getPose().inverseTransform(query, queryInLocal);
        boolean isInside = EuclidShapeTools.isPoint3DInsideEllipsoid3D((Point3DReadOnly)queryInLocal, this.getRadii(), epsilon);
        this.getIntermediateVariableSupplier().releasePoint3D(queryInLocal);
        return isInside;
    }

    @Override
    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        Point3DBasics pointToProjectInLocal = this.getIntermediateVariableSupplier().requestPoint3D();
        this.getPose().inverseTransform(pointToProject, pointToProjectInLocal);
        boolean hasBeenProjected = EuclidShapeTools.orthogonalProjectionOntoEllipsoid3D((Point3DReadOnly)pointToProjectInLocal, this.getRadii(), projectionToPack);
        if (hasBeenProjected) {
            this.transformToWorld((Transformable)projectionToPack);
        }
        this.getIntermediateVariableSupplier().releasePoint3D(pointToProjectInLocal);
        return hasBeenProjected;
    }

    default public int intersectionWith(Line3DReadOnly line, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (Vector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        Point3DBasics pointOnLineInLocal = this.getIntermediateVariableSupplier().requestPoint3D();
        Vector3DBasics lineDirectionInLocal = this.getIntermediateVariableSupplier().requestVector3D();
        this.getPose().inverseTransform(pointOnLine, pointOnLineInLocal);
        this.getPose().inverseTransform(lineDirection, lineDirectionInLocal);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3D((double)this.getRadiusX(), (double)this.getRadiusY(), (double)this.getRadiusZ(), (Point3DReadOnly)pointOnLineInLocal, (Vector3DReadOnly)lineDirectionInLocal, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        this.getIntermediateVariableSupplier().releasePoint3D(pointOnLineInLocal);
        this.getIntermediateVariableSupplier().releaseVector3D(lineDirectionInLocal);
        if (firstIntersectionToPack != null && numberOfIntersections >= 1) {
            this.transformToWorld((Transformable)firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null && numberOfIntersections == 2) {
            this.transformToWorld((Transformable)secondIntersectionToPack);
        }
        return numberOfIntersections;
    }

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        EuclidShapeTools.boundingBoxEllipsoid3D(this.getPosition(), this.getOrientation(), this.getRadii(), boundingBoxToPack);
    }

    @Override
    default public boolean isConvex() {
        return true;
    }

    @Override
    default public boolean isPrimitive() {
        return true;
    }

    @Override
    default public boolean isDefinedByPose() {
        return true;
    }

    default public double getRadiusX() {
        return this.getRadii().getX();
    }

    default public double getRadiusY() {
        return this.getRadii().getY();
    }

    default public double getRadiusZ() {
        return this.getRadii().getZ();
    }

    @Override
    public Ellipsoid3DBasics copy();

    default public boolean epsilonEquals(Ellipsoid3DReadOnly other, double epsilon) {
        return this.getRadii().epsilonEquals((Tuple3DReadOnly)other.getRadii(), epsilon) && this.getPosition().epsilonEquals((Tuple3DReadOnly)other.getPosition(), epsilon) && this.getOrientation().epsilonEquals((Matrix3DReadOnly)other.getOrientation(), epsilon);
    }

    default public boolean geometricallyEquals(Ellipsoid3DReadOnly other, double epsilon) {
        if (!this.getPosition().geometricallyEquals(other.getPosition(), epsilon)) {
            return false;
        }
        double thisRadiusX = this.getRadiusX();
        double thisRadiusY = this.getRadiusY();
        double thisRadiusZ = this.getRadiusZ();
        boolean areThisRadiiXYEqual = EuclidCoreTools.epsilonEquals((double)thisRadiusX, (double)thisRadiusY, (double)epsilon);
        boolean areThisRadiiXZEqual = EuclidCoreTools.epsilonEquals((double)thisRadiusX, (double)thisRadiusZ, (double)epsilon);
        if (areThisRadiiXYEqual && areThisRadiiXZEqual) {
            if (!EuclidCoreTools.epsilonEquals((double)other.getRadiusX(), (double)other.getRadiusY(), (double)epsilon)) {
                return false;
            }
            if (!EuclidCoreTools.epsilonEquals((double)other.getRadiusX(), (double)other.getRadiusZ(), (double)epsilon)) {
                return false;
            }
            double thisRadiiSum = thisRadiusX + thisRadiusY + thisRadiusZ;
            double otherRadiiSum = other.getRadiusX() + other.getRadiusY() + other.getRadiusZ();
            return Math.abs(thisRadiiSum - otherRadiiSum) <= 3.0 * epsilon;
        }
        Vector3DBasics otherRadii = this.getIntermediateVariableSupplier().requestVector3D();
        other.getPose().transform(other.getRadii(), otherRadii);
        this.transformToLocal((Transformable)otherRadii);
        otherRadii.absolute();
        double otherRadiusX = otherRadii.getX();
        double otherRadiusY = otherRadii.getY();
        double otherRadiusZ = otherRadii.getZ();
        this.getIntermediateVariableSupplier().releaseVector3D(otherRadii);
        if (areThisRadiiXYEqual) {
            if (!EuclidCoreTools.epsilonEquals((double)thisRadiusZ, (double)otherRadiusZ, (double)epsilon)) {
                return false;
            }
            double thisRadiiXY = EuclidCoreTools.normSquared((double)thisRadiusX, (double)thisRadiusY);
            double otherRadiiXY = EuclidCoreTools.normSquared((double)otherRadiusX, (double)otherRadiusY);
            return EuclidCoreTools.epsilonEquals((double)thisRadiiXY, (double)otherRadiiXY, (double)epsilon);
        }
        if (areThisRadiiXZEqual) {
            if (!EuclidCoreTools.epsilonEquals((double)thisRadiusY, (double)otherRadiusY, (double)epsilon)) {
                return false;
            }
            double thisRadiiXZ = EuclidCoreTools.normSquared((double)thisRadiusX, (double)thisRadiusZ);
            double otherRadiiXZ = EuclidCoreTools.normSquared((double)otherRadiusX, (double)otherRadiusZ);
            return EuclidCoreTools.epsilonEquals((double)thisRadiiXZ, (double)otherRadiiXZ, (double)epsilon);
        }
        boolean areThisRadiiYZEqual = EuclidCoreTools.epsilonEquals((double)thisRadiusY, (double)thisRadiusZ, (double)epsilon);
        if (areThisRadiiYZEqual) {
            if (!EuclidCoreTools.epsilonEquals((double)thisRadiusX, (double)otherRadiusX, (double)epsilon)) {
                return false;
            }
            double thisRadiiYZ = EuclidCoreTools.normSquared((double)thisRadiusY, (double)thisRadiusZ);
            double otherRadiiYZ = EuclidCoreTools.normSquared((double)otherRadiusY, (double)otherRadiusZ);
            return EuclidCoreTools.epsilonEquals((double)thisRadiiYZ, (double)otherRadiiYZ, (double)epsilon);
        }
        double difference = EuclidGeometryTools.distanceSquaredBetweenPoint3Ds((double)thisRadiusX, (double)thisRadiusY, (double)thisRadiusZ, (double)otherRadiusX, (double)otherRadiusY, (double)otherRadiusZ);
        return difference <= epsilon * epsilon;
    }

    default public boolean equals(Ellipsoid3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getPose().equals(other.getPose()) && this.getRadii().equals((Tuple3DReadOnly)other.getRadii());
    }

    default public void transformToLocal(Transformable transformable) {
        transformable.applyInverseTransform((Transform)this.getPose());
    }

    default public void transformToWorld(Transformable transformable) {
        transformable.applyTransform((Transform)this.getPose());
    }
}

