/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Box3DBasics
extends Box3DReadOnly,
Shape3DBasics {
    public Vector3DBasics getSize();

    @Override
    public Shape3DPoseBasics getPose();

    default public RotationMatrixBasics getOrientation() {
        return this.getPose().getShapeOrientation();
    }

    default public Point3DBasics getPosition() {
        return this.getPose().getShapePosition();
    }

    public void setIntermediateVariableSupplier(IntermediateVariableSupplier var1);

    @Override
    default public boolean containsNaN() {
        return Box3DReadOnly.super.containsNaN();
    }

    default public void setToNaN() {
        this.getPose().setToNaN();
        this.getSize().setToNaN();
    }

    default public void setToZero() {
        this.getPose().setToZero();
        this.getSize().setToZero();
    }

    default public void set(Box3DReadOnly other) {
        this.getPose().set(other.getPose());
        this.getSize().set((Tuple3DReadOnly)other.getSize());
    }

    default public void set(Point3DReadOnly position, Orientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.getPose().set(orientation, (Tuple3DReadOnly)position);
        this.getSize().set(sizeX, sizeY, sizeZ);
    }

    default public void set(Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.getPose().set(orientation, (Tuple3DReadOnly)position);
        this.getSize().set((Tuple3DReadOnly)size);
    }

    default public void set(Pose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.getPose().set(pose);
        this.getSize().set(sizeX, sizeY, sizeZ);
    }

    default public void set(Pose3DReadOnly pose, Vector3DReadOnly size) {
        this.getPose().set(pose);
        this.getSize().set((Tuple3DReadOnly)size);
    }

    default public void set(RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.getPose().set(pose);
        this.getSize().set(sizeX, sizeY, sizeZ);
    }

    default public void set(RigidBodyTransformReadOnly pose, Vector3DReadOnly size) {
        this.getPose().set(pose);
        this.getSize().set((Tuple3DReadOnly)size);
    }

    default public void set(RigidBodyTransformReadOnly pose, double[] size) {
        this.getPose().set(pose);
        this.getSize().set(size[0], size[1], size[2]);
    }

    default public void scale(double scale) {
        if (scale < 0.0) {
            throw new IllegalArgumentException("Cannot apply a negative scale: " + scale);
        }
        this.getSize().scale(scale);
    }

    default public void applyInverseTransform(Transform transform) {
        transform.inverseTransform((RigidBodyTransformBasics)this.getPose());
    }

    default public void applyTransform(Transform transform) {
        transform.transform((RigidBodyTransformBasics)this.getPose());
    }
}

