/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.tools.EuclidGeometryFactories;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractFace3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractHalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractVertex3D;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.Shape3DPose;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.RampPolytope3DView;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

class RampPolytope3D
implements RampPolytope3DView {
    private final Ramp3D ramp3D;
    private final Face rampFace;
    private final Face xMaxFace;
    private final Face yMinFace;
    private final Face yMaxFace;
    private final Face zMinFace;
    private final List<Face> faces;
    private final List<HalfEdge> edges;
    private final List<Vertex> vertices;

    RampPolytope3D(Ramp3D ramp3D) {
        this.ramp3D = ramp3D;
        DoubleSupplier xMin = () -> 0.0;
        DoubleSupplier yMin = () -> -0.5 * ramp3D.getSizeY();
        DoubleSupplier zMin = () -> 0.0;
        DoubleSupplier xMax = () -> ramp3D.getSizeX();
        DoubleSupplier yMax = () -> 0.5 * ramp3D.getSizeY();
        DoubleSupplier zMax = () -> ramp3D.getSizeZ();
        Vertex v0 = new Vertex(xMin, yMax, zMin);
        Vertex v1 = new Vertex(xMax, yMax, zMax);
        Vertex v2 = new Vertex(xMax, yMin, zMax);
        Vertex v3 = new Vertex(xMin, yMin, zMin);
        Vertex v4 = new Vertex(xMax, yMax, zMin);
        Vertex v5 = new Vertex(xMax, yMin, zMin);
        HalfEdge rampE0 = new HalfEdge(v0, v1);
        HalfEdge rampE1 = new HalfEdge(v1, v2);
        HalfEdge rampE2 = new HalfEdge(v2, v3);
        HalfEdge rampE3 = new HalfEdge(v3, v0);
        HalfEdge yMinE0 = new HalfEdge(v3, v2);
        HalfEdge yMinE1 = new HalfEdge(v2, v5);
        HalfEdge yMinE2 = new HalfEdge(v5, v3);
        HalfEdge yMaxE0 = new HalfEdge(v0, v4);
        HalfEdge yMaxE1 = new HalfEdge(v4, v1);
        HalfEdge yMaxE2 = new HalfEdge(v1, v0);
        HalfEdge xMaxE0 = new HalfEdge(v1, v4);
        HalfEdge xMaxE1 = new HalfEdge(v4, v5);
        HalfEdge xMaxE2 = new HalfEdge(v5, v2);
        HalfEdge xMaxE3 = new HalfEdge(v2, v1);
        HalfEdge zMinE0 = new HalfEdge(v0, v3);
        HalfEdge zMinE1 = new HalfEdge(v3, v5);
        HalfEdge zMinE2 = new HalfEdge(v5, v4);
        HalfEdge zMinE3 = new HalfEdge(v4, v0);
        DoubleSupplier slopeFaceAreaSupplier = () -> ramp3D.getSizeY() * ramp3D.getRampLength();
        DoubleSupplier xFaceAreaSupplier = () -> ramp3D.getSizeY() * ramp3D.getSizeZ();
        DoubleSupplier yFaceAreaSupplier = () -> 0.5 * ramp3D.getSizeX() * ramp3D.getSizeZ();
        DoubleSupplier zFaceAreaSupplier = () -> ramp3D.getSizeX() * ramp3D.getSizeY();
        Shape3DPose pose = ramp3D.getPose();
        this.rampFace = new Face("ramp", ramp3D.getRampSurfaceNormal(), slopeFaceAreaSupplier, new HalfEdge[]{rampE0, rampE1, rampE2, rampE3});
        this.yMinFace = new Face("y-min", EuclidCoreFactories.newNegativeLinkedVector3D((Vector3DReadOnly)pose.getYAxis()), yFaceAreaSupplier, new HalfEdge[]{yMinE0, yMinE1, yMinE2});
        this.zMinFace = new Face("z-min", EuclidCoreFactories.newNegativeLinkedVector3D((Vector3DReadOnly)pose.getZAxis()), zFaceAreaSupplier, new HalfEdge[]{zMinE0, zMinE1, zMinE2, zMinE3});
        this.xMaxFace = new Face("x-max", pose.getXAxis(), xFaceAreaSupplier, new HalfEdge[]{xMaxE0, xMaxE1, xMaxE2, xMaxE3});
        this.yMaxFace = new Face("y-max", pose.getYAxis(), yFaceAreaSupplier, new HalfEdge[]{yMaxE0, yMaxE1, yMaxE2});
        this.faces = Collections.unmodifiableList(Arrays.asList(this.rampFace, this.yMinFace, this.zMinFace, this.xMaxFace, this.yMaxFace));
        this.edges = Collections.unmodifiableList(this.faces.stream().flatMap(f -> f.getEdges().stream()).collect(Collectors.toList()));
        this.vertices = Collections.unmodifiableList(Arrays.asList(v0, v1, v2, v3, v4, v5));
        ramp3D.addChangeListeners(this.vertices);
        ramp3D.addChangeListeners(this.faces);
    }

    @Override
    public Face getRampFace() {
        return this.rampFace;
    }

    @Override
    public Face getYMinFace() {
        return this.yMinFace;
    }

    @Override
    public Face getZMinFace() {
        return this.zMinFace;
    }

    @Override
    public Face getXMaxFace() {
        return this.xMaxFace;
    }

    @Override
    public Face getYMaxFace() {
        return this.yMaxFace;
    }

    @Override
    public Ramp3DReadOnly getOwner() {
        return this.ramp3D;
    }

    public List<Face> getFaces() {
        return this.faces;
    }

    public List<HalfEdge> getHalfEdges() {
        return this.edges;
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    private class Vertex
    extends AbstractVertex3D<Vertex, HalfEdge, Face>
    implements Shape3DChangeListener {
        private final Point3DReadOnly positionLocal;
        private boolean dirty = true;

        private Vertex(DoubleSupplier xLocal, DoubleSupplier yLocal, DoubleSupplier zLocal) {
            this.positionLocal = EuclidCoreFactories.newLinkedPoint3DReadOnly((DoubleSupplier)xLocal, (DoubleSupplier)yLocal, (DoubleSupplier)zLocal);
        }

        @Override
        public void changed() {
            this.dirty = true;
        }

        private void update() {
            if (this.dirty) {
                this.dirty = false;
                RampPolytope3D.this.ramp3D.getPose().transform(this.positionLocal, this);
            }
        }

        @Override
        public double getX() {
            this.update();
            return super.getX();
        }

        @Override
        public double getY() {
            this.update();
            return super.getY();
        }

        @Override
        public double getZ() {
            this.update();
            return super.getZ();
        }
    }

    private class HalfEdge
    extends AbstractHalfEdge3D<Vertex, HalfEdge, Face> {
        private HalfEdge(Vertex origin, Vertex destination) {
            super(origin, destination);
        }

        void findAndSetTwin() {
            HalfEdge edgeTo = (HalfEdge)((Vertex)this.getDestination()).getEdgeTo(this.getOrigin());
            if (edgeTo != null) {
                this.setTwin(edgeTo);
                ((HalfEdge)this.getTwin()).setTwin(this);
            }
        }
    }

    private class Face
    extends AbstractFace3D<Vertex, HalfEdge, Face>
    implements Shape3DChangeListener {
        private final String name;
        private final BoundingBox3DBasics boundingBox;
        private final Point3DBasics centroid;
        private final Vector3DReadOnly normalLocal;
        private final Vector3DBasics normal;
        private final DoubleSupplier areaSupplier;
        private boolean isBoundingBoxDirty;
        private boolean isCentroidDirty;
        private boolean isNormalDirty;

        private Face(String name, Vector3DReadOnly normalLocal, DoubleSupplier areaSupplier, HalfEdge ... edges) {
            super(null, 0.0);
            this.boundingBox = EuclidGeometryFactories.newObservableBoundingBox3DBasics(null, (axis, bound) -> this.updateBoundingBox());
            this.centroid = EuclidCoreFactories.newObservablePoint3DBasics(null, axis -> this.updateCentroidAndArea());
            this.normal = EuclidCoreFactories.newObservableVector3DBasics(null, axis -> this.updateNormal());
            this.isBoundingBoxDirty = true;
            this.isCentroidDirty = true;
            this.isNormalDirty = true;
            this.name = name;
            this.normalLocal = normalLocal;
            this.areaSupplier = areaSupplier;
            this.initialize(Arrays.asList(edges), normalLocal);
            for (HalfEdge edge : edges) {
                edge.findAndSetTwin();
            }
        }

        @Override
        public void changed() {
            this.isBoundingBoxDirty = true;
            this.isCentroidDirty = true;
            this.isNormalDirty = true;
        }

        @Override
        public void updateBoundingBox() {
            if (this.isBoundingBoxDirty) {
                this.isBoundingBoxDirty = false;
                super.updateBoundingBox();
            }
        }

        @Override
        public void updateCentroidAndArea() {
            if (this.isCentroidDirty) {
                this.isCentroidDirty = false;
                this.centroid.setToZero();
                for (int i = 0; i < this.getNumberOfEdges(); ++i) {
                    this.centroid.add((Tuple3DReadOnly)this.getVertex(i));
                }
                this.centroid.scale(1.0 / (double)this.getNumberOfEdges());
            }
        }

        @Override
        public void updateNormal() {
            if (this.isNormalDirty) {
                this.isNormalDirty = false;
                this.normal.set((Tuple3DReadOnly)this.normalLocal);
            }
        }

        @Override
        public Point3DBasics getCentroid() {
            return this.centroid;
        }

        @Override
        public Vector3DBasics getNormal() {
            return this.normal;
        }

        @Override
        public double getArea() {
            return this.areaSupplier.getAsDouble();
        }

        @Override
        public BoundingBox3DBasics getBoundingBox() {
            return this.boundingBox;
        }

        @Override
        public String toString() {
            return "Ramp3D Face " + this.name + " " + super.toString();
        }
    }
}

