/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.interfaces;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface ConvexPolytope3DReadOnly
extends Shape3DReadOnly {
    default public int getNumberOfVertices() {
        return this.getVertices().size();
    }

    default public int getNumberOfEdges() {
        if (this.getNumberOfFaces() < 2) {
            return this.getNumberOfHalfEdges();
        }
        return this.getNumberOfHalfEdges() / 2;
    }

    default public int getNumberOfHalfEdges() {
        return this.getHalfEdges().size();
    }

    default public int getNumberOfFaces() {
        return this.getFaces().size();
    }

    public List<? extends Face3DReadOnly> getFaces();

    default public Face3DReadOnly getFace(int index) {
        return this.getFaces().get(index);
    }

    public List<? extends HalfEdge3DReadOnly> getHalfEdges();

    default public HalfEdge3DReadOnly getHalfEdge(int index) {
        return this.getHalfEdges().get(index);
    }

    public List<? extends Vertex3DReadOnly> getVertices();

    default public Vertex3DReadOnly getVertex(int index) {
        return this.getVertices().get(index);
    }

    @Override
    public BoundingBox3DReadOnly getBoundingBox();

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        boundingBoxToPack.set(this.getBoundingBox());
    }

    public double getConstructionEpsilon();

    @Override
    default public boolean containsNaN() {
        for (int vertexIndex = 0; vertexIndex < this.getNumberOfVertices(); ++vertexIndex) {
            if (!this.getVertex(vertexIndex).containsNaN()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean isPointInside(Point3DReadOnly pointToCheck) {
        if (this.isEmpty()) {
            return false;
        }
        if (!this.getBoundingBox().isInsideInclusive(pointToCheck)) {
            return false;
        }
        if (this.getNumberOfFaces() <= 2) {
            return this.getFace(0).isPointInside(pointToCheck, 0.0);
        }
        for (int faceIndex = 0; faceIndex < this.getNumberOfFaces(); ++faceIndex) {
            Face3DReadOnly face = this.getFace(faceIndex);
            if (!face.canObserverSeeFace(pointToCheck)) continue;
            return false;
        }
        return true;
    }

    @Override
    default public boolean isPointInside(Point3DReadOnly pointToCheck, double epsilon) {
        if (this.isEmpty()) {
            return false;
        }
        if (!this.getBoundingBox().isInsideEpsilon(pointToCheck, epsilon)) {
            return false;
        }
        if (this.getNumberOfFaces() <= 2) {
            return this.getFace(0).isPointInside(pointToCheck, epsilon);
        }
        for (int faceIndex = 0; faceIndex < this.getNumberOfFaces(); ++faceIndex) {
            if (!this.getFace(faceIndex).canObserverSeeFace(pointToCheck, epsilon)) continue;
            return false;
        }
        return true;
    }

    @Override
    default public double signedDistance(Point3DReadOnly point) {
        int faceIndex;
        if (this.getNumberOfFaces() == 0) {
            return Double.NaN;
        }
        if (this.getNumberOfFaces() == 1) {
            return this.getFace(0).distance(point);
        }
        boolean isOutside = false;
        double maxNegativeDistance = Double.NEGATIVE_INFINITY;
        for (faceIndex = 0; faceIndex < this.getNumberOfFaces(); ++faceIndex) {
            Face3DReadOnly face = this.getFace(faceIndex);
            double signedDistanceToPlane = face.signedDistanceFromSupportPlane(point);
            if (!(signedDistanceToPlane < 0.0)) {
                isOutside = true;
                break;
            }
            maxNegativeDistance = Math.max(maxNegativeDistance, signedDistanceToPlane);
        }
        if (!isOutside) {
            return maxNegativeDistance;
        }
        double closestFaceDistance = this.getFace(faceIndex).distance(point);
        ++faceIndex;
        while (faceIndex < this.getNumberOfFaces()) {
            Face3DReadOnly face = this.getFace(faceIndex);
            if (face.canObserverSeeFace(point)) {
                double candidateDistance = face.distance(point);
                closestFaceDistance = Math.min(closestFaceDistance, candidateDistance);
            }
            ++faceIndex;
        }
        return closestFaceDistance;
    }

    @Override
    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        if (this.isEmpty() || this.isPointInside(pointToProject)) {
            return false;
        }
        return this.getClosestFace(pointToProject).orthogonalProjection(pointToProject, projectionToPack);
    }

    @Override
    default public boolean evaluatePoint3DCollision(Point3DReadOnly pointToCheck, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalAtClosestPointToPack) {
        if (this.isEmpty()) {
            return false;
        }
        if (this.getNumberOfFaces() == 1) {
            Face3DReadOnly face = this.getFace(0);
            if (face.getNumberOfEdges() == 1) {
                closestPointOnSurfaceToPack.set((Tuple3DReadOnly)face.getVertex(0));
                normalAtClosestPointToPack.sub((Tuple3DReadOnly)pointToCheck, (Tuple3DReadOnly)closestPointOnSurfaceToPack);
                normalAtClosestPointToPack.normalize();
                return false;
            }
            if (face.getNumberOfEdges() == 2) {
                face.getEdge(0).orthogonalProjection(pointToCheck, closestPointOnSurfaceToPack);
                normalAtClosestPointToPack.sub((Tuple3DReadOnly)pointToCheck, (Tuple3DReadOnly)closestPointOnSurfaceToPack);
                normalAtClosestPointToPack.normalize();
                return false;
            }
            face.orthogonalProjection(pointToCheck, closestPointOnSurfaceToPack);
            if (face.isPointDirectlyAboveOrBelow(pointToCheck)) {
                normalAtClosestPointToPack.set((Tuple3DReadOnly)face.getNormal());
            } else {
                normalAtClosestPointToPack.sub((Tuple3DReadOnly)pointToCheck, (Tuple3DReadOnly)closestPointOnSurfaceToPack);
                normalAtClosestPointToPack.normalize();
            }
            return false;
        }
        Face3DReadOnly closestFace = this.getClosestFace(pointToCheck);
        closestFace.orthogonalProjection(pointToCheck, closestPointOnSurfaceToPack);
        if (closestFace.isPointDirectlyAboveOrBelow(pointToCheck)) {
            normalAtClosestPointToPack.set((Tuple3DReadOnly)closestFace.getNormal());
        } else {
            normalAtClosestPointToPack.sub((Tuple3DReadOnly)pointToCheck, (Tuple3DReadOnly)closestPointOnSurfaceToPack);
            normalAtClosestPointToPack.normalize();
        }
        return !EuclidGeometryTools.isPoint3DAbovePlane3D((Point3DReadOnly)pointToCheck, (Point3DReadOnly)closestFace.getCentroid(), (Vector3DReadOnly)closestFace.getNormal());
    }

    default public Face3DReadOnly getClosestFace(Point3DReadOnly query) {
        int faceIndex;
        if (this.getNumberOfFaces() == 0) {
            return null;
        }
        if (this.getNumberOfFaces() == 1) {
            return this.getFace(0);
        }
        boolean isOutside = false;
        double maxNegativeDistance = Double.NEGATIVE_INFINITY;
        Face3DReadOnly closestFace = null;
        for (faceIndex = 0; faceIndex < this.getNumberOfFaces(); ++faceIndex) {
            Face3DReadOnly face = this.getFace(faceIndex);
            double signedDistanceToPlane = face.signedDistanceFromSupportPlane(query);
            if (signedDistanceToPlane < 0.0) {
                if (!(signedDistanceToPlane > maxNegativeDistance)) continue;
                closestFace = face;
                maxNegativeDistance = signedDistanceToPlane;
                continue;
            }
            isOutside = true;
            break;
        }
        if (isOutside) {
            closestFace = this.getFace(faceIndex);
            double closestFaceDistance = closestFace.distance(query);
            ++faceIndex;
            while (faceIndex < this.getNumberOfFaces()) {
                double candidateDistance;
                Face3DReadOnly face = this.getFace(faceIndex);
                if (face.canObserverSeeFace(query) && (candidateDistance = face.distance(query)) < closestFaceDistance) {
                    closestFace = face;
                    closestFaceDistance = candidateDistance;
                }
                ++faceIndex;
            }
        }
        return closestFace;
    }

    @Override
    default public Vertex3DReadOnly getSupportingVertex(Vector3DReadOnly supportDirection) {
        return this.getSupportingVertex(null, supportDirection);
    }

    default public Vertex3DReadOnly getSupportingVertex(Vertex3DReadOnly seed, Vector3DReadOnly supportDirection) {
        Vertex3DReadOnly bestVertex;
        if (this.isEmpty()) {
            return null;
        }
        if (this.getNumberOfFaces() == 1) {
            return this.getFace(0).getSupportingVertex(supportDirection);
        }
        Vertex3DReadOnly vertex3DReadOnly = bestVertex = seed != null ? seed : this.getFace(0).getEdge(0).getOrigin();
        if (this.getNumberOfVertices() == 1) {
            return bestVertex;
        }
        double maxDotProduct = bestVertex.dot(supportDirection);
        Vertex3DReadOnly vertexCandidate = bestVertex;
        while (true) {
            for (HalfEdge3DReadOnly halfEdge3DReadOnly : bestVertex.getAssociatedEdges()) {
                Vertex3DReadOnly candidate = halfEdge3DReadOnly.getDestination();
                double dotProduct = candidate.dot(supportDirection);
                if (!(dotProduct > maxDotProduct)) continue;
                vertexCandidate = candidate;
                maxDotProduct = dotProduct;
            }
            if (bestVertex == vertexCandidate) {
                return bestVertex;
            }
            bestVertex = vertexCandidate;
        }
    }

    @Override
    default public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        if (this.isEmpty()) {
            return false;
        }
        supportingVertexToPack.set((Tuple3DReadOnly)this.getSupportingVertex(supportDirection));
        return true;
    }

    default public boolean isEmpty() {
        return this.getNumberOfVertices() == 0;
    }

    @Override
    default public boolean isConvex() {
        return true;
    }

    @Override
    default public boolean isPrimitive() {
        return false;
    }

    @Override
    default public boolean isDefinedByPose() {
        return false;
    }

    @Override
    default public Shape3DPoseReadOnly getPose() {
        return null;
    }

    @Override
    public Shape3DBasics copy();

    default public boolean epsilonEquals(ConvexPolytope3DReadOnly other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (this.getNumberOfFaces() != other.getNumberOfFaces()) {
            return false;
        }
        for (int faceIndex = 0; faceIndex < this.getNumberOfFaces(); ++faceIndex) {
            if (this.getFace(faceIndex).epsilonEquals(other.getFace(faceIndex), epsilon)) continue;
            return false;
        }
        return true;
    }

    default public boolean geometricallyEquals(ConvexPolytope3DReadOnly other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (this.getNumberOfFaces() != other.getNumberOfFaces()) {
            return false;
        }
        ArrayDeque<? extends Face3DReadOnly> thisFacesStack = new ArrayDeque<Face3DReadOnly>(this.getFaces());
        block0: for (int otherFaceIndex = 0; otherFaceIndex < this.getNumberOfFaces(); ++otherFaceIndex) {
            Iterator<? extends Face3DReadOnly> iterator = thisFacesStack.iterator();
            while (iterator.hasNext()) {
                Face3DReadOnly thisFace = iterator.next();
                if (!thisFace.geometricallyEquals(other.getFace(otherFaceIndex), epsilon)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return thisFacesStack.isEmpty();
    }

    default public boolean equals(ConvexPolytope3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getNumberOfFaces() != other.getNumberOfFaces()) {
            return false;
        }
        for (int faceIndex = 0; faceIndex < this.getNumberOfFaces(); ++faceIndex) {
            if (this.getFace(faceIndex).equals(other.getFace(faceIndex))) continue;
            return false;
        }
        return true;
    }
}

