/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractHalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractVertex3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DFactory;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeConstructionTools;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeTools;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.tools.SymmetricEigenDecomposition3D;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public abstract class AbstractFace3D<Vertex extends AbstractVertex3D<Vertex, Edge, Face>, Edge extends AbstractHalfEdge3D<Vertex, Edge, Face>, Face extends AbstractFace3D<Vertex, Edge, Face>>
implements Face3DReadOnly,
Clearable,
Transformable {
    private final List<Edge> edges = new ArrayList<Edge>();
    private final List<Vertex> vertices = new ArrayList<Vertex>();
    private double area;
    private final double constructionEpsilon;
    private Matrix3D verticesCovariance;
    private SymmetricEigenDecomposition3D eigenDecomposition;
    private final HalfEdge3DFactory<Vertex, Edge> edgeFactory;

    public AbstractFace3D(HalfEdge3DFactory<Vertex, Edge> edgeFactory) {
        this(edgeFactory, 1.0E-10);
    }

    public AbstractFace3D(HalfEdge3DFactory<Vertex, Edge> edgeFactory, double constructionEpsilon) {
        this.constructionEpsilon = constructionEpsilon;
        this.edgeFactory = edgeFactory;
    }

    protected void initialize(Vector3DReadOnly initialGuessNormal) {
        this.getNormal().setAndNormalize((Tuple3DReadOnly)initialGuessNormal);
        this.getBoundingBox().setToNaN();
    }

    protected void initialize(Collection<Edge> faceEdges, Vector3DReadOnly normal) {
        this.getBoundingBox().setToNaN();
        this.set(faceEdges, normal);
    }

    public void set(Collection<Edge> faceEdges, Vector3DReadOnly normal) {
        this.edges.clear();
        this.edges.addAll(faceEdges);
        this.edges.forEach(edge -> edge.setFace(this));
        this.getNormal().set((Tuple3DReadOnly)normal);
        this.updateVertices();
        this.updateNormal();
        this.updateCentroidAndArea();
        this.updateBoundingBox();
        for (AbstractHalfEdge3D edge2 : faceEdges) {
            if (edge2.getPrevious() == null) {
                edge2.setPrevious(faceEdges.stream().filter(e -> e.getDestination() == edge2.getOrigin()).findFirst().get());
            }
            if (edge2.getNext() != null) continue;
            edge2.setNext(faceEdges.stream().filter(e -> e.getOrigin() == edge2.getDestination()).findFirst().get());
        }
    }

    public boolean addVertex(Vertex vertexToAdd) {
        return this.addVertex(vertexToAdd, null, false);
    }

    public boolean addVertex(Vertex vertexToAdd, Vertex faceVertexToLock, boolean lockEdgesWithTwin) {
        boolean isFaceModified = false;
        isFaceModified = this.edges.isEmpty() ? (isFaceModified |= this.handleNoEdgeCase(vertexToAdd)) : (this.edges.size() == 1 ? (isFaceModified |= this.handleSingleEdgeCase(vertexToAdd)) : (this.edges.size() == 2 ? (isFaceModified |= this.handleTwoEdgeCase(vertexToAdd, lockEdgesWithTwin)) : (isFaceModified |= this.handleMultipleEdgeCase(vertexToAdd, faceVertexToLock, lockEdgesWithTwin))));
        if (isFaceModified) {
            AbstractHalfEdge3D startEdge = (AbstractHalfEdge3D)this.edges.get(0);
            this.edges.clear();
            this.edges.add(startEdge);
            for (HalfEdge3DReadOnly currentEdge = startEdge.getNext(); currentEdge != startEdge; currentEdge = ((AbstractHalfEdge3D)currentEdge).getNext()) {
                this.edges.add(currentEdge);
            }
            this.updateVertices();
            this.updateNormal();
            this.updateCentroidAndArea();
            this.getBoundingBox().updateToIncludePoint(vertexToAdd);
        }
        return isFaceModified;
    }

    private boolean handleNoEdgeCase(Vertex vertexToAdd) {
        AbstractHalfEdge3D newEdge = (AbstractHalfEdge3D)this.edgeFactory.newInstance(vertexToAdd, vertexToAdd);
        newEdge.setFace(this);
        newEdge.setNext(newEdge);
        newEdge.setPrevious(newEdge);
        this.edges.add(newEdge);
        return true;
    }

    private boolean handleSingleEdgeCase(Vertex vertexToAdd) {
        AbstractHalfEdge3D firstEdge = (AbstractHalfEdge3D)this.edges.get(0);
        if (firstEdge.getOrigin().geometricallyEquals((Point3DReadOnly)vertexToAdd, this.constructionEpsilon)) {
            return false;
        }
        firstEdge.setDestination(vertexToAdd);
        AbstractHalfEdge3D newEdge = (AbstractHalfEdge3D)this.edgeFactory.newInstance((Vertex3DReadOnly)vertexToAdd, firstEdge.getOrigin());
        newEdge.setFace(this);
        newEdge.setNext(firstEdge);
        newEdge.setPrevious(firstEdge);
        firstEdge.setNext(newEdge);
        firstEdge.setPrevious(newEdge);
        this.edges.add(newEdge);
        return true;
    }

    private boolean handleTwoEdgeCase(Vertex vertexToAdd, boolean lockEdgesWithTwin) {
        Vector3D resultingNormal;
        AbstractHalfEdge3D firstEdge = (AbstractHalfEdge3D)this.edges.get(0);
        AbstractHalfEdge3D secondEdge = (AbstractHalfEdge3D)this.edges.get(1);
        if (firstEdge.distance((Point3DReadOnly)vertexToAdd) < this.constructionEpsilon) {
            return false;
        }
        if (!lockEdgesWithTwin || firstEdge.getTwin() == null) {
            if (firstEdge.getOrigin().distanceSquared((Point3DReadOnly)vertexToAdd) > firstEdge.getDestination().distanceSquared((Point3DReadOnly)vertexToAdd)) {
                if (EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((Point3DReadOnly)firstEdge.getDestination(), vertexToAdd, (Point3DReadOnly)firstEdge.getOrigin()) < this.constructionEpsilon) {
                    firstEdge.setDestination(vertexToAdd);
                    secondEdge.setOrigin(vertexToAdd);
                    return true;
                }
            } else if (EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((Point3DReadOnly)firstEdge.getOrigin(), vertexToAdd, (Point3DReadOnly)firstEdge.getDestination()) < this.constructionEpsilon) {
                firstEdge.setOrigin(vertexToAdd);
                secondEdge.setDestination(vertexToAdd);
                return true;
            }
        }
        if ((resultingNormal = EuclidPolytopeTools.crossProductOfLineSegment3Ds(firstEdge.getOrigin(), firstEdge.getDestination(), firstEdge.getDestination(), vertexToAdd)).dot((Vector3DReadOnly)this.getNormal()) > 0.0) {
            firstEdge.flip();
            secondEdge.setOrigin(firstEdge.getDestination());
        }
        secondEdge.setDestination(vertexToAdd);
        AbstractHalfEdge3D newEdge = (AbstractHalfEdge3D)this.edgeFactory.newInstance((Vertex3DReadOnly)vertexToAdd, firstEdge.getOrigin());
        newEdge.setFace(this);
        newEdge.setPrevious(secondEdge);
        newEdge.setNext(firstEdge);
        firstEdge.setPrevious(newEdge);
        secondEdge.setNext(newEdge);
        this.edges.add(newEdge);
        return true;
    }

    private boolean handleMultipleEdgeCase(Vertex vertexToAdd, Vertex faceVertexToLock, boolean lockEdgesWithTwin) {
        int i;
        List<Edge> lineOfSight = this.lineOfSight((Point3DReadOnly)vertexToAdd);
        if (lineOfSight.isEmpty()) {
            return false;
        }
        HalfEdge3DReadOnly firstVisibleEdge = (AbstractHalfEdge3D)lineOfSight.get(0);
        if (lineOfSight.size() == 1 && firstVisibleEdge.distance((Point3DReadOnly)vertexToAdd) < this.constructionEpsilon) {
            return false;
        }
        HalfEdge3DReadOnly lastVisibleEdge = (AbstractHalfEdge3D)lineOfSight.get(lineOfSight.size() - 1);
        HalfEdge3DReadOnly edgeBeforeLineOfSight = ((AbstractHalfEdge3D)firstVisibleEdge).getPrevious();
        HalfEdge3DReadOnly edgeAfterLineOfSight = ((AbstractHalfEdge3D)lastVisibleEdge).getNext();
        if (edgeBeforeLineOfSight.distanceFromSupportLine((Point3DReadOnly)vertexToAdd) < this.constructionEpsilon) {
            firstVisibleEdge = edgeBeforeLineOfSight;
            lineOfSight.add(0, firstVisibleEdge);
        } else if (EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)((AbstractHalfEdge3D)edgeBeforeLineOfSight).getDestination(), vertexToAdd, (Point3DReadOnly)((AbstractHalfEdge3D)edgeBeforeLineOfSight).getOrigin()) < this.constructionEpsilon) {
            firstVisibleEdge = edgeBeforeLineOfSight;
            lineOfSight.add(0, firstVisibleEdge);
        }
        if (edgeAfterLineOfSight.distanceFromSupportLine((Point3DReadOnly)vertexToAdd) < this.constructionEpsilon) {
            lastVisibleEdge = edgeAfterLineOfSight;
            lineOfSight.add(lastVisibleEdge);
        } else if (EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)((AbstractHalfEdge3D)edgeAfterLineOfSight).getOrigin(), vertexToAdd, (Point3DReadOnly)((AbstractHalfEdge3D)edgeAfterLineOfSight).getDestination()) < this.constructionEpsilon) {
            lastVisibleEdge = edgeAfterLineOfSight;
            lineOfSight.add(lastVisibleEdge);
        }
        if (lockEdgesWithTwin) {
            for (i = 0; i < lineOfSight.size(); ++i) {
                if (((AbstractHalfEdge3D)lineOfSight.get(i)).getTwin() == null) continue;
                return false;
            }
        }
        if (lineOfSight.size() == 1) {
            AbstractHalfEdge3D additionalEdge = (AbstractHalfEdge3D)this.edgeFactory.newInstance((Vertex3DReadOnly)vertexToAdd, ((AbstractHalfEdge3D)firstVisibleEdge).getDestination());
            additionalEdge.setFace(this);
            ((AbstractHalfEdge3D)firstVisibleEdge).setDestination(vertexToAdd);
            additionalEdge.setNext(((AbstractHalfEdge3D)firstVisibleEdge).getNext());
            ((AbstractHalfEdge3D)((AbstractHalfEdge3D)firstVisibleEdge).getNext()).setPrevious(additionalEdge);
            ((AbstractHalfEdge3D)firstVisibleEdge).setNext(additionalEdge);
            additionalEdge.setPrevious(firstVisibleEdge);
            ((AbstractHalfEdge3D)firstVisibleEdge).setTwin(null);
            this.edges.add(additionalEdge);
        } else {
            if (faceVertexToLock != null) {
                for (i = 1; i < lineOfSight.size(); ++i) {
                    if (((AbstractHalfEdge3D)lineOfSight.get(i)).getOrigin() != faceVertexToLock) continue;
                    return false;
                }
            }
            ((AbstractHalfEdge3D)firstVisibleEdge).setDestination(vertexToAdd);
            ((AbstractHalfEdge3D)lastVisibleEdge).setOrigin(vertexToAdd);
            ((AbstractHalfEdge3D)firstVisibleEdge).setNext(lastVisibleEdge);
            ((AbstractHalfEdge3D)lastVisibleEdge).setPrevious(firstVisibleEdge);
            ((AbstractHalfEdge3D)firstVisibleEdge).setTwin(null);
            ((AbstractHalfEdge3D)lastVisibleEdge).setTwin(null);
            for (i = 1; i < lineOfSight.size() - 1; ++i) {
                AbstractHalfEdge3D edgeToRemove = (AbstractHalfEdge3D)lineOfSight.get(i);
                edgeToRemove.destroy();
                this.edges.remove(edgeToRemove);
            }
        }
        return true;
    }

    private void updateVertices() {
        this.vertices.clear();
        this.edges.forEach(edge -> this.vertices.add(edge.getOrigin()));
    }

    public void updateNormal() {
        if (this.vertices.size() > 3) {
            if (this.verticesCovariance == null) {
                this.verticesCovariance = new Matrix3D();
            }
            EuclidPolytopeConstructionTools.computeCovariance3D(this.vertices, (Matrix3DBasics)this.verticesCovariance);
            if (this.eigenDecomposition == null) {
                this.eigenDecomposition = new SymmetricEigenDecomposition3D();
            }
            EuclidPolytopeConstructionTools.updateFace3DNormal(this.eigenDecomposition, (Matrix3DReadOnly)this.verticesCovariance, this.getNormal());
        } else if (this.vertices.size() == 3) {
            EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)((Point3DReadOnly)this.vertices.get(0)), (Point3DReadOnly)((Point3DReadOnly)this.vertices.get(2)), (Point3DReadOnly)((Point3DReadOnly)this.vertices.get(1)), (Vector3DBasics)this.getNormal());
        } else if (this.vertices.size() == 2) {
            Vector3DBasics edgeDirection = this.getEdge(0).getDirection(false);
            this.getNormal().cross((Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)this.getNormal());
            this.getNormal().cross((Tuple3DReadOnly)this.getNormal(), (Tuple3DReadOnly)edgeDirection);
            this.getNormal().normalize();
        }
    }

    public void updateCentroidAndArea() {
        this.area = EuclidPolytopeConstructionTools.computeConvexPolygon3DArea(this.vertices, (Vector3DReadOnly)this.getNormal(), this.vertices.size(), true, this.getCentroid());
    }

    public void updateBoundingBox() {
        this.getBoundingBox().setToNaN();
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.getBoundingBox().updateToIncludePoint((Point3DReadOnly)this.vertices.get(i));
        }
    }

    public void flip() {
        for (int i = 0; i < this.edges.size(); ++i) {
            ((AbstractHalfEdge3D)this.edges.get(i)).flip();
        }
        Collections.reverse(this.edges);
        this.updateVertices();
        this.getNormal().negate();
    }

    public void destroy() {
        for (int i = 0; i < this.edges.size(); ++i) {
            ((AbstractHalfEdge3D)this.edges.get(i)).destroy();
        }
        this.edges.clear();
        this.getNormal().setToNaN();
        this.getCentroid().setToNaN();
        this.getBoundingBox().setToNaN();
        this.vertices.clear();
        this.area = Double.NaN;
    }

    public List<Edge> lineOfSight(Point3DReadOnly observer) {
        return Face3DReadOnly.super.lineOfSight(observer);
    }

    public List<Edge> lineOfSight(Point3DReadOnly observer, double epsilon) {
        return Face3DReadOnly.super.lineOfSight(observer, epsilon);
    }

    public Edge lineOfSightStart(Point3DReadOnly observer) {
        return (Edge)((AbstractHalfEdge3D)Face3DReadOnly.super.lineOfSightStart(observer));
    }

    public Edge lineOfSightEnd(Point3DReadOnly observer) {
        return (Edge)((AbstractHalfEdge3D)Face3DReadOnly.super.lineOfSightEnd(observer));
    }

    public Face getNeighbor(int index) {
        return (Face)((AbstractFace3D)Face3DReadOnly.super.getNeighbor(index));
    }

    public Edge getCommonEdgeWith(Face3DReadOnly neighbor) {
        return (Edge)((AbstractHalfEdge3D)Face3DReadOnly.super.getCommonEdgeWith(neighbor));
    }

    public Edge getClosestEdge(Point3DReadOnly point) {
        return (Edge)((AbstractHalfEdge3D)Face3DReadOnly.super.getClosestEdge(point));
    }

    public Edge getClosestVisibleEdge(Point3DReadOnly point) {
        return (Edge)((AbstractHalfEdge3D)Face3DReadOnly.super.getClosestVisibleEdge(point));
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    public Vertex getVertex(int index) {
        return (Vertex)((AbstractVertex3D)this.vertices.get(index));
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public Edge getEdge(int index) {
        return (Edge)((AbstractHalfEdge3D)this.edges.get(index));
    }

    public abstract Point3DBasics getCentroid();

    public abstract Vector3DBasics getNormal();

    @Override
    public double getArea() {
        return this.area;
    }

    public abstract BoundingBox3DBasics getBoundingBox();

    @Override
    public boolean containsNaN() {
        return Face3DReadOnly.super.containsNaN();
    }

    public void setToNaN() {
        this.edges.clear();
        this.vertices.clear();
        this.getCentroid().setToNaN();
        this.getNormal().setToNaN();
        this.area = Double.NaN;
        this.getBoundingBox().setToNaN();
    }

    public void setToZero() {
        this.edges.clear();
        this.vertices.clear();
        this.getCentroid().setToZero();
        this.getNormal().setToZero();
        this.area = 0.0;
        this.getBoundingBox().setToZero();
    }

    public void applyTransform(Transform transform) {
        for (int i = 0; i < this.getNumberOfEdges(); ++i) {
            ((AbstractHalfEdge3D)this.edges.get(i)).getOrigin().applyTransform(transform);
        }
        this.getCentroid().applyTransform(transform);
        this.getNormal().applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        for (int i = 0; i < this.getNumberOfEdges(); ++i) {
            ((AbstractHalfEdge3D)this.edges.get(i)).getOrigin().applyInverseTransform(transform);
        }
        this.getCentroid().applyInverseTransform(transform);
        this.getNormal().applyInverseTransform(transform);
    }

    public boolean equals(Object object) {
        if (object instanceof Face3DReadOnly) {
            return this.equals((Face3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return this.vertices.hashCode();
    }

    public String toString() {
        return EuclidShapeIOTools.getFace3DString(this);
    }
}

