/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision.epa;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import us.ihmc.euclid.shape.collision.EuclidShape3DCollisionResult;
import us.ihmc.euclid.shape.collision.epa.EPAFace3D;
import us.ihmc.euclid.shape.collision.epa.EPAHalfEdge3D;
import us.ihmc.euclid.shape.collision.epa.EPATools;
import us.ihmc.euclid.shape.collision.epa.EPAVertex3D;
import us.ihmc.euclid.shape.collision.gjk.GJKVertex3D;
import us.ihmc.euclid.shape.collision.gjk.GilbertJohnsonKeerthiCollisionDetector;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultBasics;
import us.ihmc.euclid.shape.collision.interfaces.SupportingVertexHolder;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class ExpandingPolytopeAlgorithm {
    private static final boolean VERBOSE = false;
    public static final double DEFAULT_TERMINAL_CONDITION_EPSILON = 1.0E-12;
    private static final double SUPPORT_DIRECTION_ZERO_COMPONENT = 1.234E-16;
    private double epsilon = 1.0E-12;
    private int maxIterations = 1000;
    private int numberOfIterations = 0;
    private final GilbertJohnsonKeerthiCollisionDetector gjkCollisionDetector = new GilbertJohnsonKeerthiCollisionDetector();
    private EPAFace3D lastResult = null;

    public EuclidShape3DCollisionResult evaluateCollision(Shape3DReadOnly shapeA, Shape3DReadOnly shapeB) {
        EuclidShape3DCollisionResult result = new EuclidShape3DCollisionResult();
        this.evaluateCollision(shapeA, shapeB, (EuclidShape3DCollisionResultBasics)result);
        return result;
    }

    public boolean evaluateCollision(Shape3DReadOnly shapeA, Shape3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        boolean areColliding;
        if (!shapeA.isPrimitive() || !shapeB.isPrimitive()) {
            areColliding = this.evaluateCollision((SupportingVertexHolder)shapeA, (SupportingVertexHolder)shapeB, resultToPack);
        } else if (shapeA.isDefinedByPose()) {
            Shape3DPoseReadOnly poseA = shapeA.getPose();
            Shape3DBasics localShapeA = shapeA.copy();
            localShapeA.getPose().setToZero();
            Shape3DBasics localShapeB = shapeB.copy();
            localShapeB.applyInverseTransform((Transform)poseA);
            areColliding = this.evaluateCollision((SupportingVertexHolder)localShapeA, (SupportingVertexHolder)localShapeB, resultToPack);
            resultToPack.applyTransform((Transform)poseA);
        } else if (shapeB.isDefinedByPose()) {
            Shape3DPoseReadOnly poseB = shapeB.getPose();
            Shape3DBasics localShapeA = shapeA.copy();
            localShapeA.applyInverseTransform((Transform)poseB);
            Shape3DBasics localShapeB = shapeB.copy();
            localShapeB.getPose().setToZero();
            areColliding = this.evaluateCollision((SupportingVertexHolder)localShapeA, (SupportingVertexHolder)localShapeB, resultToPack);
            resultToPack.applyTransform((Transform)poseB);
        } else {
            areColliding = this.evaluateCollision((SupportingVertexHolder)shapeA, (SupportingVertexHolder)shapeB, resultToPack);
        }
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
        return areColliding;
    }

    public EuclidShape3DCollisionResult evaluateCollision(SupportingVertexHolder shapeA, SupportingVertexHolder shapeB) {
        EuclidShape3DCollisionResult result = new EuclidShape3DCollisionResult();
        this.evaluateCollision(shapeA, shapeB, (EuclidShape3DCollisionResultBasics)result);
        return result;
    }

    public boolean evaluateCollision(SupportingVertexHolder shapeA, SupportingVertexHolder shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        boolean areShapesColliding = this.gjkCollisionDetector.evaluateCollision(shapeA, shapeB, resultToPack);
        if (areShapesColliding && this.gjkCollisionDetector.getSimplex() != null) {
            areShapesColliding = this.evaluateCollision(shapeA, shapeB, this.gjkCollisionDetector.getSimplex().getVertices(), resultToPack);
        }
        return areShapesColliding;
    }

    public boolean evaluateCollision(SupportingVertexHolder shapeA, SupportingVertexHolder shapeB, GJKVertex3D[] simplex, EuclidShape3DCollisionResultBasics resultToPack) {
        PriorityQueue<EPAFace3D> queue = new PriorityQueue<EPAFace3D>();
        double mu = Double.POSITIVE_INFINITY;
        List<EPAFace3D> initialPolytope = EPATools.newEPAPolytopeFromGJKSimplex(shapeA, shapeB, simplex, this.epsilon);
        if (initialPolytope == null) {
            this.lastResult = null;
        } else {
            initialPolytope.forEach(queue::add);
            Vector3D supportDirection = new Vector3D();
            this.numberOfIterations = 0;
            while (this.numberOfIterations < this.maxIterations && !queue.isEmpty()) {
                EPAFace3D entry = (EPAFace3D)queue.poll();
                if (entry.isObsolete()) continue;
                double currentNormSquared = entry.getDistanceSquaredToOrigin();
                ++this.numberOfIterations;
                if (currentNormSquared > mu + this.epsilon) break;
                this.lastResult = entry;
                if (currentNormSquared > this.epsilon) {
                    supportDirection.set((Tuple3DReadOnly)entry.getClosestPointToOrigin());
                } else {
                    supportDirection.set((Tuple3DReadOnly)entry.getNormal());
                }
                if (supportDirection.getX() == 0.0) {
                    supportDirection.setX(1.234E-16);
                } else if (supportDirection.getY() == 0.0) {
                    supportDirection.setY(1.234E-16);
                } else if (supportDirection.getZ() == 0.0) {
                    supportDirection.setZ(1.234E-16);
                }
                Point3DReadOnly vertexA = shapeA.getSupportingVertex((Vector3DReadOnly)supportDirection);
                supportDirection.negate();
                Point3DReadOnly vertexB = shapeB.getSupportingVertex((Vector3DReadOnly)supportDirection);
                EPAVertex3D newVertex = new EPAVertex3D(vertexA, vertexB);
                if (entry.contains(newVertex)) {
                    boolean terminate;
                    boolean retry = false;
                    supportDirection.negate();
                    if (supportDirection.getX() == 1.234E-16) {
                        supportDirection.setX(-1.234E-16);
                        retry = true;
                    } else if (supportDirection.getY() == 1.234E-16) {
                        supportDirection.setY(-1.234E-16);
                        retry = true;
                    } else if (supportDirection.getZ() == 1.234E-16) {
                        supportDirection.setZ(-1.234E-16);
                        retry = true;
                    }
                    if (retry) {
                        vertexA = shapeA.getSupportingVertex((Vector3DReadOnly)supportDirection);
                        supportDirection.negate();
                        vertexB = shapeB.getSupportingVertex((Vector3DReadOnly)supportDirection);
                        newVertex = new EPAVertex3D(vertexA, vertexB);
                        terminate = entry.contains(newVertex);
                    } else {
                        terminate = true;
                    }
                    if (terminate) break;
                }
                if ((mu = Math.min(mu, EuclidCoreTools.square((double)TupleTools.dot((Tuple3DReadOnly)newVertex, (Tuple3DReadOnly)entry.getClosestPointToOrigin())) / currentNormSquared)) <= EuclidCoreTools.square((double)(1.0 + this.epsilon)) * currentNormSquared || !entry.canObserverSeeFace(newVertex)) break;
                entry.markObsolete();
                ArrayList<EPAHalfEdge3D> silhouette = new ArrayList<EPAHalfEdge3D>();
                EPATools.silhouette(entry.getEdge0().getTwin(), newVertex, silhouette);
                EPATools.silhouette(entry.getEdge1().getTwin(), newVertex, silhouette);
                EPATools.silhouette(entry.getEdge2().getTwin(), newVertex, silhouette);
                boolean areNewTrianglesFine = true;
                for (EPAHalfEdge3D sentryEdge : silhouette) {
                    EPAFace3D newEntry = EPAFace3D.fromVertexAndTwinEdge(newVertex, sentryEdge, this.epsilon);
                    if (newEntry.isTriangleAffinelyDependent()) {
                        areNewTrianglesFine = false;
                        break;
                    }
                    if (!newEntry.isClosestPointInternal() || !(currentNormSquared <= newEntry.getDistanceSquaredToOrigin()) || !(newEntry.getDistanceSquaredToOrigin() <= mu + this.epsilon)) continue;
                    queue.add(newEntry);
                }
                if (!areNewTrianglesFine) break;
                boolean terminate = false;
                for (int edgeIndex = 0; edgeIndex < newVertex.getNumberOfAssociatedEdges(); ++edgeIndex) {
                    EPAHalfEdge3D edge = newVertex.getAssociatedEdge(edgeIndex);
                    EPAHalfEdge3D twin = edge.getDestination().getEdgeTo(newVertex);
                    if (twin == null) {
                        terminate = true;
                        break;
                    }
                    edge.setTwin(twin);
                }
                if (terminate) break;
                for (EPAHalfEdge3D sentryEdge : silhouette) {
                    EPAVertex3D vertexOnSilhouette = sentryEdge.getOrigin();
                    for (int index = vertexOnSilhouette.getNumberOfAssociatedEdges() - 1; index >= 0; --index) {
                        if (!vertexOnSilhouette.getAssociatedEdge(index).isObsolete()) continue;
                        vertexOnSilhouette.removeAssociatedEdge(index);
                    }
                }
            }
        }
        if (initialPolytope == null) {
            resultToPack.setShapesAreColliding(false);
            resultToPack.setSignedDistance(0.0);
            resultToPack.getNormalOnA().setToNaN();
            resultToPack.getNormalOnB().setToNaN();
        } else {
            resultToPack.setShapesAreColliding(true);
            resultToPack.setSignedDistance(-this.lastResult.getDistanceToOrigin());
            this.lastResult.computePointOnA(resultToPack.getPointOnA());
            this.lastResult.computePointOnB(resultToPack.getPointOnB());
            resultToPack.getNormalOnA().setToNaN();
            resultToPack.getNormalOnB().setToNaN();
        }
        return resultToPack.areShapesColliding();
    }

    public GilbertJohnsonKeerthiCollisionDetector getGJKCollisionDetector() {
        return this.gjkCollisionDetector;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setTerminalConditionEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public double getTerminalConditionEpsilon() {
        return this.epsilon;
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    public EPAFace3D getClosestFace() {
        return this.lastResult;
    }
}

