/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.tools;

import java.util.Collection;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidShapeIOTools {
    private EuclidShapeIOTools() {
    }

    public static String getBox3DString(Box3DReadOnly box3D) {
        return EuclidShapeIOTools.getBox3DString(EuclidCoreIOTools.DEFAULT_FORMAT, box3D);
    }

    public static String getBox3DString(String format, Box3DReadOnly box3D) {
        if (box3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getBox3DString(format, (Tuple3DReadOnly)box3D.getPosition(), (Orientation3DReadOnly)box3D.getOrientation(), box3D.getSize());
    }

    public static String getBox3DString(String format, Tuple3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly size) {
        return "Box 3D: [position: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)position) + ", " + EuclidCoreIOTools.getStringAsYawPitchRoll((String)format, (Orientation3DReadOnly)orientation) + ", size: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)size) + "]";
    }

    public static String getCapsule3DString(Capsule3DReadOnly capsule3D) {
        return EuclidShapeIOTools.getCapsule3DString(EuclidCoreIOTools.DEFAULT_FORMAT, capsule3D);
    }

    public static String getCapsule3DString(String format, Capsule3DReadOnly capsule3D) {
        return EuclidShapeIOTools.getCapsule3DString(format, (Tuple3DReadOnly)capsule3D.getPosition(), (Vector3DReadOnly)capsule3D.getAxis(), capsule3D.getLength(), capsule3D.getRadius());
    }

    public static String getCapsule3DString(String format, Tuple3DReadOnly position, Vector3DReadOnly axis, double length, double radius) {
        return "Capsule 3D: [position: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)position) + ", axis: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)axis) + ", length: " + String.format(format, length) + ", radius: " + String.format(format, radius) + "]";
    }

    public static String getCylinder3DString(Cylinder3DReadOnly cylinder3D) {
        return EuclidShapeIOTools.getCylinder3DString(EuclidCoreIOTools.DEFAULT_FORMAT, cylinder3D);
    }

    public static String getCylinder3DString(String format, Cylinder3DReadOnly cylinder3D) {
        return EuclidShapeIOTools.getCylinder3DString(format, (Tuple3DReadOnly)cylinder3D.getPosition(), (Vector3DReadOnly)cylinder3D.getAxis(), cylinder3D.getLength(), cylinder3D.getRadius());
    }

    public static String getCylinder3DString(String format, Tuple3DReadOnly position, Vector3DReadOnly axis, double length, double radius) {
        return "Cylinder 3D: [position: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)position) + ", axis: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)axis) + ", length: " + String.format(format, length) + ", radius: " + String.format(format, radius) + "]";
    }

    public static String getEllipsoid3DString(Ellipsoid3DReadOnly ellipsoid3D) {
        return EuclidShapeIOTools.getEllipsoid3DString(EuclidCoreIOTools.DEFAULT_FORMAT, ellipsoid3D);
    }

    public static String getEllipsoid3DString(String format, Ellipsoid3DReadOnly ellipsoid3D) {
        if (ellipsoid3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getEllipsoid3DString(format, (Tuple3DReadOnly)ellipsoid3D.getPosition(), (Orientation3DReadOnly)ellipsoid3D.getOrientation(), ellipsoid3D.getRadii());
    }

    public static String getEllipsoid3DString(String format, Tuple3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly radii) {
        return "Ellipsoid 3D: [position: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)position) + ", " + EuclidCoreIOTools.getStringAsYawPitchRoll((String)format, (Orientation3DReadOnly)orientation) + ", radii: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)radii) + "]";
    }

    public static String getPointShape3DString(PointShape3DReadOnly pointShape3D) {
        return EuclidShapeIOTools.getPointShape3DString(EuclidCoreIOTools.DEFAULT_FORMAT, pointShape3D);
    }

    public static String getPointShape3DString(String format, PointShape3DReadOnly pointShape3D) {
        return EuclidShapeIOTools.getPointShape3DString(format, (Tuple3DReadOnly)pointShape3D);
    }

    public static String getPointShape3DString(String format, Tuple3DReadOnly position) {
        return "Point shape 3D: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)position);
    }

    public static String getRamp3DString(Ramp3DReadOnly ramp3D) {
        return EuclidShapeIOTools.getRamp3DString(EuclidCoreIOTools.DEFAULT_FORMAT, ramp3D);
    }

    public static String getRamp3DString(String format, Ramp3DReadOnly ramp3D) {
        if (ramp3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getRamp3DString(format, (Tuple3DReadOnly)ramp3D.getPosition(), (Orientation3DReadOnly)ramp3D.getOrientation(), ramp3D.getSize());
    }

    public static String getRamp3DString(String format, Tuple3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly size) {
        return "Ramp 3D: [position: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)position) + ", " + EuclidCoreIOTools.getStringAsYawPitchRoll((String)format, (Orientation3DReadOnly)orientation) + ", size: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)size) + "]";
    }

    public static String getSphere3DString(Sphere3DReadOnly sphere3D) {
        return EuclidShapeIOTools.getSphere3DString(EuclidCoreIOTools.DEFAULT_FORMAT, sphere3D);
    }

    public static String getSphere3DString(String format, Sphere3DReadOnly sphere3D) {
        return EuclidShapeIOTools.getSphere3DString(format, (Tuple3DReadOnly)sphere3D.getPosition(), sphere3D.getRadius());
    }

    public static String getSphere3DString(String format, Tuple3DReadOnly position, double radius) {
        return "Sphere 3D: [position: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)position) + ", radius: " + String.format(format, radius) + "]";
    }

    public static String getTorus3DString(Torus3DReadOnly torus3D) {
        return EuclidShapeIOTools.getTorus3DString(EuclidCoreIOTools.DEFAULT_FORMAT, torus3D);
    }

    public static String getTorus3DString(String format, Torus3DReadOnly torus3D) {
        return EuclidShapeIOTools.getTorus3DString(format, (Tuple3DReadOnly)torus3D.getPosition(), (Vector3DReadOnly)torus3D.getAxis(), torus3D.getRadius(), torus3D.getTubeRadius());
    }

    public static String getTorus3DString(String format, Tuple3DReadOnly position, Vector3DReadOnly axis, double radius, double tubeRadius) {
        return "Torus 3D: [position: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)position) + ", axis: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)axis) + ", radius: " + String.format(format, radius) + ", tube radius: " + String.format(format, tubeRadius) + "]";
    }

    public static String getShape3DPoseString(Shape3DPoseReadOnly shape3DPose) {
        return EuclidShapeIOTools.getShape3DPoseString(EuclidCoreIOTools.DEFAULT_FORMAT, shape3DPose);
    }

    public static String getShape3DPoseString(String format, Shape3DPoseReadOnly shape3DPose) {
        return EuclidShapeIOTools.getShape3DPoseString(format, shape3DPose.getShapeOrientation(), shape3DPose.getShapePosition());
    }

    public static String getShape3DPoseString(String format, RotationMatrixReadOnly orientation, Point3DReadOnly position) {
        return "Shape 3D pose: [position: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)position) + ", " + EuclidCoreIOTools.getStringAsYawPitchRoll((String)format, (Orientation3DReadOnly)orientation) + "]";
    }

    public static String getEuclidShape3DCollisionResultString(EuclidShape3DCollisionResultReadOnly euclidShape3DCollisionResult) {
        return EuclidShapeIOTools.getEuclidShape3DCollisionResultString(EuclidCoreIOTools.DEFAULT_FORMAT, euclidShape3DCollisionResult);
    }

    public static String getEuclidShape3DCollisionResultString(String format, EuclidShape3DCollisionResultReadOnly euclidShape3DCollisionResult) {
        if (euclidShape3DCollisionResult == null) {
            return "null";
        }
        String string = "Collision test result: ";
        string = euclidShape3DCollisionResult.areShapesColliding() ? string + "colliding, depth: " + euclidShape3DCollisionResult.getSignedDistance() + "\n" : string + "non-colliding, separating distance: " + euclidShape3DCollisionResult.getSignedDistance() + "\n";
        string = string + "Shape A: " + (euclidShape3DCollisionResult.getShapeA() == null ? "null" : euclidShape3DCollisionResult.getShapeA().getClass().getSimpleName());
        string = string + ", location: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)euclidShape3DCollisionResult.getPointOnA());
        string = string + ", normal: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)euclidShape3DCollisionResult.getNormalOnA()) + "\n";
        string = string + "Shape B: " + (euclidShape3DCollisionResult.getShapeB() == null ? "null" : euclidShape3DCollisionResult.getShapeB().getClass().getSimpleName());
        string = string + ", location: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)euclidShape3DCollisionResult.getPointOnB());
        string = string + ", normal: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)euclidShape3DCollisionResult.getNormalOnB());
        return string;
    }

    public static String getVertex3DString(Vertex3DReadOnly vertex3D) {
        return EuclidShapeIOTools.getVertex3DString(EuclidCoreIOTools.DEFAULT_FORMAT, vertex3D);
    }

    public static String getVertex3DString(String format, Vertex3DReadOnly vertex3D) {
        if (vertex3D == null) {
            return "null";
        }
        String string = "Vertex 3D: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)vertex3D) + ", number of edges: " + vertex3D.getNumberOfAssociatedEdges();
        string = string + EuclidShapeIOTools.getHalfEdge3DCollectionString(format, "\n\t", vertex3D.getAssociatedEdges());
        return string;
    }

    public static String getHalfEdge3DString(HalfEdge3DReadOnly halfEdge3D) {
        return EuclidShapeIOTools.getHalfEdge3DString(EuclidCoreIOTools.DEFAULT_FORMAT, halfEdge3D);
    }

    public static String getHalfEdge3DString(String format, HalfEdge3DReadOnly halfEdge3D) {
        if (halfEdge3D == null) {
            return "null";
        }
        String string = "Half-edge 3D: " + EuclidShapeIOTools.getHalfEdge3DShortString(format, halfEdge3D);
        string = string + "\n\tTwin    : " + EuclidShapeIOTools.getHalfEdge3DShortString(format, halfEdge3D.getTwin());
        string = string + "\n\tNext    : " + EuclidShapeIOTools.getHalfEdge3DShortString(format, halfEdge3D.getNext());
        string = string + "\n\tPrevious: " + EuclidShapeIOTools.getHalfEdge3DShortString(format, halfEdge3D.getPrevious());
        string = string + "\n\tFace: " + EuclidShapeIOTools.getFace3DShortString(format, halfEdge3D.getFace());
        return string;
    }

    public static String getFace3DString(Face3DReadOnly face3D) {
        return EuclidShapeIOTools.getFace3DString(EuclidCoreIOTools.DEFAULT_FORMAT, face3D);
    }

    public static String getFace3DString(String format, Face3DReadOnly face3D) {
        if (face3D == null) {
            return "null";
        }
        return "Face 3D: " + EuclidShapeIOTools.getFace3DShortString(format, face3D) + ", area: " + String.format(format, face3D.getArea()) + ", number of edges: " + face3D.getNumberOfEdges() + EuclidShapeIOTools.getHalfEdge3DCollectionString(format, "\n\t", face3D.getEdges());
    }

    public static String getConvexPolytope3DString(ConvexPolytope3DReadOnly convexPolytope3D) {
        return EuclidShapeIOTools.getConvexPolytope3DString(EuclidCoreIOTools.DEFAULT_FORMAT, convexPolytope3D);
    }

    public static String getConvexPolytope3DString(String format, ConvexPolytope3DReadOnly convexPolytope3D) {
        if (convexPolytope3D == null) {
            return "null";
        }
        String string = "Convex polytope 3D: number of: [faces: " + convexPolytope3D.getNumberOfFaces() + ", edges: " + convexPolytope3D.getNumberOfEdges() + ", vertices: " + convexPolytope3D.getNumberOfVertices();
        String linePrefix = "\n\t";
        string = string + "\nFace list: " + EuclidShapeIOTools.getFace3DCollectionString(format, linePrefix, convexPolytope3D.getFaces());
        string = string + "\nEdge list: " + EuclidShapeIOTools.getHalfEdge3DCollectionString(format, linePrefix, convexPolytope3D.getHalfEdges());
        string = string + "\nVertex list: " + EuclidShapeIOTools.getVertex3DCollectionString(format, linePrefix, convexPolytope3D.getVertices());
        return string;
    }

    private static String getVertex3DCollectionString(String format, String linePrefix, Collection<? extends Vertex3DReadOnly> vertices) {
        return EuclidCoreIOTools.getCollectionString((String)linePrefix, null, (String)linePrefix, vertices, vertex -> EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)vertex));
    }

    private static String getHalfEdge3DCollectionString(String format, String linePrefix, Collection<? extends HalfEdge3DReadOnly> halfEdges) {
        return EuclidCoreIOTools.getCollectionString((String)linePrefix, null, (String)linePrefix, halfEdges, halfEdge -> EuclidShapeIOTools.getHalfEdge3DShortString(format, halfEdge));
    }

    private static String getFace3DCollectionString(String format, String linePrefix, Collection<? extends Face3DReadOnly> faces) {
        return EuclidCoreIOTools.getCollectionString((String)linePrefix, null, (String)linePrefix, faces, face -> EuclidShapeIOTools.getFace3DShortString(format, face));
    }

    private static String getHalfEdge3DShortString(String format, HalfEdge3DReadOnly halfEdge) {
        if (halfEdge == null) {
            return null;
        }
        return "[" + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)halfEdge.getOrigin()) + "; " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)halfEdge.getDestination()) + "]";
    }

    private static String getFace3DShortString(String format, Face3DReadOnly face3D) {
        if (face3D == null) {
            return "null";
        }
        return "centroid: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)face3D.getCentroid()) + ", normal: " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)face3D.getNormal());
    }
}

