/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope;

import java.util.List;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.shape.convexPolytope.Face3D;
import us.ihmc.euclid.shape.convexPolytope.HalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.Vertex3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;

public class ConvexPolytope3D
extends AbstractConvexPolytope3D<Vertex3D, HalfEdge3D, Face3D>
implements GeometryObject<ConvexPolytope3D> {
    private final Point3D centroid = new Point3D();
    private final BoundingBox3D boundingBox = new BoundingBox3D();

    public ConvexPolytope3D() {
        this(1.0E-10);
    }

    public ConvexPolytope3D(double constructionEpsilon) {
        super(constructionEpsilon);
        this.setFactories(Vertex3D::new, HalfEdge3D::new, Face3D::new);
        this.initialize();
    }

    public ConvexPolytope3D(Vertex3DSupplier vertex3DSupplier) {
        this(vertex3DSupplier, 1.0E-10);
    }

    public ConvexPolytope3D(Vertex3DSupplier vertex3DSupplier, double constructionEpsilon) {
        this(constructionEpsilon);
        this.addVertices(vertex3DSupplier);
    }

    public ConvexPolytope3D(ConvexPolytope3DReadOnly other) {
        this(other.getConstructionEpsilon());
        this.set(other);
    }

    public ConvexPolytope3D(List<Face3D> faces, double constructionEpsilon) {
        this(constructionEpsilon);
        this.initialize(faces);
    }

    public void set(ConvexPolytope3D other) {
        this.set((ConvexPolytope3DReadOnly)other);
    }

    public Point3D getCentroid() {
        return this.centroid;
    }

    @Override
    public BoundingBox3DBasics getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public ConvexPolytope3D copy() {
        return new ConvexPolytope3D(this);
    }

    public boolean epsilonEquals(ConvexPolytope3D other, double epsilon) {
        return super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(ConvexPolytope3D other, double epsilon) {
        return super.geometricallyEquals(other, epsilon);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ConvexPolytope3DReadOnly) {
            return this.equals((ConvexPolytope3DReadOnly)object);
        }
        return false;
    }
}

