/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Line2DBasics
extends Line2DReadOnly,
Transformable,
Clearable {
    public Point2DBasics getPoint();

    public UnitVector2DBasics getDirection();

    default public boolean containsNaN() {
        return this.getPoint().containsNaN() || this.getDirection().containsNaN();
    }

    default public void setToZero() {
        this.getPoint().setToZero();
        this.getDirection().set((UnitVector2DReadOnly)Axis2D.X);
    }

    default public void setToNaN() {
        this.getPoint().setToNaN();
        this.getDirection().setToNaN();
    }

    default public void rotate(double angleInRadians) {
        RotationMatrixTools.applyYawRotation((double)angleInRadians, (Tuple2DReadOnly)this.getDirection(), (Tuple2DBasics)this.getDirection());
    }

    default public void set(Line2DReadOnly other) {
        this.getPoint().set((Tuple2DReadOnly)other.getPoint());
        this.getDirection().set(other.getDirection());
    }

    default public void set(Line3DReadOnly line3DReadOnly) {
        this.getPoint().set((Tuple3DReadOnly)line3DReadOnly.getPoint());
        this.getDirection().set((Tuple3DReadOnly)line3DReadOnly.getDirection());
    }

    default public void set(LineSegment2DReadOnly lineSegment2DReadOnly) {
        this.set(lineSegment2DReadOnly.getFirstEndpoint(), lineSegment2DReadOnly.getSecondEndpoint());
    }

    default public void set(LineSegment3DReadOnly lineSegment3DReadOnly) {
        this.set(lineSegment3DReadOnly.getFirstEndpoint(), lineSegment3DReadOnly.getSecondEndpoint());
    }

    default public void set(double pointOnLineX, double pointOnLineY, double lineDirectionX, double lineDirectionY) {
        this.getPoint().set(pointOnLineX, pointOnLineY);
        this.getDirection().set(lineDirectionX, lineDirectionY);
    }

    default public void set(Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine) {
        if (firstPointOnLine.equals((EuclidGeometry)secondPointOnLine)) {
            throw new RuntimeException("Tried to create a line from two coincidal points.");
        }
        this.getPoint().set((Tuple2DReadOnly)firstPointOnLine);
        this.getDirection().sub((Tuple2DReadOnly)secondPointOnLine, (Tuple2DReadOnly)firstPointOnLine);
    }

    default public void set(Point3DReadOnly firstPointOnLine, Point3DReadOnly secondPointOnLine) {
        if (firstPointOnLine.equals((EuclidGeometry)secondPointOnLine)) {
            throw new RuntimeException("Tried to create a line from two coincidal points.");
        }
        this.getPoint().set((Tuple3DReadOnly)firstPointOnLine);
        this.getDirection().set((Tuple3DReadOnly)secondPointOnLine);
        this.getDirection().sub(firstPointOnLine.getX(), firstPointOnLine.getY());
    }

    default public void set(Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        this.getPoint().set((Tuple2DReadOnly)pointOnLine);
        this.getDirection().set((Tuple2DReadOnly)lineDirection);
    }

    default public void set(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection) {
        this.getPoint().set((Tuple3DReadOnly)pointOnLine);
        this.getDirection().set((Tuple3DReadOnly)lineDirection);
    }

    default public void shift(boolean shiftToLeft, double distanceToShift) {
        double vectorX = this.getDirectionX();
        double vectorY = this.getDirectionY();
        double orthogonalVectorX = -vectorY;
        double orthogonalVectorY = vectorX;
        if (!shiftToLeft) {
            orthogonalVectorX = -orthogonalVectorX;
            orthogonalVectorY = -orthogonalVectorY;
        }
        orthogonalVectorX = distanceToShift * orthogonalVectorX;
        orthogonalVectorY = distanceToShift * orthogonalVectorY;
        this.translate(orthogonalVectorX, orthogonalVectorY);
    }

    default public void shiftToLeft(double distanceToShift) {
        this.shift(true, distanceToShift);
    }

    default public void shiftToRight(double distanceToShift) {
        this.shift(false, distanceToShift);
    }

    default public void translate(double x, double y) {
        this.getPoint().add(x, y);
    }

    default public void applyTransform(Transform transform) {
        this.applyTransform(transform, true);
    }

    default public void applyInverseTransform(Transform transform) {
        this.applyInverseTransform(transform, true);
    }

    default public void applyTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.getPoint().applyTransform(transform, checkIfTransformInXYPlane);
        this.getDirection().applyTransform(transform, checkIfTransformInXYPlane);
    }

    default public void applyInverseTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.getPoint().applyInverseTransform(transform, checkIfTransformInXYPlane);
        this.getDirection().applyInverseTransform(transform, checkIfTransformInXYPlane);
    }
}

