/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public interface Pose3DReadOnly
extends RigidBodyTransformReadOnly,
EuclidGeometry {
    public Point3DReadOnly getPosition();

    public QuaternionReadOnly getOrientation();

    default public Point3DReadOnly getTranslation() {
        return this.getPosition();
    }

    default public QuaternionReadOnly getRotation() {
        return this.getOrientation();
    }

    default public double getX() {
        return this.getPosition().getX();
    }

    default public double getY() {
        return this.getPosition().getY();
    }

    default public double getZ() {
        return this.getPosition().getZ();
    }

    default public double getYaw() {
        return this.getOrientation().getYaw();
    }

    default public double getPitch() {
        return this.getOrientation().getPitch();
    }

    default public double getRoll() {
        return this.getOrientation().getRoll();
    }

    default public boolean containsNaN() {
        return this.getOrientation().containsNaN() || this.getPosition().containsNaN();
    }

    default public void get(Tuple3DBasics positionToPack, Orientation3DBasics orientationToPack) {
        positionToPack.set((Tuple3DReadOnly)this.getPosition());
        orientationToPack.set((Orientation3DReadOnly)this.getOrientation());
    }

    default public void get(RigidBodyTransformBasics transformToPack) {
        transformToPack.set((Orientation3DReadOnly)this.getOrientation(), (Tuple3DReadOnly)this.getPosition());
    }

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Pose3DReadOnly)) {
            return false;
        }
        Pose3DReadOnly other = (Pose3DReadOnly)geometry;
        return this.getPosition().epsilonEquals((EuclidGeometry)other.getPosition(), epsilon) && this.getOrientation().epsilonEquals((EuclidGeometry)other.getOrientation(), epsilon);
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Pose3DReadOnly)) {
            return false;
        }
        Pose3DReadOnly other = (Pose3DReadOnly)geometry;
        return this.getPosition().equals((EuclidGeometry)other.getPosition()) && this.getOrientation().equals((EuclidGeometry)other.getOrientation());
    }

    default public String toString(String format) {
        return EuclidGeometryIOTools.getPose3DString(format, this);
    }
}

