/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public interface Pose3DBasics
extends Pose3DReadOnly,
Transformable,
Clearable,
RigidBodyTransformBasics {
    default public void setX(double x) {
        this.getPosition().setX(x);
    }

    default public void setY(double y) {
        this.getPosition().setY(y);
    }

    default public void setZ(double z) {
        this.getPosition().setZ(z);
    }

    public Point3DBasics getPosition();

    public QuaternionBasics getOrientation();

    default public Point3DBasics getTranslation() {
        return this.getPosition();
    }

    default public QuaternionBasics getRotation() {
        return this.getOrientation();
    }

    default public void set(double x, double y, double z, double yaw, double pitch, double roll) {
        this.getPosition().set(x, y, z);
        this.getOrientation().setYawPitchRoll(yaw, pitch, roll);
    }

    default public void set(Pose2DReadOnly pose2DReadOnly) {
        this.getPosition().set((Tuple2DReadOnly)pose2DReadOnly.getPosition(), 0.0);
        this.getOrientation().set(pose2DReadOnly.getOrientation());
    }

    default public void set(Pose3DReadOnly other) {
        this.getPosition().set((Tuple3DReadOnly)other.getPosition());
        this.getOrientation().set(other.getOrientation());
    }

    default public void set(RigidBodyTransformReadOnly rigidBodyTransform) {
        this.getPosition().set(rigidBodyTransform.getTranslation());
        this.getOrientation().set(rigidBodyTransform.getRotation());
    }

    default public void set(Tuple3DReadOnly position, Orientation3DReadOnly orientation) {
        this.getOrientation().set(orientation);
        this.getPosition().set(position);
    }

    @Override
    default public boolean containsNaN() {
        return this.getOrientation().containsNaN() || this.getPosition().containsNaN();
    }

    default public void setToNaN() {
        this.getOrientation().setToNaN();
        this.getPosition().setToNaN();
    }

    default public void setToZero() {
        this.getOrientation().setToZero();
        this.getPosition().setToZero();
    }

    default public void interpolate(Pose3DReadOnly other, double alpha) {
        this.getPosition().interpolate((Tuple3DReadOnly)other.getPosition(), alpha);
        this.getOrientation().interpolate(other.getOrientation(), alpha);
    }

    default public void interpolate(Pose3DReadOnly pose1, Pose3DReadOnly pose2, double alpha) {
        this.getPosition().interpolate((Tuple3DReadOnly)pose1.getPosition(), (Tuple3DReadOnly)pose2.getPosition(), alpha);
        this.getOrientation().interpolate(pose1.getOrientation(), pose2.getOrientation(), alpha);
    }

    default public void prependTranslation(double x, double y, double z) {
        this.getPosition().add(x, y, z);
    }

    default public void prependTranslation(Tuple3DReadOnly translation) {
        this.prependTranslation(translation.getX(), translation.getY(), translation.getZ());
    }

    default public void prependRotation(Orientation3DReadOnly rotation) {
        rotation.transform((Tuple3DBasics)this.getPosition());
        rotation.transform((Orientation3DBasics)this.getOrientation());
    }

    default public void prependYawRotation(double yaw) {
        RotationMatrixTools.applyYawRotation((double)yaw, (Tuple3DReadOnly)this.getPosition(), (Tuple3DBasics)this.getPosition());
        this.getOrientation().prependYawRotation(yaw);
    }

    default public void prependPitchRotation(double pitch) {
        RotationMatrixTools.applyPitchRotation((double)pitch, (Tuple3DReadOnly)this.getPosition(), (Tuple3DBasics)this.getPosition());
        this.getOrientation().prependPitchRotation(pitch);
    }

    default public void prependRollRotation(double roll) {
        RotationMatrixTools.applyRollRotation((double)roll, (Tuple3DReadOnly)this.getPosition(), (Tuple3DBasics)this.getPosition());
        this.getOrientation().prependRollRotation(roll);
    }

    default public void prependTransform(RigidBodyTransformReadOnly transform) {
        this.applyTransform((Transform)transform);
    }

    default public void appendTranslation(double x, double y, double z) {
        double thisX = this.getX();
        double thisY = this.getY();
        double thisZ = this.getZ();
        this.getPosition().set(x, y, z);
        this.getOrientation().transform((Tuple3DBasics)this.getPosition());
        this.getPosition().add(thisX, thisY, thisZ);
    }

    default public void appendTranslation(Tuple3DReadOnly translation) {
        this.appendTranslation(translation.getX(), translation.getY(), translation.getZ());
    }

    default public void appendRotation(Orientation3DReadOnly orientation) {
        this.getOrientation().append(orientation);
    }

    default public void appendYawRotation(double yaw) {
        this.getOrientation().appendYawRotation(yaw);
    }

    default public void appendPitchRotation(double pitch) {
        this.getOrientation().appendPitchRotation(pitch);
    }

    default public void appendRollRotation(double roll) {
        this.getOrientation().appendRollRotation(roll);
    }

    default public void appendTransform(RigidBodyTransformReadOnly transform) {
        QuaternionTools.addTransform((QuaternionReadOnly)this.getOrientation(), (Tuple3DReadOnly)transform.getTranslation(), (Tuple3DBasics)this.getPosition());
        this.getOrientation().append(transform.getRotation());
    }

    default public void applyTransform(Transform transform) {
        transform.transform(this.getPosition());
        transform.transform((Orientation3DBasics)this.getOrientation());
    }

    default public void applyInverseTransform(Transform transform) {
        transform.inverseTransform(this.getPosition());
        transform.inverseTransform((Orientation3DBasics)this.getOrientation());
    }
}

