/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation2DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface Pose2DBasics
extends Pose2DReadOnly,
Clearable,
Transformable {
    default public void setX(double x) {
        this.getPosition().setX(x);
    }

    default public void setY(double y) {
        this.getPosition().setY(y);
    }

    default public void setYaw(double yaw) {
        this.getOrientation().setYaw(yaw);
    }

    public Point2DBasics getPosition();

    public Orientation2DBasics getOrientation();

    @Override
    default public boolean containsNaN() {
        return Pose2DReadOnly.super.containsNaN();
    }

    default public void setToZero() {
        this.getPosition().setToZero();
        this.getOrientation().setToZero();
    }

    default public void setToNaN() {
        this.getPosition().setToNaN();
        this.getOrientation().setToNaN();
    }

    default public void set(Pose2DReadOnly other) {
        this.getPosition().set((Tuple2DReadOnly)other.getPosition());
        this.getOrientation().set(other.getOrientation());
    }

    default public void set(Pose3DReadOnly pose3DReadOnly) {
        this.getPosition().set((Tuple3DReadOnly)pose3DReadOnly.getPosition());
        this.getOrientation().set((Orientation3DReadOnly)pose3DReadOnly.getOrientation());
    }

    default public void set(double x, double y, double yaw) {
        this.getPosition().set(x, y);
        this.getOrientation().setYaw(yaw);
    }

    default public void set(Tuple2DReadOnly position, double yaw) {
        this.getPosition().set(position);
        this.getOrientation().setYaw(yaw);
    }

    default public void set(Tuple2DReadOnly position, Orientation2DReadOnly orientation) {
        this.getPosition().set(position);
        this.getOrientation().set(orientation);
    }

    default public void set(RigidBodyTransformReadOnly rigidBodyTransform) {
        this.set(rigidBodyTransform, true);
    }

    default public void set(RigidBodyTransformReadOnly rigidBodyTransform, boolean checkIsTransform2D) {
        if (checkIsTransform2D) {
            rigidBodyTransform.checkIfRotation2D();
        }
        this.getPosition().set(rigidBodyTransform.getTranslation());
        this.getOrientation().set(rigidBodyTransform.getRotation());
    }

    default public void interpolate(Pose2DReadOnly other, double alpha) {
        this.getPosition().interpolate((Tuple2DReadOnly)other.getPosition(), alpha);
        this.getOrientation().interpolate(other.getOrientation(), alpha);
    }

    default public void interpolate(Pose2DReadOnly pose1, Pose2DReadOnly pose2, double alpha) {
        this.getPosition().interpolate((Tuple2DReadOnly)pose1.getPosition(), (Tuple2DReadOnly)pose2.getPosition(), alpha);
        this.getOrientation().interpolate(pose1.getOrientation(), pose2.getOrientation(), alpha);
    }

    default public void prependTranslation(double x, double y) {
        this.getPosition().add(x, y);
    }

    default public void prependTranslation(Tuple2DReadOnly translation) {
        this.prependTranslation(translation.getX(), translation.getY());
    }

    default public void prependRotation(double yaw) {
        RotationMatrixTools.applyYawRotation((double)yaw, (Tuple2DReadOnly)this.getPosition(), (Tuple2DBasics)this.getPosition());
        this.getOrientation().add(yaw);
    }

    default public void prependRotation(Orientation2DReadOnly orientation) {
        this.prependRotation(orientation.getYaw());
    }

    default public void appendTranslation(double x, double y) {
        double thisX = this.getPosition().getX();
        double thisY = this.getPosition().getY();
        this.getPosition().set(x, y);
        this.getOrientation().transform((Tuple2DBasics)this.getPosition());
        this.getPosition().add(thisX, thisY);
    }

    default public void appendTranslation(Tuple2DReadOnly translation) {
        this.appendTranslation(translation.getX(), translation.getY());
    }

    default public void appendRotation(double yaw) {
        this.getOrientation().add(yaw);
    }

    default public void appendRotation(Orientation2DReadOnly orientation) {
        this.appendRotation(orientation.getYaw());
    }

    default public void applyTransform(Transform transform) {
        this.getPosition().applyTransform(transform);
        this.getOrientation().applyTransform(transform);
    }

    default public void applyInverseTransform(Transform transform) {
        this.getPosition().applyInverseTransform(transform);
        this.getOrientation().applyInverseTransform(transform);
    }
}

