/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.tools;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.ObjDoubleConsumer;
import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class EuclidGeometryFactories {
    public static BoundingBox2DReadOnly newLinkedBoundingBox2DReadOnly(final Point2DReadOnly minPoint, final Point2DReadOnly maxPoint) {
        return new BoundingBox2DReadOnly(){

            @Override
            public Point2DReadOnly getMinPoint() {
                return minPoint;
            }

            @Override
            public Point2DReadOnly getMaxPoint() {
                return maxPoint;
            }

            public boolean equals(Object object) {
                if (object instanceof BoundingBox2DReadOnly) {
                    return this.equals((BoundingBox2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidGeometryIOTools.getBoundingBox2DString(this);
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)minPoint, (Object)maxPoint);
            }
        };
    }

    public static BoundingBox3DReadOnly newLinkedBoundingBox3DReadOnly(final Point3DReadOnly minPoint, final Point3DReadOnly maxPoint) {
        return new BoundingBox3DReadOnly(){

            @Override
            public Point3DReadOnly getMinPoint() {
                return minPoint;
            }

            @Override
            public Point3DReadOnly getMaxPoint() {
                return maxPoint;
            }

            public boolean equals(Object object) {
                if (object instanceof BoundingBox3DReadOnly) {
                    return this.equals((BoundingBox3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidGeometryIOTools.getBoundingBox3DString(this);
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)minPoint, (Object)maxPoint);
            }
        };
    }

    public static BoundingBox2DBasics newLinkedBoundingBox2DBasics(final Point2DBasics minPoint, final Point2DBasics maxPoint) {
        return new BoundingBox2DBasics(){

            @Override
            public Point2DBasics getMinPoint() {
                return minPoint;
            }

            @Override
            public Point2DBasics getMaxPoint() {
                return maxPoint;
            }

            public boolean equals(Object object) {
                if (object instanceof BoundingBox2DReadOnly) {
                    return this.equals((BoundingBox2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidGeometryIOTools.getBoundingBox2DString(this);
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)minPoint, (Object)maxPoint);
            }
        };
    }

    public static BoundingBox3DBasics newLinkedBoundingBox3DBasics(final Point3DBasics minPoint, final Point3DBasics maxPoint) {
        return new BoundingBox3DBasics(){

            @Override
            public Point3DBasics getMinPoint() {
                return minPoint;
            }

            @Override
            public Point3DBasics getMaxPoint() {
                return maxPoint;
            }

            public boolean equals(Object object) {
                if (object instanceof BoundingBox3DReadOnly) {
                    return this.equals((BoundingBox3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidGeometryIOTools.getBoundingBox3DString(this);
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)minPoint, (Object)maxPoint);
            }
        };
    }

    public static BoundingBox2DBasics newObservableBoundingBox2DBasics(BoundingBoxChangedListener<Axis2D> valueChangedListener, BiConsumer<Axis2D, Bound> valueAccessedListener) {
        return EuclidGeometryFactories.newObservableBoundingBox2DBasics(valueChangedListener, valueAccessedListener, new BoundingBox2D());
    }

    public static BoundingBox2DBasics newObservableBoundingBox2DBasics(final BoundingBoxChangedListener<Axis2D> valueChangedListener, final BiConsumer<Axis2D, Bound> valueAccessedListener, final BoundingBox2DBasics source) {
        return new BoundingBox2DBasics(){
            private final Point2DBasics minPoint;
            private final Point2DBasics maxPoint;
            private boolean isNotifying = false;
            {
                ObjDoubleConsumer<Axis2D> minChangedListener = this.toPoint2DValueChangedListener(valueChangedListener, Bound.MIN);
                Consumer<Axis2D> minAccessedListener = this.toPoint2DValueAccessedListener(valueAccessedListener, Bound.MIN);
                ObjDoubleConsumer<Axis2D> maxChangedListener = this.toPoint2DValueChangedListener(valueChangedListener, Bound.MAX);
                Consumer<Axis2D> maxAccessedListener = this.toPoint2DValueAccessedListener(valueAccessedListener, Bound.MAX);
                this.minPoint = EuclidCoreFactories.newObservablePoint2DBasics(minChangedListener, minAccessedListener, (Point2DBasics)source.getMinPoint());
                this.maxPoint = EuclidCoreFactories.newObservablePoint2DBasics(maxChangedListener, maxAccessedListener, (Point2DBasics)source.getMaxPoint());
            }

            private ObjDoubleConsumer<Axis2D> toPoint2DValueChangedListener(BoundingBoxChangedListener<Axis2D> valueChangedListener2, Bound bound) {
                if (valueChangedListener2 == null) {
                    return null;
                }
                return (axis, newValue) -> {
                    if (this.isNotifying) {
                        return;
                    }
                    this.isNotifying = true;
                    valueChangedListener2.changed((Axis2D)axis, bound, newValue);
                    this.isNotifying = false;
                };
            }

            private Consumer<Axis2D> toPoint2DValueAccessedListener(BiConsumer<Axis2D, Bound> valueAccessedListener2, Bound bound) {
                if (valueAccessedListener2 == null) {
                    return null;
                }
                return axis -> {
                    if (this.isNotifying) {
                        return;
                    }
                    this.isNotifying = true;
                    valueAccessedListener2.accept((Axis2D)axis, bound);
                    this.isNotifying = false;
                };
            }

            @Override
            public Point2DBasics getMinPoint() {
                return this.minPoint;
            }

            @Override
            public Point2DBasics getMaxPoint() {
                return this.maxPoint;
            }

            public boolean equals(Object object) {
                if (object instanceof BoundingBox2DReadOnly) {
                    return this.equals((BoundingBox2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidGeometryIOTools.getBoundingBox2DString(this);
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)this.minPoint, (Object)this.maxPoint);
            }
        };
    }

    public static BoundingBox3DBasics newObservableBoundingBox3DBasics(BoundingBoxChangedListener<Axis3D> valueChangedListener, BiConsumer<Axis3D, Bound> valueAccessedListener) {
        return EuclidGeometryFactories.newObservableBoundingBox3DBasics(valueChangedListener, valueAccessedListener, new BoundingBox3D());
    }

    public static BoundingBox3DBasics newObservableBoundingBox3DBasics(final BoundingBoxChangedListener<Axis3D> valueChangedListener, final BiConsumer<Axis3D, Bound> valueAccessedListener, final BoundingBox3DBasics source) {
        return new BoundingBox3DBasics(){
            private final Point3DBasics minPoint;
            private final Point3DBasics maxPoint;
            private boolean isNotifying = false;
            {
                ObjDoubleConsumer<Axis3D> minChangedListener = this.toPoint3DValueChangedListener(valueChangedListener, Bound.MIN);
                Consumer<Axis3D> minAccessedListener = this.toPoint3DValueAccessedListener(valueAccessedListener, Bound.MIN);
                ObjDoubleConsumer<Axis3D> maxChangedListener = this.toPoint3DValueChangedListener(valueChangedListener, Bound.MAX);
                Consumer<Axis3D> maxAccessedListener = this.toPoint3DValueAccessedListener(valueAccessedListener, Bound.MAX);
                this.minPoint = EuclidCoreFactories.newObservablePoint3DBasics(minChangedListener, minAccessedListener, (Point3DBasics)source.getMinPoint());
                this.maxPoint = EuclidCoreFactories.newObservablePoint3DBasics(maxChangedListener, maxAccessedListener, (Point3DBasics)source.getMaxPoint());
            }

            private ObjDoubleConsumer<Axis3D> toPoint3DValueChangedListener(BoundingBoxChangedListener<Axis3D> valueChangedListener2, Bound bound) {
                if (valueChangedListener2 == null) {
                    return null;
                }
                return (axis, newValue) -> {
                    if (this.isNotifying) {
                        return;
                    }
                    this.isNotifying = true;
                    valueChangedListener2.changed((Axis3D)axis, bound, newValue);
                    this.isNotifying = false;
                };
            }

            private Consumer<Axis3D> toPoint3DValueAccessedListener(BiConsumer<Axis3D, Bound> valueAccessedListener2, Bound bound) {
                if (valueAccessedListener2 == null) {
                    return null;
                }
                return axis -> {
                    if (this.isNotifying) {
                        return;
                    }
                    this.isNotifying = true;
                    valueAccessedListener2.accept((Axis3D)axis, bound);
                    this.isNotifying = false;
                };
            }

            @Override
            public Point3DBasics getMinPoint() {
                return this.minPoint;
            }

            @Override
            public Point3DBasics getMaxPoint() {
                return this.maxPoint;
            }

            public boolean equals(Object object) {
                if (object instanceof BoundingBox3DReadOnly) {
                    return this.equals((BoundingBox3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidGeometryIOTools.getBoundingBox3DString(this);
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)this.minPoint, (Object)this.maxPoint);
            }
        };
    }

    @FunctionalInterface
    public static interface BoundingBoxChangedListener<Axis> {
        public void changed(Axis var1, Bound var2, double var3);
    }
}

