/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import java.util.List;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.exceptions.EmptyPolygonException;
import us.ihmc.euclid.geometry.exceptions.OutdatedPolygonException;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DBasics;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public interface ConvexPolygon2DReadOnly
extends Vertex2DSupplier {
    public boolean isClockwiseOrdered();

    public boolean isUpToDate();

    default public void checkIfUpToDate() {
        if (!this.isUpToDate()) {
            throw new OutdatedPolygonException("Call the update method before doing any other calculation!");
        }
    }

    @Override
    public int getNumberOfVertices();

    public List<? extends Point2DReadOnly> getVertexBufferView();

    default public List<? extends Point2DReadOnly> getPolygonVerticesView() {
        return this.getVertexBufferView().subList(0, this.getNumberOfVertices());
    }

    @Override
    default public boolean isEmpty() {
        return this.getNumberOfVertices() == 0;
    }

    default public void checkNonEmpty() {
        if (this.isEmpty()) {
            throw new EmptyPolygonException("This polygon has no vertex.");
        }
    }

    default public void checkIndexInBoundaries(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("vertexIndex < 0");
        }
        if (index >= this.getNumberOfVertices()) {
            throw new IndexOutOfBoundsException("vertexIndex >= numberOfVertices. numberOfVertices = " + this.getNumberOfVertices());
        }
    }

    default public boolean containsNaN() {
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            if (!this.getVertexBufferView().get(i).containsNaN()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public Point2DReadOnly getVertex(int index) {
        this.checkIfUpToDate();
        this.checkNonEmpty();
        this.checkIndexInBoundaries(index);
        return this.getVertexBufferView().get(index);
    }

    default public Point2DReadOnly getNextVertex(int index) {
        return this.getVertex(this.getNextVertexIndex(index));
    }

    default public Point2DReadOnly getPreviousVertex(int index) {
        return this.getVertex(this.getPreviousVertexIndex(index));
    }

    default public Point2DReadOnly getVertexCCW(int index) {
        return this.getVertex(this.getNumberOfVertices() - 1 - index);
    }

    default public Point2DReadOnly getNextVertexCCW(int index) {
        return this.getVertexCCW(this.getNextVertexIndex(index));
    }

    default public Point2DReadOnly getPreviousVertexCCW(int index) {
        return this.getVertexCCW(this.getPreviousVertexIndex(index));
    }

    default public int getNextVertexIndex(int currentVertexIndex) {
        this.checkIfUpToDate();
        this.checkIndexInBoundaries(currentVertexIndex);
        this.checkNonEmpty();
        if (currentVertexIndex < this.getNumberOfVertices() - 1) {
            return currentVertexIndex + 1;
        }
        return 0;
    }

    default public int getPreviousVertexIndex(int currentVertexIndex) {
        this.checkIfUpToDate();
        this.checkIndexInBoundaries(currentVertexIndex);
        this.checkNonEmpty();
        if (currentVertexIndex < 1) {
            return this.getNumberOfVertices() - 1;
        }
        return currentVertexIndex - 1;
    }

    public double getArea();

    public Point2DReadOnly getCentroid();

    public BoundingBox2DReadOnly getBoundingBox();

    default public double getBoundingBoxRangeX() {
        BoundingBox2DReadOnly boundingBox = this.getBoundingBox();
        return boundingBox.getMaxX() - boundingBox.getMinX();
    }

    default public double getBoundingBoxRangeY() {
        BoundingBox2DReadOnly boundingBox = this.getBoundingBox();
        return boundingBox.getMaxPoint().getY() - boundingBox.getMinPoint().getY();
    }

    default public double getMaxX() {
        return this.getBoundingBox().getMaxX();
    }

    default public double getMinX() {
        return this.getBoundingBox().getMinX();
    }

    default public double getMaxY() {
        return this.getBoundingBox().getMaxY();
    }

    default public double getMinY() {
        return this.getBoundingBox().getMinY();
    }

    default public void getPointsInClockwiseOrder(int startIndexInclusive, int endIndexInclusive, List<Point2DReadOnly> pointListToPack) {
        this.checkIfUpToDate();
        this.checkIndexInBoundaries(startIndexInclusive);
        this.checkIndexInBoundaries(endIndexInclusive);
        int index = startIndexInclusive;
        while (true) {
            pointListToPack.add(this.getVertex(index));
            if (index == endIndexInclusive) break;
            index = this.getNextVertexIndex(index);
        }
    }

    default public void getVerticesInClockwiseOrder(int startIndexInclusive, int endIndexInclusive, ConvexPolygon2DBasics polygonToPack) {
        this.checkIfUpToDate();
        this.checkIndexInBoundaries(startIndexInclusive);
        this.checkIndexInBoundaries(endIndexInclusive);
        int index = startIndexInclusive;
        while (true) {
            polygonToPack.addVertex(this.getVertex(index));
            if (index == endIndexInclusive) break;
            index = this.getNextVertexIndex(index);
        }
    }

    default public boolean isPointInside(double x, double y) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D(x, y, this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered());
    }

    default public boolean isPointInside(double x, double y, double epsilon) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D(x, y, this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered(), epsilon);
    }

    default public boolean isPointInside(Point2DReadOnly point) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D(point, this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered());
    }

    default public boolean isPointInside(Point2DReadOnly point, double epsilon) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D(point, this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered(), epsilon);
    }

    default public boolean getClosestPointWithRay(Line2DReadOnly ray, Point2DBasics closestPointToPack) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D(ray.getPoint(), (Vector2DReadOnly)ray.getDirection(), this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered(), closestPointToPack);
    }

    default public Point2DBasics getClosestPointWithRay(Line2DReadOnly ray) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D(ray.getPoint(), (Vector2DReadOnly)ray.getDirection(), this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered());
    }

    default public double distance(Point2DReadOnly point) {
        return Math.max(0.0, this.signedDistance(point));
    }

    default public double signedDistance(Point2DReadOnly point) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D(point, this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered());
    }

    default public boolean orthogonalProjection(Point2DBasics pointToProject) {
        return this.orthogonalProjection((Point2DReadOnly)pointToProject, pointToProject);
    }

    default public boolean orthogonalProjection(Point2DReadOnly pointToProject, Point2DBasics projectionToPack) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.orthogonalProjectionOnConvexPolygon2D(pointToProject, this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered(), projectionToPack);
    }

    default public Point2DBasics orthogonalProjectionCopy(Point2DReadOnly pointToProject) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.orthogonalProjectionOnConvexPolygon2D(pointToProject, this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered());
    }

    default public int lineOfSightStartIndex(Point2DReadOnly observer) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.lineOfSightStartIndex(observer, this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered());
    }

    default public int lineOfSightEndIndex(Point2DReadOnly observer) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.lineOfSightEndIndex(observer, this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered());
    }

    default public int[] lineOfSightIndices(Point2DReadOnly observer) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.lineOfSightIndices(observer, this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered());
    }

    default public boolean lineOfSightStartVertex(Point2DReadOnly observer, Point2DBasics startVertexToPack) {
        int lineOfSightStartIndex = this.lineOfSightStartIndex(observer);
        if (lineOfSightStartIndex == -1) {
            return false;
        }
        startVertexToPack.set((Tuple2DReadOnly)this.getVertex(lineOfSightStartIndex));
        return true;
    }

    default public boolean lineOfSightEndVertex(Point2DReadOnly observer, Point2DBasics endVertexToPack) {
        this.checkIfUpToDate();
        int lineOfSightEndIndex = this.lineOfSightEndIndex(observer);
        if (lineOfSightEndIndex == -1) {
            return false;
        }
        endVertexToPack.set((Tuple2DReadOnly)this.getVertex(lineOfSightEndIndex));
        return true;
    }

    default public Point2DBasics lineOfSightStartVertexCopy(Point2DReadOnly observer) {
        Point2D startVertex = new Point2D();
        boolean success = this.lineOfSightStartVertex(observer, (Point2DBasics)startVertex);
        return success ? startVertex : null;
    }

    default public Point2DBasics lineOfSightEndVertexCopy(Point2DReadOnly observer) {
        Point2D endVertex = new Point2D();
        boolean success = this.lineOfSightEndVertex(observer, (Point2DBasics)endVertex);
        return success ? endVertex : null;
    }

    default public Point2DBasics[] lineOfSightVertices(Point2DReadOnly observer) {
        Point2DBasics startVertex = this.lineOfSightStartVertexCopy(observer);
        Point2DBasics endVertex = this.lineOfSightEndVertexCopy(observer);
        if (startVertex == null || endVertex == null) {
            return null;
        }
        return new Point2DBasics[]{startVertex, endVertex};
    }

    default public boolean canObserverSeeEdge(int edgeIndex, Point2DReadOnly observer) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.canObserverSeeEdge(edgeIndex, observer, this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered());
    }

    default public boolean pointIsOnPerimeter(Point2DReadOnly point) {
        return Math.abs(this.signedDistance(point)) < 1.0E-10;
    }

    default public int intersectionWith(Line2DReadOnly line, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D(line.getPoint(), (Vector2DReadOnly)line.getDirection(), this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public Point2DBasics[] intersectionWith(Line2DReadOnly line) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D(line.getPoint(), (Vector2DReadOnly)line.getDirection(), this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered());
    }

    default public int intersectionWithRay(Line2DReadOnly ray, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.intersectionBetweenRay2DAndConvexPolygon2D(ray.getPoint(), (Vector2DReadOnly)ray.getDirection(), this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public Point2DBasics[] intersectionWithRay(Line2DReadOnly ray) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.intersectionBetweenRay2DAndConvexPolygon2D(ray.getPoint(), (Vector2DReadOnly)ray.getDirection(), this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered());
    }

    default public int intersectionWith(LineSegment2DReadOnly lineSegment2D, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D(lineSegment2D.getFirstEndpoint(), lineSegment2D.getSecondEndpoint(), this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public Point2DBasics[] intersectionWith(LineSegment2DReadOnly lineSegment2D) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D(lineSegment2D.getFirstEndpoint(), lineSegment2D.getSecondEndpoint(), this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered());
    }

    default public int getClosestEdgeIndex(Point2DReadOnly point) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.closestEdgeIndexToPoint2D(point, this.getVertexBufferView(), this.getNumberOfVertices(), this.isClockwiseOrdered());
    }

    default public boolean getClosestEdge(Point2DReadOnly point, LineSegment2DBasics closestEdgeToPack) {
        int edgeIndex = this.getClosestEdgeIndex(point);
        if (edgeIndex == -1) {
            return false;
        }
        this.getEdge(edgeIndex, closestEdgeToPack);
        return true;
    }

    default public LineSegment2DBasics getClosestEdgeCopy(Point2DReadOnly point) {
        LineSegment2D closestEdge = new LineSegment2D();
        if (this.getClosestEdge(point, closestEdge)) {
            return closestEdge;
        }
        return null;
    }

    default public int getClosestVertexIndex(Point2DReadOnly point) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.closestVertexIndexToPoint2D(point, this.getVertexBufferView(), this.getNumberOfVertices());
    }

    default public boolean getClosestVertex(Point2DReadOnly point, Point2DBasics vertexToPack) {
        int vertexIndex = this.getClosestVertexIndex(point);
        if (vertexIndex == -1) {
            return false;
        }
        vertexToPack.set((Tuple2DReadOnly)this.getVertex(vertexIndex));
        return true;
    }

    default public Point2DBasics getClosestVertexCopy(Point2DReadOnly point) {
        int vertexIndex = this.getClosestVertexIndex(point);
        if (vertexIndex == -1) {
            return null;
        }
        return new Point2D((Tuple2DReadOnly)this.getVertex(vertexIndex));
    }

    default public int getClosestVertexIndex(Line2DReadOnly line) {
        this.checkIfUpToDate();
        return EuclidGeometryPolygonTools.closestVertexIndexToLine2D(line.getPoint(), (Vector2DReadOnly)line.getDirection(), this.getVertexBufferView(), this.getNumberOfVertices());
    }

    default public boolean getClosestVertex(Line2DReadOnly line, Point2DBasics vertexToPack) {
        int vertexIndex = this.getClosestVertexIndex(line);
        if (vertexIndex == -1) {
            return false;
        }
        vertexToPack.set((Tuple2DReadOnly)this.getVertex(vertexIndex));
        return true;
    }

    default public Point2DBasics getClosestVertexCopy(Line2DReadOnly line) {
        int vertexIndex = this.getClosestVertexIndex(line);
        if (vertexIndex == -1) {
            return null;
        }
        return new Point2D((Tuple2DReadOnly)this.getVertex(vertexIndex));
    }

    default public void getEdge(int edgeIndex, LineSegment2DBasics edgeToPack) {
        edgeToPack.set(this.getVertex(edgeIndex), this.getNextVertex(edgeIndex));
    }

    default public ConvexPolygon2DBasics translateCopy(Tuple2DReadOnly translation) {
        ConvexPolygon2D copy = new ConvexPolygon2D(this);
        copy.translate(translation);
        return copy;
    }

    default public boolean equals(ConvexPolygon2DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            Point2DReadOnly otherVertex;
            Point2DReadOnly thisVertex = this.getVertexBufferView().get(i);
            if (thisVertex.equals((Tuple2DReadOnly)(otherVertex = other.getVertexBufferView().get(i)))) continue;
            return false;
        }
        return true;
    }

    default public boolean epsilonEquals(ConvexPolygon2DReadOnly other, double epsilon) {
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int i = 0; i < other.getNumberOfVertices(); ++i) {
            Point2DReadOnly otherVertex;
            Point2DReadOnly thisVertex = this.getVertexBufferView().get(i);
            if (thisVertex.epsilonEquals((Tuple2DReadOnly)(otherVertex = other.getVertexBufferView().get(i)), epsilon)) continue;
            return false;
        }
        return true;
    }

    default public boolean geometricallyEquals(ConvexPolygon2DReadOnly other, double epsilon) {
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        boolean sameClockwiseDirection = this.isClockwiseOrdered() == other.isClockwiseOrdered();
        int indexOfClosestOtherPoint = other.getClosestVertexIndex(this.getVertex(0));
        for (int thisPointIndex = 0; thisPointIndex < this.getNumberOfVertices(); ++thisPointIndex) {
            Point2DReadOnly otherVertex;
            int otherPointIndex = sameClockwiseDirection ? (indexOfClosestOtherPoint + thisPointIndex) % this.getNumberOfVertices() : (this.getNumberOfVertices() + indexOfClosestOtherPoint - thisPointIndex) % this.getNumberOfVertices();
            Point2DReadOnly thisVertex = this.getVertexBufferView().get(thisPointIndex);
            if (thisVertex.geometricallyEquals(otherVertex = other.getVertexBufferView().get(otherPointIndex), epsilon)) continue;
            return false;
        }
        return true;
    }
}

