/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.exceptions.BoundingBoxException;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface BoundingBox3DReadOnly {
    public Point3DReadOnly getMinPoint();

    public Point3DReadOnly getMaxPoint();

    default public double getMinX() {
        return this.getMinPoint().getX();
    }

    default public double getMinY() {
        return this.getMinPoint().getY();
    }

    default public double getMinZ() {
        return this.getMinPoint().getZ();
    }

    default public double getMaxX() {
        return this.getMaxPoint().getX();
    }

    default public double getMaxY() {
        return this.getMaxPoint().getY();
    }

    default public double getMaxZ() {
        return this.getMaxPoint().getZ();
    }

    default public void checkBounds() {
        if (this.getMinX() > this.getMaxX()) {
            throw new BoundingBoxException("minPoint.getX() > maxPoint.getX(): " + this.getMinX() + ">" + this.getMaxX());
        }
        if (this.getMinY() > this.getMaxY()) {
            throw new BoundingBoxException("minPoint.getY() > maxPoint.getY(): " + this.getMinY() + ">" + this.getMaxY());
        }
        if (this.getMinZ() > this.getMaxZ()) {
            throw new BoundingBoxException("minPoint.getZ() > maxPoint.getZ(): " + this.getMinZ() + ">" + this.getMaxZ());
        }
    }

    default public boolean containsNaN() {
        return this.getMinPoint().containsNaN() || this.getMaxPoint().containsNaN();
    }

    default public void getCenterPoint(Point3DBasics centerToPack) {
        centerToPack.interpolate((Tuple3DReadOnly)this.getMinPoint(), (Tuple3DReadOnly)this.getMaxPoint(), 0.5);
    }

    default public void getPointGivenParameters(double xParameter, double yParameter, double zParameter, Point3DBasics pointToPack) {
        pointToPack.set(this.getMinX() + xParameter * (this.getMaxX() - this.getMinX()), this.getMinY() + yParameter * (this.getMaxY() - this.getMinY()), this.getMinZ() + zParameter * (this.getMaxZ() - this.getMinZ()));
    }

    default public double getDiagonalLengthSquared() {
        return this.getMinPoint().distanceSquared(this.getMaxPoint());
    }

    default public boolean isInsideExclusive(Point3DReadOnly query) {
        return this.isInsideExclusive(query.getX(), query.getY(), query.getZ());
    }

    default public boolean isInsideExclusive(double x, double y, double z) {
        if (x <= this.getMinX() || x >= this.getMaxX()) {
            return false;
        }
        if (y <= this.getMinY() || y >= this.getMaxY()) {
            return false;
        }
        return !(z <= this.getMinZ()) && !(z >= this.getMaxZ());
    }

    default public boolean isInsideInclusive(Point3DReadOnly query) {
        return this.isInsideInclusive(query.getX(), query.getY(), query.getZ());
    }

    default public boolean isInsideInclusive(double x, double y, double z) {
        if (x < this.getMinX() || x > this.getMaxX()) {
            return false;
        }
        if (y < this.getMinY() || y > this.getMaxY()) {
            return false;
        }
        return !(z < this.getMinZ()) && !(z > this.getMaxZ());
    }

    default public boolean isInsideEpsilon(Point3DReadOnly query, double epsilon) {
        return this.isInsideEpsilon(query.getX(), query.getY(), query.getZ(), epsilon);
    }

    default public boolean isInsideEpsilon(double x, double y, double z, double epsilon) {
        if (x <= this.getMinX() - epsilon || x >= this.getMaxX() + epsilon) {
            return false;
        }
        if (y <= this.getMinY() - epsilon || y >= this.getMaxY() + epsilon) {
            return false;
        }
        return !(z <= this.getMinZ() - epsilon) && !(z >= this.getMaxZ() + epsilon);
    }

    default public boolean isXYInsideExclusive(Point2DReadOnly query) {
        return this.isXYInsideExclusive(query.getX(), query.getY());
    }

    default public boolean isXYInsideExclusive(double x, double y) {
        if (x <= this.getMinX() || x >= this.getMaxX()) {
            return false;
        }
        return !(y <= this.getMinY()) && !(y >= this.getMaxY());
    }

    default public boolean isXYInsideInclusive(Point2DReadOnly query) {
        return this.isXYInsideInclusive(query.getX(), query.getY());
    }

    default public boolean isXYInsideInclusive(double x, double y) {
        if (x < this.getMinX() || x > this.getMaxX()) {
            return false;
        }
        return !(y < this.getMinY()) && !(y > this.getMaxY());
    }

    default public boolean isXYInsideEpsilon(Point2DReadOnly query, double epsilon) {
        return this.isXYInsideEpsilon(query.getX(), query.getY(), epsilon);
    }

    default public boolean isXYInsideEpsilon(double x, double y, double epsilon) {
        if (x <= this.getMinX() - epsilon || x >= this.getMaxX() + epsilon) {
            return false;
        }
        return !(y <= this.getMinY() - epsilon) && !(y >= this.getMaxY() + epsilon);
    }

    default public boolean intersectsExclusive(BoundingBox3DReadOnly other) {
        if (other.getMinX() >= this.getMaxX() || other.getMaxX() <= this.getMinX()) {
            return false;
        }
        if (other.getMinY() >= this.getMaxY() || other.getMaxY() <= this.getMinY()) {
            return false;
        }
        return !(other.getMinZ() >= this.getMaxZ()) && !(other.getMaxZ() <= this.getMinZ());
    }

    default public boolean intersectsInclusive(BoundingBox3DReadOnly other) {
        if (other.getMinX() > this.getMaxX() || other.getMaxX() < this.getMinX()) {
            return false;
        }
        if (other.getMinY() > this.getMaxY() || other.getMaxY() < this.getMinY()) {
            return false;
        }
        return !(other.getMinZ() > this.getMaxZ()) && !(other.getMaxZ() < this.getMinZ());
    }

    default public boolean intersectsEpsilon(BoundingBox3DReadOnly other, double epsilon) {
        if (other.getMinX() >= this.getMaxX() + epsilon || other.getMaxX() <= this.getMinX() - epsilon) {
            return false;
        }
        if (other.getMinY() >= this.getMaxY() + epsilon || other.getMaxY() <= this.getMinY() - epsilon) {
            return false;
        }
        return !(other.getMinZ() >= this.getMaxZ() + epsilon) && !(other.getMaxZ() <= this.getMinZ() - epsilon);
    }

    default public boolean intersectsExclusiveInXYPlane(BoundingBox2DReadOnly other) {
        if (other.getMinX() >= this.getMaxX() || other.getMaxX() <= this.getMinX()) {
            return false;
        }
        return !(other.getMinY() >= this.getMaxY()) && !(other.getMaxY() <= this.getMinY());
    }

    default public boolean intersectsInclusiveInXYPlane(BoundingBox2DReadOnly other) {
        if (other.getMinX() > this.getMaxX() || other.getMaxX() < this.getMinX()) {
            return false;
        }
        return !(other.getMinY() > this.getMaxY()) && !(other.getMaxY() < this.getMinY());
    }

    default public boolean intersectsEpsilonInXYPlane(BoundingBox2DReadOnly other, double epsilon) {
        if (other.getMinX() >= this.getMaxX() + epsilon || other.getMaxX() <= this.getMinX() - epsilon) {
            return false;
        }
        return !(other.getMinY() >= this.getMaxY() + epsilon) && !(other.getMaxY() <= this.getMinY() - epsilon);
    }

    default public boolean doesIntersectWithLine3D(Line3DReadOnly line3D) {
        return this.doesIntersectWithLine3D(line3D.getPoint(), (Vector3DReadOnly)line3D.getDirection());
    }

    default public boolean doesIntersectWithLine3D(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection) {
        return this.intersectionWithLine3D(pointOnLine, lineDirection, null, null) > 0;
    }

    default public boolean doesIntersectWithLineSegment3D(LineSegment3DReadOnly lineSegment3D) {
        return this.doesIntersectWithLineSegment3D(lineSegment3D.getFirstEndpoint(), lineSegment3D.getSecondEndpoint());
    }

    default public boolean doesIntersectWithLineSegment3D(Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd) {
        return this.intersectionWithLineSegment3D(lineSegmentStart, lineSegmentEnd, null, null) > 0;
    }

    default public boolean doesIntersectWithRay3D(Point3DReadOnly rayOrigin, Vector3DReadOnly rayDirection) {
        return this.intersectionWithRay3D(rayOrigin, rayDirection, null, null) > 0;
    }

    default public int intersectionWithLine3D(Line3DReadOnly line3D, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return this.intersectionWithLine3D(line3D.getPoint(), (Vector3DReadOnly)line3D.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLine3D(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D(this.getMinPoint(), this.getMaxPoint(), pointOnLine, lineDirection, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment3D(LineSegment3DReadOnly lineSegment3D, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return this.intersectionWithLineSegment3D(lineSegment3D.getFirstEndpoint(), lineSegment3D.getSecondEndpoint(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment3D(Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D(this.getMinPoint(), this.getMaxPoint(), lineSegmentStart, lineSegmentEnd, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithRay3D(Point3DReadOnly rayOrigin, Vector3DReadOnly rayDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D(this.getMinPoint(), this.getMaxPoint(), rayOrigin, rayDirection, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public boolean epsilonEquals(BoundingBox3DReadOnly other, double epsilon) {
        return this.getMinPoint().epsilonEquals((Tuple3DReadOnly)other.getMinPoint(), epsilon) && this.getMaxPoint().epsilonEquals((Tuple3DReadOnly)other.getMaxPoint(), epsilon);
    }

    default public boolean geometricallyEquals(BoundingBox3DReadOnly other, double epsilon) {
        return this.getMinPoint().geometricallyEquals(other.getMinPoint(), epsilon) && this.getMaxPoint().geometricallyEquals(other.getMaxPoint(), epsilon);
    }

    default public boolean equals(BoundingBox3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getMinPoint().equals((Tuple3DReadOnly)other.getMinPoint()) && this.getMaxPoint().equals((Tuple3DReadOnly)other.getMaxPoint());
    }
}

