/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.GeometricallyComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class BoundingBox3D
implements BoundingBox3DBasics,
EpsilonComparable<BoundingBox3D>,
Settable<BoundingBox3D>,
GeometricallyComparable<BoundingBox3D> {
    private final Point3D minPoint = new Point3D();
    private final Point3D maxPoint = new Point3D();

    public static BoundingBox3D createUsingCenterAndPlusMinusVector(Point3DReadOnly center, Tuple3DReadOnly plusMinusTuple) {
        BoundingBox3D boundingBox3D = new BoundingBox3D();
        boundingBox3D.set(center, (Vector3DReadOnly)new Vector3D(plusMinusTuple));
        return boundingBox3D;
    }

    public static BoundingBox3D union(BoundingBox3DReadOnly boundingBoxOne, BoundingBox3DReadOnly boundingBoxTwo) {
        BoundingBox3D union = new BoundingBox3D();
        union.combine(boundingBoxOne, boundingBoxTwo);
        return union;
    }

    public BoundingBox3D() {
        this.setToNaN();
    }

    public BoundingBox3D(Point3DReadOnly min, Point3DReadOnly max) {
        this.set(min, max);
    }

    public BoundingBox3D(BoundingBox3DReadOnly other) {
        this.set(other);
    }

    public BoundingBox3D(double[] min, double[] max) {
        this.set(min, max);
    }

    public BoundingBox3D(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void set(BoundingBox3D other) {
        BoundingBox3DBasics.super.set(other);
    }

    @Override
    public Point3DBasics getMinPoint() {
        return this.minPoint;
    }

    @Override
    public Point3DBasics getMaxPoint() {
        return this.maxPoint;
    }

    public boolean epsilonEquals(BoundingBox3D other, double epsilon) {
        return BoundingBox3DBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(BoundingBox3D other, double epsilon) {
        return BoundingBox3DBasics.super.geometricallyEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof BoundingBox3DReadOnly) {
            return this.equals((BoundingBox3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.minPoint, (Object)this.maxPoint);
    }

    public String toString() {
        return EuclidGeometryIOTools.getBoundingBox3DString(this);
    }
}

