/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.exceptions.BoundingBoxException;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public interface BoundingBox2DReadOnly {
    public Point2DReadOnly getMinPoint();

    public Point2DReadOnly getMaxPoint();

    default public double getMinX() {
        return this.getMinPoint().getX();
    }

    default public double getMinY() {
        return this.getMinPoint().getY();
    }

    default public double getMaxX() {
        return this.getMaxPoint().getX();
    }

    default public double getMaxY() {
        return this.getMaxPoint().getY();
    }

    default public void checkBounds() {
        if (this.getMinX() > this.getMaxX()) {
            throw new BoundingBoxException("minPoint.getX() > maxPoint.getX(): " + this.getMinX() + ">" + this.getMaxX());
        }
        if (this.getMinY() > this.getMaxY()) {
            throw new BoundingBoxException("minPoint.getY() > maxPoint.getY(): " + this.getMinY() + ">" + this.getMaxY());
        }
    }

    default public boolean containsNaN() {
        return this.getMinPoint().containsNaN() || this.getMaxPoint().containsNaN();
    }

    default public void getCenterPoint(Point2DBasics centerToPack) {
        this.checkBounds();
        centerToPack.interpolate((Tuple2DReadOnly)this.getMinPoint(), (Tuple2DReadOnly)this.getMaxPoint(), 0.5);
    }

    default public void getPointGivenParameters(double xParameter, double yParameter, Point2DBasics pointToPack) {
        this.checkBounds();
        pointToPack.set(this.getMinX() + xParameter * (this.getMaxX() - this.getMinX()), this.getMinY() + yParameter * (this.getMaxY() - this.getMinY()));
    }

    default public double getDiagonalLengthSquared() {
        this.checkBounds();
        return this.getMinPoint().distanceSquared(this.getMaxPoint());
    }

    default public boolean isInsideExclusive(Point2DReadOnly query) {
        return this.isInsideExclusive(query.getX(), query.getY());
    }

    default public boolean isInsideExclusive(double x, double y) {
        this.checkBounds();
        if (x <= this.getMinX() || x >= this.getMaxX()) {
            return false;
        }
        return !(y <= this.getMinY()) && !(y >= this.getMaxY());
    }

    default public boolean isInsideInclusive(Point2DReadOnly query) {
        return this.isInsideInclusive(query.getX(), query.getY());
    }

    default public boolean isInsideInclusive(double x, double y) {
        this.checkBounds();
        if (x < this.getMinX() || x > this.getMaxX()) {
            return false;
        }
        return !(y < this.getMinY()) && !(y > this.getMaxY());
    }

    default public boolean isInsideEpsilon(Point2DReadOnly query, double epsilon) {
        return this.isInsideEpsilon(query.getX(), query.getY(), epsilon);
    }

    default public boolean isInsideEpsilon(double x, double y, double epsilon) {
        this.checkBounds();
        if (x <= this.getMinX() - epsilon || x >= this.getMaxX() + epsilon) {
            return false;
        }
        return !(y <= this.getMinY() - epsilon) && !(y >= this.getMaxY() + epsilon);
    }

    default public boolean intersectsExclusive(BoundingBox2DReadOnly other) {
        this.checkBounds();
        if (other.getMinX() >= this.getMaxX() || other.getMaxX() <= this.getMinX()) {
            return false;
        }
        return !(other.getMinY() >= this.getMaxY()) && !(other.getMaxY() <= this.getMinY());
    }

    default public boolean intersectsInclusive(BoundingBox2DReadOnly other) {
        this.checkBounds();
        if (other.getMinX() > this.getMaxX() || other.getMaxX() < this.getMinX()) {
            return false;
        }
        return !(other.getMinY() > this.getMaxY()) && !(other.getMaxY() < this.getMinY());
    }

    default public boolean intersectsEpsilon(BoundingBox2DReadOnly other, double epsilon) {
        this.checkBounds();
        if (other.getMinX() >= this.getMaxX() + epsilon || other.getMaxX() <= this.getMinX() - epsilon) {
            return false;
        }
        return !(other.getMinY() >= this.getMaxY() + epsilon) && !(other.getMaxY() <= this.getMinY() - epsilon);
    }

    default public boolean doesIntersectWithLine2D(Line2DReadOnly line2D) {
        return this.doesIntersectWithLine2D(line2D.getPoint(), (Vector2DReadOnly)line2D.getDirection());
    }

    default public boolean doesIntersectWithLine2D(Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        return this.intersectionWithLine2D(pointOnLine, lineDirection, null, null) > 0;
    }

    default public boolean doesIntersectWithLineSegment2D(LineSegment2DReadOnly lineSegment2D) {
        return this.doesIntersectWithLineSegment2D(lineSegment2D.getFirstEndpoint(), lineSegment2D.getSecondEndpoint());
    }

    default public boolean doesIntersectWithLineSegment2D(Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        return this.intersectionWithLineSegment2D(lineSegmentStart, lineSegmentEnd, null, null) > 0;
    }

    default public boolean doesIntersectWithRay2D(Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection) {
        return this.intersectionWithRay2D(rayOrigin, rayDirection, null, null) > 0;
    }

    default public int intersectionWithLine2D(Line2DReadOnly line2D, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        return this.intersectionWithLine2D(line2D.getPoint(), (Vector2DReadOnly)line2D.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLine2D(Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkBounds();
        return EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D(this.getMinPoint(), this.getMaxPoint(), pointOnLine, lineDirection, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment2D(LineSegment2DReadOnly lineSegment2D, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        return this.intersectionWithLineSegment2D(lineSegment2D.getFirstEndpoint(), lineSegment2D.getSecondEndpoint(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment2D(Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkBounds();
        return EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D(this.getMinPoint(), this.getMaxPoint(), lineSegmentStart, lineSegmentEnd, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithRay2D(Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkBounds();
        return EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D(this.getMinPoint(), this.getMaxPoint(), rayOrigin, rayDirection, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public boolean epsilonEquals(BoundingBox2DReadOnly other, double epsilon) {
        return this.getMinPoint().epsilonEquals((Tuple2DReadOnly)other.getMinPoint(), epsilon) && this.getMaxPoint().epsilonEquals((Tuple2DReadOnly)other.getMaxPoint(), epsilon);
    }

    default public boolean geometricallyEquals(BoundingBox2DReadOnly other, double epsilon) {
        return this.getMinPoint().geometricallyEquals(other.getMinPoint(), epsilon) && this.getMaxPoint().geometricallyEquals(other.getMaxPoint(), epsilon);
    }

    default public boolean equals(BoundingBox2DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getMinPoint().equals((Tuple2DReadOnly)other.getMinPoint()) && this.getMaxPoint().equals((Tuple2DReadOnly)other.getMaxPoint());
    }
}

