/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DBasics;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Line3D
implements Line3DBasics,
GeometryObject<Line3D> {
    private final Point3D point = new Point3D();
    private final UnitVector3D direction = new UnitVector3D((Tuple3DReadOnly)Axis3D.X);

    public Line3D() {
    }

    public Line3D(double pointOnLineX, double pointOnLineY, double pointOnLineZ, double lineDirectionX, double lineDirectionY, double lineDirectionZ) {
        this.set(pointOnLineX, pointOnLineY, pointOnLineZ, lineDirectionX, lineDirectionY, lineDirectionZ);
    }

    public Line3D(Line2DReadOnly line2DReadOnly) {
        this.set(line2DReadOnly);
    }

    public Line3D(Line3DReadOnly other) {
        this.set(other);
    }

    public Line3D(LineSegment2DReadOnly lineSegment2DReadOnly) {
        this.set(lineSegment2DReadOnly);
    }

    public Line3D(LineSegment3DReadOnly lineSegment3DReadOnly) {
        this.set(lineSegment3DReadOnly);
    }

    public Line3D(Point3DReadOnly firstPointOnLine, Point3DReadOnly secondPointOnLine) {
        this.set(firstPointOnLine, secondPointOnLine);
    }

    public Line3D(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection) {
        this.set(pointOnLine, lineDirection);
    }

    @Override
    public UnitVector3DBasics getDirection() {
        return this.direction;
    }

    @Override
    public Point3DBasics getPoint() {
        return this.point;
    }

    public void set(Line3D other) {
        Line3DBasics.super.set(other);
    }

    public boolean epsilonEquals(Line3D other, double epsilon) {
        return Line3DBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(Line3D other, double epsilon) {
        return Line3DBasics.super.geometricallyEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof Line3DReadOnly) {
            return this.equals((Line3DReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return EuclidGeometryIOTools.getLine3DString(this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.point, (Object)this.direction);
    }
}

