/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class FrameVector3D
implements FrameVector3DBasics,
Settable<FrameVector3D> {
    private ReferenceFrame referenceFrame;
    private final Vector3D vector = new Vector3D();

    public FrameVector3D() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameVector3D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameVector3D(ReferenceFrame referenceFrame, double x, double y, double z) {
        this.setIncludingFrame(referenceFrame, x, y, z);
    }

    public FrameVector3D(ReferenceFrame referenceFrame, double[] vectorArray) {
        this.setIncludingFrame(referenceFrame, vectorArray);
    }

    public FrameVector3D(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.setIncludingFrame(referenceFrame, tuple3DReadOnly);
    }

    public FrameVector3D(ReferenceFrame referenceFrame, Tuple2DReadOnly tuple2DReadOnly) {
        this.setIncludingFrame(referenceFrame, tuple2DReadOnly, 0.0);
    }

    public FrameVector3D(FrameTuple2DReadOnly frameTuple2DReadOnly) {
        this.setIncludingFrame(frameTuple2DReadOnly, 0.0);
    }

    public FrameVector3D(FrameTuple3DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(FrameVector3D other) {
        FrameVector3DBasics.super.set((FrameTuple3DReadOnly)other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setX(double x) {
        this.vector.setX(x);
    }

    public void setY(double y) {
        this.vector.setY(y);
    }

    public void setZ(double z) {
        this.vector.setZ(z);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getX() {
        return this.vector.getX();
    }

    public double getY() {
        return this.vector.getY();
    }

    public double getZ() {
        return this.vector.getZ();
    }

    public boolean equals(Object object) {
        if (object instanceof FrameTuple3DReadOnly) {
            return this.equals((EuclidFrameGeometry)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.vector, (Object)this.referenceFrame);
    }
}

