/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.tools.EuclidCoreTestTools;

public class EuclidFrameTestTools {
    private static final String DEFAULT_FORMAT = EuclidCoreTestTools.DEFAULT_FORMAT;

    private EuclidFrameTestTools() {
    }

    public static void assertEquals(EuclidFrameGeometry expected, EuclidFrameGeometry actual, double epsilon) {
        EuclidFrameTestTools.assertEquals(null, expected, actual, epsilon);
    }

    public static void assertEquals(String messagePrefix, EuclidFrameGeometry expected, EuclidFrameGeometry actual, double epsilon) {
        EuclidFrameTestTools.assertEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertEquals(String messagePrefix, EuclidFrameGeometry expected, EuclidFrameGeometry actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)format);
        }
    }

    public static void assertGeometricallyEquals(EuclidFrameGeometry expected, EuclidFrameGeometry actual, double epsilon) {
        EuclidFrameTestTools.assertGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertGeometricallyEquals(String messagePrefix, EuclidFrameGeometry expected, EuclidFrameGeometry actual, double epsilon) {
        EuclidFrameTestTools.assertGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertGeometricallyEquals(String messagePrefix, EuclidFrameGeometry expected, EuclidFrameGeometry actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)format);
        }
        if (!expected.geometricallyEquals(actual, epsilon)) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)format);
        }
    }
}

