/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.orientation.Orientation2D;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.Transform;

public class FrameOrientation2D
implements FrameOrientation2DBasics,
Settable<FrameOrientation2D> {
    private ReferenceFrame referenceFrame;
    private final Orientation2D orientation = new Orientation2D();

    public FrameOrientation2D() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameOrientation2D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameOrientation2D(double yaw) {
        this.setIncludingFrame(ReferenceFrame.getWorldFrame(), yaw);
    }

    public FrameOrientation2D(ReferenceFrame referenceFrame, double yaw) {
        this.setIncludingFrame(referenceFrame, yaw);
    }

    public FrameOrientation2D(Orientation2DReadOnly orientation2DReadOnly) {
        this(ReferenceFrame.getWorldFrame(), orientation2DReadOnly);
    }

    public FrameOrientation2D(ReferenceFrame referenceFrame, Orientation2DReadOnly orientation2DReadOnly) {
        this.setIncludingFrame(referenceFrame, orientation2DReadOnly);
    }

    public FrameOrientation2D(FrameOrientation2DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public FrameOrientation2D(FrameQuaternionReadOnly frameQuaternionReadOnly) {
        this.setIncludingFrame(frameQuaternionReadOnly);
    }

    public void set(FrameOrientation2D other) {
        FrameOrientation2DBasics.super.set(other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setYaw(double yaw) {
        this.orientation.setYaw(yaw);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getYaw() {
        return this.orientation.getYaw();
    }

    public void applyTransform(Transform transform) {
        this.orientation.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.orientation.applyInverseTransform(transform);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameOrientation2DReadOnly) {
            return this.equals((EuclidFrameGeometry)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.orientation, (Object)this.referenceFrame);
    }
}

