/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;

public interface FramePose2DReadOnly
extends Pose2DReadOnly,
EuclidFrameGeometry {
    public FramePoint2DReadOnly getPosition();

    public FrameOrientation2DReadOnly getOrientation();

    default public double getPositionDistance(FramePose2DReadOnly other) {
        return this.getPositionDistance(other.getPosition());
    }

    default public double getPositionDistance(FramePoint2DReadOnly point) {
        return this.getPosition().distance(point);
    }

    default public double getOrientationDistance(FrameOrientation2DReadOnly orientation) {
        return this.getOrientation().distance(orientation);
    }

    default public double getOrientationDistance(FramePose2DReadOnly other) {
        return this.getOrientationDistance(other.getOrientation());
    }

    default public String toString(String format) {
        return EuclidFrameIOTools.getFramePose2DString(format, this);
    }
}

