/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface FrameOrientation2DReadOnly
extends Orientation2DReadOnly,
EuclidFrameGeometry {
    default public double difference(FrameOrientation2DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        return super.difference((Orientation2DReadOnly)other);
    }

    default public double distance(FrameOrientation2DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        return super.distance((Orientation2DReadOnly)other);
    }

    default public void transform(FixedFrameTuple3DBasics tupleToTransform) {
        this.checkReferenceFrameMatch(tupleToTransform);
        super.transform((Tuple3DBasics)tupleToTransform);
    }

    default public void transform(FrameTuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal);
        super.transform((Tuple3DReadOnly)tupleOriginal, tupleTransformed);
    }

    default public void transform(Tuple3DReadOnly tupleOriginal, FixedFrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleTransformed);
        super.transform(tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void transform(Tuple3DReadOnly tupleOriginal, FrameTuple3DBasics tupleTransformed) {
        tupleTransformed.setToZero(this.getReferenceFrame());
        super.transform(tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void transform(FrameTuple3DReadOnly tupleOriginal, FixedFrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal, tupleTransformed);
        super.transform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void transform(FrameTuple3DReadOnly tupleOriginal, FrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal);
        tupleTransformed.setToZero(this.getReferenceFrame());
        super.transform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void transform(FixedFrameTuple2DBasics tupleToTransform) {
        this.checkReferenceFrameMatch(tupleToTransform);
        super.transform((Tuple2DBasics)tupleToTransform);
    }

    default public void transform(FrameTuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal);
        super.transform((Tuple2DReadOnly)tupleOriginal, tupleTransformed);
    }

    default public void transform(Tuple2DReadOnly tupleOriginal, FixedFrameTuple2DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleTransformed);
        super.transform(tupleOriginal, (Tuple2DBasics)tupleTransformed);
    }

    default public void transform(Tuple2DReadOnly tupleOriginal, FrameTuple2DBasics tupleTransformed) {
        tupleTransformed.setToZero(this.getReferenceFrame());
        super.transform(tupleOriginal, (Tuple2DBasics)tupleTransformed);
    }

    default public void transform(FrameTuple2DReadOnly tupleOriginal, FixedFrameTuple2DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal, tupleTransformed);
        super.transform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleTransformed);
    }

    default public void transform(FrameTuple2DReadOnly tupleOriginal, FrameTuple2DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal);
        tupleTransformed.setToZero(this.getReferenceFrame());
        super.transform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleTransformed);
    }

    default public void inverseTransform(FixedFrameTuple3DBasics tupleToTransform) {
        this.checkReferenceFrameMatch(tupleToTransform);
        super.inverseTransform((Tuple3DBasics)tupleToTransform);
    }

    default public void inverseTransform(FrameTuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal);
        super.inverseTransform((Tuple3DReadOnly)tupleOriginal, tupleTransformed);
    }

    default public void inverseTransform(Tuple3DReadOnly tupleOriginal, FixedFrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleTransformed);
        super.inverseTransform(tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void inverseTransform(Tuple3DReadOnly tupleOriginal, FrameTuple3DBasics tupleTransformed) {
        tupleTransformed.setToZero(this.getReferenceFrame());
        super.inverseTransform(tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void inverseTransform(FrameTuple3DReadOnly tupleOriginal, FixedFrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal, tupleTransformed);
        super.inverseTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void inverseTransform(FrameTuple3DReadOnly tupleOriginal, FrameTuple3DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal);
        tupleTransformed.setToZero(this.getReferenceFrame());
        super.inverseTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleTransformed);
    }

    default public void inverseTransform(FixedFrameTuple2DBasics tupleToTransform) {
        this.checkReferenceFrameMatch(tupleToTransform);
        super.inverseTransform((Tuple2DBasics)tupleToTransform);
    }

    default public void inverseTransform(FrameTuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal);
        super.inverseTransform((Tuple2DReadOnly)tupleOriginal, tupleTransformed);
    }

    default public void inverseTransform(FrameTuple2DReadOnly tupleOriginal, FixedFrameTuple2DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal, tupleTransformed);
        super.inverseTransform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleTransformed);
    }

    default public void inverseTransform(FrameTuple2DReadOnly tupleOriginal, FrameTuple2DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleOriginal);
        tupleTransformed.setToZero(this.getReferenceFrame());
        super.inverseTransform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleTransformed);
    }

    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, FixedFrameTuple2DBasics tupleTransformed) {
        this.checkReferenceFrameMatch(tupleTransformed);
        super.inverseTransform(tupleOriginal, (Tuple2DBasics)tupleTransformed);
    }

    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, FrameTuple2DBasics tupleTransformed) {
        tupleTransformed.setToZero(this.getReferenceFrame());
        super.inverseTransform(tupleOriginal, (Tuple2DBasics)tupleTransformed);
    }

    default public String toString(String format) {
        return EuclidFrameIOTools.getFrameOrientation2DString(format, this);
    }
}

