/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface FrameBoundingBox3DReadOnly
extends BoundingBox3DReadOnly,
EuclidFrameGeometry {
    public FramePoint3DReadOnly getMinPoint();

    public FramePoint3DReadOnly getMaxPoint();

    default public void getCenterPoint(FixedFramePoint3DBasics centerToPack) {
        this.checkReferenceFrameMatch(centerToPack);
        super.getCenterPoint((Point3DBasics)centerToPack);
    }

    default public void getCenterPoint(FramePoint3DBasics centerToPack) {
        centerToPack.setReferenceFrame(this.getReferenceFrame());
        super.getCenterPoint((Point3DBasics)centerToPack);
    }

    default public void getPointGivenParameters(double xParameter, double yParameter, double zParameter, FixedFramePoint3DBasics pointToPack) {
        this.checkReferenceFrameMatch(pointToPack);
        super.getPointGivenParameters(xParameter, yParameter, zParameter, (Point3DBasics)pointToPack);
    }

    default public void getPointGivenParameters(double xParameter, double yParameter, double zParameter, FramePoint3DBasics pointToPack) {
        pointToPack.setReferenceFrame(this.getReferenceFrame());
        super.getPointGivenParameters(xParameter, yParameter, zParameter, (Point3DBasics)pointToPack);
    }

    default public boolean isInsideExclusive(FramePoint3DReadOnly query) {
        this.checkReferenceFrameMatch(query);
        return super.isInsideExclusive((Point3DReadOnly)query);
    }

    default public boolean isInsideInclusive(FramePoint3DReadOnly query) {
        this.checkReferenceFrameMatch(query);
        return super.isInsideInclusive((Point3DReadOnly)query);
    }

    default public boolean isInsideEpsilon(FramePoint3DReadOnly query, double epsilon) {
        this.checkReferenceFrameMatch(query);
        return super.isInsideEpsilon((Point3DReadOnly)query, epsilon);
    }

    default public boolean isXYInsideExclusive(FramePoint2DReadOnly query) {
        this.checkReferenceFrameMatch(query);
        return super.isXYInsideExclusive((Point2DReadOnly)query);
    }

    default public boolean isXYInsideInclusive(FramePoint2DReadOnly query) {
        this.checkReferenceFrameMatch(query);
        return super.isXYInsideInclusive((Point2DReadOnly)query);
    }

    default public boolean isXYInsideEpsilon(FramePoint2DReadOnly query, double epsilon) {
        this.checkReferenceFrameMatch(query);
        return super.isXYInsideEpsilon((Point2DReadOnly)query, epsilon);
    }

    default public boolean intersectsExclusive(FrameBoundingBox3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        return super.intersectsExclusive((BoundingBox3DReadOnly)other);
    }

    default public boolean intersectsInclusive(FrameBoundingBox3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        return super.intersectsInclusive((BoundingBox3DReadOnly)other);
    }

    default public boolean intersectsEpsilon(FrameBoundingBox3DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.intersectsEpsilon((BoundingBox3DReadOnly)other, epsilon);
    }

    default public boolean intersectsExclusiveInXYPlane(FrameBoundingBox2DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        return super.intersectsExclusiveInXYPlane((BoundingBox2DReadOnly)other);
    }

    default public boolean intersectsInclusiveInXYPlane(FrameBoundingBox2DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        return super.intersectsInclusiveInXYPlane((BoundingBox2DReadOnly)other);
    }

    default public boolean intersectsEpsilonInXYPlane(FrameBoundingBox2DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.intersectsEpsilonInXYPlane((BoundingBox2DReadOnly)other, epsilon);
    }

    default public boolean doesIntersectWithLine3D(FrameLine3DReadOnly line3D) {
        this.checkReferenceFrameMatch(line3D);
        return super.doesIntersectWithLine3D((Line3DReadOnly)line3D);
    }

    default public boolean doesIntersectWithLine3D(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection) {
        this.checkReferenceFrameMatch(pointOnLine, lineDirection);
        return super.doesIntersectWithLine3D((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
    }

    default public boolean doesIntersectWithLineSegment3D(FrameLineSegment3DReadOnly lineSegment3D) {
        this.checkReferenceFrameMatch(lineSegment3D);
        return super.doesIntersectWithLineSegment3D((LineSegment3DReadOnly)lineSegment3D);
    }

    default public boolean doesIntersectWithLineSegment3D(FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd) {
        this.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        return super.doesIntersectWithLineSegment3D((Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
    }

    default public boolean doesIntersectWithRay3D(FramePoint3DReadOnly rayOrigin, FrameVector3DReadOnly rayDirection) {
        this.checkReferenceFrameMatch(rayOrigin, rayDirection);
        return super.doesIntersectWithRay3D((Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection);
    }

    default public int intersectionWithLine3D(FrameLine3DReadOnly line3D, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(line3D);
        return super.intersectionWithLine3D((Line3DReadOnly)line3D, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLine3D(Line3DReadOnly line3D, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithLine3D(line3D, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLine3D(Line3DReadOnly line3D, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithLine3D(line3D, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLine3D(FrameLine3DReadOnly line3D, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(line3D);
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithLine3D((Line3DReadOnly)line3D, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLine3D(FrameLine3DReadOnly line3D, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(line3D);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithLine3D((Line3DReadOnly)line3D, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLine3D(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(pointOnLine, lineDirection);
        return super.intersectionWithLine3D((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLine3D(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithLine3D(pointOnLine, lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLine3D(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithLine3D(pointOnLine, lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLine3D(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(pointOnLine, lineDirection);
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithLine3D((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLine3D(FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(pointOnLine, lineDirection);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithLine3D((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment3D(FrameLineSegment3DReadOnly lineSegment3D, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegment3D);
        return super.intersectionWithLineSegment3D((LineSegment3DReadOnly)lineSegment3D, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment3D(LineSegment3DReadOnly lineSegment3D, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithLineSegment3D(lineSegment3D, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment3D(LineSegment3DReadOnly lineSegment3D, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithLineSegment3D(lineSegment3D, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment3D(FrameLineSegment3DReadOnly lineSegment3D, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegment3D);
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithLineSegment3D((LineSegment3DReadOnly)lineSegment3D, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment3D(FrameLineSegment3DReadOnly lineSegment3D, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegment3D);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithLineSegment3D((LineSegment3DReadOnly)lineSegment3D, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment3D(FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        return super.intersectionWithLineSegment3D((Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment3D(Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithLineSegment3D(lineSegmentStart, lineSegmentEnd, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment3D(Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithLineSegment3D(lineSegmentStart, lineSegmentEnd, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment3D(FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithLineSegment3D((Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment3D(FramePoint3DReadOnly lineSegmentStart, FramePoint3DReadOnly lineSegmentEnd, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithLineSegment3D((Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithRay3D(FramePoint3DReadOnly rayOrigin, FrameVector3DReadOnly rayDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(rayOrigin, rayDirection);
        return super.intersectionWithRay3D((Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithRay3D(Point3DReadOnly rayOrigin, Vector3DReadOnly rayDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithRay3D(rayOrigin, rayDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithRay3D(Point3DReadOnly rayOrigin, Vector3DReadOnly rayDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithRay3D(rayOrigin, rayDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithRay3D(FramePoint3DReadOnly rayOrigin, FrameVector3DReadOnly rayDirection, FixedFramePoint3DBasics firstIntersectionToPack, FixedFramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(rayOrigin, rayDirection);
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithRay3D((Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithRay3D(FramePoint3DReadOnly rayOrigin, FrameVector3DReadOnly rayDirection, FramePoint3DBasics firstIntersectionToPack, FramePoint3DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(rayOrigin, rayDirection);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithRay3D((Point3DReadOnly)rayOrigin, (Vector3DReadOnly)rayDirection, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
    }

    default public String toString(String format) {
        return EuclidFrameIOTools.getFrameBoundingBox3DString(format, this);
    }
}

