/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface FixedFrameTuple3DBasics
extends FrameTuple3DReadOnly,
Tuple3DBasics {
    default public void set(ReferenceFrame referenceFrame, Tuple2DReadOnly tuple2DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(tuple2DReadOnly);
    }

    default public void set(ReferenceFrame referenceFrame, Tuple2DReadOnly tuple2DReadOnly, double z) {
        this.checkReferenceFrameMatch(referenceFrame);
        super.set(tuple2DReadOnly, z);
    }

    default public void set(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(tuple3DReadOnly);
    }

    default public void set(ReferenceFrame referenceFrame, double x, double y, double z) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(x, y, z);
    }

    default public void set(FrameTuple2DReadOnly frameTuple2DReadOnly) {
        this.set(frameTuple2DReadOnly.getReferenceFrame(), frameTuple2DReadOnly);
    }

    default public void set(FrameTuple2DReadOnly frameTuple2DReadOnly, double z) {
        this.set(frameTuple2DReadOnly.getReferenceFrame(), frameTuple2DReadOnly, z);
    }

    default public void set(FrameTuple3DReadOnly other) {
        this.set(other.getReferenceFrame(), other);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Tuple2DReadOnly tuple2DReadOnly, double z) {
        super.set(tuple2DReadOnly, z);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameTuple2DReadOnly frameTuple2DReadOnly, double z) {
        this.setMatchingFrame(frameTuple2DReadOnly.getReferenceFrame(), frameTuple2DReadOnly, z);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        super.set(tuple3DReadOnly);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setMatchingFrame(FrameTuple3DReadOnly other) {
        this.setMatchingFrame(other.getReferenceFrame(), other);
    }

    default public void setMatchingFrame(ReferenceFrame referenceFrame, double x, double y, double z) {
        super.set(x, y, z);
        referenceFrame.transformFromThisToDesiredFrame(this.getReferenceFrame(), (Transformable)this);
    }

    default public void setAndAbsolute(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        super.setAndAbsolute(tuple3DReadOnly);
    }

    default public void setAndAbsolute(FrameTuple3DReadOnly other) {
        this.setAndAbsolute(other.getReferenceFrame(), other);
    }

    default public void setAndNegate(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        super.setAndNegate(tuple3DReadOnly);
    }

    default public void setAndNegate(FrameTuple3DReadOnly other) {
        this.setAndNegate(other.getReferenceFrame(), other);
    }

    default public void setAndNormalize(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.setAndNormalize(tuple3DReadOnly);
    }

    default public void setAndNormalize(FrameTuple3DReadOnly other) {
        this.setAndNormalize(other.getReferenceFrame(), other);
    }

    default public void setAndScale(double scalar, ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        super.setAndScale(scalar, tuple3DReadOnly);
    }

    default public void setAndScale(double scalar, FrameTuple3DReadOnly other) {
        this.setAndScale(scalar, other.getReferenceFrame(), other);
    }

    default public void setAndClipToMax(double max, ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        super.setAndClipToMax(max, tuple3DReadOnly);
    }

    default public void setAndClipToMax(double max, FrameTuple3DReadOnly other) {
        this.setAndClipToMax(max, other.getReferenceFrame(), other);
    }

    default public void setAndClipToMin(double min, ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        super.setAndClipToMin(min, tuple3DReadOnly);
    }

    default public void setAndClipToMin(double min, FrameTuple3DReadOnly other) {
        this.setAndClipToMin(min, other.getReferenceFrame(), other);
    }

    default public void setAndClipToMinMax(double min, double max, ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.checkReferenceFrameMatch(referenceFrame);
        super.setAndClipToMinMax(min, max, tuple3DReadOnly);
    }

    default public void setAndClipToMinMax(double min, double max, FrameTuple3DReadOnly other) {
        this.setAndClipToMinMax(min, max, other.getReferenceFrame(), other);
    }

    default public void add(FrameTuple3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.add((Tuple3DReadOnly)other);
    }

    default public void add(FrameTuple3DReadOnly frameTuple1, FrameTuple3DReadOnly frameTuple2) {
        this.checkReferenceFrameMatch(frameTuple1, frameTuple2);
        super.add((Tuple3DReadOnly)frameTuple1, (Tuple3DReadOnly)frameTuple2);
    }

    default public void add(FrameTuple3DReadOnly frameTuple1, Tuple3DReadOnly tuple2) {
        this.checkReferenceFrameMatch(frameTuple1);
        super.add((Tuple3DReadOnly)frameTuple1, tuple2);
    }

    default public void add(Tuple3DReadOnly tuple1, FrameTuple3DReadOnly frameTuple2) {
        this.checkReferenceFrameMatch(frameTuple2);
        super.add(tuple1, (Tuple3DReadOnly)frameTuple2);
    }

    default public void sub(FrameTuple3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.sub((Tuple3DReadOnly)other);
    }

    default public void sub(FrameTuple3DReadOnly frameTuple1, FrameTuple3DReadOnly frameTuple2) {
        this.checkReferenceFrameMatch(frameTuple1, frameTuple2);
        super.sub((Tuple3DReadOnly)frameTuple1, (Tuple3DReadOnly)frameTuple2);
    }

    default public void sub(Tuple3DReadOnly tuple1, FrameTuple3DReadOnly frameTuple2) {
        this.checkReferenceFrameMatch(frameTuple2);
        super.sub(tuple1, (Tuple3DReadOnly)frameTuple2);
    }

    default public void sub(FrameTuple3DReadOnly frameTuple1, Tuple3DReadOnly tuple2) {
        this.checkReferenceFrameMatch(frameTuple1);
        super.sub((Tuple3DReadOnly)frameTuple1, tuple2);
    }

    default public void scaleAdd(double scalar, FrameTuple3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.scaleAdd(scalar, (Tuple3DReadOnly)other);
    }

    default public void scaleAdd(double scalar, FrameTuple3DReadOnly frameTuple1, FrameTuple3DReadOnly frameTuple2) {
        this.checkReferenceFrameMatch(frameTuple1, frameTuple2);
        super.scaleAdd(scalar, (Tuple3DReadOnly)frameTuple1, (Tuple3DReadOnly)frameTuple2);
    }

    default public void scaleAdd(double scalar, Tuple3DReadOnly tuple1, FrameTuple3DReadOnly frameTuple2) {
        this.checkReferenceFrameMatch(frameTuple2);
        super.scaleAdd(scalar, tuple1, (Tuple3DReadOnly)frameTuple2);
    }

    default public void scaleAdd(double scalar, FrameTuple3DReadOnly frameTuple1, Tuple3DReadOnly tuple2) {
        this.checkReferenceFrameMatch(frameTuple1);
        super.scaleAdd(scalar, (Tuple3DReadOnly)frameTuple1, tuple2);
    }

    default public void scaleSub(double scalar, FrameTuple3DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        super.scaleSub(scalar, (Tuple3DReadOnly)other);
    }

    default public void scaleSub(double scalar, FrameTuple3DReadOnly frameTuple1, FrameTuple3DReadOnly frameTuple2) {
        this.checkReferenceFrameMatch(frameTuple1, frameTuple2);
        super.scaleSub(scalar, (Tuple3DReadOnly)frameTuple1, (Tuple3DReadOnly)frameTuple2);
    }

    default public void scaleSub(double scalar, Tuple3DReadOnly tuple1, FrameTuple3DReadOnly frameTuple2) {
        this.checkReferenceFrameMatch(frameTuple2);
        super.scaleSub(scalar, tuple1, (Tuple3DReadOnly)frameTuple2);
    }

    default public void scaleSub(double scalar, FrameTuple3DReadOnly frameTuple1, Tuple3DReadOnly frameTuple2) {
        this.checkReferenceFrameMatch(frameTuple1);
        super.scaleSub(scalar, (Tuple3DReadOnly)frameTuple1, frameTuple2);
    }

    default public void interpolate(FrameTuple3DReadOnly other, double alpha) {
        this.checkReferenceFrameMatch(other);
        super.interpolate((Tuple3DReadOnly)other, alpha);
    }

    default public void interpolate(FrameTuple3DReadOnly frameTuple1, FrameTuple3DReadOnly frameTuple2, double alpha) {
        this.checkReferenceFrameMatch(frameTuple1, frameTuple2);
        super.interpolate((Tuple3DReadOnly)frameTuple1, (Tuple3DReadOnly)frameTuple2, alpha);
    }

    default public void interpolate(Tuple3DReadOnly tuple1, FrameTuple3DReadOnly frameTuple2, double alpha) {
        this.checkReferenceFrameMatch(frameTuple2);
        super.interpolate(tuple1, (Tuple3DReadOnly)frameTuple2, alpha);
    }

    default public void interpolate(FrameTuple3DReadOnly frameTuple1, Tuple3DReadOnly tuple2, double alpha) {
        this.checkReferenceFrameMatch(frameTuple1);
        super.interpolate((Tuple3DReadOnly)frameTuple1, tuple2, alpha);
    }
}

