/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.api;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.api.RandomFrameTypeBuilder;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.api.ReflectionBasedBuilder;
import us.ihmc.euclid.referenceFrame.api.ReflectionBasedComparer;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FrameChangeable;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex3DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.interfaces.Transform;

public class EuclidFrameAPITester {
    public static final String READ_ONLY = "ReadOnly";
    public static final String BASICS = "Basics";
    public static final String FRAME = "Frame";
    public static final String FIXED_FRAME = "FixedFrame";
    public static final String MATCHING_FRAME = "MatchingFrame";
    public static final String INCLUDING_FRAME = "IncludingFrame";
    public static final String SET_MATCHING_FRAME = "setMatchingFrame";
    public static final String SET_INCLUDING_FRAME = "setIncludingFrame";
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final boolean DEBUG = false;
    private static final double EPSILON = 1.0E-12;
    private final Random random = new Random(345345L);
    private final ReflectionBasedBuilder reflectionBasedBuilder = new ReflectionBasedBuilder();
    private final Set<Class<?>> framelessTypesWithoutFrameEquivalent = new HashSet();
    private final Map<Class<?>, Class<?>> framelessTypesToFrameTypesTable = new HashMap();
    private final Set<Class<?>> frameReadOnlyTypes = new HashSet();
    private final Set<Class<?>> fixedFrameMutableTypes = new HashSet();
    private final Set<Class<?>> mutableFrameMutableTypes = new HashSet();
    private final Set<Class<?>> exceptionsToIgnore = new HashSet();

    public EuclidFrameAPITester() {
    }

    public EuclidFrameAPITester(EuclidFrameAPIDefaultConfiguration configuration) {
        configuration.configure(this, this.reflectionBasedBuilder);
    }

    public void registerExceptionsToIgnore(Class<?> ... exceptionTypes) {
        for (Class<?> exceptionType : exceptionTypes) {
            this.exceptionsToIgnore.add(exceptionType);
        }
    }

    public void registerFramelessTypesSmart(Class<?> ... framelessMutableTypes) {
        for (Class<?> framelessMutableType : framelessMutableTypes) {
            this.registerFramelessTypeSmart(framelessMutableType);
        }
    }

    public void registerFramelessTypeSmart(Class<?> framelessMutableType) {
        Class<?> framelessReadOnlyType = EuclidFrameAPITester.searchSuperInterfaceFromSimpleName(framelessMutableType.getSimpleName().replace(BASICS, READ_ONLY), framelessMutableType);
        Objects.requireNonNull(framelessReadOnlyType, "Could not find read-only type for " + framelessMutableType.getSimpleName());
        this.framelessTypesWithoutFrameEquivalent.addAll(Arrays.asList(framelessMutableType, framelessReadOnlyType));
    }

    public void registerFramelessReadOnlyType(Class<?> framelessReadOnlyType) {
        this.framelessTypesWithoutFrameEquivalent.add(framelessReadOnlyType);
    }

    public void registerFramelessType(Class<?> framelessMutableType, Class<?> framelessReadOnlyType) {
        this.framelessTypesWithoutFrameEquivalent.addAll(Arrays.asList(framelessMutableType, framelessReadOnlyType));
    }

    public void registerFrameTypesSmart(Class<?> ... mutableFrameMutableTypes) {
        for (Class<?> mutableFrameMutableType : mutableFrameMutableTypes) {
            this.registerFrameTypeSmart(mutableFrameMutableType);
        }
    }

    public void registerFrameTypeSmart(Class<?> mutableFrameMutableType) {
        String mutableFrameMutableTypeName = mutableFrameMutableType.getSimpleName();
        String fixedFrameMutableTypeName = mutableFrameMutableTypeName.replace(FRAME, FIXED_FRAME);
        Class<?> fixedFrameMutableType = EuclidFrameAPITester.searchSuperInterfaceFromSimpleName(fixedFrameMutableTypeName, mutableFrameMutableType);
        String frameReadOnlyTypeName = mutableFrameMutableTypeName.replace(BASICS, READ_ONLY);
        Class<?> frameReadOnlyType = EuclidFrameAPITester.searchSuperInterfaceFromSimpleName(frameReadOnlyTypeName, fixedFrameMutableType);
        String framelessMutableTypeName = mutableFrameMutableTypeName.replace(FRAME, "");
        Class<?> framelessMutableType = EuclidFrameAPITester.searchSuperInterfaceFromSimpleName(framelessMutableTypeName, fixedFrameMutableType);
        String framelessReadOnlyTypeName = framelessMutableType.getSimpleName().replace(BASICS, READ_ONLY);
        Class<?> framelessReadOnlyType = EuclidFrameAPITester.searchSuperInterfaceFromSimpleName(framelessReadOnlyTypeName, framelessMutableType);
        Objects.requireNonNull(fixedFrameMutableType, "Could not find fixed-frame mutable type for " + mutableFrameMutableType.getSimpleName());
        Objects.requireNonNull(frameReadOnlyType, "Could not find frame read-only type for " + mutableFrameMutableType.getSimpleName());
        Objects.requireNonNull(framelessMutableType, "Could not find frameless mutable type for " + mutableFrameMutableType.getSimpleName());
        Objects.requireNonNull(framelessReadOnlyType, "Could not find frameless read-only type for " + mutableFrameMutableType.getSimpleName());
        this.registerFrameType(mutableFrameMutableType, fixedFrameMutableType, frameReadOnlyType, framelessMutableType, framelessReadOnlyType);
    }

    public void registerFrameType(Class<?> mutableFrameMutableType, Class<?> fixedFrameMutableType, Class<?> frameReadOnlyType, Class<?> framelessMutableType, Class<?> framelessReadOnlyType) {
        Objects.requireNonNull(framelessReadOnlyType, "Frameless read-only type cannot be null.");
        Objects.requireNonNull(frameReadOnlyType, "Frame read-only type cannot be null.");
        this.framelessTypesToFrameTypesTable.put(framelessReadOnlyType, frameReadOnlyType);
        Objects.requireNonNull(framelessMutableType, "Frameless mutable type cannot be null.");
        if (fixedFrameMutableType != null) {
            this.framelessTypesToFrameTypesTable.put(framelessMutableType, fixedFrameMutableType);
        } else if (mutableFrameMutableType != null) {
            this.framelessTypesToFrameTypesTable.put(framelessMutableType, mutableFrameMutableType);
        } else {
            throw new NullPointerException("Either fixedFrameMutableType or mutableFrameMutableType has to be not null.");
        }
        this.frameReadOnlyTypes.add(frameReadOnlyType);
        if (fixedFrameMutableType != null) {
            this.fixedFrameMutableTypes.add(fixedFrameMutableType);
        }
        if (mutableFrameMutableType != null) {
            this.mutableFrameMutableTypes.add(mutableFrameMutableType);
        }
    }

    public void registerReadOnlyFrameTypeSmart(Class<?> ... frameReadOnlyTypes) {
        for (Class<?> frameReadOnlyType : frameReadOnlyTypes) {
            this.registerReadOnlyFrameTypeSmart(frameReadOnlyType);
        }
    }

    public void registerReadOnlyFrameTypeSmart(Class<?> frameReadOnlyType) {
        Class<?> framelessReadOnlyType = EuclidFrameAPITester.searchSuperInterfaceFromSimpleName(frameReadOnlyType.getSimpleName().replace(FRAME, ""), frameReadOnlyType);
        Objects.requireNonNull(framelessReadOnlyType, "Could not find frameless read-only type for " + frameReadOnlyType.getSimpleName());
        this.framelessTypesToFrameTypesTable.put(framelessReadOnlyType, frameReadOnlyType);
        this.frameReadOnlyTypes.add(frameReadOnlyType);
    }

    public ReflectionBasedBuilder getReflectionBasedBuilder() {
        return this.reflectionBasedBuilder;
    }

    public void assertOverloadingWithFrameObjects(Class<?> typeWithFrameMethods, Class<?> typeWithFramelessMethods, boolean assertAllCombinations) {
        this.assertOverloadingWithFrameObjects(typeWithFrameMethods, typeWithFramelessMethods, assertAllCombinations, 1);
    }

    public void assertOverloadingWithFrameObjects(Class<?> typeWithFrameMethods, Class<?> typeWithFramelessMethods, boolean assertAllCombinations, int minNumberOfFramelessArguments) {
        this.assertOverloadingWithFrameObjects(typeWithFrameMethods, typeWithFramelessMethods, assertAllCombinations, minNumberOfFramelessArguments, m -> true);
    }

    public static Predicate<Method> methodFilterFromSignature(Collection<MethodSignature> signaturesToIgnore) {
        List filters = signaturesToIgnore.stream().map(EuclidFrameAPITester::methodFilterFromSignature).collect(Collectors.toList());
        return method -> filters.stream().allMatch(filter -> filter.test(method));
    }

    public static Predicate<Method> methodFilterFromSignature(MethodSignature signatureToIgnore) {
        return method -> {
            if (!signatureToIgnore.getName().equals(method.getName())) {
                return true;
            }
            return !Arrays.equals(method.getParameterTypes(), signatureToIgnore.toParameterTypeArray());
        };
    }

    public void assertOverloadingWithFrameObjects(Class<?> typeWithFrameMethods, Class<?> typeWithFramelessMethods, boolean assertAllCombinations, int minNumberOfFramelessArguments, Predicate<Method> framelessMethodFilter) {
        Predicate<Method> filter = framelessMethodFilter.and(this.atLeastNFramelessParameters(minNumberOfFramelessArguments));
        List framelessSignatures = Stream.of(typeWithFramelessMethods.getMethods()).filter(filter).map(MethodSignature::new).collect(Collectors.toList());
        for (MethodSignature framelessSignature : framelessSignatures) {
            List<MethodSignature> expectedMethodSignatures = this.createExpectedMethodSignaturesWithFrameArgument(framelessSignature, assertAllCombinations);
            for (MethodSignature expectedMethodSignature : expectedMethodSignatures) {
                this.assertMethodOverloadedWithSpecificSignature(typeWithFrameMethods, typeWithFramelessMethods, framelessSignature, expectedMethodSignature);
            }
        }
    }

    private void assertMethodOverloadedWithSpecificSignature(Class<?> typeWithOverloadingMethods, Class<?> typeWithOriginalMethods, MethodSignature originalSignature, MethodSignature overloadingSignature) throws SecurityException {
        try {
            Method overloadingMethod = typeWithOverloadingMethods.getMethod(originalSignature.getName(), overloadingSignature.toParameterTypeArray());
            Class<?> originalReturnType = originalSignature.getReturnType();
            Class<?> overloadingReturnType = overloadingMethod.getReturnType();
            if (originalReturnType == null != (overloadingReturnType == null)) {
                Object message = "Inconsistency found in the return type.";
                message = (String)message + "\nOriginal    method: " + originalSignature.getMethodSimpleName();
                message = (String)message + "\nOverloading method: " + MethodSignature.getMethodSimpleName(overloadingMethod);
                message = (String)message + "\nOriginal type declaring method: " + typeWithOriginalMethods.getSimpleName();
                message = (String)message + "\nType overloading original     : " + typeWithOverloadingMethods.getSimpleName();
                throw new AssertionError(message);
            }
            if (overloadingReturnType.equals(originalReturnType) || overloadingReturnType == this.findCorrespondingFrameType(originalReturnType)) {
                return;
            }
            if (overloadingReturnType.isAssignableFrom(this.findCorrespondingFrameType(originalReturnType))) {
                String message = "Unexpected return type: expected: " + this.findCorrespondingFrameType(originalReturnType).getSimpleName() + ", actual: " + overloadingReturnType.getSimpleName();
                message = message + "\nOriginal    method: " + originalSignature.getMethodSimpleName();
                message = message + "\nOverloading method: " + MethodSignature.getMethodSimpleName(overloadingMethod);
                message = message + "\nOriginal type declaring method: " + typeWithOriginalMethods.getSimpleName();
                message = message + "\nType overloading original     : " + typeWithOverloadingMethods.getSimpleName();
                throw new AssertionError((Object)message);
            }
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("The original method in " + typeWithOriginalMethods.getSimpleName() + ":\n" + originalSignature.getMethodSimpleName() + "\nis not properly overloaded, expected to find in " + typeWithOverloadingMethods.getSimpleName() + ":\n" + overloadingSignature.getMethodSimpleName()));
        }
    }

    public void assertAPIDeclareMatchingFrameSetters(Class<?> typeWithFrameMethods, Class<?> typeWithFramelessMethods, Predicate<Method> framelessMethodFilter) {
        Predicate<Method> filter = framelessMethodFilter.and(this.atLeastNFramelessParameters(1)).and(m -> m.getName().equals("set"));
        List framelessSignatures = Stream.of(typeWithFramelessMethods.getMethods()).filter(filter).map(MethodSignature::new).collect(Collectors.toList());
        for (MethodSignature framelessSetterSignature : framelessSignatures) {
            List<MethodSignature> expectedSetMatchingFrameSignatures = this.createExpectedSetMatchingFrameSignatures(framelessSetterSignature);
            for (MethodSignature expectedSetMatchingFrameSignature : expectedSetMatchingFrameSignatures) {
                try {
                    Method setMatchingFrameMethod = typeWithFrameMethods.getMethod(expectedSetMatchingFrameSignature.getName(), expectedSetMatchingFrameSignature.toParameterTypeArray());
                    Class<?> originalReturnType = framelessSetterSignature.getReturnType();
                    Class<?> overloadingReturnType = setMatchingFrameMethod.getReturnType();
                    if (originalReturnType == null && overloadingReturnType != null) {
                        Object message = "Inconsistency found in the return type.";
                        message = (String)message + "\nOriginal setter: " + framelessSetterSignature.getMethodSimpleName();
                        message = (String)message + "\nCorresponding setMatchingFrame: " + MethodSignature.getMethodSimpleName(setMatchingFrameMethod);
                        message = (String)message + "\nOriginal type declaring method: " + typeWithFramelessMethods.getSimpleName();
                        message = (String)message + "\nType declaring setMatchingFrame: " + typeWithFrameMethods.getSimpleName();
                        throw new AssertionError(message);
                    }
                    if (overloadingReturnType.equals(originalReturnType)) {
                        return;
                    }
                    if (overloadingReturnType.isAssignableFrom(this.findCorrespondingFrameType(originalReturnType))) {
                        throw new AssertionError((Object)("Unexpected return type: expected: " + this.findCorrespondingFrameType(originalReturnType).getSimpleName() + ", actual: " + overloadingReturnType.getSimpleName()));
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)("Could not find setMatchingFrame correspond to the original setter in " + typeWithFramelessMethods.getSimpleName() + ":\n" + framelessSetterSignature.getMethodSimpleName() + "\nExpected to find in " + typeWithFrameMethods.getSimpleName() + ":\n" + expectedSetMatchingFrameSignature.getMethodSimpleName()));
                }
            }
        }
    }

    private List<MethodSignature> createExpectedSetMatchingFrameSignatures(MethodSignature framelessSetterSignature) {
        assert (framelessSetterSignature.getName().equals("set"));
        ArrayList<MethodSignature> signatures = new ArrayList<MethodSignature>();
        MethodSignature expectedSetMatchingFrameSignature = new MethodSignature(framelessSetterSignature);
        expectedSetMatchingFrameSignature.setName(SET_MATCHING_FRAME);
        expectedSetMatchingFrameSignature.addParameterType(0, ReferenceFrame.class);
        signatures.add(expectedSetMatchingFrameSignature);
        expectedSetMatchingFrameSignature = new MethodSignature(framelessSetterSignature);
        expectedSetMatchingFrameSignature.setName(SET_MATCHING_FRAME);
        for (int i = 0; i < expectedSetMatchingFrameSignature.getParameterCount(); ++i) {
            Class<?> parameterType = expectedSetMatchingFrameSignature.getParameterType(i);
            if (!this.isFramelessTypeWithFrameEquivalent(parameterType)) continue;
            expectedSetMatchingFrameSignature.setParameterType(i, this.findCorrespondingFrameType(parameterType));
        }
        signatures.add(expectedSetMatchingFrameSignature);
        return signatures;
    }

    public void assertSetMatchingFramePreserveFunctionality(RandomFrameTypeBuilder frameTypeBuilder, int numberOfIterations) {
        this.assertSetMatchingFramePreserveFunctionality(frameTypeBuilder, m -> true, numberOfIterations);
    }

    public void assertSetMatchingFramePreserveFunctionality(RandomFrameTypeBuilder frameTypeBuilder, Predicate<Method> methodFilter, int numberOfIterations) {
        Class<?> frameType = frameTypeBuilder.newInstance(this.random, worldFrame).getClass();
        Predicate<Method> filter = methodFilter.and(m -> m.getName().equals(SET_MATCHING_FRAME));
        List frameMethods = Stream.of(frameType.getMethods()).filter(filter).collect(Collectors.toList());
        for (Method matchingFrameMethod : frameMethods) {
            try {
                ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame("frameA", this.random, worldFrame);
                ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame("frameB", this.random, worldFrame);
                Method setterMethod = this.findCorrespondingSetterToSetMatchingIncludingFrame(frameType, matchingFrameMethod);
                int retryCounter = 0;
                for (int iteration = 0; iteration < numberOfIterations; ++iteration) {
                    Object matchingFrameMethodReturnObject;
                    Object setterMethodReturnObject;
                    Throwable expectedException;
                    ReferenceFrameHolder setterObject;
                    ReferenceFrameHolder matchingFrameObject;
                    Object[] setterMethodParameters;
                    Object[] matchingFrameMethodParameters;
                    block25: {
                        boolean isLastParameterToCheck2DTransform;
                        matchingFrameMethodParameters = this.reflectionBasedBuilder.next(this.random, frameA, matchingFrameMethod.getParameterTypes());
                        setterMethodParameters = this.reflectionBasedBuilder.clone(matchingFrameMethodParameters);
                        if (setterMethodParameters == null) {
                            System.err.println("Cloning parameters failed for\n\t" + MethodSignature.getMethodSimpleName(matchingFrameMethod) + "\n\tparameters: " + EuclidFrameAPITester.getArgumentTypeString(matchingFrameMethodParameters));
                            if (++retryCounter > 50) {
                                throw new AssertionError((Object)"Retried too many times, aborting.");
                            }
                            System.out.println("Retrying.");
                            --iteration;
                            continue;
                        }
                        boolean bl = isLastParameterToCheck2DTransform = this.is2DType(frameType) && matchingFrameMethod.getParameterTypes()[matchingFrameMethod.getParameterCount() - 1] == Boolean.TYPE;
                        if (matchingFrameMethod.getParameterTypes()[0] == ReferenceFrame.class) {
                            matchingFrameMethodParameters[0] = frameA;
                            setterMethodParameters = Arrays.copyOfRange(setterMethodParameters, 1, setterMethodParameters.length);
                        }
                        if (isLastParameterToCheck2DTransform) {
                            setterMethodParameters = Arrays.copyOfRange(setterMethodParameters, 0, setterMethodParameters.length - 1);
                        }
                        matchingFrameObject = frameTypeBuilder.newInstance(this.random, frameB);
                        setterObject = frameTypeBuilder.newInstance(this.random, frameA);
                        expectedException = null;
                        setterMethodReturnObject = null;
                        matchingFrameMethodReturnObject = null;
                        try {
                            if (isLastParameterToCheck2DTransform) {
                                setterMethodReturnObject = EuclidFrameAPITester.invokeMethod(setterObject, setterMethod, setterMethodParameters);
                                Method applyTransformMethod = frameType.getMethod("applyTransform", Transform.class, Boolean.TYPE);
                                EuclidFrameAPITester.invokeMethod(setterObject, applyTransformMethod, frameA.getTransformToDesiredFrame(frameB), matchingFrameMethodParameters[matchingFrameMethodParameters.length - 1]);
                                ((FrameChangeable)setterObject).setReferenceFrame(frameB);
                                break block25;
                            }
                            if (this.is2DType(frameType) && Stream.of(setterMethodParameters).map(Object::getClass).allMatch(this::is3DType)) {
                                setterObject = frameTypeBuilder.newInstance(this.random, frameB);
                                Object[] localSetterMethodParameters = this.reflectionBasedBuilder.clone(setterMethodParameters);
                                if (setterMethodParameters == null) {
                                    System.err.println("Cloning parameters failed for\n\t" + MethodSignature.getMethodSimpleName(matchingFrameMethod) + "\n\tparameters: " + EuclidFrameAPITester.getArgumentTypeString(matchingFrameMethodParameters));
                                    if (++retryCounter > 50) {
                                        throw new AssertionError((Object)"Retried too many times, aborting.");
                                    }
                                    System.out.println("Retrying.");
                                    --iteration;
                                    continue;
                                }
                                for (int paramIndex = 0; paramIndex < localSetterMethodParameters.length; ++paramIndex) {
                                    Object setterMethodParameter = localSetterMethodParameters[paramIndex];
                                    if (setterMethodParameter instanceof FrameVertex3DSupplier) {
                                        FrameVertex3DSupplier asSupplier = (FrameVertex3DSupplier)setterMethodParameter;
                                        ArrayList<FramePoint3D> vertices = new ArrayList<FramePoint3D>();
                                        for (int vertexIndex = 0; vertexIndex < asSupplier.getNumberOfVertices(); ++vertexIndex) {
                                            vertices.add(new FramePoint3D(asSupplier.getVertex(vertexIndex)));
                                        }
                                        vertices.forEach(v -> v.changeFrame(frameB));
                                        localSetterMethodParameters[paramIndex] = FrameVertex3DSupplier.asFrameVertex3DSupplier(vertices);
                                        continue;
                                    }
                                    if (setterMethodParameter instanceof FrameChangeable) {
                                        ((FrameChangeable)setterMethodParameter).changeFrame(frameB);
                                        continue;
                                    }
                                    if (setterMethodParameter instanceof Transformable) {
                                        frameA.transformFromThisToDesiredFrame(frameB, (Transformable)setterMethodParameter);
                                        Object parameterTransformed = setterMethodParameter;
                                        setterMethodParameter = this.reflectionBasedBuilder.next(this.random, frameB, setterMethodParameter.getClass());
                                        Method framelessSetter = this.findFramelessSetter(setterMethodParameter.getClass());
                                        EuclidFrameAPITester.invokeMethod(setterMethodParameter, framelessSetter, parameterTransformed);
                                        continue;
                                    }
                                    throw new IllegalStateException("Unhandled type " + setterMethodParameter.getClass().getSimpleName());
                                }
                                setterMethodReturnObject = EuclidFrameAPITester.invokeMethod(setterObject, setterMethod, localSetterMethodParameters);
                                break block25;
                            }
                            setterMethodReturnObject = EuclidFrameAPITester.invokeMethod(setterObject, setterMethod, setterMethodParameters);
                            if (setterObject instanceof FrameChangeable) {
                                ((FrameChangeable)setterObject).changeFrame(frameB);
                                break block25;
                            }
                            if (setterObject instanceof Transformable) {
                                setterObject.getReferenceFrame().transformFromThisToDesiredFrame(frameB, (Transformable)setterObject);
                                ReferenceFrameHolder objectTransformed = setterObject;
                                setterObject = (ReferenceFrameHolder)this.reflectionBasedBuilder.next(this.random, frameB, setterObject.getClass());
                                Method framelessSetter = this.findFramelessSetter(setterObject.getClass());
                                EuclidFrameAPITester.invokeMethod(setterObject, framelessSetter, objectTransformed);
                                break block25;
                            }
                            throw new IllegalStateException("Unhandled type " + setterObject.getClass().getSimpleName());
                        }
                        catch (Throwable e) {
                            expectedException = e;
                        }
                    }
                    try {
                        matchingFrameMethodReturnObject = EuclidFrameAPITester.invokeMethod(matchingFrameObject, matchingFrameMethod, matchingFrameMethodParameters);
                    }
                    catch (Throwable e) {
                        if (expectedException != null && e.getClass() == expectedException.getClass()) continue;
                        EuclidFrameAPITester.reportInconsistentException(matchingFrameMethod, setterMethod, expectedException, e);
                    }
                    int shift = matchingFrameMethod.getParameterTypes()[0] == ReferenceFrame.class ? 1 : 0;
                    for (int i = 0; i < setterMethodParameters.length; ++i) {
                        Object setterParameter = setterMethodParameters[i];
                        Object matchingFrameParameter = matchingFrameMethodParameters[i + shift];
                        if (ReflectionBasedComparer.epsilonEquals(setterParameter, matchingFrameParameter, 1.0E-12)) continue;
                        this.reportInconsistentArguments(matchingFrameMethod, setterMethod, matchingFrameMethodParameters, setterMethodParameters, setterParameter, matchingFrameParameter);
                    }
                    if (!ReflectionBasedComparer.epsilonEquals(setterMethodReturnObject, matchingFrameMethodReturnObject, 1.0E-12)) {
                        this.reportInconsistentReturnedType(matchingFrameMethod, setterMethod, setterMethodReturnObject, matchingFrameMethodReturnObject);
                    }
                    if (ReflectionBasedComparer.epsilonEquals(setterObject, matchingFrameObject, 1.0E-12)) continue;
                    EuclidFrameAPITester.reportInconsistentObject(matchingFrameMethod, setterObject, matchingFrameObject, setterMethod);
                }
            }
            catch (RuntimeException e) {
                System.err.println("Problem when evaluating the method: " + MethodSignature.getMethodSimpleName(matchingFrameMethod));
                throw e;
            }
        }
    }

    private Method findFramelessSetter(Class<?> frameTypeToSearchFrameSetter) {
        Predicate<Method> filter = m -> m.getName().equals("set") && m.getParameterCount() == 1 && this.isFramelessType(m.getParameterTypes()[0]) && m.getParameterTypes()[0].isAssignableFrom(frameTypeToSearchFrameSetter);
        return Stream.of(frameTypeToSearchFrameSetter.getMethods()).filter(filter).findFirst().orElse(null);
    }

    public void assertSetIncludingFramePreserveFunctionality(RandomFrameTypeBuilder frameTypeBuilder, int numberOfIterations) {
        this.assertSetIncludingFramePreserveFunctionality(frameTypeBuilder, m -> true, numberOfIterations);
    }

    public void assertSetIncludingFramePreserveFunctionality(RandomFrameTypeBuilder frameTypeBuilder, Predicate<Method> methodFilter, int numberOfIterations) {
        Class<?> frameType = frameTypeBuilder.newInstance(this.random, worldFrame).getClass();
        Predicate<Method> filter = methodFilter.and(m -> m.getName().equals(SET_INCLUDING_FRAME));
        List frameMethods = Stream.of(frameType.getMethods()).filter(filter).collect(Collectors.toList());
        for (Method includingFrameMethod : frameMethods) {
            try {
                ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame("frameA", this.random, worldFrame);
                ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame("frameB", this.random, worldFrame);
                Method setterMethod = this.findCorrespondingSetterToSetMatchingIncludingFrame(frameType, includingFrameMethod);
                int retryCounter = 0;
                for (int iteration = 0; iteration < numberOfIterations; ++iteration) {
                    Object[] includingFrameMethodParameters = this.reflectionBasedBuilder.next(this.random, frameA, includingFrameMethod.getParameterTypes());
                    Object[] setterMethodParameters = this.reflectionBasedBuilder.clone(includingFrameMethodParameters);
                    if (setterMethodParameters == null) {
                        System.err.println("Cloning parameters failed for\n\t" + MethodSignature.getMethodSimpleName(includingFrameMethod) + "\n\tparameters: " + EuclidFrameAPITester.getArgumentTypeString(includingFrameMethodParameters));
                        if (++retryCounter > 50) {
                            throw new AssertionError((Object)"Retried too many times, aborting.");
                        }
                        System.out.println("Retrying.");
                        --iteration;
                        continue;
                    }
                    if (includingFrameMethod.getParameterTypes()[0] == ReferenceFrame.class) {
                        includingFrameMethodParameters[0] = frameA;
                        setterMethodParameters = Arrays.copyOfRange(setterMethodParameters, 1, setterMethodParameters.length);
                    }
                    ReferenceFrameHolder includingFrameObject = frameTypeBuilder.newInstance(this.random, frameB);
                    ReferenceFrameHolder setterObject = frameTypeBuilder.newInstance(this.random, frameA);
                    Throwable expectedException = null;
                    Object setterMethodReturnObject = null;
                    Object includingFrameMethodReturnObject = null;
                    try {
                        setterMethodReturnObject = EuclidFrameAPITester.invokeMethod(setterObject, setterMethod, setterMethodParameters);
                    }
                    catch (Throwable e) {
                        expectedException = e;
                    }
                    try {
                        includingFrameMethodReturnObject = EuclidFrameAPITester.invokeMethod(includingFrameObject, includingFrameMethod, includingFrameMethodParameters);
                    }
                    catch (Throwable e) {
                        if (expectedException != null && e.getClass() == expectedException.getClass()) continue;
                        EuclidFrameAPITester.reportInconsistentException(includingFrameMethod, setterMethod, expectedException, e);
                    }
                    int shift = includingFrameMethod.getParameterTypes()[0] == ReferenceFrame.class ? 1 : 0;
                    for (int i = 0; i < setterMethodParameters.length; ++i) {
                        Object setterParameter = setterMethodParameters[i];
                        Object matchingFrameParameter = includingFrameMethodParameters[i + shift];
                        if (ReflectionBasedComparer.epsilonEquals(setterParameter, matchingFrameParameter, 1.0E-12)) continue;
                        this.reportInconsistentArguments(includingFrameMethod, setterMethod, includingFrameMethodParameters, setterMethodParameters, setterParameter, matchingFrameParameter);
                    }
                    if (!ReflectionBasedComparer.epsilonEquals(setterMethodReturnObject, includingFrameMethodReturnObject, 1.0E-12)) {
                        this.reportInconsistentReturnedType(includingFrameMethod, setterMethod, setterMethodReturnObject, includingFrameMethodReturnObject);
                    }
                    if (ReflectionBasedComparer.epsilonEquals(setterObject, includingFrameObject, 1.0E-12)) continue;
                    EuclidFrameAPITester.reportInconsistentObject(includingFrameMethod, setterObject, includingFrameObject, setterMethod);
                }
            }
            catch (RuntimeException e) {
                System.err.println("Problem when evaluating the method: " + MethodSignature.getMethodSimpleName(includingFrameMethod));
                throw e;
            }
        }
    }

    private Method findCorrespondingSetterToSetMatchingIncludingFrame(Class<?> frameType, Method setMatchingIncludingFrameMethod) {
        MethodSignature frameSetterSignature = new MethodSignature(setMatchingIncludingFrameMethod);
        frameSetterSignature.setName("set");
        Class<?> lastParameter = frameSetterSignature.getParameterType(setMatchingIncludingFrameMethod.getParameterCount() - 1);
        if (lastParameter == Boolean.TYPE && this.is2DType(frameType)) {
            frameSetterSignature.removeParameterType(frameSetterSignature.getParameterCount() - 1);
        }
        if (frameSetterSignature.getParameterType(0) == ReferenceFrame.class) {
            frameSetterSignature.removeParameterType(0);
        }
        try {
            return frameType.getMethod(frameSetterSignature.getName(), frameSetterSignature.toParameterTypeArray());
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("Could not find the frameless setter that corresponds to :\n" + MethodSignature.getMethodSimpleName(setMatchingIncludingFrameMethod) + ", declared in " + setMatchingIncludingFrameMethod.getDeclaringClass().getSimpleName() + "\nExpected to find in " + frameType.getSimpleName() + ":\n" + frameSetterSignature.getMethodSimpleName()));
        }
    }

    public void assertStaticMethodsCheckReferenceFrame(Class<?> typeDeclaringStaticMethodsToTest, int numberOfIterations) throws Throwable {
        this.assertStaticMethodsCheckReferenceFrame(typeDeclaringStaticMethodsToTest, m -> true, numberOfIterations);
    }

    /*
     * Unable to fully structure code
     */
    public void assertStaticMethodsCheckReferenceFrame(Class<?> typeDeclaringStaticMethodsToTest, Predicate<Method> methodFilter, int numberOfIterations) throws Throwable {
        filter = methodFilter.and(this.atLeastNFrameParameters(2)).and((Predicate<Method>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$assertStaticMethodsCheckReferenceFrame$12(java.lang.reflect.Method ), (Ljava/lang/reflect/Method;)Z)()).and((Predicate<Method>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$assertStaticMethodsCheckReferenceFrame$13(java.lang.reflect.Method ), (Ljava/lang/reflect/Method;)Z)());
        frameMethods = Stream.of(typeDeclaringStaticMethodsToTest.getMethods()).filter(filter).collect(Collectors.toList());
        methodsWithReturnFrameType = frameMethods.stream().filter((Predicate<Method>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$assertStaticMethodsCheckReferenceFrame$14(java.lang.reflect.Method ), (Ljava/lang/reflect/Method;)Z)((EuclidFrameAPITester)this)).collect(Collectors.toList());
        for (iteration = 0; iteration < numberOfIterations; ++iteration) {
            block25: {
                frameA = EuclidFrameRandomTools.nextReferenceFrame("frameA", this.random, EuclidFrameAPITester.worldFrame);
                frameB = EuclidFrameRandomTools.nextReferenceFrame("frameB", this.random, EuclidFrameAPITester.worldFrame);
                var10_10 = frameMethods.iterator();
                while (true) {
                    frameMethod = (Method)var10_10.next();
                    parameterTypes = frameMethod.getParameterTypes();
                    parameters = new Object[parameterTypes.length];
                    for (i = 0; i < parameterTypes.length; ++i) {
                        parameterType = parameterTypes[i];
                        parameters[i] = this.reflectionBasedBuilder.next(this.random, frameA, parameterType);
                    }
                    EuclidFrameAPITester.invokeStaticMethod(frameMethod, parameters);
                    continue;
                    break;
                }
                finally {
                    if (!var10_10.hasNext()) break block25;
                }
            }
            for (Method frameMethod : frameMethods) {
                parameterTypes = frameMethod.getParameterTypes();
                numberOfArgumentsToTest = 0;
                for (Class<?> parameterType : parameterTypes) {
                    if (this.isFrameOfFrameTypeMutable(parameterType)) continue;
                    ++numberOfArgumentsToTest;
                }
                numberOfCombinations = (int)Math.pow(2.0, numberOfArgumentsToTest);
                for (i = 1; i < numberOfCombinations - 1; ++i) {
                    parameters = new Object[parameterTypes.length];
                    currentByte = 0;
                    for (j = 0; j < parameterTypes.length; ++j) {
                        parameterType = parameterTypes[j];
                        v0 = mutateFrame = this.isFrameOfFrameTypeMutable(parameterType) == false;
                        if (!mutateFrame) {
                            parameters[j] = this.reflectionBasedBuilder.next(this.random, frameA, parameterType);
                            continue;
                        }
                        frame = frameA;
                        mask = (int)Math.pow(2.0, currentByte);
                        if ((i & mask) != 0) {
                            frame = frameB;
                        }
                        parameters[j] = this.reflectionBasedBuilder.next(this.random, frame, parameterType);
                        ++currentByte;
                    }
                    try {
                        EuclidFrameAPITester.invokeStaticMethod(frameMethod, parameters);
                        EuclidFrameAPITester.failToThrowReferenceFrameMismatchException(typeDeclaringStaticMethodsToTest, frameMethod, parameters);
                        continue;
                    }
                    catch (ReferenceFrameMismatchException j) {
                        continue;
                    }
                    catch (Throwable t) {
                        if (this.isExceptionToBeIgnored(t)) continue;
                        throw t;
                    }
                }
            }
            for (Method frameMethod : frameMethods) {
                parameterTypes = frameMethod.getParameterTypes();
                parameters = new Object[parameterTypes.length];
                for (i = 0; i < parameterTypes.length; ++i) {
                    parameterType = parameterTypes[i];
                    parameters[i] = this.isMutableFrameMutableType(parameterType) != false ? this.reflectionBasedBuilder.next(this.random, frameB, parameterType) : this.reflectionBasedBuilder.next(this.random, frameA, parameterType);
                }
                try {
                    EuclidFrameAPITester.invokeStaticMethod(frameMethod, parameters);
                }
                catch (Throwable t) {
                    if (this.isExceptionToBeIgnored(t)) continue;
                    throw t;
                }
                for (i = 0; i < parameterTypes.length; ++i) {
                    parameterType = parameterTypes[i];
                    if (!this.isMutableFrameMutableType(parameterType) || (newFrame = ((ReferenceFrameHolder)parameters[i]).getReferenceFrame()) == frameA) continue;
                    EuclidFrameAPITester.failToChangeParameterFrame(typeDeclaringStaticMethodsToTest, frameMethod, parameters, i);
                }
            }
            for (Method frameMethod : methodsWithReturnFrameType) {
                parameterTypes = frameMethod.getParameterTypes();
                parameters = new Object[parameterTypes.length];
                for (i = 0; i < parameterTypes.length; ++i) {
                    parameterType = parameterTypes[i];
                    parameters[i] = this.reflectionBasedBuilder.next(this.random, frameA, parameterType);
                }
                result = null;
                result = EuclidFrameAPITester.invokeStaticMethod(frameMethod, parameters);
                continue;
                ** finally { 
lbl91:
                // 1 sources

                if (result == null || (resultFrame = ((ReferenceFrameHolder)result).getReferenceFrame()) == frameA) continue;
                EuclidFrameAPITester.failToSetResultFrame(typeDeclaringStaticMethodsToTest, frameMethod, parameters, result);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void assertMethodsOfReferenceFrameHolderCheckReferenceFrame(RandomFrameTypeBuilder frameTypeBuilder, Predicate<Method> methodFilter, int numberOfIterations) throws Throwable {
        frameType = frameTypeBuilder.newInstance(this.random, EuclidFrameAPITester.worldFrame).getClass();
        filter = methodFilter.and((Predicate<Method>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$assertMethodsOfReferenceFrameHolderCheckReferenceFrame$15(java.lang.reflect.Method ), (Ljava/lang/reflect/Method;)Z)()).and(this.atLeastNFrameParameters(1));
        frameMethods = Stream.of(frameType.getMethods()).filter(filter).collect(Collectors.toList());
        methodsWithReturnFrameType = frameMethods.stream().filter((Predicate<Method>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$assertMethodsOfReferenceFrameHolderCheckReferenceFrame$16(java.lang.reflect.Method ), (Ljava/lang/reflect/Method;)Z)((EuclidFrameAPITester)this)).collect(Collectors.toList());
        for (iteration = 0; iteration < numberOfIterations; ++iteration) {
            block27: {
                frameA = EuclidFrameRandomTools.nextReferenceFrame("frameA", this.random, EuclidFrameAPITester.worldFrame);
                frameB = EuclidFrameRandomTools.nextReferenceFrame("frameB", this.random, EuclidFrameAPITester.worldFrame);
                var11_11 = frameMethods.iterator();
                while (true) {
                    frameMethod = (Method)var11_11.next();
                    frameObject = frameTypeBuilder.newInstance(this.random, frameA);
                    parameterTypes = frameMethod.getParameterTypes();
                    parameters = new Object[parameterTypes.length];
                    for (i = 0; i < parameterTypes.length; ++i) {
                        parameterType = parameterTypes[i];
                        parameters[i] = this.reflectionBasedBuilder.next(this.random, frameA, parameterType);
                    }
                    EuclidFrameAPITester.invokeMethod(frameObject, frameMethod, parameters);
                    continue;
                    break;
                }
                finally {
                    if (!var11_11.hasNext()) break block27;
                }
            }
            for (Method frameMethod : frameMethods) {
                if (frameMethod.getName().endsWith("MatchingFrame")) {
                    this.assertSetMatchingFrameChecksFrames(frameTypeBuilder, frameMethod, frameA, frameB);
                    continue;
                }
                if (frameMethod.getName().endsWith("IncludingFrame")) {
                    this.assertSetIncludingFrameChecksFrames(frameTypeBuilder, frameMethod, frameA, frameB);
                    continue;
                }
                frameObject = frameTypeBuilder.newInstance(this.random, frameA);
                parameterTypes = frameMethod.getParameterTypes();
                numberOfArgumentsToTest = 0;
                for (Class<?> parameterType : parameterTypes) {
                    if (this.isFrameOfFrameTypeMutable(parameterType)) continue;
                    ++numberOfArgumentsToTest;
                }
                numberOfCombinations = (int)Math.pow(2.0, numberOfArgumentsToTest);
                for (i = 1; i < numberOfCombinations; ++i) {
                    parameters = new Object[parameterTypes.length];
                    currentByte = 0;
                    for (j = 0; j < parameterTypes.length; ++j) {
                        parameterType = parameterTypes[j];
                        v0 = mutateFrame = this.isFrameOfFrameTypeMutable(parameterType) == false;
                        if (!mutateFrame) {
                            parameters[j] = this.reflectionBasedBuilder.next(this.random, frameA, parameterType);
                            continue;
                        }
                        frame = frameA;
                        mask = (int)Math.pow(2.0, currentByte);
                        if ((i & mask) != 0) {
                            frame = frameB;
                        }
                        parameters[j] = this.reflectionBasedBuilder.next(this.random, frame, parameterType);
                        ++currentByte;
                    }
                    try {
                        EuclidFrameAPITester.invokeMethod(frameObject, frameMethod, parameters);
                        EuclidFrameAPITester.failToThrowReferenceFrameMismatchException(frameType, frameMethod, parameters);
                        continue;
                    }
                    catch (ReferenceFrameMismatchException j) {
                        continue;
                    }
                    catch (Throwable t) {
                        if (t instanceof ReferenceFrameMismatchException) continue;
                        EuclidFrameAPITester.failToThrowReferenceFrameMismatchException(frameType, frameMethod, parameters, t);
                    }
                }
            }
            for (Method frameMethod : frameMethods) {
                frameObject = frameTypeBuilder.newInstance(this.random, frameA);
                parameterTypes = frameMethod.getParameterTypes();
                parameters = new Object[parameterTypes.length];
                for (i = 0; i < parameterTypes.length; ++i) {
                    parameterType = parameterTypes[i];
                    parameters[i] = this.isMutableFrameMutableType(parameterType) != false ? this.reflectionBasedBuilder.next(this.random, frameB, parameterType) : this.reflectionBasedBuilder.next(this.random, frameA, parameterType);
                }
                try {
                    EuclidFrameAPITester.invokeMethod(frameObject, frameMethod, parameters);
                }
                catch (Throwable t) {
                    if (this.isExceptionToBeIgnored(t)) continue;
                    throw t;
                }
                for (i = 0; i < parameterTypes.length; ++i) {
                    parameterType = parameterTypes[i];
                    if (!this.isMutableFrameMutableType(parameterType) || (newFrame = ((ReferenceFrameHolder)parameters[i]).getReferenceFrame()) == frameA) continue;
                    EuclidFrameAPITester.failToChangeParameterFrame(frameType, frameMethod, parameters, i);
                }
            }
            for (Method frameMethod : methodsWithReturnFrameType) {
                frameObject = frameTypeBuilder.newInstance(this.random, frameA);
                parameterTypes = frameMethod.getParameterTypes();
                parameters = new Object[parameterTypes.length];
                for (i = 0; i < parameterTypes.length; ++i) {
                    parameterType = parameterTypes[i];
                    parameters[i] = this.reflectionBasedBuilder.next(this.random, frameA, parameterType);
                }
                result = null;
                result = EuclidFrameAPITester.invokeMethod(frameObject, frameMethod, parameters);
                continue;
                ** finally { 
lbl103:
                // 1 sources

                if (result == null || (resultFrame = ((ReferenceFrameHolder)result).getReferenceFrame()) == frameA) continue;
                EuclidFrameAPITester.failToSetResultFrame(frameType, frameMethod, parameters, result);
            }
        }
    }

    private void assertSetIncludingFrameChecksFrames(RandomFrameTypeBuilder frameTypeBuilder, Method setIncludingFrameMethod, ReferenceFrame frameA, ReferenceFrame frameB) {
        this.assertSetMatchingFrameChecksFrames(frameTypeBuilder, setIncludingFrameMethod, frameA, frameB);
    }

    private void assertSetMatchingFrameChecksFrames(RandomFrameTypeBuilder frameTypeBuilder, Method setMatchingFrameMethod, ReferenceFrame frameA, ReferenceFrame frameB) {
        ReferenceFrameHolder frameObject = frameTypeBuilder.newInstance(this.random, frameA);
        Class<?> frameType = frameObject.getClass();
        Class<?>[] parameterTypes = setMatchingFrameMethod.getParameterTypes();
        for (int i = 0; i < setMatchingFrameMethod.getParameterCount(); ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (!this.isFrameType(parameterType) || this.frameReadOnlyTypes.contains(parameterType)) continue;
            String message = setMatchingFrameMethod.getName() + " is expected to only request read-only parameters.\n";
            message = message + "In " + frameType.getSimpleName() + " the " + i + "th parameter is not a read-only:\n";
            message = message + MethodSignature.getMethodSimpleName(setMatchingFrameMethod);
            throw new AssertionError((Object)message);
        }
        int numberOfArgumentsToTest = this.countFrameParameters(setMatchingFrameMethod);
        if (numberOfArgumentsToTest < 2) {
            return;
        }
        int numberOfCombinations = (int)Math.pow(2.0, numberOfArgumentsToTest);
        for (int i = 1; i < numberOfCombinations - 1; ++i) {
            Object[] parameters = new Object[parameterTypes.length];
            int currentByte = 0;
            for (int j = 0; j < parameterTypes.length; ++j) {
                Class<?> parameterType = parameterTypes[j];
                if (this.isFrameType(parameterType)) {
                    ReferenceFrame frame = frameA;
                    int mask = (int)Math.pow(2.0, currentByte);
                    if ((i & mask) != 0) {
                        frame = frameB;
                    }
                    parameters[j] = this.reflectionBasedBuilder.next(this.random, frame, parameterType);
                    ++currentByte;
                    continue;
                }
                parameters[j] = this.reflectionBasedBuilder.next(this.random, frameA, parameterType);
            }
            try {
                EuclidFrameAPITester.invokeMethod(frameObject, setMatchingFrameMethod, parameters);
                EuclidFrameAPITester.failToThrowReferenceFrameMismatchException(frameType, setMatchingFrameMethod, parameters);
                continue;
            }
            catch (ReferenceFrameMismatchException j) {
                continue;
            }
            catch (Throwable t) {
                if (this.isExceptionToBeIgnored(t)) continue;
                EuclidFrameAPITester.failToThrowReferenceFrameMismatchException(frameType, setMatchingFrameMethod, parameters, t);
            }
        }
    }

    public void assertStaticMethodsPreserveFunctionality(Class<?> typeWithFrameMethodsToTest, Class<?> typeWithFramelessMethods, int numberOfIterations) {
        this.assertStaticMethodsPreserveFunctionality(typeWithFrameMethodsToTest, typeWithFramelessMethods, m -> true, numberOfIterations);
    }

    public void assertStaticMethodsPreserveFunctionality(Class<?> typeWithFrameMethodsToTest, Class<?> typeWithFramelessMethods, Predicate<Method> methodFilter, int numberOfIterations) {
        List frameMethods = Stream.of(typeWithFrameMethodsToTest.getMethods()).filter(methodFilter).collect(Collectors.toList());
        block7: for (Method frameMethod : frameMethods) {
            String frameMethodName = frameMethod.getName();
            Class<?>[] frameMethodParameterTypes = frameMethod.getParameterTypes();
            Class[] framelessMethodParameterTypes = new Class[frameMethodParameterTypes.length];
            for (int i = 0; i < framelessMethodParameterTypes.length; ++i) {
                framelessMethodParameterTypes[i] = this.isFrameType(frameMethodParameterTypes[i]) ? this.findCorrespondingFramelessType(frameMethodParameterTypes[i]) : frameMethodParameterTypes[i];
            }
            int retryCounter = 0;
            for (int iteration = 0; iteration < numberOfIterations; ++iteration) {
                try {
                    Method framelessMethod = typeWithFramelessMethods.getMethod(frameMethodName, framelessMethodParameterTypes);
                    Object[] frameMethodParameters = this.reflectionBasedBuilder.next(this.random, worldFrame, frameMethodParameterTypes);
                    if (frameMethodParameters == null) continue block7;
                    Object[] framelessMethodParameters = this.reflectionBasedBuilder.clone(frameMethodParameters);
                    if (framelessMethodParameters == null) {
                        System.err.println("Cloning parameters failed for\n\t" + MethodSignature.getMethodSimpleName(frameMethod) + "\n\tparameters: " + EuclidFrameAPITester.getArgumentTypeString(frameMethodParameters));
                        if (++retryCounter > 50) {
                            throw new AssertionError((Object)"Retried too many times, aborting.");
                        }
                        System.out.println("Retrying.");
                        --iteration;
                        continue;
                    }
                    Throwable expectedException = null;
                    Object framelessMethodReturnObject = null;
                    Object frameMethodReturnObject = null;
                    try {
                        framelessMethodReturnObject = EuclidFrameAPITester.invokeStaticMethod(framelessMethod, framelessMethodParameters);
                    }
                    catch (Throwable e) {
                        expectedException = e;
                    }
                    try {
                        frameMethodReturnObject = EuclidFrameAPITester.invokeStaticMethod(frameMethod, frameMethodParameters);
                    }
                    catch (Throwable e) {
                        if (expectedException != null && e.getClass() == expectedException.getClass()) continue;
                        EuclidFrameAPITester.reportInconsistentException(frameMethod, framelessMethod, expectedException, e);
                    }
                    for (int i = 0; i < frameMethodParameters.length; ++i) {
                        Object framelessParameter = framelessMethodParameters[i];
                        Object frameParameter = frameMethodParameters[i];
                        if (ReflectionBasedComparer.epsilonEquals(framelessParameter, frameParameter, 1.0E-12)) continue;
                        this.reportInconsistentArguments(frameMethod, framelessMethod, frameMethodParameters, framelessMethodParameters, framelessParameter, frameParameter);
                    }
                    if (ReflectionBasedComparer.epsilonEquals(framelessMethodReturnObject, frameMethodReturnObject, 1.0E-12)) continue;
                    this.reportInconsistentReturnedType(frameMethod, framelessMethod, framelessMethodReturnObject, frameMethodReturnObject);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    EuclidFrameAPITester.debugNoSuchMethodException(typeWithFrameMethodsToTest, typeWithFramelessMethods, frameMethod, framelessMethodParameterTypes);
                    continue;
                }
                catch (SecurityException e) {
                    EuclidFrameAPITester.debugSecurityException(typeWithFramelessMethods, frameMethodName, framelessMethodParameterTypes);
                }
            }
        }
    }

    public void assertFrameMethodsOfFrameHolderPreserveFunctionality(FrameTypeCopier frameTypeCopier, RandomFramelessTypeBuilder framelessTypeBuilber, Predicate<Method> methodFilter, int numberOfIterations) {
        this.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeCopier, framelessTypeBuilber, methodFilter, numberOfIterations, 1.0E-12);
    }

    public void assertFrameMethodsOfFrameHolderPreserveFunctionality(FrameTypeCopier frameTypeCopier, RandomFramelessTypeBuilder framelessTypeBuilber, Predicate<Method> methodFilter, int numberOfIterations, double epsilon) {
        Class<?> frameTypeToTest = frameTypeCopier.newInstance(worldFrame, framelessTypeBuilber.newInstance(this.random)).getClass();
        if (frameTypeToTest.isAnonymousClass()) {
            frameTypeToTest = frameTypeToTest.getInterfaces().length == 0 ? frameTypeToTest.getSuperclass() : frameTypeToTest.getInterfaces()[0];
        }
        Class<?> framelessType = framelessTypeBuilber.newInstance(this.random).getClass();
        List frameMethods = Stream.of(frameTypeToTest.getMethods()).filter(methodFilter).collect(Collectors.toList());
        block8: for (Method frameMethod : frameMethods) {
            String frameMethodName = frameMethod.getName();
            Class<?>[] frameMethodParameterTypes = frameMethod.getParameterTypes();
            Class[] framelessMethodParameterTypes = new Class[frameMethodParameterTypes.length];
            for (int i = 0; i < framelessMethodParameterTypes.length; ++i) {
                framelessMethodParameterTypes[i] = this.isFrameType(frameMethodParameterTypes[i]) ? this.findCorrespondingFramelessType(frameMethodParameterTypes[i]) : frameMethodParameterTypes[i];
            }
            int retryCounter = 0;
            for (int iteration = 0; iteration < numberOfIterations; ++iteration) {
                Object framelessObject = framelessTypeBuilber.newInstance(this.random);
                ReferenceFrameHolder frameObject = frameTypeCopier.newInstance(worldFrame, framelessObject);
                try {
                    Method framelessMethod = framelessType.getMethod(frameMethodName, framelessMethodParameterTypes);
                    Object[] frameMethodParameters = this.reflectionBasedBuilder.next(this.random, worldFrame, frameMethodParameterTypes);
                    if (frameMethodParameters == null) continue block8;
                    Object[] framelessMethodParameters = this.reflectionBasedBuilder.clone(frameMethodParameters);
                    if (framelessMethodParameters == null) {
                        System.err.println("Cloning parameters failed for\n\t" + MethodSignature.getMethodSimpleName(frameMethod) + "\n\tparameters: " + EuclidFrameAPITester.getArgumentTypeString(frameMethodParameters));
                        if (++retryCounter > 50) {
                            throw new AssertionError((Object)"Retried too many times, aborting.");
                        }
                        System.out.println("Retyring.");
                        --iteration;
                        continue;
                    }
                    Throwable expectedException = null;
                    Object framelessMethodReturnObject = null;
                    Object frameMethodReturnObject = null;
                    try {
                        framelessMethodReturnObject = EuclidFrameAPITester.invokeMethod(framelessObject, framelessMethod, framelessMethodParameters);
                    }
                    catch (Throwable e) {
                        expectedException = e;
                    }
                    try {
                        frameMethodReturnObject = EuclidFrameAPITester.invokeMethod(frameObject, frameMethod, frameMethodParameters);
                    }
                    catch (Throwable e) {
                        if (expectedException != null && e.getClass() == expectedException.getClass()) continue;
                        EuclidFrameAPITester.reportInconsistentException(frameMethod, framelessMethod, expectedException, e);
                    }
                    for (int i = 0; i < frameMethodParameters.length; ++i) {
                        Object framelessParameter = framelessMethodParameters[i];
                        Object frameParameter = frameMethodParameters[i];
                        if (ReflectionBasedComparer.epsilonEquals(framelessParameter, frameParameter, epsilon)) continue;
                        this.reportInconsistentArguments(frameMethod, framelessMethod, frameMethodParameters, framelessMethodParameters, framelessParameter, frameParameter);
                    }
                    if (!ReflectionBasedComparer.epsilonEquals(framelessMethodReturnObject, frameMethodReturnObject, epsilon)) {
                        this.reportInconsistentReturnedType(frameMethod, framelessMethod, framelessMethodReturnObject, frameMethodReturnObject);
                    }
                    if (ReflectionBasedComparer.epsilonEquals(framelessObject, frameObject, epsilon)) continue;
                    EuclidFrameAPITester.reportInconsistentObject(frameMethod, framelessObject, frameObject, framelessMethod);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    EuclidFrameAPITester.debugNoSuchMethodException(frameTypeToTest, framelessType, frameMethod, framelessMethodParameterTypes);
                    continue;
                }
                catch (SecurityException e) {
                    EuclidFrameAPITester.debugSecurityException(framelessType, frameMethodName, framelessMethodParameterTypes);
                    continue;
                }
                catch (RuntimeException e) {
                    System.err.println("Problem when evaluating the method: " + MethodSignature.getMethodSimpleName(frameMethod.getReturnType(), frameMethodName, frameMethodParameterTypes));
                    throw e;
                }
            }
        }
    }

    private static void failToSetResultFrame(Class<?> typeDeclaringMethod, Method frameMethod, Object[] parameters, Object result) throws AssertionError {
        String message = "The method: " + MethodSignature.getMethodSimpleName(frameMethod) + "\ndid not set the frame of the result.";
        message = message + "\nType being tested: " + typeDeclaringMethod.getSimpleName();
        message = message + "\nArguments used: " + Arrays.toString(parameters);
        message = message + "\nArgument types: " + EuclidFrameAPITester.getArgumentTypeString(parameters);
        message = message + "\nResult: " + result;
        throw new AssertionError((Object)message);
    }

    private static void failToChangeParameterFrame(Class<?> typeDeclaringMethod, Method frameMethod, Object[] parameters, int parameterIndex) throws AssertionError {
        String message = "The method: " + MethodSignature.getMethodSimpleName(frameMethod) + "\ndid not change the frame of the " + (parameterIndex + 1) + "th parameter.";
        message = message + "\nType being tested: " + typeDeclaringMethod.getSimpleName();
        message = message + "\nArguments used: " + Arrays.toString(parameters);
        message = message + "\nArgument types: " + EuclidFrameAPITester.getArgumentTypeString(parameters);
        throw new AssertionError((Object)message);
    }

    private static void failToThrowReferenceFrameMismatchException(Class<?> typeDeclaringMethod, Method frameMethod, Object[] parameters) throws AssertionError {
        EuclidFrameAPITester.failToThrowReferenceFrameMismatchException(typeDeclaringMethod, frameMethod, parameters, null);
    }

    private static void failToThrowReferenceFrameMismatchException(Class<?> typeDeclaringMethod, Method frameMethod, Object[] parameters, Throwable exceptionThrownInstead) throws AssertionError {
        String message = "Should have thrown a " + ReferenceFrameMismatchException.class.getSimpleName();
        message = message + "\nType being tested: " + typeDeclaringMethod.getSimpleName();
        message = message + "\nMethod: " + MethodSignature.getMethodSimpleName(frameMethod);
        message = message + "\nArguments used: " + Arrays.toString(parameters);
        message = message + "\nArgument types: " + EuclidFrameAPITester.getArgumentTypeString(parameters);
        if (exceptionThrownInstead != null) {
            throw new AssertionError(message, exceptionThrownInstead);
        }
        throw new AssertionError((Object)message);
    }

    private static void debugSecurityException(Class<?> typeWithFramelessMethods, String frameMethodName, Class<?>[] framelessMethodParameterTypes) {
    }

    private static void debugNoSuchMethodException(Class<?> typeWithFrameMethodsToTest, Class<?> typeWithFramelessMethods, Method frameMethod, Class<?>[] framelessMethodParameterTypes) {
    }

    private static void reportInconsistentObject(Method frameMethod, Object framelessObject, ReferenceFrameHolder frameObject, Method framelessMethod) throws AssertionError {
        Object message = "";
        message = (String)message + "Detected a method inconsistent with its original method.";
        message = (String)message + "\nInconsistent method: " + MethodSignature.getMethodSimpleName(frameMethod);
        message = (String)message + "\nOriginal     method: " + MethodSignature.getMethodSimpleName(framelessMethod);
        message = (String)message + "\nActual   object after method call:" + frameObject;
        message = (String)message + "\nExpected object after method call:" + framelessObject;
        throw new AssertionError(message);
    }

    private static void reportInconsistentException(Method frameMethod, Method framelessMethod, Throwable expectedException, Throwable e) throws AssertionError {
        Object message = "";
        message = (String)message + "The method: " + MethodSignature.getMethodSimpleName(frameMethod);
        message = (String)message + "\ndid not throw the same exception as the original method: " + MethodSignature.getMethodSimpleName(framelessMethod);
        message = (String)message + "\nExpected exception class: " + (expectedException == null ? "none" : expectedException.getClass().getSimpleName());
        message = (String)message + "\nActual   exception class: " + e.getClass().getSimpleName();
        throw new AssertionError(message);
    }

    private void reportInconsistentArguments(Method frameMethod, Method framelessMethod, Object[] frameMethodParameters, Object[] framelessMethodParameters, Object framelessParameter, Object frameParameter) throws AssertionError {
        Object message = "";
        message = (String)message + "Detected a method inconsistent with its original method.";
        message = (String)message + "\nInconsistent method: " + MethodSignature.getMethodSimpleName(frameMethod);
        message = (String)message + "\nOriginal     method: " + MethodSignature.getMethodSimpleName(framelessMethod);
        message = (String)message + "\nActual   arguments after call:\n" + Arrays.toString(frameMethodParameters);
        message = (String)message + "\nExpected arguments after call:\n" + EuclidCoreIOTools.getCollectionString((String)"[", (String)"]", (String)", ", Arrays.asList(framelessMethodParameters), this::toStringAsFramelessObject);
        throw new AssertionError(message);
    }

    private void reportInconsistentReturnedType(Method frameMethod, Method framelessMethod, Object framelessMethodReturnObject, Object frameMethodReturnObject) throws AssertionError {
        Object message = "";
        message = (String)message + "Detected a method inconsistent with its original method.";
        message = (String)message + "\nInconsistent method: " + MethodSignature.getMethodSimpleName(frameMethod);
        message = (String)message + "\nOriginal     method: " + MethodSignature.getMethodSimpleName(framelessMethod);
        message = (String)message + "\nActual   method returned:" + frameMethodReturnObject;
        message = (String)message + "\nExpected method returned:" + this.toStringAsFramelessObject(framelessMethodReturnObject);
        throw new AssertionError(message);
    }

    private String toStringAsFramelessObject(Object frameObject) {
        if (this.isFrameObject(frameObject)) {
            return this.findCorrespondingFramelessType(frameObject.getClass()).cast(frameObject).toString();
        }
        return frameObject.toString();
    }

    private boolean isMutableFrameMutableType(Class<?> frameType) {
        return this.mutableFrameMutableTypes.contains(frameType) && !this.fixedFrameMutableTypes.contains(frameType);
    }

    private boolean isFrameOfFrameTypeMutable(Class<?> frameType) {
        return !this.fixedFrameMutableTypes.contains(frameType) && !this.frameReadOnlyTypes.contains(frameType);
    }

    private static Object invokeStaticMethod(Method frameMethod, Object[] parameters) throws Throwable {
        try {
            return frameMethod.invoke(null, parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            System.err.println("Something went wrong when invoking the static method: " + MethodSignature.getMethodSimpleName(frameMethod));
            System.err.println("Objects used as parameters: " + EuclidFrameAPITester.getArgumentTypeString(parameters));
            e.printStackTrace();
            throw e;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static Object invokeMethod(Object methodHolder, Method frameMethod, Object ... parameters) throws Throwable {
        try {
            frameMethod.setAccessible(true);
            return frameMethod.invoke(methodHolder, parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            System.err.println("Something went wrong when invoking the method: " + MethodSignature.getMethodSimpleName(frameMethod));
            System.err.println("Objects used as parameters: " + EuclidFrameAPITester.getArgumentTypeString(parameters));
            e.printStackTrace();
            throw e;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private boolean isExceptionToBeIgnored(Throwable t) {
        return this.exceptionsToIgnore.stream().filter(c -> c.isAssignableFrom(t.getClass())).findAny().isPresent();
    }

    private static String getArgumentTypeString(Object ... arguments) {
        return EuclidCoreIOTools.getCollectionString((String)", ", Arrays.asList(arguments), o -> o.getClass().getSimpleName());
    }

    private static String getSimpleNames(Class<?>[] types) {
        String ret = Arrays.stream(types).map(t -> t.getSimpleName()).collect(Collectors.toList()).toString();
        return ret.substring(1, ret.length() - 1);
    }

    private Predicate<Method> atLeastNFrameParameters(int minNumberOfFrameParameters) {
        return method -> this.countFrameParameters((Method)method) >= minNumberOfFrameParameters;
    }

    private int countFrameParameters(Method method) {
        return (int)Stream.of(method.getParameterTypes()).filter(this::isFrameType).count();
    }

    private Predicate<Method> atLeastNFramelessParameters(int minNumberOfFramelessParameters) {
        return method -> this.countFramelessParameters((Method)method) >= minNumberOfFramelessParameters;
    }

    private int countFramelessParameters(Method method) {
        return (int)Stream.of(method.getParameterTypes()).filter(this::isFramelessType).count();
    }

    private List<MethodSignature> createExpectedMethodSignaturesWithFrameArgument(MethodSignature framelessSignature, boolean createAllCombinations) {
        List<MethodSignature> expectedFrameSignatures = new ArrayList<MethodSignature>();
        if (!createAllCombinations) {
            MethodSignature combination = new MethodSignature(framelessSignature);
            for (int k = 0; k < combination.getParameterCount(); ++k) {
                if (!this.isFramelessTypeWithFrameEquivalent(combination.getParameterType(k))) continue;
                combination.setParameterType(k, this.findCorrespondingFrameType(combination.getParameterType(k)));
            }
            expectedFrameSignatures.add(combination);
        } else {
            int numberOfArgumentsToOverload = (int)Arrays.stream(framelessSignature.toParameterTypeArray()).filter(t -> this.isFramelessTypeWithFrameEquivalent((Class<?>)t)).count();
            int numberOfCombinations = (int)Math.pow(2.0, numberOfArgumentsToOverload);
            for (int i = 0; i < numberOfCombinations; ++i) {
                MethodSignature combination = new MethodSignature(framelessSignature);
                int currentByte = 0;
                for (int k = 0; k < combination.getParameterCount(); ++k) {
                    if (!this.isFramelessTypeWithFrameEquivalent(combination.getParameterType(k))) continue;
                    int mask = (int)Math.pow(2.0, currentByte);
                    if ((i & mask) != 0) {
                        combination.setParameterType(k, this.findCorrespondingFrameType(combination.getParameterType(k)));
                    }
                    ++currentByte;
                }
                expectedFrameSignatures.add(combination);
            }
            expectedFrameSignatures = expectedFrameSignatures.stream().filter(signature -> !signature.equals(framelessSignature)).collect(Collectors.toList());
        }
        return expectedFrameSignatures;
    }

    private Class<?> findCorrespondingFrameType(Class<?> framelessType) {
        if (framelessType.isArray()) {
            return Array.newInstance(this.findCorrespondingFrameType(framelessType.getComponentType()), 0).getClass();
        }
        if (!this.isFramelessTypeWithFrameEquivalent(framelessType)) {
            throw new IllegalArgumentException("Cannot handle the following type: " + framelessType.getSimpleName());
        }
        Class<?> frameType = null;
        for (Map.Entry<Class<?>, Class<?>> entry : this.framelessTypesToFrameTypesTable.entrySet()) {
            if (!entry.getKey().isAssignableFrom(framelessType) || frameType != null && !frameType.isAssignableFrom(entry.getValue())) continue;
            frameType = entry.getValue();
        }
        if (frameType == null) {
            throw new RuntimeException("Could not find the corresponding frame type for: " + framelessType.getSimpleName());
        }
        return frameType;
    }

    private Class<?> findCorrespondingFramelessType(Class<?> frameType) {
        if (frameType.isArray()) {
            return Array.newInstance(this.findCorrespondingFramelessType(frameType.getComponentType()), 0).getClass();
        }
        if (!this.isFrameType(frameType)) {
            throw new IllegalArgumentException("Cannot handle the following type: " + frameType.getSimpleName());
        }
        Class<?> framelessType = null;
        for (Map.Entry<Class<?>, Class<?>> entry : this.framelessTypesToFrameTypesTable.entrySet()) {
            if (!entry.getValue().isAssignableFrom(frameType) || framelessType != null && !framelessType.isAssignableFrom(entry.getKey())) continue;
            framelessType = entry.getKey();
        }
        if (framelessType == null) {
            throw new RuntimeException("Could not find the corresponding frameless type for: " + frameType.getSimpleName());
        }
        return framelessType;
    }

    private boolean isFrameObject(Object object) {
        return this.isFrameType(object.getClass());
    }

    private boolean isFrameType(Class<?> type) {
        for (Class<?> frameType : this.framelessTypesToFrameTypesTable.values()) {
            if (!frameType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    private boolean isFramelessType(Class<?> type) {
        if (ReferenceFrameHolder.class.isAssignableFrom(type)) {
            return false;
        }
        for (Class<?> framelessType : this.framelessTypesToFrameTypesTable.keySet()) {
            if (!framelessType.isAssignableFrom(type)) continue;
            return true;
        }
        for (Class<?> framelessType : this.framelessTypesWithoutFrameEquivalent) {
            if (!framelessType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    private boolean isFramelessTypeWithFrameEquivalent(Class<?> framelessType) {
        if (framelessType.isArray()) {
            return this.isFramelessTypeWithFrameEquivalent(framelessType.getComponentType());
        }
        return this.isFramelessType(framelessType) && !this.framelessTypesWithoutFrameEquivalent.contains(framelessType);
    }

    private boolean is2DType(Class<?> type) {
        try {
            return this.findCorrespondingFramelessType(type).getSimpleName().contains("2D");
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean is3DType(Class<?> type) {
        try {
            return this.findCorrespondingFramelessType(type).getSimpleName().contains("3D");
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static Class<?> searchSuperInterfaceFromSimpleName(String name, Class<?> typeToStartFrom) {
        for (Class<?> superInterface : typeToStartFrom.getInterfaces()) {
            if (!superInterface.getSimpleName().equals(name)) continue;
            return superInterface;
        }
        for (Class<?> superInterface : typeToStartFrom.getInterfaces()) {
            Class<?> thoroughSearchResult = EuclidFrameAPITester.searchSuperInterfaceFromSimpleName(name, superInterface);
            if (thoroughSearchResult == null) continue;
            return thoroughSearchResult;
        }
        return null;
    }

    private /* synthetic */ boolean lambda$assertMethodsOfReferenceFrameHolderCheckReferenceFrame$16(Method m) {
        return this.isFrameType(m.getReturnType());
    }

    private static /* synthetic */ boolean lambda$assertMethodsOfReferenceFrameHolderCheckReferenceFrame$15(Method m) {
        return Modifier.isPublic(m.getModifiers());
    }

    private /* synthetic */ boolean lambda$assertStaticMethodsCheckReferenceFrame$14(Method m) {
        return this.isFrameType(m.getReturnType());
    }

    private static /* synthetic */ boolean lambda$assertStaticMethodsCheckReferenceFrame$13(Method m) {
        return Modifier.isPublic(m.getModifiers());
    }

    private static /* synthetic */ boolean lambda$assertStaticMethodsCheckReferenceFrame$12(Method m) {
        return Modifier.isStatic(m.getModifiers());
    }
}

