/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameMatrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex3DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.FrameYawPitchRollReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class EuclidFrameIOTools {
    private EuclidFrameIOTools() {
    }

    public static String getFrameTuple2DString(FrameTuple2DReadOnly tuple) {
        return EuclidFrameIOTools.getFrameTuple2DString(EuclidCoreIOTools.DEFAULT_FORMAT, tuple);
    }

    public static String getFrameTuple2DString(String format, FrameTuple2DReadOnly tuple) {
        if (tuple == null) {
            return "null";
        }
        return EuclidCoreIOTools.getTuple2DString((String)format, (Tuple2DReadOnly)tuple) + " - " + tuple.getReferenceFrame();
    }

    public static String getFrameTuple3DString(FrameTuple3DReadOnly tuple) {
        return EuclidFrameIOTools.getFrameTuple3DString(EuclidCoreIOTools.DEFAULT_FORMAT, tuple);
    }

    public static String getFrameTuple3DString(String format, FrameTuple3DReadOnly tuple) {
        if (tuple == null) {
            return "null";
        }
        return EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)tuple) + " - " + tuple.getReferenceFrame();
    }

    public static String getFrameTuple4DString(FrameTuple4DReadOnly tuple) {
        return EuclidFrameIOTools.getFrameTuple4DString(EuclidCoreIOTools.DEFAULT_FORMAT, tuple);
    }

    public static String getFrameTuple4DString(String format, FrameTuple4DReadOnly tuple) {
        if (tuple == null) {
            return "null";
        }
        return EuclidCoreIOTools.getTuple4DString((String)format, (Tuple4DReadOnly)tuple) + " - " + tuple.getReferenceFrame();
    }

    public static String getFrameMatrix3DString(FrameMatrix3DReadOnly matrix) {
        return EuclidFrameIOTools.getFrameMatrix3DString(EuclidCoreIOTools.DEFAULT_FORMAT, matrix);
    }

    public static String getFrameMatrix3DString(String format, FrameMatrix3DReadOnly matrix) {
        if (matrix == null) {
            return "null";
        }
        return EuclidCoreIOTools.getMatrix3DString((String)format, (Matrix3DReadOnly)matrix) + "\n" + matrix.getReferenceFrame();
    }

    public static String getFrameYawPitchRollString(FrameYawPitchRollReadOnly yawPitchRoll) {
        return EuclidFrameIOTools.getFrameYawPitchRollString(EuclidCoreIOTools.DEFAULT_FORMAT, yawPitchRoll);
    }

    public static String getFrameYawPitchRollString(String format, FrameYawPitchRollReadOnly yawPitchRoll) {
        if (yawPitchRoll == null) {
            return "null";
        }
        return EuclidCoreIOTools.getYawPitchRollString((String)format, (YawPitchRollReadOnly)yawPitchRoll) + " - " + yawPitchRoll.getReferenceFrame();
    }

    public static String getStringAsFrameYawPitchRoll(FrameOrientation3DReadOnly orientation) {
        return EuclidFrameIOTools.getStringAsFrameYawPitchRoll(EuclidCoreIOTools.DEFAULT_FORMAT, orientation);
    }

    public static String getStringAsFrameYawPitchRoll(String format, FrameOrientation3DReadOnly orientation) {
        if (orientation == null) {
            return "null";
        }
        return EuclidCoreIOTools.getStringAsYawPitchRoll((String)format, (Orientation3DReadOnly)orientation) + " - " + orientation.getReferenceFrame();
    }

    public static String getFrameLine2DString(FrameLine2DReadOnly line2D) {
        return EuclidFrameIOTools.getFrameLine2DString(EuclidCoreIOTools.DEFAULT_FORMAT, line2D);
    }

    public static String getFrameLine2DString(String format, FrameLine2DReadOnly line2D) {
        if (line2D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getLine2DString((String)format, (Line2DReadOnly)line2D) + ", " + line2D.getReferenceFrame();
    }

    public static String getFrameLine3DString(FrameLine3DReadOnly line3D) {
        return EuclidFrameIOTools.getFrameLine3DString(EuclidCoreIOTools.DEFAULT_FORMAT, line3D);
    }

    public static String getFrameLine3DString(String format, FrameLine3DReadOnly line3D) {
        if (line3D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getLine3DString((String)format, (Line3DReadOnly)line3D) + ", " + line3D.getReferenceFrame();
    }

    public static String getFrameLineSegment2DString(FrameLineSegment2DReadOnly lineSegment2D) {
        return EuclidFrameIOTools.getFrameLineSegment2DString(EuclidCoreIOTools.DEFAULT_FORMAT, lineSegment2D);
    }

    public static String getFrameLineSegment2DString(String format, FrameLineSegment2DReadOnly lineSegment2D) {
        if (lineSegment2D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getLineSegment2DString((String)format, (LineSegment2DReadOnly)lineSegment2D) + ", " + lineSegment2D.getReferenceFrame();
    }

    public static String getFrameLineSegment3DString(FrameLineSegment3DReadOnly lineSegment3D) {
        return EuclidFrameIOTools.getFrameLineSegment3DString(EuclidCoreIOTools.DEFAULT_FORMAT, lineSegment3D);
    }

    public static String getFrameLineSegment3DString(String format, FrameLineSegment3DReadOnly lineSegment3D) {
        if (lineSegment3D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getLineSegment3DString((String)format, (LineSegment3DReadOnly)lineSegment3D) + ", " + lineSegment3D.getReferenceFrame();
    }

    public static String getFrameBoundingBox2DString(FrameBoundingBox2DReadOnly boundingBox2D) {
        return EuclidFrameIOTools.getFrameBoundingBox2DString(EuclidCoreIOTools.DEFAULT_FORMAT, boundingBox2D);
    }

    public static String getFrameBoundingBox2DString(String format, FrameBoundingBox2DReadOnly boundingBox2D) {
        if (boundingBox2D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getBoundingBox2DString((String)format, (BoundingBox2DReadOnly)boundingBox2D) + ", " + boundingBox2D.getReferenceFrame();
    }

    public static String getFrameBoundingBox3DString(FrameBoundingBox3DReadOnly boundingBox3D) {
        return EuclidFrameIOTools.getFrameBoundingBox3DString(EuclidCoreIOTools.DEFAULT_FORMAT, boundingBox3D);
    }

    public static String getFrameBoundingBox3DString(String format, FrameBoundingBox3DReadOnly boundingBox3D) {
        if (boundingBox3D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getBoundingBox3DString((String)format, (BoundingBox3DReadOnly)boundingBox3D) + ", " + boundingBox3D.getReferenceFrame();
    }

    public static String getFrameOrientation2DString(FrameOrientation2DReadOnly orientation2D) {
        return EuclidFrameIOTools.getFrameOrientation2DString(EuclidCoreIOTools.DEFAULT_FORMAT, orientation2D);
    }

    public static String getFrameOrientation2DString(String format, FrameOrientation2DReadOnly orientation2D) {
        if (orientation2D == null) {
            return "null";
        }
        return EuclidCoreIOTools.getOrientation2DString((String)format, (Orientation2DReadOnly)orientation2D) + " - " + orientation2D.getReferenceFrame();
    }

    public static String getFramePose2DString(FramePose2DReadOnly pose2D) {
        return EuclidFrameIOTools.getFramePose2DString(EuclidCoreIOTools.DEFAULT_FORMAT, pose2D);
    }

    public static String getFramePose2DString(String format, FramePose2DReadOnly pose2D) {
        if (pose2D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getPose2DString((String)format, (Pose2DReadOnly)pose2D) + ", " + pose2D.getReferenceFrame();
    }

    public static String getFramePose3DString(FramePose3DReadOnly pose3D) {
        return EuclidFrameIOTools.getFramePose3DString(EuclidCoreIOTools.DEFAULT_FORMAT, pose3D);
    }

    public static String getFramePose3DString(String format, FramePose3DReadOnly pose3D) {
        if (pose3D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getPose3DString((String)format, (Pose3DReadOnly)pose3D) + ", " + pose3D.getReferenceFrame();
    }

    public static String getFrameConvexPolygon2DString(FrameConvexPolygon2DReadOnly convexPolygon2D) {
        return EuclidFrameIOTools.getFrameConvexPolygon2DString(EuclidCoreIOTools.DEFAULT_FORMAT, convexPolygon2D);
    }

    public static String getFrameConvexPolygon2DString(String format, FrameConvexPolygon2DReadOnly convexPolygon2D) {
        if (convexPolygon2D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getConvexPolygon2DString((String)format, (ConvexPolygon2DReadOnly)convexPolygon2D) + "\n" + convexPolygon2D.getReferenceFrame();
    }

    public static String getFrameVertex2DSupplierString(FrameVertex2DSupplier vertex2DSupplier) {
        return EuclidFrameIOTools.getFrameVertex2DSupplierString(EuclidCoreIOTools.DEFAULT_FORMAT, vertex2DSupplier);
    }

    public static String getFrameVertex2DSupplierString(String format, FrameVertex2DSupplier vertex2DSupplier) {
        if (vertex2DSupplier == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getVertex2DSupplierString((String)format, (Vertex2DSupplier)vertex2DSupplier) + "\n" + vertex2DSupplier.getReferenceFrame();
    }

    public static String getFrameVertex3DSupplierString(FrameVertex3DSupplier vertex3DSupplier) {
        return EuclidFrameIOTools.getFrameVertex3DSupplierString(EuclidCoreIOTools.DEFAULT_FORMAT, vertex3DSupplier);
    }

    public static String getFrameVertex3DSupplierString(String format, FrameVertex3DSupplier vertex3DSupplier) {
        if (vertex3DSupplier == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getVertex3DSupplierString((String)format, (Vertex3DSupplier)vertex3DSupplier) + "\n" + vertex3DSupplier.getReferenceFrame();
    }
}

