/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import java.util.Random;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameBoundingBox2D;
import us.ihmc.euclid.referenceFrame.FrameBoundingBox3D;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FrameLine3D;
import us.ihmc.euclid.referenceFrame.FrameLineSegment2D;
import us.ihmc.euclid.referenceFrame.FrameLineSegment3D;
import us.ihmc.euclid.referenceFrame.FrameMatrix3D;
import us.ihmc.euclid.referenceFrame.FrameOrientation2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose2D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameRotationMatrix;
import us.ihmc.euclid.referenceFrame.FrameUnitVector2D;
import us.ihmc.euclid.referenceFrame.FrameUnitVector3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.FrameVector4D;
import us.ihmc.euclid.referenceFrame.FrameYawPitchRoll;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex3DSupplier;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class EuclidFrameRandomTools {
    private EuclidFrameRandomTools() {
    }

    public static ReferenceFrame nextReferenceFrame(Random random) {
        return EuclidFrameRandomTools.nextReferenceFrame(random, false);
    }

    public static ReferenceFrame nextReferenceFrame(String frameName, Random random) {
        return EuclidFrameRandomTools.nextReferenceFrame(frameName, random, false);
    }

    public static ReferenceFrame nextReferenceFrame(Random random, boolean use2DTransform) {
        return EuclidFrameRandomTools.nextReferenceFrame(random, ReferenceFrame.getWorldFrame(), use2DTransform);
    }

    public static ReferenceFrame nextReferenceFrame(String frameName, Random random, boolean use2DTransform) {
        return EuclidFrameRandomTools.nextReferenceFrame(frameName, random, ReferenceFrame.getWorldFrame(), use2DTransform);
    }

    public static ReferenceFrame nextReferenceFrame(Random random, ReferenceFrame parentFrame) {
        return EuclidFrameRandomTools.nextReferenceFrame(random, parentFrame, false);
    }

    public static ReferenceFrame nextReferenceFrame(Random random, ReferenceFrame parentFrame, boolean use2DTransform) {
        return EuclidFrameRandomTools.nextReferenceFrame("randomFrame", random, parentFrame, use2DTransform);
    }

    public static ReferenceFrame nextReferenceFrame(String frameName, Random random, ReferenceFrame parentFrame) {
        return EuclidFrameRandomTools.nextReferenceFrame(frameName, random, parentFrame, false);
    }

    public static ReferenceFrame nextReferenceFrame(String frameName, Random random, ReferenceFrame parentFrame, boolean use2DTransform) {
        RigidBodyTransform transformFromParent = use2DTransform ? EuclidCoreRandomTools.nextRigidBodyTransform2D((Random)random) : EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        return ReferenceFrameTools.constructFrameWithUnchangingTransformFromParent(frameName, parentFrame, (RigidBodyTransformReadOnly)transformFromParent);
    }

    public static ReferenceFrame[] nextReferenceFrameTree(Random random) {
        return EuclidFrameRandomTools.nextReferenceFrameTree(random, false);
    }

    public static ReferenceFrame[] nextReferenceFrameTree(String namePrefix, Random random) {
        return EuclidFrameRandomTools.nextReferenceFrameTree(namePrefix, random, false);
    }

    public static ReferenceFrame[] nextReferenceFrameTree(Random random, boolean use2DTransforms) {
        return EuclidFrameRandomTools.nextReferenceFrameTree(random, 20, use2DTransforms);
    }

    public static ReferenceFrame[] nextReferenceFrameTree(String namePrefix, Random random, boolean use2DTransforms) {
        return EuclidFrameRandomTools.nextReferenceFrameTree(namePrefix, random, ReferenceFrame.getWorldFrame(), 20, use2DTransforms);
    }

    public static ReferenceFrame[] nextReferenceFrameTree(Random random, int numberOfReferenceFrames) {
        return EuclidFrameRandomTools.nextReferenceFrameTree(random, numberOfReferenceFrames, false);
    }

    public static ReferenceFrame[] nextReferenceFrameTree(Random random, int numberOfReferenceFrames, boolean use2DTransforms) {
        return EuclidFrameRandomTools.nextReferenceFrameTree("randomFrame", random, ReferenceFrame.getWorldFrame(), numberOfReferenceFrames, use2DTransforms);
    }

    public static ReferenceFrame[] nextReferenceFrameTree(String frameNamePrefix, Random random, ReferenceFrame rootFrame, int numberOfReferenceFrames) {
        return EuclidFrameRandomTools.nextReferenceFrameTree(frameNamePrefix, random, rootFrame, numberOfReferenceFrames, false);
    }

    public static ReferenceFrame[] nextReferenceFrameTree(String frameNamePrefix, Random random, ReferenceFrame rootFrame, int numberOfReferenceFrames, boolean use2DTransforms) {
        ReferenceFrame[] referenceFrames = new ReferenceFrame[numberOfReferenceFrames + 1];
        referenceFrames[0] = rootFrame;
        for (int i = 0; i < numberOfReferenceFrames; ++i) {
            int parentFrameIndex = random.nextInt(i + 1);
            ReferenceFrame parentFrame = referenceFrames[parentFrameIndex];
            referenceFrames[i + 1] = EuclidFrameRandomTools.nextReferenceFrame(frameNamePrefix + i, random, parentFrame, use2DTransforms);
        }
        return referenceFrames;
    }

    public static FramePoint3D nextFramePoint3D(Random random, ReferenceFrame referenceFrame) {
        return new FramePoint3D(referenceFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
    }

    public static FramePoint3D nextFramePoint3D(Random random, ReferenceFrame referenceFrame, double minMax) {
        return new FramePoint3D(referenceFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)minMax));
    }

    public static FramePoint3D nextFramePoint3D(Random random, ReferenceFrame referenceFrame, double min, double max) {
        return new FramePoint3D(referenceFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)min, (double)max));
    }

    public static FramePoint3D nextFramePoint3D(Random random, ReferenceFrame referenceFrame, double maxAbsoluteX, double maxAbsoluteY, double maxAbsoluteZ) {
        return new FramePoint3D(referenceFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)maxAbsoluteX, (double)maxAbsoluteY, (double)maxAbsoluteZ));
    }

    public static FramePoint3D nextFramePoint3D(Random random, ReferenceFrame referenceFrame, double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        return new FramePoint3D(referenceFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)minX, (double)maxX, (double)minY, (double)maxY, (double)minZ, (double)maxZ));
    }

    public static FrameVector3D nextFrameVector3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameVector3D(referenceFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
    }

    public static FrameUnitVector3D nextFrameUnitVector3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameUnitVector3D(referenceFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextUnitVector3D((Random)random));
    }

    public static FrameVector3D nextFrameVector3D(Random random, ReferenceFrame referenceFrame, Tuple3DReadOnly minMax) {
        return new FrameVector3D(referenceFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (Tuple3DReadOnly)minMax));
    }

    public static FrameVector3D nextFrameVector3D(Random random, ReferenceFrame referenceFrame, Tuple3DReadOnly min, Tuple3DReadOnly max) {
        return new FrameVector3D(referenceFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (Tuple3DReadOnly)min, (Tuple3DReadOnly)max));
    }

    public static FrameVector3D nextFrameVector3D(Random random, ReferenceFrame referenceFrame, double min, double max) {
        return new FrameVector3D(referenceFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)min, (double)max));
    }

    public static FrameVector3D nextFrameVector3D(Random random, ReferenceFrame referenceFrame, double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        return new FrameVector3D(referenceFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)minX, (double)maxX, (double)minY, (double)maxY, (double)minZ, (double)maxZ));
    }

    public static FrameVector3D nextFrameVector3DWithFixedLength(Random random, ReferenceFrame referenceFrame, double length) {
        return new FrameVector3D(referenceFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)length));
    }

    public static FrameVector3D nextOrthogonalFrameVector3D(Random random, FrameVector3DReadOnly vectorToBeOrthogonalTo, boolean normalize) {
        return EuclidFrameRandomTools.nextOrthogonalFrameVector3D(random, vectorToBeOrthogonalTo.getReferenceFrame(), vectorToBeOrthogonalTo, normalize);
    }

    public static FrameVector3D nextOrthogonalFrameVector3D(Random random, ReferenceFrame referenceFrame, Vector3DReadOnly vectorToBeOrthogonalTo, boolean normalize) {
        return new FrameVector3D(referenceFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)vectorToBeOrthogonalTo, (boolean)normalize));
    }

    public static FramePoint2D nextFramePoint2D(Random random, ReferenceFrame referenceFrame) {
        return new FramePoint2D(referenceFrame, (Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
    }

    public static FramePoint2D nextFramePoint2D(Random random, ReferenceFrame referenceFrame, double minMax) {
        return new FramePoint2D(referenceFrame, (Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)minMax));
    }

    public static FramePoint2D nextFramePoint2D(Random random, ReferenceFrame referenceFrame, double min, double max) {
        return new FramePoint2D(referenceFrame, (Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)min, (double)max));
    }

    public static FramePoint2D nextFramePoint2D(Random random, ReferenceFrame referenceFrame, double minX, double maxX, double minY, double maxY) {
        return new FramePoint2D(referenceFrame, (Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)minX, (double)maxX, (double)minY, (double)maxY));
    }

    public static FrameVector2D nextFrameVector2D(Random random, ReferenceFrame referenceFrame) {
        return new FrameVector2D(referenceFrame, (Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random));
    }

    public static FrameUnitVector2D nextFrameUnitVector2D(Random random, ReferenceFrame referenceFrame) {
        return new FrameUnitVector2D(referenceFrame, (Tuple2DReadOnly)EuclidCoreRandomTools.nextUnitVector2D((Random)random));
    }

    public static FrameVector2D nextFrameVector2D(Random random, ReferenceFrame referenceFrame, double min, double max) {
        return new FrameVector2D(referenceFrame, (Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random, (double)min, (double)min));
    }

    public static FrameVector2D nextFrameVector2DWithFixedLength(Random random, ReferenceFrame referenceFrame, double length) {
        return new FrameVector2D(referenceFrame, (Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)length));
    }

    public static FrameVector2D nextFrameVector2D(Random random, ReferenceFrame referenceFrame, Tuple2DReadOnly minMax) {
        return new FrameVector2D(referenceFrame, (Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random, (Tuple2DReadOnly)minMax));
    }

    public static FrameVector2D nextFrameVector2D(Random random, ReferenceFrame referenceFrame, Tuple2DReadOnly min, Tuple2DReadOnly max) {
        return new FrameVector2D(referenceFrame, (Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random, (Tuple2DReadOnly)min, (Tuple2DReadOnly)max));
    }

    public static FrameYawPitchRoll nextFrameYawPitchRoll(Random random, ReferenceFrame referenceFrame) {
        return new FrameYawPitchRoll(referenceFrame, (Orientation3DReadOnly)EuclidCoreRandomTools.nextYawPitchRoll((Random)random));
    }

    public static FrameYawPitchRoll nextFrameYawPitchRoll(Random random, ReferenceFrame referenceFrame, double minMaxYaw, double minMaxPitch, double minMaxRoll) {
        return new FrameYawPitchRoll(referenceFrame, (Orientation3DReadOnly)EuclidCoreRandomTools.nextYawPitchRoll((Random)random, (double)minMaxYaw, (double)minMaxPitch, (double)minMaxRoll));
    }

    public static FrameYawPitchRoll nextFrameYawPitchRollUniform(Random random, ReferenceFrame referenceFrame, double minMaxAngle) {
        return new FrameYawPitchRoll(referenceFrame, (Orientation3DReadOnly)EuclidCoreRandomTools.nextYawPitchRollUniform((Random)random, (double)minMaxAngle));
    }

    public static FrameQuaternion nextFrameQuaternion(Random random, ReferenceFrame referenceFrame) {
        return new FrameQuaternion(referenceFrame, (QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
    }

    public static FrameQuaternion nextFrameQuaternion(Random random, ReferenceFrame referenceFrame, double minMaxAngle) {
        return new FrameQuaternion(referenceFrame, (QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random, (double)minMaxAngle));
    }

    public static FrameOrientation3DBasics nextFrameOrientation3D(Random random, ReferenceFrame referenceFrame) {
        switch (random.nextInt(3)) {
            case 0: {
                return EuclidFrameRandomTools.nextFrameQuaternion(random, referenceFrame);
            }
            case 1: {
                return EuclidFrameRandomTools.nextFrameRotationMatrix(random, referenceFrame);
            }
        }
        return EuclidFrameRandomTools.nextFrameYawPitchRoll(random, referenceFrame);
    }

    public static FrameVector4D nextFrameVector4D(Random random, ReferenceFrame referenceFrame) {
        return new FrameVector4D(referenceFrame, (Tuple4DReadOnly)EuclidCoreRandomTools.nextVector4D((Random)random));
    }

    public static FrameOrientation2D nextFrameOrientation2D(Random random, ReferenceFrame referenceFrame) {
        return new FrameOrientation2D(referenceFrame, (Orientation2DReadOnly)EuclidCoreRandomTools.nextOrientation2D((Random)random));
    }

    public static FramePose2D nextFramePose2D(Random random, ReferenceFrame referenceFrame) {
        return new FramePose2D(referenceFrame, (Pose2DReadOnly)EuclidGeometryRandomTools.nextPose2D((Random)random));
    }

    public static FramePose2D nextFramePose2D(Random random, ReferenceFrame referenceFrame, double positionMinMax, double orientationMinMax) {
        return new FramePose2D(referenceFrame, (Pose2DReadOnly)EuclidGeometryRandomTools.nextPose2D((Random)random, (double)positionMinMax, (double)orientationMinMax));
    }

    public static FramePose3D nextFramePose3D(Random random, ReferenceFrame referenceFrame) {
        return new FramePose3D(referenceFrame, (Pose3DReadOnly)EuclidGeometryRandomTools.nextPose3D((Random)random));
    }

    public static FramePose3D nextFramePose3D(Random random, ReferenceFrame referenceFrame, double maxAbsoluteX, double maxAbsoluteY, double maxAbsoluteZ) {
        return new FramePose3D(referenceFrame, (Pose3DReadOnly)EuclidGeometryRandomTools.nextPose3D((Random)random, (double)maxAbsoluteX, (double)maxAbsoluteY, (double)maxAbsoluteZ));
    }

    public static FramePose3D nextFramePose3D(Random random, ReferenceFrame referenceFrame, double positionMinMax, double orientationMinMax) {
        return new FramePose3D(referenceFrame, (Pose3DReadOnly)EuclidGeometryRandomTools.nextPose3D((Random)random, (double)positionMinMax, (double)orientationMinMax));
    }

    public static FrameLine2D nextFrameLine2D(Random random, ReferenceFrame referenceFrame) {
        return new FrameLine2D(referenceFrame, (Line2DReadOnly)EuclidGeometryRandomTools.nextLine2D((Random)random));
    }

    public static FrameLine3D nextFrameLine3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameLine3D(referenceFrame, (Line3DReadOnly)EuclidGeometryRandomTools.nextLine3D((Random)random));
    }

    public static FrameLineSegment2D nextFrameLineSegment2D(Random random, ReferenceFrame referenceFrame) {
        return new FrameLineSegment2D(referenceFrame, (LineSegment2DReadOnly)EuclidGeometryRandomTools.nextLineSegment2D((Random)random));
    }

    public static FrameLineSegment3D nextFrameLineSegment3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameLineSegment3D(referenceFrame, (LineSegment3DReadOnly)EuclidGeometryRandomTools.nextLineSegment3D((Random)random));
    }

    public static FrameBoundingBox2D nextFrameBoundingBox2D(Random random, ReferenceFrame referenceFrame) {
        return new FrameBoundingBox2D(referenceFrame, (BoundingBox2DReadOnly)EuclidGeometryRandomTools.nextBoundingBox2D((Random)random));
    }

    public static FrameBoundingBox2D nextFrameBoundingBox2D(Random random, ReferenceFrame referenceFrame, double centerMinMax, double sizeMax) {
        return new FrameBoundingBox2D(referenceFrame, (BoundingBox2DReadOnly)EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)centerMinMax, (double)sizeMax));
    }

    public static FrameBoundingBox3D nextFrameBoundingBox3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameBoundingBox3D(referenceFrame, (BoundingBox3DReadOnly)EuclidGeometryRandomTools.nextBoundingBox3D((Random)random));
    }

    public static FrameBoundingBox3D nextFrameBoundingBox3D(Random random, ReferenceFrame referenceFrame, double centerMinMax, double sizeMax) {
        return new FrameBoundingBox3D(referenceFrame, (BoundingBox3DReadOnly)EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)centerMinMax, (double)sizeMax));
    }

    public static FrameConvexPolygon2D nextFrameConvexPolygon2D(Random random, ReferenceFrame referenceFrame) {
        return new FrameConvexPolygon2D(referenceFrame, (Vertex2DSupplier)EuclidGeometryRandomTools.nextConvexPolygon2D((Random)random, (double)1.0, (int)10));
    }

    public static FrameConvexPolygon2D nextFrameConvexPolygon2D(Random random, ReferenceFrame referenceFrame, double maxAbsoluteXY, int numberOfPossiblePoints) {
        return new FrameConvexPolygon2D(referenceFrame, (Vertex2DSupplier)EuclidGeometryRandomTools.nextConvexPolygon2D((Random)random, (double)maxAbsoluteXY, (int)numberOfPossiblePoints));
    }

    public static FrameVertex2DSupplier nextFrameVertex2DSupplier(Random random, ReferenceFrame referenceFrame) {
        return EuclidFrameRandomTools.nextFrameVertex2DSupplier(random, referenceFrame, 20);
    }

    public static FrameVertex2DSupplier nextFrameVertex2DSupplier(final Random random, final ReferenceFrame referenceFrame, final int numberOfVertices) {
        return new FrameVertex2DSupplier(){
            Vertex2DSupplier vertex2dSupplier;
            {
                this.vertex2dSupplier = EuclidGeometryRandomTools.nextVertex2DSupplier((Random)random, (int)numberOfVertices);
            }

            public int getNumberOfVertices() {
                return this.vertex2dSupplier.getNumberOfVertices();
            }

            @Override
            public FramePoint2DReadOnly getVertex(int index) {
                return new FramePoint2D(referenceFrame, (Tuple2DReadOnly)this.vertex2dSupplier.getVertex(index));
            }
        };
    }

    public static FrameVertex3DSupplier nextFrameVertex3DSupplier(Random random, ReferenceFrame referenceFrame) {
        return EuclidFrameRandomTools.nextFrameVertex3DSupplier(random, referenceFrame, 20);
    }

    public static FrameVertex3DSupplier nextFrameVertex3DSupplier(final Random random, final ReferenceFrame referenceFrame, final int numberOfVertices) {
        return new FrameVertex3DSupplier(){
            Vertex3DSupplier vertex2dSupplier;
            {
                this.vertex2dSupplier = EuclidGeometryRandomTools.nextVertex3DSupplier((Random)random, (int)numberOfVertices);
            }

            public int getNumberOfVertices() {
                return this.vertex2dSupplier.getNumberOfVertices();
            }

            @Override
            public FramePoint3DReadOnly getVertex(int index) {
                return new FramePoint3D(referenceFrame, (Tuple3DReadOnly)this.vertex2dSupplier.getVertex(index));
            }
        };
    }

    public static FrameMatrix3D nextFrameMatrix3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameMatrix3D(referenceFrame, (Matrix3DReadOnly)EuclidCoreRandomTools.nextMatrix3D((Random)random));
    }

    public static FrameMatrix3D nextFrameMatrix3D(Random random, ReferenceFrame referenceFrame, double minMaxValue) {
        return new FrameMatrix3D(referenceFrame, (Matrix3DReadOnly)EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)minMaxValue));
    }

    public static FrameMatrix3D nextFrameMatrix3D(Random random, ReferenceFrame referenceFrame, double minValue, double maxValue) {
        return new FrameMatrix3D(referenceFrame, (Matrix3DReadOnly)EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)minValue, (double)maxValue));
    }

    public static FrameRotationMatrix nextFrameRotationMatrix(Random random, ReferenceFrame referenceFrame) {
        return new FrameRotationMatrix(referenceFrame, (Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
    }

    public static FrameRotationMatrix nextFrameRotationMatrix(Random random, ReferenceFrame referenceFrame, double minMaxAngle) {
        return new FrameRotationMatrix(referenceFrame, (Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random, (double)minMaxAngle));
    }

    public static FrameMatrix3D nextDiagonalFrameMatrix3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameMatrix3D(referenceFrame, (Matrix3DReadOnly)EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random));
    }

    public static FrameMatrix3D nextDiagonalFrameMatrix3D(Random random, ReferenceFrame referenceFrame, double minMaxValue) {
        return new FrameMatrix3D(referenceFrame, (Matrix3DReadOnly)EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)minMaxValue));
    }

    public static FrameMatrix3D nextDiagonalFrameMatrix3D(Random random, ReferenceFrame referenceFrame, double minValue, double maxValue) {
        return new FrameMatrix3D(referenceFrame, (Matrix3DReadOnly)EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)minValue, (double)maxValue));
    }
}

