/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DBasics;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameLine2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public interface FrameLine2DReadOnly
extends Line2DReadOnly,
EuclidFrameGeometry {
    public FramePoint2DReadOnly getPoint();

    public FrameUnitVector2DReadOnly getDirection();

    default public void get(FixedFramePoint2DBasics pointToPack, FixedFrameVector2DBasics directionToPack) {
        this.checkReferenceFrameMatch(pointToPack, directionToPack);
        super.get((Point2DBasics)pointToPack, (Vector2DBasics)directionToPack);
    }

    default public void get(FramePoint2DBasics pointToPack, FrameVector2DBasics directionToPack) {
        pointToPack.setReferenceFrame(this.getReferenceFrame());
        directionToPack.setReferenceFrame(this.getReferenceFrame());
        super.get((Point2DBasics)pointToPack, (Vector2DBasics)directionToPack);
    }

    default public void get(Point2DBasics pointToPack, FixedFrameVector2DBasics directionToPack) {
        this.checkReferenceFrameMatch(directionToPack);
        super.get(pointToPack, (Vector2DBasics)directionToPack);
    }

    default public void get(Point2DBasics pointToPack, FrameVector2DBasics directionToPack) {
        directionToPack.setReferenceFrame(this.getReferenceFrame());
        super.get(pointToPack, (Vector2DBasics)directionToPack);
    }

    default public void get(FixedFramePoint2DBasics pointToPack, Vector2DBasics directionToPack) {
        this.checkReferenceFrameMatch(pointToPack);
        super.get((Point2DBasics)pointToPack, directionToPack);
    }

    default public void get(FramePoint2DBasics pointToPack, Vector2DBasics directionToPack) {
        pointToPack.setReferenceFrame(this.getReferenceFrame());
        super.get((Point2DBasics)pointToPack, directionToPack);
    }

    default public boolean isPointOnLeftSideOfLine(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.isPointOnLeftSideOfLine((Point2DReadOnly)point);
    }

    default public double distance(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.distance((Point2DReadOnly)point);
    }

    default public boolean isPointOnLine(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.isPointOnLine((Point2DReadOnly)point);
    }

    default public boolean isPointOnLine(FramePoint2DReadOnly point, double epsilon) {
        this.checkReferenceFrameMatch(point);
        return super.isPointOnLine((Point2DReadOnly)point, epsilon);
    }

    default public boolean isPointOnRightSideOfLine(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.isPointOnRightSideOfLine((Point2DReadOnly)point);
    }

    default public boolean isPointOnSideOfLine(FramePoint2DReadOnly point, boolean testLeftSide) {
        this.checkReferenceFrameMatch(point);
        return super.isPointOnSideOfLine((Point2DReadOnly)point, testLeftSide);
    }

    default public FramePoint2DBasics intersectionWith(Line2DReadOnly secondLine) {
        Point2DBasics intersection = super.intersectionWith(secondLine);
        if (intersection == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)intersection);
    }

    default public FramePoint2DBasics intersectionWith(FrameLine2DReadOnly secondLine) {
        this.checkReferenceFrameMatch(secondLine);
        Point2DBasics intersection = super.intersectionWith((Line2DReadOnly)secondLine);
        if (intersection == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)intersection);
    }

    default public boolean intersectionWith(FrameLine2DReadOnly secondLine, Point2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(secondLine);
        return super.intersectionWith((Line2DReadOnly)secondLine, intersectionToPack);
    }

    default public boolean intersectionWith(FrameLine2DReadOnly secondLine, FixedFramePoint2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(secondLine);
        if (intersectionToPack != null) {
            this.checkReferenceFrameMatch(intersectionToPack);
        }
        return super.intersectionWith((Line2DReadOnly)secondLine, (Point2DBasics)intersectionToPack);
    }

    default public boolean intersectionWith(FrameLine2DReadOnly secondLine, FramePoint2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(secondLine);
        if (intersectionToPack != null) {
            intersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWith((Line2DReadOnly)secondLine, (Point2DBasics)intersectionToPack);
    }

    default public boolean intersectionWith(Line2DReadOnly secondLine, FixedFramePoint2DBasics intersectionToPack) {
        if (intersectionToPack != null) {
            this.checkReferenceFrameMatch(intersectionToPack);
        }
        return super.intersectionWith(secondLine, (Point2DBasics)intersectionToPack);
    }

    default public boolean intersectionWith(Line2DReadOnly secondLine, FramePoint2DBasics intersectionToPack) {
        if (intersectionToPack != null) {
            intersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWith(secondLine, (Point2DBasics)intersectionToPack);
    }

    default public FramePoint2DBasics intersectionWith(LineSegment2DReadOnly lineSegment) {
        Point2DBasics intersection = super.intersectionWith(lineSegment);
        if (intersection == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)intersection);
    }

    default public FramePoint2DBasics intersectionWith(FrameLineSegment2DReadOnly lineSegment) {
        this.checkReferenceFrameMatch(lineSegment);
        Point2DBasics intersection = super.intersectionWith((LineSegment2DReadOnly)lineSegment);
        if (intersection == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)intersection);
    }

    default public boolean intersectionWith(FrameLineSegment2DReadOnly lineSegment, Point2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(lineSegment);
        return super.intersectionWith((LineSegment2DReadOnly)lineSegment, intersectionToPack);
    }

    default public boolean intersectionWith(LineSegment2DReadOnly lineSegment, FixedFramePoint2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(intersectionToPack);
        return super.intersectionWith(lineSegment, (Point2DBasics)intersectionToPack);
    }

    default public boolean intersectionWith(LineSegment2DReadOnly lineSegment, FramePoint2DBasics intersectionToPack) {
        intersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith(lineSegment, (Point2DBasics)intersectionToPack);
    }

    default public boolean intersectionWith(FrameLineSegment2DReadOnly lineSegment, FixedFramePoint2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(lineSegment, intersectionToPack);
        return super.intersectionWith((LineSegment2DReadOnly)lineSegment, (Point2DBasics)intersectionToPack);
    }

    default public boolean intersectionWith(FrameLineSegment2DReadOnly lineSegment, FramePoint2DBasics intersectionToPack) {
        this.checkReferenceFrameMatch(lineSegment);
        intersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith((LineSegment2DReadOnly)lineSegment, (Point2DBasics)intersectionToPack);
    }

    default public FramePoint2DBasics[] intersectionWith(ConvexPolygon2DReadOnly convexPolygon) {
        Point2DBasics[] intersections = convexPolygon.intersectionWith((Line2DReadOnly)this);
        if (intersections == null) {
            return null;
        }
        FramePoint2DBasics[] frameIntersections = new FramePoint2D[intersections.length];
        for (int i = 0; i < intersections.length; ++i) {
            frameIntersections[i] = new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)intersections[i]);
        }
        return frameIntersections;
    }

    default public FramePoint2DBasics[] intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon) {
        this.checkReferenceFrameMatch(convexPolygon);
        return this.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, FixedFramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(firstIntersectionToPack);
        return super.intersectionWith(convexPolygon, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, FixedFramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon, firstIntersectionToPack);
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, FramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith(convexPolygon, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, FramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon);
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(firstIntersectionToPack, secondIntersectionToPack);
        return super.intersectionWith(convexPolygon, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon, firstIntersectionToPack, secondIntersectionToPack);
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith(convexPolygon, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon);
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, Point2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(secondIntersectionToPack);
        return super.intersectionWith(convexPolygon, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, Point2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon, secondIntersectionToPack);
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, Point2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith(convexPolygon, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, Point2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon);
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameConvexPolygon2DReadOnly convexPolygon, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(convexPolygon);
        return super.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public boolean isPointBehindLine(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.isPointBehindLine((Point2DReadOnly)point);
    }

    default public boolean isPointInFrontOfLine(FrameVector2DReadOnly frontDirection, Point2DReadOnly point) {
        this.checkReferenceFrameMatch(frontDirection);
        return super.isPointInFrontOfLine((Vector2DReadOnly)frontDirection, point);
    }

    default public boolean isPointInFrontOfLine(Vector2DReadOnly frontDirection, FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.isPointInFrontOfLine(frontDirection, (Point2DReadOnly)point);
    }

    default public boolean isPointInFrontOfLine(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.isPointInFrontOfLine((Point2DReadOnly)point);
    }

    default public boolean isPointInFrontOfLine(FrameVector2DReadOnly frontDirection, FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(frontDirection, point);
        return super.isPointInFrontOfLine((Vector2DReadOnly)frontDirection, (Point2DReadOnly)point);
    }

    default public boolean orthogonalProjection(FixedFramePoint2DBasics pointToProject) {
        this.checkReferenceFrameMatch(pointToProject);
        return super.orthogonalProjection((Point2DBasics)pointToProject);
    }

    default public boolean orthogonalProjection(FramePoint2DReadOnly pointToProject, Point2DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject);
        return super.orthogonalProjection((Point2DReadOnly)pointToProject, projectionToPack);
    }

    default public boolean orthogonalProjection(Point2DReadOnly pointToProject, FixedFramePoint2DBasics projectionToPack) {
        this.checkReferenceFrameMatch(projectionToPack);
        return super.orthogonalProjection(pointToProject, (Point2DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(Point2DReadOnly pointToProject, FramePoint2DBasics projectionToPack) {
        projectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.orthogonalProjection(pointToProject, (Point2DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint2DReadOnly pointToProject, FixedFramePoint2DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject, projectionToPack);
        return super.orthogonalProjection((Point2DReadOnly)pointToProject, (Point2DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint2DReadOnly pointToProject, FramePoint2DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject);
        projectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.orthogonalProjection((Point2DReadOnly)pointToProject, (Point2DBasics)projectionToPack);
    }

    default public FramePoint2DBasics orthogonalProjectionCopy(Point2DReadOnly pointToProject) {
        Point2DBasics projection = super.orthogonalProjectionCopy(pointToProject);
        if (projection == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)projection);
    }

    default public FramePoint2DBasics orthogonalProjectionCopy(FramePoint2DReadOnly pointToProject) {
        this.checkReferenceFrameMatch(pointToProject);
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)super.orthogonalProjectionCopy((Point2DReadOnly)pointToProject));
    }

    default public FrameLine2DBasics interiorBisector(Line2DReadOnly secondLine) {
        return new FrameLine2D(this.getReferenceFrame(), (Line2DReadOnly)super.interiorBisector(secondLine));
    }

    default public FrameLine2DBasics interiorBisector(FrameLine2DReadOnly secondLine) {
        this.checkReferenceFrameMatch(secondLine);
        return new FrameLine2D(this.getReferenceFrame(), (Line2DReadOnly)super.interiorBisector((Line2DReadOnly)secondLine));
    }

    default public boolean isCollinear(FrameLine2DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.isCollinear((Line2DReadOnly)other, epsilon);
    }

    default public boolean isCollinear(FrameLine2DReadOnly other, double angleEpsilon, double distanceEpsilon) {
        this.checkReferenceFrameMatch(other);
        return super.isCollinear((Line2DReadOnly)other, angleEpsilon, distanceEpsilon);
    }

    default public double parameterGivenPointOnLine(FramePoint2DReadOnly pointOnLine, double epsilon) {
        this.checkReferenceFrameMatch(pointOnLine);
        return super.parameterGivenPointOnLine((Point2DReadOnly)pointOnLine, epsilon);
    }

    default public FrameLine2DBasics perpendicularLineThroughPoint(Point2DReadOnly point) {
        return new FrameLine2D(this.getReferenceFrame(), (Line2DReadOnly)super.perpendicularLineThroughPoint(point));
    }

    default public FrameLine2DBasics perpendicularLineThroughPoint(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return new FrameLine2D(this.getReferenceFrame(), (Line2DReadOnly)super.perpendicularLineThroughPoint((Point2DReadOnly)point));
    }

    default public void perpendicularLineThroughPoint(FramePoint2DReadOnly point, Line2DBasics perpendicularLineToPack) {
        this.checkReferenceFrameMatch(point);
        super.perpendicularLineThroughPoint((Point2DReadOnly)point, perpendicularLineToPack);
    }

    default public void perpendicularLineThroughPoint(FramePoint2DReadOnly point, FixedFrameLine2DBasics perpendicularLineToPack) {
        this.checkReferenceFrameMatch(point, perpendicularLineToPack);
        super.perpendicularLineThroughPoint((Point2DReadOnly)point, (Line2DBasics)perpendicularLineToPack);
    }

    default public void perpendicularLineThroughPoint(FramePoint2DReadOnly point, FrameLine2DBasics perpendicularLineToPack) {
        this.checkReferenceFrameMatch(point);
        perpendicularLineToPack.setReferenceFrame(this.getReferenceFrame());
        super.perpendicularLineThroughPoint((Point2DReadOnly)point, (Line2DBasics)perpendicularLineToPack);
    }

    default public void perpendicularLineThroughPoint(Point2DReadOnly point, FixedFrameLine2DBasics perpendicularLineToPack) {
        this.checkReferenceFrameMatch(perpendicularLineToPack);
        super.perpendicularLineThroughPoint(point, (Line2DBasics)perpendicularLineToPack);
    }

    default public void perpendicularLineThroughPoint(Point2DReadOnly point, FrameLine2DBasics perpendicularLineToPack) {
        perpendicularLineToPack.setReferenceFrame(this.getReferenceFrame());
        super.perpendicularLineThroughPoint(point, (Line2DBasics)perpendicularLineToPack);
    }

    default public void getTwoPointsOnLine(FixedFramePoint2DBasics firstPointOnLineToPack, Point2DBasics secondPointOnLineToPack) {
        this.checkReferenceFrameMatch(firstPointOnLineToPack);
        super.getTwoPointsOnLine((Point2DBasics)firstPointOnLineToPack, secondPointOnLineToPack);
    }

    default public void getTwoPointsOnLine(FramePoint2DBasics firstPointOnLineToPack, Point2DBasics secondPointOnLineToPack) {
        firstPointOnLineToPack.setReferenceFrame(this.getReferenceFrame());
        super.getTwoPointsOnLine((Point2DBasics)firstPointOnLineToPack, secondPointOnLineToPack);
    }

    default public void getTwoPointsOnLine(Point2DBasics firstPointOnLineToPack, FixedFramePoint2DBasics secondPointOnLineToPack) {
        this.checkReferenceFrameMatch(secondPointOnLineToPack);
        super.getTwoPointsOnLine(firstPointOnLineToPack, (Point2DBasics)secondPointOnLineToPack);
    }

    default public void getTwoPointsOnLine(Point2DBasics firstPointOnLineToPack, FramePoint2DBasics secondPointOnLineToPack) {
        secondPointOnLineToPack.setReferenceFrame(this.getReferenceFrame());
        super.getTwoPointsOnLine(firstPointOnLineToPack, (Point2DBasics)secondPointOnLineToPack);
    }

    default public void getTwoPointsOnLine(FixedFramePoint2DBasics firstPointOnLineToPack, FixedFramePoint2DBasics secondPointOnLineToPack) {
        this.checkReferenceFrameMatch(firstPointOnLineToPack, secondPointOnLineToPack);
        super.getTwoPointsOnLine((Point2DBasics)firstPointOnLineToPack, (Point2DBasics)secondPointOnLineToPack);
    }

    default public void getTwoPointsOnLine(FramePoint2DBasics firstPointOnLineToPack, FramePoint2DBasics secondPointOnLineToPack) {
        firstPointOnLineToPack.setReferenceFrame(this.getReferenceFrame());
        secondPointOnLineToPack.setReferenceFrame(this.getReferenceFrame());
        super.getTwoPointsOnLine((Point2DBasics)firstPointOnLineToPack, (Point2DBasics)secondPointOnLineToPack);
    }

    default public boolean areLinesPerpendicular(FrameLine2DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        return super.areLinesPerpendicular((Line2DReadOnly)other);
    }

    default public FrameVector2DBasics perpendicularVector() {
        return new FrameVector2D(this.getReferenceFrame(), (Tuple2DReadOnly)super.perpendicularVector());
    }

    default public void perpendicularVector(FixedFrameVector2DBasics vectorToPack) {
        this.checkReferenceFrameMatch(vectorToPack);
        super.perpendicularVector((Vector2DBasics)vectorToPack);
    }

    default public void perpendicularVector(FrameVector2DBasics vectorToPack) {
        vectorToPack.setReferenceFrame(this.getReferenceFrame());
        super.perpendicularVector((Vector2DBasics)vectorToPack);
    }

    default public void pointOnLineGivenParameter(double t, FixedFramePoint2DBasics pointToPack) {
        this.checkReferenceFrameMatch(pointToPack);
        super.pointOnLineGivenParameter(t, (Point2DBasics)pointToPack);
    }

    default public void pointOnLineGivenParameter(double t, FramePoint2DBasics pointToPack) {
        pointToPack.setReferenceFrame(this.getReferenceFrame());
        super.pointOnLineGivenParameter(t, (Point2DBasics)pointToPack);
    }

    default public FramePoint2DBasics pointOnLineGivenParameter(double t) {
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)super.pointOnLineGivenParameter(t));
    }

    default public boolean interiorBisector(FrameLine2DReadOnly secondLine, Line2DBasics interiorBisectorToPack) {
        this.checkReferenceFrameMatch(secondLine);
        return super.interiorBisector((Line2DReadOnly)secondLine, interiorBisectorToPack);
    }

    default public boolean interiorBisector(Line2DReadOnly secondLine, FixedFrameLine2DBasics interiorBisectorToPack) {
        this.checkReferenceFrameMatch(interiorBisectorToPack);
        return super.interiorBisector(secondLine, (Line2DBasics)interiorBisectorToPack);
    }

    default public boolean interiorBisector(Line2DReadOnly secondLine, FrameLine2DBasics interiorBisectorToPack) {
        interiorBisectorToPack.setReferenceFrame(this.getReferenceFrame());
        return super.interiorBisector(secondLine, (Line2DBasics)interiorBisectorToPack);
    }

    default public boolean interiorBisector(FrameLine2DReadOnly secondLine, FixedFrameLine2DBasics interiorBisectorToPack) {
        this.checkReferenceFrameMatch(secondLine, interiorBisectorToPack);
        return super.interiorBisector((Line2DReadOnly)secondLine, (Line2DBasics)interiorBisectorToPack);
    }

    default public boolean interiorBisector(FrameLine2DReadOnly secondLine, FrameLine2DBasics interiorBisectorToPack) {
        this.checkReferenceFrameMatch(secondLine);
        interiorBisectorToPack.setReferenceFrame(this.getReferenceFrame());
        return super.interiorBisector((Line2DReadOnly)secondLine, (Line2DBasics)interiorBisectorToPack);
    }

    default public String toString(String format) {
        return EuclidFrameIOTools.getFrameLine2DString(format, this);
    }
}

