/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.FrameNameRestrictionLevel;
import us.ihmc.euclid.referenceFrame.ReferenceFrameChangedListener;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;

public abstract class ReferenceFrame {
    public static final String SEPARATOR = ":";
    public static FrameNameRestrictionLevel DEFAULT_RESTRICTION_LEVEL = FrameNameRestrictionLevel.loadFromEnvironment("euclid.referenceFrame.restrictionLevel", "FrameNameRestrictionLevel", FrameNameRestrictionLevel.NAME_ID);
    private final String frameName;
    private final String nameId;
    private final long frameIndex;
    private long framesAddedToTree = 0L;
    private long additionalNameBasedHashCode;
    private final ReferenceFrame parentFrame;
    private final List<WeakReference<ReferenceFrame>> children = new ArrayList<WeakReference<ReferenceFrame>>();
    private final HashSet<String> childrenNames = new HashSet();
    private boolean hasDuplicateChildrenNames = false;
    private ReferenceFrame topFrameNameRestriction = null;
    private final HashSet<String> subtreeFrameNames = new HashSet();
    private boolean hasBeenRemoved = false;
    private final ReferenceFrame[] framesStartingWithRootEndingWithThis;
    private final RigidBodyTransform transformToParent;
    static long nextTransformToRootID = 1L;
    long transformToRootID = Long.MIN_VALUE;
    private final RigidBodyTransform transformToRoot;
    private boolean accessingTransformToRoot = false;
    private Predicate<ReferenceFrame> treeUpdateCondition = null;
    private final boolean isAStationaryFrame;
    private final boolean isZupFrame;
    private final boolean isFixedInParent;
    private List<ReferenceFrameChangedListener> changedListeners = null;
    private FrameNameRestrictionLevel nameRestrictionLevel;

    public ReferenceFrame(String frameName) {
        this(frameName, null, null, true, true);
    }

    public ReferenceFrame(String frameName, ReferenceFrame parentFrame) {
        this(frameName, parentFrame, null, false, false);
    }

    public ReferenceFrame(String frameName, ReferenceFrame parentFrame, boolean isAStationaryFrame, boolean isZupFrame) {
        this(frameName, parentFrame, null, isAStationaryFrame, isZupFrame);
    }

    public ReferenceFrame(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent) {
        this(frameName, parentFrame, transformToParent, false, false);
    }

    public ReferenceFrame(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent, boolean isAStationaryFrame, boolean isZupFrame) {
        this(frameName, parentFrame, transformToParent, isAStationaryFrame, isZupFrame, false);
    }

    public ReferenceFrame(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent, boolean isAStationaryFrame, boolean isZupFrame, boolean isFixedInParent) {
        if (frameName.contains(SEPARATOR)) {
            throw new RuntimeException("A reference frame name can not contain ':'. Tried to construct a frame with name " + frameName + ".");
        }
        this.frameName = frameName;
        this.parentFrame = parentFrame;
        this.framesStartingWithRootEndingWithThis = ReferenceFrameTools.createPathFromRoot(this);
        if (parentFrame == null) {
            this.transformToRootID = 0L;
            this.nameId = frameName;
            this.frameIndex = 0L;
            this.transformToRoot = null;
            this.transformToParent = null;
            this.isAStationaryFrame = true;
            this.isZupFrame = true;
            this.isFixedInParent = true;
            this.nameRestrictionLevel = DEFAULT_RESTRICTION_LEVEL;
            if (this.nameRestrictionLevel == FrameNameRestrictionLevel.FRAME_NAME) {
                this.topFrameNameRestriction = this;
                this.subtreeFrameNames.add(frameName);
            }
        } else {
            parentFrame.checkIfRemoved();
            this.nameId = parentFrame.nameId + SEPARATOR + frameName;
            this.nameRestrictionLevel = parentFrame.nameRestrictionLevel;
            if (this.nameRestrictionLevel == FrameNameRestrictionLevel.FRAME_NAME) {
                this.topFrameNameRestriction = parentFrame.topFrameNameRestriction;
            }
            this.checkAndProcessNewFrameName();
            this.frameIndex = parentFrame.incrementFramesAdded();
            parentFrame.children.add(new WeakReference<ReferenceFrame>(this));
            this.transformToRoot = new RigidBodyTransform();
            this.transformToParent = new RigidBodyTransform();
            if (transformToParent != null) {
                this.transformToParent.set(transformToParent);
                this.transformToParent.normalizeRotationPart();
            }
            if (isAStationaryFrame && !parentFrame.isAStationaryFrame) {
                throw new IllegalArgumentException("The child of a non-stationary frame cannot be stationary.");
            }
            this.isAStationaryFrame = isAStationaryFrame;
            this.isZupFrame = isZupFrame;
            this.isFixedInParent = isFixedInParent;
            this.notifyListeners(ChangeType.FRAME_ADDED, this, parentFrame);
        }
    }

    public void setNameRestrictionLevel(FrameNameRestrictionLevel nameRestrictionLevel) {
        if (this.nameRestrictionLevel == nameRestrictionLevel) {
            return;
        }
        if (nameRestrictionLevel.ordinal() < this.nameRestrictionLevel.ordinal()) {
            if (this.parentFrame == null && this.children.isEmpty()) {
                this.topFrameNameRestriction = null;
                this.nameRestrictionLevel = nameRestrictionLevel;
            } else {
                throw new IllegalArgumentException("Cannot reduce name restriction level. Current mode: " + this.nameRestrictionLevel + ", tried to set to: " + nameRestrictionLevel);
            }
        }
        this.setAndCheckRestrictionLevelRecursively(nameRestrictionLevel, this);
    }

    private void setAndCheckRestrictionLevelRecursively(FrameNameRestrictionLevel nameRestrictionLevel, ReferenceFrame frameWithNewRestrictionLevel) {
        this.nameRestrictionLevel = nameRestrictionLevel;
        if (nameRestrictionLevel == FrameNameRestrictionLevel.NAME_ID) {
            if (this.hasDuplicateChildrenNames) {
                throw new RuntimeException("Duplicate ReferenceFrame nameId's detected!");
            }
        } else if (nameRestrictionLevel == FrameNameRestrictionLevel.FRAME_NAME) {
            this.topFrameNameRestriction = frameWithNewRestrictionLevel;
            if (this.topFrameNameRestriction.subtreeFrameNames.contains(this.frameName)) {
                throw new RuntimeException("Duplicate ReferenceFrame names detected: " + this.frameName);
            }
            this.topFrameNameRestriction.subtreeFrameNames.add(this.frameName);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ReferenceFrame childFrame = (ReferenceFrame)this.children.get(i).get();
            if (childFrame == null) continue;
            childFrame.setAndCheckRestrictionLevelRecursively(nameRestrictionLevel, frameWithNewRestrictionLevel);
        }
    }

    private void checkAndProcessNewFrameName() {
        if (this.nameRestrictionLevel == FrameNameRestrictionLevel.NAME_ID) {
            if (this.parentFrame.childrenNames.contains(this.frameName)) {
                throw new RuntimeException("Duplicate reference frame: " + this.nameId);
            }
        } else if (this.nameRestrictionLevel == FrameNameRestrictionLevel.FRAME_NAME) {
            if (this.topFrameNameRestriction.subtreeFrameNames.contains(this.frameName)) {
                throw new RuntimeException("Frame " + this.frameName + " already exists: " + this.nameId);
            }
            this.topFrameNameRestriction.subtreeFrameNames.add(this.frameName);
        }
        this.parentFrame.hasDuplicateChildrenNames = this.hasDuplicateChildrenNames || this.parentFrame.childrenNames.contains(this.frameName);
        this.parentFrame.childrenNames.add(this.frameName);
    }

    public FrameNameRestrictionLevel getNameRestrictionLevel() {
        this.checkIfRemoved();
        return this.nameRestrictionLevel;
    }

    private long incrementFramesAdded() {
        ++this.framesAddedToTree;
        if (this.parentFrame == null) {
            return this.framesAddedToTree;
        }
        return this.parentFrame.incrementFramesAdded();
    }

    public boolean isWorldFrame() {
        this.checkIfRemoved();
        return this == ReferenceFrameTools.getWorldFrame();
    }

    public boolean isRootFrame() {
        this.checkIfRemoved();
        return this.parentFrame == null;
    }

    public boolean isAStationaryFrame() {
        this.checkIfRemoved();
        return this.isAStationaryFrame;
    }

    public boolean isZupFrame() {
        this.checkIfRemoved();
        return this.isZupFrame;
    }

    public boolean isFixedInParent() {
        this.checkIfRemoved();
        return this.isFixedInParent;
    }

    public void update() {
        this.checkIfRemoved();
        if (this.parentFrame == null) {
            return;
        }
        this.updateTransformToParent(this.transformToParent);
        this.transformToRootID = Long.MIN_VALUE;
    }

    protected abstract void updateTransformToParent(RigidBodyTransform var1);

    public ReferenceFrame getParent() {
        this.checkIfRemoved();
        return this.parentFrame;
    }

    public ReferenceFrame getRootFrame() {
        this.checkIfRemoved();
        return this.framesStartingWithRootEndingWithThis[0];
    }

    public RigidBodyTransform getTransformToParent() {
        RigidBodyTransform transformToReturn = new RigidBodyTransform();
        this.getTransformToParent(transformToReturn);
        return transformToReturn;
    }

    public void getTransformToParent(RigidBodyTransform transformToPack) {
        this.checkIfRemoved();
        transformToPack.set(this.transformToParent);
    }

    public void getTransformToParent(RigidBodyTransformBasics transformToPack) {
        this.checkIfRemoved();
        transformToPack.set((RigidBodyTransformReadOnly)this.transformToParent);
    }

    public String getName() {
        this.checkIfRemoved();
        return this.frameName;
    }

    public String getNameId() {
        this.checkIfRemoved();
        return this.nameId;
    }

    public RigidBodyTransform getTransformToDesiredFrame(ReferenceFrame desiredFrame) {
        RigidBodyTransform ret = new RigidBodyTransform();
        this.getTransformToDesiredFrame(ret, desiredFrame);
        return ret;
    }

    public RigidBodyTransform getTransformToWorldFrame() {
        RigidBodyTransform ret = new RigidBodyTransform();
        this.getTransformToDesiredFrame(ret, ReferenceFrameTools.getWorldFrame());
        return ret;
    }

    public void getTransformToDesiredFrame(RigidBodyTransform transformToPack, ReferenceFrame desiredFrame) {
        this.getTransformToDesiredFrame((RigidBodyTransformBasics)transformToPack, desiredFrame);
    }

    public void getTransformToDesiredFrame(RigidBodyTransformBasics transformToPack, ReferenceFrame desiredFrame) {
        this.checkIfRemoved();
        try {
            if (this == desiredFrame) {
                transformToPack.setToZero();
                return;
            }
            this.verifySameRoots(desiredFrame);
            if (this.isRootFrame()) {
                transformToPack.setAndInvert((RigidBodyTransformReadOnly)desiredFrame.getTransformToRoot());
            } else if (desiredFrame.isRootFrame()) {
                transformToPack.set((RigidBodyTransformReadOnly)this.getTransformToRoot());
            } else if (this.isParentFrame(desiredFrame)) {
                transformToPack.set((RigidBodyTransformReadOnly)this.transformToParent);
            } else if (desiredFrame.isParentFrame(this)) {
                transformToPack.setAndInvert((RigidBodyTransformReadOnly)desiredFrame.transformToParent);
            } else if (this.parentFrame == desiredFrame.parentFrame) {
                transformToPack.setAndInvert((RigidBodyTransformReadOnly)desiredFrame.transformToParent);
                transformToPack.multiply((RigidBodyTransformReadOnly)this.transformToParent);
            } else if (this.parentFrame.parentFrame == desiredFrame) {
                transformToPack.set((RigidBodyTransformReadOnly)this.transformToParent);
                if (!this.parentFrame.isRootFrame()) {
                    transformToPack.preMultiply((RigidBodyTransformReadOnly)this.parentFrame.transformToParent);
                }
            } else if (this == desiredFrame.parentFrame.parentFrame) {
                transformToPack.setAndInvert((RigidBodyTransformReadOnly)desiredFrame.transformToParent);
                if (!desiredFrame.parentFrame.isRootFrame()) {
                    transformToPack.multiplyInvertOther((RigidBodyTransformReadOnly)desiredFrame.parentFrame.transformToParent);
                }
            } else {
                transformToPack.setAndInvert((RigidBodyTransformReadOnly)desiredFrame.getTransformToRoot());
                transformToPack.multiply((RigidBodyTransformReadOnly)this.getTransformToRoot());
            }
        }
        catch (NotARotationMatrixException e) {
            throw new NotARotationMatrixException("Caught exception, this frame: " + this.frameName + ", other frame: " + desiredFrame.getName() + ", exception:\n" + e.getMessage());
        }
    }

    public boolean isParentFrame(ReferenceFrame frame) {
        this.checkIfRemoved();
        return frame == this.parentFrame;
    }

    public boolean isChildFrame(ReferenceFrame frame) {
        this.checkIfRemoved();
        return frame.isParentFrame(this);
    }

    public void verifySameRoots(ReferenceFrame referenceFrame) {
        if (this.getRootFrame() != referenceFrame.getRootFrame()) {
            throw new RuntimeException("Frames do not have same roots. this = " + this + ", referenceFrame = " + referenceFrame);
        }
    }

    public void transformFromThisToDesiredFrame(ReferenceFrame desiredFrame, Transformable objectToTransform) {
        this.checkIfRemoved();
        if (this == desiredFrame) {
            return;
        }
        this.verifySameRoots(desiredFrame);
        if (this.isRootFrame()) {
            objectToTransform.applyInverseTransform((Transform)desiredFrame.getTransformToRoot());
        } else if (desiredFrame.isRootFrame()) {
            objectToTransform.applyTransform((Transform)this.getTransformToRoot());
        } else if (this.isParentFrame(desiredFrame)) {
            objectToTransform.applyTransform((Transform)this.transformToParent);
        } else if (desiredFrame.isParentFrame(this)) {
            objectToTransform.applyInverseTransform((Transform)desiredFrame.transformToParent);
        } else if (this.parentFrame == desiredFrame.parentFrame) {
            objectToTransform.applyTransform((Transform)this.transformToParent);
            objectToTransform.applyInverseTransform((Transform)desiredFrame.transformToParent);
        } else if (this.parentFrame.parentFrame == desiredFrame) {
            objectToTransform.applyTransform((Transform)this.transformToParent);
            if (!this.parentFrame.isRootFrame()) {
                objectToTransform.applyTransform((Transform)this.parentFrame.transformToParent);
            }
        } else if (this == desiredFrame.parentFrame.parentFrame) {
            if (!desiredFrame.parentFrame.isRootFrame()) {
                objectToTransform.applyInverseTransform((Transform)desiredFrame.parentFrame.transformToParent);
            }
            objectToTransform.applyInverseTransform((Transform)desiredFrame.transformToParent);
        } else {
            objectToTransform.applyTransform((Transform)this.getTransformToRoot());
            objectToTransform.applyInverseTransform((Transform)desiredFrame.getTransformToRoot());
        }
    }

    public RigidBodyTransform getTransformToRoot() {
        this.efficientComputeTransform();
        return this.transformToRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void efficientComputeTransform() {
        Predicate<ReferenceFrame> treeUpdateCondition = this.framesStartingWithRootEndingWithThis[0].treeUpdateCondition;
        if (treeUpdateCondition != null && !treeUpdateCondition.test(this)) {
            return;
        }
        this.checkIfRemoved();
        int chainLength = this.framesStartingWithRootEndingWithThis.length;
        boolean updateFromHereOnOut = false;
        long previousUpdateId = 0L;
        for (int i = 0; i < chainLength; ++i) {
            ReferenceFrame referenceFrame = this.framesStartingWithRootEndingWithThis[i];
            if (!updateFromHereOnOut && referenceFrame.transformToRootID < previousUpdateId) {
                updateFromHereOnOut = true;
                ++nextTransformToRootID;
            }
            if (updateFromHereOnOut && referenceFrame.parentFrame != null) {
                if (referenceFrame.accessingTransformToRoot) {
                    return;
                }
                try {
                    referenceFrame.accessingTransformToRoot = true;
                    RigidBodyTransform parentsTransformToRoot = referenceFrame.parentFrame.transformToRoot;
                    if (parentsTransformToRoot != null) {
                        if (referenceFrame.parentFrame.accessingTransformToRoot) {
                            return;
                        }
                        referenceFrame.parentFrame.accessingTransformToRoot = true;
                        try {
                            referenceFrame.transformToRoot.set(parentsTransformToRoot);
                        }
                        finally {
                            referenceFrame.parentFrame.accessingTransformToRoot = false;
                        }
                        referenceFrame.transformToRoot.multiply((RigidBodyTransformReadOnly)referenceFrame.transformToParent);
                        referenceFrame.transformToRoot.normalizeRotationPart();
                    } else {
                        referenceFrame.transformToRoot.set(referenceFrame.transformToParent);
                    }
                    referenceFrame.transformToRootID = nextTransformToRootID;
                }
                finally {
                    referenceFrame.accessingTransformToRoot = false;
                }
            }
            previousUpdateId = referenceFrame.transformToRootID;
        }
    }

    public String toString() {
        this.checkIfRemoved();
        return this.frameName;
    }

    public void checkReferenceFrameMatch(ReferenceFrameHolder referenceFrameHolder) throws ReferenceFrameMismatchException {
        this.checkReferenceFrameMatch(referenceFrameHolder.getReferenceFrame());
    }

    public void checkReferenceFrameMatch(ReferenceFrame referenceFrame) throws ReferenceFrameMismatchException {
        this.checkIfRemoved();
        if (this != referenceFrame) {
            String msg = "Argument's frame " + referenceFrame + " does not match " + this;
            throw new ReferenceFrameMismatchException(msg);
        }
    }

    public void checkIsWorldFrame() throws RuntimeException {
        this.checkIfRemoved();
        if (!this.isWorldFrame()) {
            throw new RuntimeException("Frame " + this + " is not world frame.");
        }
    }

    public void checkIsAStationaryFrame() throws RuntimeException {
        this.checkIfRemoved();
        if (!this.isAStationaryFrame()) {
            throw new RuntimeException("Frame " + this + " is not a stationary frame.");
        }
    }

    public void checkIsAZUpFrame() throws RuntimeException {
        this.checkIfRemoved();
        if (!this.isZupFrame()) {
            throw new RuntimeException("Frame " + this + " is not a z-up frame.");
        }
    }

    public int hashCode() {
        this.checkIfRemoved();
        return this.nameId.hashCode();
    }

    public boolean equals(Object other) {
        this.checkIfRemoved();
        if (other instanceof ReferenceFrame) {
            return ((ReferenceFrame)other).nameId.equals(this.nameId);
        }
        return false;
    }

    public long getFrameIndex() {
        this.checkIfRemoved();
        return this.frameIndex;
    }

    public long getAdditionalNameBasedHashCode() {
        this.checkIfRemoved();
        return this.additionalNameBasedHashCode;
    }

    public void setAdditionalNameBasedHashCode(long additionalNameBasedHashCode) {
        this.checkIfRemoved();
        this.additionalNameBasedHashCode = additionalNameBasedHashCode;
    }

    protected void checkIfRemoved() {
        if (this.hasBeenRemoved) {
            throw new RuntimeException("Can not use frame that was removed from the frame tree.");
        }
    }

    public void remove() {
        if (!this.hasBeenRemoved && this.parentFrame != null) {
            this.parentFrame.updateChildren();
            for (int i = 0; i < this.parentFrame.children.size(); ++i) {
                if (this.parentFrame.children.get(i).get() != this) continue;
                this.parentFrame.children.remove(i);
                this.parentFrame.childrenNames.remove(this.frameName);
                break;
            }
            if (this.topFrameNameRestriction != null) {
                this.topFrameNameRestriction.subtreeFrameNames.remove(this.frameName);
            }
            this.notifyListeners(ChangeType.FRAME_REMOVED, this, this.parentFrame);
            this.disableRecursivly();
        }
    }

    private void updateChildren() {
        boolean hasChildBeenGCed = false;
        for (int i = this.children.size() - 1; i >= 0; --i) {
            if (this.children.get(i).get() != null) continue;
            this.children.remove(i);
            hasChildBeenGCed = true;
        }
        if (hasChildBeenGCed) {
            this.notifyListeners(ChangeType.FRAME_GCED, null, this);
        }
    }

    public void clearChildren() {
        this.checkIfRemoved();
        this.children.stream().map(Reference::get).filter(child -> child != null).forEach(child -> child.disableRecursivly());
        this.children.clear();
        this.childrenNames.clear();
        if (this.topFrameNameRestriction != null) {
            this.topFrameNameRestriction.subtreeFrameNames.remove(this.frameName);
        }
        if (this.isRootFrame()) {
            this.framesAddedToTree = 0L;
        }
    }

    private void disableRecursivly() {
        this.hasBeenRemoved = true;
        this.children.stream().map(Reference::get).filter(child -> child != null).forEach(child -> child.disableRecursivly());
        this.changedListeners = null;
        if (this.topFrameNameRestriction != null) {
            this.topFrameNameRestriction.subtreeFrameNames.remove(this.frameName);
        }
    }

    public int getNumberOfChildren() {
        this.checkIfRemoved();
        this.updateChildren();
        return this.children.size();
    }

    public ReferenceFrame getChild(int index) {
        this.checkIfRemoved();
        return (ReferenceFrame)this.children.get(index).get();
    }

    public ReferenceFrame[] getFramesStartingWithRootEndingWithThis() {
        this.checkIfRemoved();
        return this.framesStartingWithRootEndingWithThis;
    }

    public static ReferenceFrame getWorldFrame() {
        return ReferenceFrameTools.getWorldFrame();
    }

    public void setTreeUpdateCondition(Predicate<ReferenceFrame> treeUpdateCondition) {
        this.checkIfRemoved();
        this.getRootFrame().treeUpdateCondition = treeUpdateCondition;
    }

    public void addListener(ReferenceFrameChangedListener listener) {
        this.checkIfRemoved();
        if (this.changedListeners == null) {
            this.changedListeners = new ArrayList<ReferenceFrameChangedListener>();
        }
        this.changedListeners.add(listener);
    }

    public void removeListeners() {
        this.checkIfRemoved();
        this.changedListeners = null;
    }

    public boolean removeListener(ReferenceFrameChangedListener listener) {
        this.checkIfRemoved();
        if (this.changedListeners == null) {
            return false;
        }
        return this.changedListeners.remove(listener);
    }

    private void notifyListeners(ChangeType type, ReferenceFrame target, ReferenceFrame targetParent) {
        if (this.changedListeners != null) {
            FrameChange change = new FrameChange(type, target, targetParent);
            for (int i = 0; i < this.changedListeners.size(); ++i) {
                this.changedListeners.get(i).changed(change);
            }
        }
        if (this.parentFrame != null) {
            this.parentFrame.notifyListeners(type, target, targetParent);
        }
    }

    private static enum ChangeType {
        FRAME_ADDED,
        FRAME_REMOVED,
        FRAME_GCED;

    }

    private class FrameChange
    implements ReferenceFrameChangedListener.Change {
        private final ChangeType type;
        private final ReferenceFrame target;
        private final ReferenceFrame targetParent;

        public FrameChange(ChangeType type, ReferenceFrame target, ReferenceFrame targetParent) {
            this.type = type;
            this.target = target;
            this.targetParent = targetParent;
        }

        @Override
        public boolean wasAdded() {
            return this.type == ChangeType.FRAME_ADDED;
        }

        @Override
        public boolean wasRemoved() {
            return this.type == ChangeType.FRAME_REMOVED;
        }

        @Override
        public boolean wasGarbageCollected() {
            return this.type == ChangeType.FRAME_GCED;
        }

        @Override
        public ReferenceFrame getSource() {
            return ReferenceFrame.this;
        }

        @Override
        public ReferenceFrame getTarget() {
            return this.target;
        }

        @Override
        public ReferenceFrame getTargetParent() {
            return this.targetParent;
        }
    }
}

